/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.comm;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.CommandesBiopod;
import com.mazet.biostim.comm.RawDataBioPod;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiopod;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Utils;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class BioPod {
    private static final double correction = 0.3;
    public static double biopodA;
    public static double biopodB;
    public static int biopodLeadOff;
    public static RawDataBioPod rawBiopodA;
    public static RawDataBioPod rawBiopodB;
    public static CommandesBiopod commandesBiopod;

    public static String getCommandePath() {
        return String.format("%sappData/biopod_%d.json", Computer.absolutePath, Main.getConfig().fwBiopod);
    }

    public static void setBiopodA(double val) {
        biopodA = val * 0.3;
    }

    public static void setBiopodB(double val) {
        biopodB = val * 0.3;
    }

    public static void startRawA() {
        if (SondeBT.connectionBioPod == 3) {
            SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.startBioPodRaw);
        } else if (UsbBiopod.isConnexionBiopod()) {
            UsbBiopod.sendByteTrame(BioPod.commandesBiopod.RAW_C1_STATUS, 1);
        }
        rawBiopodA = new RawDataBioPod('A');
    }

    public static void stopRawA() {
        if (SondeBT.connectionBioPod == 3) {
            SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.stopBioPodRaw);
        } else if (UsbBiopod.isConnexionBiopod()) {
            UsbBiopod.sendByteTrame(BioPod.commandesBiopod.RAW_C1_STATUS, 0);
        }
    }

    public static void startRawB() {
        if (SondeBT.connectionBioPod == 3) {
            SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.startBioPodRaw2);
        } else if (UsbBiopod.isConnexionBiopod()) {
            UsbBiopod.sendByteTrame(BioPod.commandesBiopod.RAW_C2_STATUS, 1);
        }
        rawBiopodB = new RawDataBioPod('B');
    }

    public static void stopRawB() {
        if (SondeBT.connectionBioPod == 3) {
            SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.stopBioPodRaw2);
        } else if (UsbBiopod.isConnexionBiopod()) {
            UsbBiopod.sendByteTrame(BioPod.commandesBiopod.RAW_C2_STATUS, 0);
        }
    }

    public static void setModel(String msg) {
        try {
            int pos = msg.indexOf(59);
            int modele = Integer.parseInt(msg.substring(0, pos));
            int check = Integer.parseInt(msg.substring(pos + 1));
            if (BioPod.getCode(modele, Main.getConfig().idBiopod) == check) {
                if (UsbBiopod.isConnexionBiopod()) {
                    UsbBiopod.sendIntTrame(BioPod.commandesBiopod.CHANGE_MODEL, modele);
                } else if (SondeBT.connectionBioPod == 3) {
                    SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.biopodCmdWriteInt, BioPod.commandesBiopod.CHANGE_MODEL, modele);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getCode(int a, int b) {
        return ((a + 443) * 7069 ^ (b + 571) * 7669) % 985529;
    }

    static void saveJson(String json) {
        try {
            Utils.debugInfo("json recup\u00e9r\u00e9: %s", json);
            commandesBiopod = Utils.fromJson(json, CommandesBiopod.class);
            Path chemin = Paths.get(BioPod.getCommandePath(), new String[0]);
            Files.createDirectories(chemin.getParent(), new FileAttribute[0]);
            Files.write(chemin, json.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            Utils.debugInfo("Erreur recup du json : " + e.getMessage());
        }
    }

    public static boolean isConnected() {
        return UsbBiopod.isConnexionBiopod() || SondeBT.connectionBioPod == 3;
    }

    static {
        rawBiopodA = new RawDataBioPod('A');
        rawBiopodB = new RawDataBioPod('B');
        commandesBiopod = new CommandesBiopod();
    }
}

