/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.programme.bfb.AnimationAPA;
import com.mazet.biostim.view.programme.bfb.AnimationBalance;
import com.mazet.biostim.view.programme.bfb.BiofeedbackController;
import com.mazet.biostim.zdata.Pageprogramme;
import com.mazet.biostim.zdata.Programme;
import java.util.Collection;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class MenuHautBFBController {
    @FXML
    public HBox menuHautHbox;
    @FXML
    Region commentRegion;
    @FXML
    TextArea commentaire;
    @FXML
    AnchorPane patientAllonge;
    @FXML
    AnchorPane patientAssis;
    @FXML
    AnchorPane patientDebout;
    @FXML
    Label reussite;
    @FXML
    ComboBox<Programme> modifProfil;
    @FXML
    VBox calibVoies;
    @FXML
    VBox valVoies;
    @FXML
    Label valVoie1;
    @FXML
    HBox calibVoie1;
    @FXML
    private Label labelMaxLim1;
    @FXML
    Label valVoie2;
    @FXML
    HBox calibVoie2;
    @FXML
    private Label labelMaxLim2;
    @FXML
    Label dureeProg;
    @FXML
    Region reposRegion;
    @FXML
    HBox hboxRepos;
    @FXML
    private Label nivRepos;
    @FXML
    Region dynRegion;
    @FXML
    HBox hboxTravail;
    @FXML
    private Label nivTravail;
    @FXML
    HBox hboxHaut;
    @FXML
    private Label nivHaut;
    @FXML
    HBox hboxMontee;
    @FXML
    private Label nivMontee;
    @FXML
    Region stimRegion;
    @FXML
    Region bfbAssisteRegion;
    @FXML
    Label freq;
    @FXML
    HBox hboxStim;
    @FXML
    Label nivStim;
    @FXML
    Button eclair;
    @FXML
    HBox hboxSeuil;
    @FXML
    Label seuil;
    @FXML
    CheckBox relachement;
    @FXML
    CheckBox insuffisant;
    @FXML
    Region tendanceRegion;
    @FXML
    LineChart<Integer, Double> graphTendance;
    @FXML
    VBox vitesseRegion;
    @FXML
    Label vitesse;
    private BiofeedbackController controller;
    Pageprogramme pageProg;
    String action;
    private int compteurTemp;
    private Timeline holdBouton;

    void init(BiofeedbackController controller) {
        this.controller = controller;
        this.pageProg = Main.progEnCours.currentPageProgram;
        this.commentaire.setText(Main.progEnCours.commentaire);
        this.colorPosition();
        this.valVoie1.setStyle("-fx-text-fill:" + controller.biofeedbackAnimation.getCouleurVoie1());
        this.labelMaxLim1.setStyle("-fx-text-fill:" + controller.biofeedbackAnimation.getCouleurVoie1());
        this.valVoie2.setStyle("-fx-text-fill:" + controller.biofeedbackAnimation.getCouleurVoie2());
        this.labelMaxLim2.setStyle("-fx-text-fill:" + controller.biofeedbackAnimation.getCouleurVoie2());
        FxUtils.adjustLabelWidth(this.reussite, "1000%", 1.3);
        FxUtils.adjustLabelWidth(this.dureeProg, "00:00", 1.3);
        FxUtils.adjustLabelWidth(this.valVoie1, "A: 0000", 1.1);
        FxUtils.adjustLabelWidth(this.valVoie2, "B: 0000", 1.1);
        FxUtils.adjustHboxReglageStyle(this.hboxRepos, "1800", 1.1, null);
        FxUtils.adjustHboxReglageStyle(this.hboxTravail, "60.0", 1.1, null);
        FxUtils.adjustHboxReglageStyle(this.hboxHaut, "100%", 1.1, null);
        FxUtils.adjustHboxReglageStyle(this.hboxMontee, "10.0", 1.1, null);
        FxUtils.adjustHboxReglageStyle(this.hboxStim, "100.0", 1.1, null);
        FxUtils.adjustHboxReglageStyle(this.hboxSeuil, "100%", 1.1, null);
        FxUtils.adjustHboxReglageStyle(this.calibVoie1, "0000", 1.1, (Region)this.valVoie1);
        FxUtils.adjustHboxReglageStyle(this.calibVoie2, "0000", 1.1, (Region)this.valVoie2);
        this.setReposVisibility();
        if (controller.nbVoie != 2) {
            FxUtils.setVisibility((Node)this.calibVoie2, false);
            FxUtils.setVisibility((Node)this.valVoie2, false);
        }
        if (controller.biofeedbackAnimation instanceof AnimationBalance) {
            FxUtils.setVisibility((Node)this.commentRegion, true);
            FxUtils.setVisibility((Node)this.patientDebout, false);
            FxUtils.setVisibility((Node)this.patientAllonge, false);
            FxUtils.setVisibility((Node)this.patientAssis, false);
            FxUtils.setVisibility((Node)this.calibVoies, false);
            FxUtils.setVisibility((Node)this.valVoies, false);
            FxUtils.setVisibility((Node)this.reussite, true);
            if (this.pageProg.designBalance == 1) {
                FxUtils.setVisibility((Node)this.vitesseRegion, true);
                FxUtils.adjustHboxReglageStyle((HBox)this.vitesseRegion.getChildren().get(1), "33", 1.2, null);
                this.vitesse.setText(Integer.toString(this.pageProg.vitesse));
            }
        } else if (this.pageProg.isBfbAssiste()) {
            this.freq.setText(String.format("%dHz / %dus", this.pageProg.getFreq(), this.pageProg.getLargeur()));
            FxUtils.setVisibility((Node)this.stimRegion, true);
            FxUtils.setVisibility((Node)this.bfbAssisteRegion, true);
        } else if (this.pageProg.containStim()) {
            FxUtils.setVisibility((Node)this.stimRegion, true);
        } else if (!Main.getConfig().isActivated || this.pageProg.getInfo() != null || this.pageProg.getType() == 10 || controller.biofeedbackAnimation instanceof AnimationAPA) {
            FxUtils.setVisibility((Node)this.reussite, true);
        } else if (this.pageProg.getType() == 7) {
            FxUtils.setVisibility((Node)this.dynRegion, true);
            FxUtils.setVisibility((Node)this.reussite, true);
        } else {
            FxUtils.setVisibility(this.modifProfil, true);
            FxUtils.setVisibility((Node)this.reussite, true);
        }
        this.relachement.setSelected(this.pageProg.relachement);
        this.insuffisant.setSelected(this.pageProg.insuffisant);
        if (this.modifProfil.isVisible()) {
            ObservableList comboList = FXCollections.observableArrayList();
            int posSelect = -1;
            for (Programme prog : Programme.getProgrammesCombinables(false)) {
                comboList.add((Object)prog);
                if (Main.progEnCours.currentProgram.getId() != prog.getId()) continue;
                posSelect = comboList.size() - 1;
            }
            this.modifProfil.getItems().addAll((Collection)comboList);
            this.modifProfil.getSelectionModel().select(posSelect);
            this.modifProfil.getSelectionModel().selectedItemProperty().addListener((a, b, c) -> this.modifProfil());
            this.modifProfil.setCellFactory(param -> Programme.cellFactory());
            this.modifProfil.setButtonCell(Programme.simpleCellFactory());
        }
    }

    private void modifProfil() {
        int pos = this.modifProfil.getSelectionModel().getSelectedIndex();
        if (pos >= 0) {
            Programme prog = (Programme)this.modifProfil.getItems().get(pos);
            this.pageProg = prog.getFirstPage();
            this.setReposVisibility();
            this.controller.profil = this.pageProg.getProfil();
            this.controller.biofeedbackAnimation.setPositionCurseur();
            this.controller.needUpdateProfil = true;
            this.controller.profilChanged = true;
        }
    }

    private void setReposVisibility() {
        int typ = this.pageProg.getType();
        boolean notVisi = this.pageProg.getTrepos() < 0.01 || typ == 10 || typ == 12 || (typ == 5 || typ == 9) && !this.pageProg.forceRepos || this.controller.biofeedbackAnimation instanceof AnimationAPA || this.controller.biofeedbackAnimation instanceof AnimationBalance;
        FxUtils.setVisibility((Node)this.reposRegion, !notVisi);
    }

    @FXML
    private void setZero() {
        this.controller.setZero1();
    }

    @FXML
    public void fxMousePressed(MouseEvent event) {
        this.mousePressed(event);
    }

    @FXML
    private void fxMouseReleased() {
        this.mouseReleased();
    }

    void updateInfo() {
        double val = Main.progEnCours.getAffMax(this.controller.cvoie1);
        this.labelMaxLim1.setText(Main.progEnCours.relativeValue(this.controller.cvoie1, val));
        if (this.controller.nbVoie == 2) {
            val = Main.progEnCours.getAffMax(this.controller.cvoie2);
            this.labelMaxLim2.setText(Main.progEnCours.relativeValue(this.controller.cvoie2, val));
        }
        this.nivRepos.setText(Utils.stringOfReglage(this.pageProg.getTrepos()));
        this.nivHaut.setText(this.pageProg.dynHaut + "%");
        this.nivMontee.setText(String.format("%.1f", (double)this.pageProg.dynMontee / 10.0));
        this.nivTravail.setText(String.format("%.1f", (double)this.pageProg.dynTravail / 10.0));
        this.seuil.setText(Main.progEnCours.seuilBFBAssiste + "%");
        this.nivStim.setText(String.format("%.1f mA", Main.progEnCours.getStimAmplitudeA()));
    }

    public void updateRelachement() {
        this.pageProg.relachement = this.relachement.isSelected();
    }

    public void updateInsuffisant() {
        this.pageProg.insuffisant = this.insuffisant.isSelected();
    }

    public void setPosition(MouseEvent mouseEvent) {
        String str = (String)((Node)mouseEvent.getSource()).getUserData();
        int position = Integer.parseInt(str);
        Main.progEnCours.position = position == Main.progEnCours.position ? 0 : position;
        this.colorPosition();
    }

    public void colorPosition() {
        if (Main.progEnCours.position == 1) {
            this.patientAllonge.getStyleClass().add((Object)"patientAllongeBleu");
        } else {
            this.patientAllonge.getStyleClass().remove((Object)"patientAllongeBleu");
        }
        if (Main.progEnCours.position == 2) {
            this.patientAssis.getStyleClass().add((Object)"patientAssisBleu");
        } else {
            this.patientAssis.getStyleClass().remove((Object)"patientAssisBleu");
        }
        if (Main.progEnCours.position == 3) {
            this.patientDebout.getStyleClass().add((Object)"patientDeboutBleu");
        } else {
            this.patientDebout.getStyleClass().remove((Object)"patientDeboutBleu");
        }
    }

    @FXML
    public void mousePressed(MouseEvent event) {
        this.action = (String)((Button)event.getSource()).getUserData();
        this.compteurTemp = 0;
        if (this.holdBouton != null) {
            this.holdBouton.stop();
        }
        this.holdBouton = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)20.0), ae -> {
            if (this.controller.finish) {
                this.holdBouton.stop();
            }
            if (this.compteurTemp >= 15) {
                this.reglageEnCours();
            }
            ++this.compteurTemp;
        }, new KeyValue[0])});
        this.holdBouton.setCycleCount(-1);
        this.holdBouton.playFromStart();
    }

    @FXML
    void mouseReleased() {
        if (this.holdBouton != null) {
            this.holdBouton.stop();
            this.holdBouton = null;
            this.reglageEnCours();
        }
    }

    void reglageEnCours() {
        Pageprogramme page = this.pageProg;
        try {
            boolean modifDyn = true;
            switch (this.action) {
                case "h-": {
                    page.incrDynHaut(-1);
                    break;
                }
                case "h+": {
                    page.incrDynHaut(1);
                    break;
                }
                case "m-": {
                    page.incrDynMontee(-1);
                    break;
                }
                case "m+": {
                    page.incrDynMontee(1);
                    break;
                }
                case "t-": {
                    int initTravail = page.dynTravail;
                    page.incrDynTravail(-1);
                    page.setTrepos(page.getTrepos() + (double)(initTravail - page.dynTravail) / 10.0);
                    break;
                }
                case "t+": {
                    int initTravail = page.dynTravail;
                    page.incrDynTravail(1);
                    page.setTrepos(page.getTrepos() + (double)(initTravail - page.dynTravail) / 10.0);
                    break;
                }
                case "d-": {
                    page.incrTrepos(-1);
                    break;
                }
                case "d+": {
                    page.incrTrepos(1);
                    break;
                }
                default: {
                    modifDyn = false;
                }
            }
            if (modifDyn) {
                this.controller.profil = page.getProfil();
            }
            this.controller.needUpdateProfil = true;
            switch (this.action) {
                case "v1-": {
                    this.moinsTarage(this.controller.cvoie1);
                    break;
                }
                case "v1+": {
                    this.plusTarage(this.controller.cvoie1);
                    break;
                }
                case "v2-": {
                    this.moinsTarage(this.controller.cvoie2);
                    break;
                }
                case "v2+": {
                    this.plusTarage(this.controller.cvoie2);
                    break;
                }
                case "spe+": {
                    this.controller.setEpaisseur(Main.progEnCours.epaisseurProfil + 1);
                    break;
                }
                case "spe-": {
                    this.controller.setEpaisseur(Main.progEnCours.epaisseurProfil - 1);
                    break;
                }
                case "s+": {
                    this.controller.deltaSeuil(5);
                    break;
                }
                case "s-": {
                    this.controller.deltaSeuil(-5);
                    break;
                }
                case "stim+": {
                    if (UsbBiostim.isEnableIncrStim()) {
                        this.controller.deltaStim(1);
                    }
                    this.controller.needUpdateProfil = false;
                    break;
                }
                case "stim-": {
                    this.controller.deltaStim(-1);
                    this.controller.needUpdateProfil = false;
                    break;
                }
                case "vit-": {
                    this.moinsVitesse();
                    break;
                }
                case "vit+": {
                    this.plusVitesse();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void moinsTarage(int voie) {
        double dv;
        double base;
        double Vmax = Main.progEnCours.getAffMax(voie);
        if (Vmax > (base = Main.progEnCours.getBase(voie)) + 2.0 * (dv = Utils.getDoubleDelta(Vmax - base))) {
            Main.progEnCours.setAffMax(voie, Vmax - dv);
        }
    }

    private void plusTarage(int voie) {
        Main.progEnCours.incrAffMax(voie, 1);
    }

    private void moinsVitesse() {
        if (this.pageProg.vitesse > 1) {
            --this.pageProg.vitesse;
        }
        this.vitesse.setText(Integer.toString(this.pageProg.vitesse));
    }

    private void plusVitesse() {
        if (this.pageProg.vitesse < 10) {
            ++this.pageProg.vitesse;
        }
        this.vitesse.setText(Integer.toString(this.pageProg.vitesse));
    }
}

