/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.zdata;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.zdata.Session;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;

public class Patient {
    public String id;
    private String firstName = "";
    private String lastName = "";
    public int motif = -1;
    private String numSecu;
    private Date dateNaissance;
    private String adresse;
    private String taille;
    private String poid;
    private Integer genre;
    private String telephone;
    private String mail;
    private String medecinNom;
    private String medecinPrenom;
    private String medecinAdresse;
    private String medecinMail;
    private String medecinTelephone;
    public int kine;
    private final ArrayList<Session> bilan;
    private transient String fileName;

    public Patient() {
        this.kine = Main.getConfig().kine;
        this.bilan = new ArrayList<Session>(Collections.singletonList(new Session()));
        this.id = Main.getConfig().numero_serie + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, -25);
        this.dateNaissance = cal.getTime();
    }

    public Patient(String prenom, String nom) {
        this.kine = Main.getConfig().kine;
        this.bilan = new ArrayList<Session>(Collections.singletonList(new Session()));
        this.firstName = prenom;
        this.lastName = nom;
    }

    public static Patient patientFromJson(String file) {
        Patient res = Utils.fromJsonFile(Main.getConfig().getRepPatients() + "/db/" + file, Patient.class);
        if (res != null) {
            res.fileName = file;
        }
        return res;
    }

    private String fileNameWithKine() {
        if (this.kine == -1) {
            return this.firstName + "_" + this.lastName + ".json";
        }
        return String.format("%s_%s.%d.json", this.firstName, this.lastName, this.kine);
    }

    public void save(boolean ecrase) {
        try {
            if (this.isNewPatient()) {
                this.firstName = "new";
                this.lastName = "patient";
            }
            String archive = this.fileName != null && this.fileName.charAt(0) == '@' ? "@" : "";
            this.fileName = this.fileNameWithKine();
            if (!ecrase) {
                String baseName = this.lastName + " ";
                int i = 1;
                while (new File(Main.getConfig().getRepPatients() + "/db/" + this.fileName).exists() || new File(Main.getConfig().getRepPatients() + "/db/@" + this.fileName).exists()) {
                    Utils.debugInfo("patient d\u00e9j\u00e0 existant " + this.firstName + " " + this.lastName);
                    this.lastName = baseName + i;
                    this.fileName = this.fileNameWithKine();
                    ++i;
                }
            }
            this.fileName = archive + this.fileName;
            Utils.saveJson(this, Main.getConfig().getRepPatients() + "/db/" + this.fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void delete() {
        File file = new File(Main.getConfig().getRepPatients() + "/db/" + this.fileName);
        file.delete();
    }

    public static String supprimerCaracteresInterdits(String nom) {
        String expressionInterdite = "[\\\\/:*?\"<>|]";
        return nom.replaceAll(expressionInterdite, "");
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = Patient.supprimerCaracteresInterdits(firstName);
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = Patient.supprimerCaracteresInterdits(lastName);
    }

    public String getName() {
        if (this.isNewPatient()) {
            return TransientConfig.translate("patient");
        }
        return this.firstName + " " + this.lastName;
    }

    public boolean isNewPatient() {
        return this.lastName.isEmpty() && this.firstName.isEmpty();
    }

    public String getNameAndId() {
        if (this.isNewPatient()) {
            if (this.numSecu == null || this.numSecu.isEmpty()) {
                return TransientConfig.translate("patient");
            }
            return this.numSecu;
        }
        String res = this.firstName + " " + this.lastName;
        if (this.numSecu != null && !this.numSecu.isEmpty()) {
            res = res + "\n" + this.numSecu;
        }
        return res;
    }

    public String getNumSecu() {
        return this.numSecu;
    }

    public void setNumSecu(String numSecu) {
        this.numSecu = numSecu;
    }

    public Date getDateNaissance() {
        return this.dateNaissance;
    }

    public void setDateNaissance(Date dateNaissance) {
        this.dateNaissance = dateNaissance;
    }

    public String getAdresse() {
        return this.adresse;
    }

    public void setAdresse(String adresse) {
        this.adresse = adresse;
    }

    public String getTaille() {
        return this.taille;
    }

    public void setTaille(String taille) {
        this.taille = taille;
    }

    public String getPoid() {
        return this.poid;
    }

    public void setPoid(String poid) {
        this.poid = poid;
    }

    public String getMedecinNom() {
        return this.medecinNom;
    }

    public void setMedecinNom(String medecinNom) {
        this.medecinNom = medecinNom;
    }

    public String getMedecinPrenom() {
        return this.medecinPrenom;
    }

    public void setMedecinPrenom(String medecinPrenom) {
        this.medecinPrenom = medecinPrenom;
    }

    public String getMedecinAdresse() {
        return this.medecinAdresse;
    }

    public void setMedecinAdresse(String medecinAdresse) {
        this.medecinAdresse = medecinAdresse;
    }

    public String getMedecinMail() {
        return this.medecinMail;
    }

    public void setMedecinMail(String medecinMail) {
        this.medecinMail = medecinMail;
    }

    public String getMedecinTelephone() {
        return this.medecinTelephone;
    }

    public void setMedecinTelephone(String medecinTelephone) {
        this.medecinTelephone = medecinTelephone;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public ArrayList<Session> getSessions() {
        return this.bilan;
    }

    public Integer getGenre() {
        return this.genre;
    }

    public void setGenre(Integer genre) {
        this.genre = genre;
    }

    public String getFileName() {
        return this.fileName;
    }
}

