/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.main;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiopod;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.main.listViewController;
import com.mazet.biostim.zdata.Patient;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;

public class MenuController {
    @FXML
    Label logo;
    @FXML
    public ToggleButton homeButton;
    @FXML
    public ToggleButton biopodUSB;
    @FXML
    private AnchorPane anchorBT;
    @FXML
    private ToggleButton btButton;
    @FXML
    private ProgressBar sondeBatt;
    @FXML
    private Label sondeBT;
    @FXML
    private ProgressBar biopodBatt;
    @FXML
    private ToggleButton biopodBT;
    @FXML
    private ProgressBar balanceBatt;
    @FXML
    private ToggleButton balanceBT;
    @FXML
    private ProgressBar bluebackBatt;
    @FXML
    private Label blueback;
    @FXML
    public ToggleButton patientButton;
    @FXML
    public ToggleButton plancheButton;
    @FXML
    public ToggleButton favoriButton;
    @FXML
    public ToggleButton autotestButton;
    @FXML
    public ToggleButton configButton;
    @FXML
    private Label deconnection;
    public ArrayList<ToggleButton> toggleButtons;
    public static String logoName;

    public void setMain() {
        this.toggleButtons = new ArrayList<ToggleButton>(Arrays.asList(this.homeButton, this.biopodUSB, this.btButton, this.biopodBT, this.balanceBT, this.patientButton, this.plancheButton, this.favoriButton, this.autotestButton, this.configButton));
        this.favoriButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menufavoris"});
        this.biopodUSB.getStyleClass().setAll((Object[])new String[]{"usbAcc", "biopodusb"});
        this.biopodBT.getStyleClass().setAll((Object[])new String[]{"btAcc", "biopod"});
        this.balanceBT.getStyleClass().setAll((Object[])new String[]{"btAcc", "balance"});
        this.changeVignette();
        this.changeHomeStatus();
        this.changeBTStatus();
        this.changeAlertes();
        this.changeLogo();
        this.updateMenuWidth();
        Main.sceneMain.heightProperty().addListener((a, b, c) -> this.updateMenuWidth());
        Main.sceneMain.widthProperty().addListener((a, b, c) -> this.updateMenuWidth());
    }

    public void changeLogo() {
        if (Main.getConfig().option10()) {
            logoName = "biostim10.png";
        } else {
            logoName = "biostim2";
            logoName = logoName + Main.getConfig().nbVoiesPression();
            if (Main.getConfig().isActivated) {
                logoName = logoName + "p";
            }
            logoName = logoName + ".png";
        }
        logoName = "skin1/" + logoName;
        if (Main.getConfig().distributeur.equals("menfis")) {
            logoName = "menfis/pfr.png";
        }
        FxUtils.setBackGroundIntoInJar((Region)this.logo, logoName);
        if (Main.getConfig().optionPlanches()) {
            this.plancheButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menuPlanche"});
        } else {
            this.plancheButton.getStyleClass().setAll((Object[])new String[]{"logoGaucheInactif", "menuPlancheGris"});
        }
        this.changeVignette();
        if (Main.currentController instanceof listViewController) {
            Platform.runLater(this::goToHome);
        }
    }

    public void updateMenuWidth() {
        double height = Main.sceneMain.getHeight() / 21.0;
        double width = Main.sceneMain.getWidth() / 8.0;
        Main.addDynamicCSS(String.format(".logoGauche{ -fx-background-size:%.0fpx; }\n.logoGaucheInactif { -fx-background-size:%.0fpx; }\n.menuGauche { -fx-pref-width:%.0f; }\n.vboxBT { -fx-padding: 0 %.0f 0 0; }\n.battBT { -fx-min-width: %.0f; -fx-max-width: %.0f; }\n.btAcc { -fx-min-height: %.0f; -fx-max-height: %.0f; -fx-min-width: %.0f; -fx-max-width: %.0f;}\n.usbAcc { -fx-min-height: %.0f; -fx-max-height: %.0f; -fx-min-width: %.0f; -fx-max-width: %.0f;}\n.menuDeconnexion { -fx-background-size: %.0f %.0f; -fx-pref-width: %.0f; -fx-pref-height: %.0f; }", height, height, width, width / 20.0, width / 6.0, width / 6.0, width / 8.0, width / 8.0, width / 6.0, width / 6.0, width / 4.0, width / 4.0, width / 6.0, width / 6.0, width / 12.0, width / 12.0, width / 4.0, width / 5.0));
    }

    public void changeAlertes() {
        Platform.runLater(() -> {
            switch (Main.getConfig().etatCloud) {
                case 0: {
                    this.autotestButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menuAutotestVert"});
                    break;
                }
                case 1: {
                    this.autotestButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menuAutotestOrange"});
                    break;
                }
                case 2: {
                    this.autotestButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menuAutotestRouge"});
                }
            }
            boolean alerteConfig = Main.getConfig().indiceHtmlAffiche < Main.getConfig().currentIndiceHtml || !Main.getConfig().compteOK();
            this.configButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", alerteConfig ? "menuConfigAlerte" : "menuConfig"});
        });
    }

    public void changeVignette() {
        Patient activePatient = Main.getCurrentPatient();
        if (Main.getConfig().optionPatients()) {
            if (activePatient != null) {
                String prenom = activePatient.getFirstName() == null ? "" : activePatient.getFirstName();
                String nom = activePatient.getLastName() == null ? "" : activePatient.getLastName();
                this.patientButton.setText(prenom + " " + nom);
                this.patientButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menuPatient"});
                this.deconnection.setVisible(true);
            } else {
                this.patientButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menuChoisir"});
                this.patientButton.setText("");
                this.deconnection.setVisible(false);
            }
        } else {
            this.patientButton.getStyleClass().setAll((Object[])new String[]{"logoGaucheInactif", "menuChoisirGris"});
            this.patientButton.setText("");
            this.deconnection.setVisible(false);
        }
    }

    public void deconnexionPatient() {
        Utils.debugInfo("deconnexion patient");
        Main.currentController.exitAction();
        Main.setCurrentPatient(null);
        this.changeVignette();
        Main.changeCenterView("patient", "list", Main.menu.patientButton);
    }

    public void changeHomeStatus() {
        if (Main.getConfig().isVerrouilleTotal() || Main.getConfig().nbAvantBlocage == 0) {
            this.homeButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menuHomeVerrouille"});
        } else if (UsbBiostim.isConnexionBioStim()) {
            if (UsbBiostim.getEtatPoire() == 0) {
                this.homeButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menuHomeOK"});
            } else {
                Utils.debugInfo("Etat poire KO : " + UsbBiostim.getEtatPoire());
                this.homeButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menuHomePb"});
            }
        } else {
            this.homeButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "menuHomeKO"});
        }
        FxUtils.setVisibility((Node)this.biopodUSB, UsbBiopod.isConnexionBiopod());
    }

    public void changeBTStatus() {
        Platform.runLater(() -> {
            FxUtils.setVisibility((Node)this.anchorBT, Main.getConfig().optionBluetooth != 0 && SondeBT.isOsCompatible());
            FxUtils.setVisibility((Node)this.sondeBT, false);
            FxUtils.setVisibility((Node)this.sondeBatt, false);
            FxUtils.setVisibility((Node)this.biopodBT, false);
            FxUtils.setVisibility((Node)this.biopodBatt, false);
            FxUtils.setVisibility((Node)this.balanceBT, false);
            FxUtils.setVisibility((Node)this.balanceBatt, false);
            FxUtils.setVisibility((Node)this.blueback, false);
            FxUtils.setVisibility((Node)this.bluebackBatt, false);
            this.sondeBatt.getStyleClass().setAll((Object[])new String[]{"progress-bar", "battBT"});
            this.biopodBatt.getStyleClass().setAll((Object[])new String[]{"progress-bar", "battBT"});
            this.balanceBatt.getStyleClass().setAll((Object[])new String[]{"progress-bar", "battBT"});
            this.bluebackBatt.getStyleClass().setAll((Object[])new String[]{"progress-bar", "battBT"});
            if (SondeBT.connectionSonde == 0) {
                this.btButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "btOff"});
            } else if (SondeBT.connectionSonde != 3 && SondeBT.connectionBiomoov != 3 && SondeBT.connectionBioPod != 3 && SondeBT.connectionBlueback < 2) {
                FxUtils.setVisibility((Node)this.sondeBatt, true);
                this.sondeBatt.setProgress(-1.0);
                this.btButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "btOrange"});
            } else {
                this.btButton.getStyleClass().setAll((Object[])new String[]{"logoGauche", "btOn"});
                if (SondeBT.connectionSonde == 3) {
                    FxUtils.setVisibility((Node)this.sondeBT, true);
                    FxUtils.setVisibility((Node)this.sondeBatt, true);
                    this.updateBatt(SondeBT.batterySonde, this.sondeBatt);
                    this.sondeBT.getStyleClass().setAll((Object[])new String[]{"btAcc", SondeBT.sondeBT == 1 ? "emy" : "perifit"});
                }
                if (SondeBT.connectionBioPod == 3) {
                    FxUtils.setVisibility((Node)this.biopodBT, true);
                    FxUtils.setVisibility((Node)this.biopodBatt, true);
                    this.updateBatt(SondeBT.batteryBioPod, this.biopodBatt);
                }
                if (SondeBT.connectionBiomoov == 3) {
                    FxUtils.setVisibility((Node)this.balanceBT, true);
                    FxUtils.setVisibility((Node)this.balanceBatt, true);
                    this.updateBatt(SondeBT.batteryBiomoov, this.balanceBatt);
                }
                if (SondeBT.connectionBlueback >= 2) {
                    FxUtils.setVisibility((Node)this.blueback, true);
                    FxUtils.setVisibility((Node)this.bluebackBatt, true);
                    this.updateBatt(SondeBT.batteryBlueback, this.bluebackBatt);
                }
            }
        });
    }

    public void updateBatt(int niveau, ProgressBar pb) {
        pb.getStyleClass().setAll((Object[])new String[]{"progress-bar", "battBT"});
        if (niveau >= 0) {
            pb.setProgress((double)(20 + niveau) / 120.0);
            if (niveau > 40) {
                pb.getStyleClass().add((Object)"battBT_green");
            } else if (niveau > 20) {
                pb.getStyleClass().add((Object)"battBT_orange");
            } else {
                pb.getStyleClass().add((Object)"battBT_red");
            }
        } else {
            pb.setProgress(-1.0);
        }
    }

    public void toPageBalance() {
        Main.changeCenterView("configuration/balanceConfig.fxml", this.balanceBT);
    }

    public void toPageBiopod(MouseEvent event) {
        if (Main.getConfig().versionRecherche) {
            this.toPageBiopodForce();
        } else {
            ((ToggleButton)event.getSource()).setSelected(false);
        }
    }

    public void toPageBiopodForce() {
        if (UsbBiopod.isConnexionBiopod()) {
            Main.changeCenterView("configuration/biopodTest.fxml", this.biopodUSB);
        } else {
            Main.changeCenterView("configuration/biopodTest.fxml", this.biopodBT);
        }
    }

    public void updateBattBiomoov() {
        this.updateBatt(SondeBT.batteryBiomoov, this.balanceBatt);
    }

    public void updateBattBioPod() {
        this.updateBatt(SondeBT.batteryBioPod, this.biopodBatt);
    }

    public void updateBattSonde() {
        this.updateBatt(SondeBT.batterySonde, this.sondeBatt);
    }

    @FXML
    private void sondeBTChangeAction() {
        if (SondeBT.connectionBiomoov != 0) {
            new Thread(SondeBT::stop).start();
        } else {
            SondeBT.start();
        }
    }

    @FXML
    private void clicLogo() {
        MenuController.setFullScreen();
    }

    public static void setFullScreen() {
        System.out.format("resolution : %.0f*%.0f%n", Main.primaryStage.getWidth(), Main.primaryStage.getHeight());
        Main.primaryStage.setFullScreen(!Main.primaryStage.isFullScreen());
        System.out.format("resolution : %.0f*%.0f%n", Main.primaryStage.getWidth(), Main.primaryStage.getHeight());
    }

    @FXML
    public void goToHome() {
        Main.changeCenterView("main", "List", this.homeButton);
    }

    @FXML
    public void goToAutotest() {
        Main.changeCenterView("configuration/autotest.fxml", this.autotestButton);
    }

    @FXML
    public void goToConfig() {
        Main.changeCenterView("configuration", "main", this.configButton);
    }

    @FXML
    private void goToFav() {
        Main.progEnCours = null;
        Main.setCategorie("favoris");
        Main.changeCenterView("programme", "progList", this.favoriButton);
    }

    @FXML
    private void goToPlanch() {
        if (Main.getConfig().optionPlanches()) {
            Main.changeCenterView("planche", "main", this.plancheButton);
        }
    }

    @FXML
    private void goToListPatient() {
        if (Main.getConfig().optionPatients()) {
            if (Main.getCurrentPatient() == null) {
                Main.changeCenterView("patient", "list", this.patientButton);
            } else {
                Main.changeCenterView("patient", "bilan", this.patientButton);
            }
        }
    }

    @FXML
    private void closeButtonAction() {
        Main.main.stop();
    }
}

