/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimationSpecif;
import java.util.ArrayList;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;

public class AnimationLotus
extends BiofeedbackAnimationSpecif {
    private static final double voie1RelativePosX = 0.5;
    private static final double voie1RelativePosY = 0.7;
    private static final double mintheta = 100.0;
    private static final double maxtheta = 25.0;
    private static final double propMax = 0.6;
    private static final int nbRayons = 11;
    private double rayonMax;
    private final ArrayList<Arc> listArc = new ArrayList();

    @Override
    public void initGame() {
        try {
            for (int i = 0; i < 22; ++i) {
                Arc a = new Arc();
                a.setType(ArcType.CHORD);
                a.setFill((Paint)Color.HOTPINK);
                a.setStrokeWidth(0.0);
                a.setOpacity(0.3);
                a.setLength(90.0);
                this.listArc.add(a);
                this.controller.gameAnchor.getChildren().add((Object)a);
            }
            super.initGame();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void updateSizeGame() {
        super.updateSizeGame();
        this.rayonMax = Math.min(this.widthGame / 2.0, this.anchorHeight * 0.7) / 1.414;
    }

    @Override
    public void updateSpecifique() {
        super.updateSpecifique();
        this.updateArc();
    }

    private void updateArc() {
        try {
            double x0 = 0.5 * this.widthGame;
            double y0 = 0.7 * this.anchorHeight;
            double rc = (1.0 - this.controller.niveauVoie1Aff / 100.0 * 0.6) * this.rayonMax;
            double theta0 = 100.0 + this.controller.niveauVoie1Aff / 100.0 * -75.0;
            for (int i = 0; i < 11; ++i) {
                double theta = -theta0 + 2.0 * theta0 * (double)i / 10.0 + 135.0;
                Arc a = this.listArc.get(2 * i);
                a.setCenterX(x0 + rc * Math.sin(theta * 2.0 * Math.PI / 360.0));
                a.setCenterY(y0 + rc * Math.cos(theta * 2.0 * Math.PI / 360.0));
                a.setRadiusX(rc);
                a.setRadiusY(rc);
                a.setStartAngle(theta);
                a = this.listArc.get(2 * i + 1);
                a.setCenterX(x0 + rc * Math.sin((theta + 90.0) * 2.0 * Math.PI / 360.0));
                a.setCenterY(y0 + rc * Math.cos((theta + 90.0) * 2.0 * Math.PI / 360.0));
                a.setRadiusX(rc);
                a.setRadiusY(rc);
                a.setStartAngle(theta + 180.0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

