/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimationSpecif;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;

public class AnimationPompier
extends BiofeedbackAnimationSpecif {
    private Rectangle flamme;
    private Rectangle pompier;
    private Rectangle immeuble;
    private Rectangle camionPompier;
    private Rectangle gerbeEau;
    private Line tuyauLance;
    private Line jetDeau;
    private Rectangle boucheIncendie;
    ImagePattern immeubleVide;
    ImagePattern immeubleSecours1;
    ImagePattern immeubleSecours2;
    private double hauteurPompier;
    private double immeublePosX;
    private double largeurImmeuble;
    private double imagesY;
    private double hauteurImages;
    private double hauteurPremierEtage;
    private double hauteurBoucheIncendie;
    private int compt = 25;
    private int monte = 1;
    private double amplitudeFlamme = 0.0;

    @Override
    public void updateSpecifique() {
        super.updateSpecifique();
        try {
            double profil = this.profToAff(this.controller.profilLevel);
            --this.compt;
            if (this.compt < 0) {
                this.compt = (int)(40.0 * Math.random());
                this.monte = -this.monte;
            }
            if (this.amplitudeFlamme < -0.4) {
                this.monte = 1;
            }
            if (this.amplitudeFlamme > 0.4) {
                this.monte = -1;
            }
            this.amplitudeFlamme += (double)this.monte * 0.1 * Math.random();
            double hauteurFlamme = (this.hauteurImages - this.hauteurPremierEtage) * profil / 100.0;
            this.flamme.setHeight(hauteurFlamme);
            this.flamme.setY(this.imagesY + this.hauteurImages - this.hauteurPremierEtage - hauteurFlamme);
            double largeurFlamme = this.largeurImmeuble * 0.1 * (1.0 + this.amplitudeFlamme) * (100.0 + profil) / 100.0;
            this.flamme.setWidth(largeurFlamme);
            this.flamme.setX(this.immeublePosX - largeurFlamme * 0.75);
            double pompierPosY = this.imagesY + (this.hauteurImages - this.hauteurPremierEtage) * (100.0 - this.controller.niveauVoie1Aff) / 100.0 - this.hauteurPompier * 25.0 / 79.0;
            this.pompier.setY(pompierPosY);
            this.tuyauLance.setStartY(pompierPosY + this.hauteurPompier);
            if (this.controller.isInProfile != 0) {
                if (this.controller.dureeMilli % 0.7 > 0.35) {
                    this.immeuble.setFill((Paint)this.immeubleSecours1);
                } else {
                    this.immeuble.setFill((Paint)this.immeubleSecours2);
                }
            } else {
                this.immeuble.setFill((Paint)this.immeubleVide);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initGame() {
        try {
            this.controller.animationAnchor.getStyleClass().setAll((Object[])new String[]{"ludiquePompier"});
            this.immeuble = new Rectangle();
            this.camionPompier = new Rectangle();
            this.camionPompier.setFill((Paint)new ImagePattern(new Image("/res/img/pompier/camion.png")));
            this.flamme = new Rectangle();
            this.flamme.setFill((Paint)new ImagePattern(new Image("/res/img/pompier/flamme.png")));
            this.pompier = new Rectangle();
            this.pompier.setFill((Paint)new ImagePattern(new Image("/res/img/pompier/pompier.png")));
            this.tuyauLance = new Line();
            this.tuyauLance.setStroke((Paint)Color.rgb((int)64, (int)88, (int)85));
            this.updateSizeGame();
            this.controller.gameAnchor.getChildren().addAll((Object[])new Node[]{this.camionPompier, this.flamme, this.immeuble, this.pompier, this.tuyauLance});
            this.immeubleVide = new ImagePattern(new Image("/res/img/pompier/immeuble.png"));
            this.immeubleSecours1 = new ImagePattern(new Image("/res/img/pompier/immeuble_au_secours.png"));
            this.immeubleSecours2 = new ImagePattern(new Image("/res/img/pompier/immeuble_au_secours2.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void updateSizeGame() {
        this.immeublePosX = this.widthGame * 0.5;
        this.imagesY = this.anchorHeight * 0.05;
        this.hauteurImages = this.anchorHeight * 0.9;
        this.largeurImmeuble = this.hauteurImages * 104.0 / 386.0;
        this.hauteurPremierEtage = this.hauteurImages / 7.0;
        double largeurCamionPompier = this.hauteurImages * 103.0 / 381.0;
        double camionPompierPosX = this.immeublePosX - largeurCamionPompier * 1.3;
        this.hauteurPompier = largeurCamionPompier * 79.0 / 139.0;
        double pompierPosX = this.immeublePosX - largeurCamionPompier;
        this.immeuble.setX(this.immeublePosX);
        this.immeuble.setY(this.imagesY);
        this.immeuble.setWidth(this.largeurImmeuble);
        this.immeuble.setHeight(this.hauteurImages);
        this.camionPompier.setX(camionPompierPosX);
        this.camionPompier.setY(this.imagesY);
        this.camionPompier.setWidth(largeurCamionPompier);
        this.camionPompier.setHeight(this.hauteurImages);
        this.pompier.setX(pompierPosX);
        this.pompier.setWidth(largeurCamionPompier);
        this.pompier.setHeight(this.hauteurPompier);
        this.tuyauLance.setStrokeWidth(largeurCamionPompier * 0.015);
        this.tuyauLance.setStartX(pompierPosX + largeurCamionPompier * 0.02);
        this.tuyauLance.setEndX(pompierPosX + largeurCamionPompier * 0.02);
        this.tuyauLance.setEndY(this.imagesY + this.hauteurImages - this.hauteurPompier / 4.0);
    }

    @Override
    void updateVoie2Std() {
        double voie2PosX = this.widthVoie2 * 0.5;
        double hauteurTotaleJetDeau = this.anchorHeight * 0.9 - this.hauteurBoucheIncendie;
        double hauteurGerbe = this.widthVoie2 * 0.5 * (0.5 + 0.5 * this.controller.niveauVoie2Aff / 100.0);
        double hauteurJet = (hauteurTotaleJetDeau - hauteurGerbe) * this.controller.niveauVoie2Aff / 100.0;
        this.gerbeEau.setY(this.anchorHeight * 0.9500000000000001 - hauteurJet - this.hauteurBoucheIncendie - hauteurGerbe);
        this.gerbeEau.setX(voie2PosX - hauteurGerbe);
        this.gerbeEau.setHeight(hauteurGerbe);
        this.gerbeEau.setWidth(hauteurGerbe * 2.0);
        this.jetDeau.setEndY(this.anchorHeight * 0.05 + hauteurTotaleJetDeau - hauteurJet);
        this.jetDeau.setStrokeWidth(0.07 * hauteurGerbe);
    }

    @Override
    void initVoie2() {
        this.gerbeEau = new Rectangle();
        this.gerbeEau.setFill((Paint)new ImagePattern(new Image("/res/img/pompier/jet_eau.png")));
        this.boucheIncendie = new Rectangle();
        this.boucheIncendie.setFill((Paint)new ImagePattern(new Image("/res/img/pompier/bouche_incendie.png")));
        this.jetDeau = new Line();
        this.jetDeau.setStroke((Paint)Color.rgb((int)35, (int)89, (int)226));
        this.updateSizeVoie2();
        this.controller.voie2Anchor.getChildren().addAll((Object[])new Node[]{this.boucheIncendie, this.jetDeau, this.gerbeEau});
    }

    @Override
    protected void updateSizeVoie2() {
        double voie2PosX = this.widthVoie2 * 0.5;
        this.hauteurBoucheIncendie = Math.min(this.anchorHeight * 0.1, this.widthVoie2 * 240.0 / 400.0);
        double largeurBouche = this.hauteurBoucheIncendie * 400.0 / 240.0;
        this.boucheIncendie.setX(voie2PosX - largeurBouche / 2.0);
        this.boucheIncendie.setY(this.anchorHeight * 0.9500000000000001 - this.hauteurBoucheIncendie);
        this.boucheIncendie.setWidth(largeurBouche);
        this.boucheIncendie.setHeight(this.hauteurBoucheIncendie);
        this.jetDeau.setStartX(voie2PosX);
        this.jetDeau.setEndX(voie2PosX);
        this.jetDeau.setStartY(this.anchorHeight * 0.9500000000000001 - this.hauteurBoucheIncendie);
    }
}

