/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.imageio.ImageIO;

public class Pdf {
    private static final Font font24 = new Font(Font.FontFamily.TIMES_ROMAN, 24.0f, 1);
    private static final Font font18 = new Font(Font.FontFamily.TIMES_ROMAN, 18.0f);
    private static final Font font10 = new Font(Font.FontFamily.TIMES_ROMAN, 10.0f);

    public static void createPDF(Node node1, Node node2, String namePDF) {
        File pdfFile = Pdf.openDocument(namePDF);
        if (pdfFile != null) {
            try {
                Document doc = new Document(PageSize.A4);
                FileOutputStream fos = new FileOutputStream(pdfFile);
                Pdf.addHeader(PdfWriter.getInstance(doc, fos));
                doc.open();
                float pheight = doc.getPageSize().getHeight() - doc.leftMargin() - doc.rightMargin();
                float pwidth = doc.getPageSize().getWidth() - doc.topMargin() - doc.bottomMargin();
                doc.newPage();
                BufferedImage bufImage = SwingFXUtils.fromFXImage((Image)node1.snapshot(new SnapshotParameters(), null), null);
                doc.add(Pdf.imageFromBufImage(bufImage, pwidth, pheight));
                BufferedImage bufImage1 = SwingFXUtils.fromFXImage((Image)node2.snapshot(new SnapshotParameters(), null), null);
                int iheight = bufImage1.getHeight();
                int iwidth = bufImage1.getWidth();
                for (int pos = 0; pos < iheight; pos += 2 * iwidth) {
                    doc.newPage();
                    BufferedImage temp = pos + 2 * iwidth > iheight ? bufImage1.getSubimage(0, pos, iwidth, iheight - pos) : bufImage1.getSubimage(0, pos, iwidth, 2 * iwidth);
                    doc.add(Pdf.imageFromBufImage(temp, pwidth, pheight));
                }
                fos.flush();
                doc.close();
                fos.close();
                Desktop d = Desktop.getDesktop();
                d.open(pdfFile);
            }
            catch (Exception e) {
                Utils.popupAlert(TransientConfig.translate("contentErrorPDF"));
                e.printStackTrace();
            }
        }
    }

    public static void createBilanPDF(Node node1, Node node2, String namePDF, String titre, boolean isAnorectal, boolean isLanscape) {
        String type = TransientConfig.translate(isAnorectal ? "Bilan_anorectal_court" : "Bilan_perineal_court");
        File pdfFile = Pdf.openDocument(namePDF.isEmpty() ? type : namePDF);
        if (pdfFile != null) {
            try {
                Document doc = new Document(PageSize.A4);
                if (isLanscape) {
                    doc.setPageSize(PageSize.A4.rotate());
                }
                FileOutputStream fos = new FileOutputStream(pdfFile);
                Pdf.addHeader(PdfWriter.getInstance(doc, fos));
                doc.open();
                float pheight = doc.getPageSize().getHeight() - doc.leftMargin() - doc.rightMargin();
                float pwidth = doc.getPageSize().getWidth() - doc.topMargin() - doc.bottomMargin();
                doc.newPage();
                if (!titre.isEmpty()) {
                    type = titre + "\n" + type;
                }
                Paragraph pTitre = new Paragraph(type, font24);
                pTitre.setAlignment(1);
                doc.add(pTitre);
                if (node1 != null) {
                    BufferedImage bufImage = SwingFXUtils.fromFXImage((Image)node1.snapshot(new SnapshotParameters(), null), null);
                    com.itextpdf.text.Image tableau = Pdf.imageFromBufImage(bufImage, pwidth * 0.8f, pheight);
                    tableau.setAlignment(1);
                    doc.add(tableau);
                }
                BufferedImage bufImage1 = SwingFXUtils.fromFXImage((Image)node2.snapshot(new SnapshotParameters(), null), null);
                doc.add(Pdf.imageFromBufImage(bufImage1, pwidth, pheight));
                fos.flush();
                doc.close();
                fos.close();
                Desktop d = Desktop.getDesktop();
                d.open(pdfFile);
            }
            catch (Exception e) {
                Utils.popupAlert(TransientConfig.translate("contentErrorPDF"));
                e.printStackTrace();
            }
        }
    }

    public static void createHistPDF(Pane pane, boolean isMoyenne, ProgressIndicator waiting, int deltaDeb, int deltaFin, String titre, String soustitre, Region entete, int max1, int max2) {
        try {
            File pdfFile = Computer.newBiostimFile("courbe.pdf");
            Document doc = new Document(PageSize.A4);
            FileOutputStream fos = new FileOutputStream(pdfFile);
            Pdf.addHeader(PdfWriter.getInstance(doc, fos));
            doc.open();
            Paragraph pTitre = new Paragraph(titre, font24);
            pTitre.setAlignment(1);
            doc.add(pTitre);
            if (soustitre != null) {
                Paragraph pSousTitre = new Paragraph(soustitre, font18);
                pSousTitre.setAlignment(1);
                doc.add(pSousTitre);
            }
            doc.add(new Paragraph("  "));
            double nbHauteur = isMoyenne ? 4.2 : 6.0;
            float pheight = doc.getPageSize().getHeight() - doc.leftMargin() - doc.rightMargin();
            float uheight = (float)((double)pheight / nbHauteur);
            float pwidth = doc.getPageSize().getWidth() - doc.topMargin() - doc.bottomMargin();
            double iheight = pane.getHeight();
            double iwidth = pane.getWidth() - (double)deltaFin;
            double incr = iheight * (double)pwidth / (double)uheight;
            SnapshotParameters sp = new SnapshotParameters();
            ArrayList<WritableImage> images = new ArrayList<WritableImage>();
            if (entete != null) {
                sp.setViewport(new Rectangle2D(0.0, 0.0, entete.getWidth() - 200.0, entete.getHeight()));
                Pdf.addImage(entete.snapshot(sp, null), doc, pwidth, uheight);
            }
            String echelle = String.format(TransientConfig.translate("echelleVoie", "1") + " : %d", max1);
            if (max2 > 0) {
                echelle = String.format("%s / " + TransientConfig.translate("echelleVoie", "2") + " : %d", echelle, max2);
            }
            Paragraph pmax = new Paragraph(echelle, font10);
            doc.add(pmax);
            for (double pos = (double)deltaDeb; pos < iwidth; pos += incr) {
                if (pos + incr >= iwidth) {
                    sp.setViewport(new Rectangle2D(pos, 0.0, iwidth - pos, iheight));
                } else {
                    sp.setViewport(new Rectangle2D(pos, 0.0, incr, iheight));
                }
                images.add(pane.snapshot(sp, null));
            }
            new Thread(() -> Pdf.remplirPdf(images, doc, fos, pwidth, uheight, pdfFile, waiting)).start();
        }
        catch (Exception e) {
            Utils.popupAlert(TransientConfig.translate("contentErrorPDF"));
            e.printStackTrace();
        }
    }

    private static void remplirPdf(ArrayList<WritableImage> images, Document doc, FileOutputStream fos, float pwidth, float uheight, File pdfFile, ProgressIndicator waiting) {
        try {
            waiting.setVisible(true);
            for (WritableImage image : images) {
                Pdf.addImage(image, doc, pwidth, uheight);
            }
            fos.flush();
            doc.close();
            fos.close();
            Desktop d = Desktop.getDesktop();
            d.open(pdfFile);
            waiting.setVisible(false);
        }
        catch (Exception e) {
            waiting.setVisible(false);
            e.printStackTrace();
        }
    }

    private static void addImage(WritableImage image, Document doc, float pwidth, float uheight) {
        try {
            BufferedImage temp = SwingFXUtils.fromFXImage((Image)image, null);
            int newW = 1200;
            int newH = temp.getHeight() * newW / temp.getWidth();
            BufferedImage temp2 = new BufferedImage(newW, newH, temp.getType());
            Graphics2D g = temp2.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(temp, 0, 0, newW, newH, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g.dispose();
            doc.add(Pdf.imageFromBufImage(temp2, pwidth, uheight));
            doc.add(new Paragraph(" "));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static com.itextpdf.text.Image imageFromBufImage(BufferedImage bufImage, float pwidth, float pheight) {
        com.itextpdf.text.Image image = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufImage, "png", baos);
            image = com.itextpdf.text.Image.getInstance(baos.toByteArray());
            image.scaleToFit(pwidth, pheight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    private static File openDocument(String namePDF) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Fichier PDF", new String[]{"*.pdf"})});
        fileChooser.setInitialDirectory(new File(Computer.absolutePath));
        fileChooser.setInitialFileName(namePDF);
        return fileChooser.showSaveDialog((Window)Main.primaryStage);
    }

    private static void addHeader(PdfWriter writer) {
        writer.setPageEvent(new PdfPageEventHelper(){

            @Override
            public void onEndPage(PdfWriter writer, Document document) {
                try {
                    PdfContentByte cb = writer.getDirectContent();
                    Image im = new Image(Main.getConfig().getLogo());
                    BufferedImage bufImage = SwingFXUtils.fromFXImage((Image)im, null);
                    com.itextpdf.text.Image image = Pdf.imageFromBufImage(bufImage, 1000.0f, 1000.0f);
                    ColumnText.showTextAligned(cb, 2, new Phrase(new Chunk(image, 0.0f, -30.0f)), document.right() - document.left() + document.leftMargin(), document.top() + 25.0f, 0.0f);
                    if (!Main.getConfig().logoPerso.isEmpty()) {
                        com.itextpdf.text.Image image2 = com.itextpdf.text.Image.getInstance(Main.getConfig().logoPerso);
                        image2.scaleToFit(1000.0f, 1000.0f);
                        ColumnText.showTextAligned(cb, 0, new Phrase(new Chunk(image2, 0.0f, -30.0f)), document.leftMargin(), document.top() + 25.0f, 0.0f);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

