/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.zdata;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.programme.bfb.BiofeedbackController;
import com.mazet.biostim.zdata.Patient;
import com.mazet.biostim.zdata.Programme;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javafx.scene.chart.XYChart;
import org.json.JSONArray;
import org.json.JSONObject;

public class Historique {
    public ArrayList<Integer> temps = new ArrayList();
    public ArrayList<Double> niveauVoie1 = new ArrayList();
    public ArrayList<Double> niveauVoie2 = new ArrayList();
    public ArrayList<Double> mvt = new ArrayList();
    public ArrayList<Integer> tempsEvt = new ArrayList();
    public ArrayList<String> events = new ArrayList();
    private int lastPos = -1;
    private double cumulT = 0.0;
    private double cumulV1 = 0.0;
    private double cumulV2 = 0.0;
    private int nbCumul = 0;
    public XYChart.Series<Integer, Double> tendanceTravail = new XYChart.Series();
    public XYChart.Series<Integer, Double> tendanceRepos = new XYChart.Series();
    private int cycle = 0;
    private int compteurCycle = 0;
    private int nbTendTravail = 0;
    private double cumulTendTravail = 0.0;
    private int nbTendRepos = 0;
    private double cumulTendRepos = 0.0;
    public boolean hasBalance;
    private double cumulMvt = 0.0;

    public Historique(Programme programme) {
        this.hasBalance = SondeBT.connectionBiomoov >= 3 && !Biostim.isVoieBalance(programme.getVoieBFB1()) && !Biostim.isVoieBalance(programme.getVoieBFB2());
        this.tendanceTravail.setName(TransientConfig.translate("travail"));
        this.tendanceRepos.setName(TransientConfig.translate("repos"));
    }

    public void ajouteValeur(double time, BiofeedbackController controller) {
        int pos = (int)(time / 0.1);
        if (pos != this.lastPos) {
            this.lastPos = pos;
            if (this.nbCumul != 0) {
                this.temps.add((int)(this.cumulT / (double)this.nbCumul * 100.0));
                this.niveauVoie1.add(this.cumulV1 / (double)this.nbCumul);
                if (controller.nbVoie == 2) {
                    this.niveauVoie2.add(this.cumulV2 / (double)this.nbCumul);
                }
                if (this.hasBalance) {
                    this.mvt.add(this.cumulMvt / (double)this.nbCumul);
                }
            }
            this.cumulT = 0.0;
            this.cumulV1 = 0.0;
            this.cumulV2 = 0.0;
            this.cumulMvt = 0.0;
            this.nbCumul = 0;
        }
        ++this.nbCumul;
        this.cumulT += time;
        this.cumulV1 += controller.niveauVoie1Reel;
        this.cumulV2 += controller.niveauVoie2Reel;
        this.cumulMvt += Biostim.getVoie(11);
        if (controller.profilLevel != 0.0) {
            ++this.nbTendTravail;
            this.cumulTendTravail += controller.niveauVoie1Reel;
        } else {
            ++this.nbTendRepos;
            this.cumulTendRepos += controller.niveauVoie1Reel;
        }
        int cycle = (int)Math.floor(time / controller.profil.getDuree());
        if (cycle != this.cycle) {
            this.cycle = cycle;
            this.endMotifProfil();
        }
    }

    public void ajouteValeur(double time, double voie1, double voie2) {
        int pos = (int)(time / 0.1);
        if (pos != this.lastPos) {
            this.lastPos = pos;
            if (this.nbCumul != 0) {
                this.temps.add((int)(this.cumulT / (double)this.nbCumul * 100.0));
                this.niveauVoie1.add(this.cumulV1 / (double)this.nbCumul);
                this.niveauVoie2.add(this.cumulV2 / (double)this.nbCumul);
            }
            this.cumulT = 0.0;
            this.cumulV1 = 0.0;
            this.cumulV2 = 0.0;
            this.nbCumul = 0;
        } else {
            ++this.nbCumul;
            this.cumulT += time;
            this.cumulV1 += voie1;
            this.cumulV2 += voie2;
        }
    }

    public void ajouteValeur(double time, double voie1) {
        int pos = (int)(time / 0.1);
        if (pos != this.lastPos) {
            this.lastPos = pos;
            if (this.nbCumul != 0) {
                this.temps.add((int)(this.cumulT / (double)this.nbCumul * 100.0));
                this.niveauVoie1.add(this.cumulV1 / (double)this.nbCumul);
            }
            this.cumulT = 0.0;
            this.cumulV1 = 0.0;
            this.nbCumul = 0;
        } else {
            ++this.nbCumul;
            this.cumulT += time;
            this.cumulV1 += voie1;
        }
    }

    public void resetCumul() {
        this.lastPos = -1;
        this.nbCumul = 0;
    }

    public void endMotifProfil() {
        if (this.nbTendTravail > 0) {
            this.tendanceTravail.getData().add((Object)new XYChart.Data((Object)this.compteurCycle, (Object)(this.cumulTendTravail / (double)this.nbTendTravail)));
        }
        if (this.nbTendRepos > 0) {
            this.tendanceRepos.getData().add((Object)new XYChart.Data((Object)this.compteurCycle, (Object)(this.cumulTendRepos / (double)this.nbTendRepos)));
        }
        ++this.compteurCycle;
        this.nbTendTravail = 0;
        this.cumulTendTravail = 0.0;
        this.nbTendRepos = 0;
        this.cumulTendRepos = 0.0;
    }

    public void addEvent(String evt, double time) {
        this.tempsEvt.add((int)(time * 100.0));
        this.events.add(evt);
    }

    public String saveHistory(double max1, double max2) {
        try {
            if (Main.getConfig().isActivated && !this.temps.isEmpty()) {
                JSONObject json = new JSONObject();
                json.put("temps", new JSONArray((Collection<?>)this.temps));
                JSONArray nv1 = new JSONArray();
                for (double n : this.niveauVoie1) {
                    nv1.put((int)(n / max1 * 1000.0));
                }
                json.put("niveauVoie1", nv1);
                JSONArray nv2 = new JSONArray();
                for (double n : this.niveauVoie2) {
                    nv2.put((int)(n / max2 * 1000.0));
                }
                json.put("niveauVoie2", nv2);
                if (this.hasBalance) {
                    JSONArray nvmvt = new JSONArray();
                    double maxmvt = 1.0;
                    for (double n : this.mvt) {
                        if (!(n > maxmvt)) continue;
                        maxmvt = n;
                    }
                    for (double n : this.mvt) {
                        nvmvt.put((int)(n / maxmvt * 1000.0));
                    }
                    json.put("mvt", nvmvt);
                }
                json.put("tempsEvt", new JSONArray((Collection<?>)this.tempsEvt));
                json.put("events", new JSONArray((Collection<?>)this.events));
                Patient patient = Main.getCurrentPatient();
                String nomFichier = patient.getFirstName() + "_" + patient.getLastName() + "_" + Utils.fileDateFormat.format(new Date()) + ".json";
                FileWriter file = new FileWriter(Main.getConfig().getRepPatients() + "/seances/" + nomFichier);
                file.write(json.toString());
                file.close();
                return nomFichier;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

