/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.FtpBioPodBrut;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.configuration.Autotest;
import com.mazet.biostim.view.configuration.CloudManager;
import com.mazet.biostim.view.patient.PatientFile;
import com.mazet.biostim.view.programme.bfb.AnimationRevoir;
import com.mazet.biostim.view.programme.bilan.ProgBilan;
import com.mazet.biostim.zdata.Historique;
import com.mazet.biostim.zdata.Pageprogramme;
import com.mazet.biostim.zdata.Patient;
import com.mazet.biostim.zdata.Programme;
import com.mazet.biostim.zdata.Seance;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ProgEnCours {
    public Programme currentProgram;
    public Pageprogramme currentPageProgram;
    private boolean progQuitte = false;
    private int progDureeRestante = 0;
    private Integer pageDureeRestante;
    public final LinkedHashMap<String, Double> stimAmplitudeA = new LinkedHashMap();
    public final LinkedHashMap<String, Double> stimAmplitudeB = new LinkedHashMap();
    public double imaxA;
    public double imaxB;
    private long dansProfil = 1L;
    private long horsProfil = 0L;
    public double points = 0.0;
    private int minPower = 9999;
    private int minPower2 = 9999;
    private int maxPower = -1;
    private int maxPower2 = -1;
    private int nbContractions = 1;
    private int nbRepos = 1;
    private double lastProfilLevel = 0.0;
    private Double startPlateau = null;
    private boolean contractionOK = true;
    private double sommeContractionMoyenne = 0.0;
    private double sommeReposMoyen = 0.0;
    private double sommeDeficitContraction = 0.0;
    private double sommeDeficitContractionPourMille = 0.0;
    public int nbContractionsCompletes = 0;
    public Historique historique;
    public AnimationRevoir revoir;
    public int fpsBFB = 0;
    private final double[] affMaxVoie = new double[17];
    private final double[] baseVoie = new double[17];
    private final double[] affMinVoie = new double[17];
    public int epaisseurProfil;
    public boolean aleatoire;
    public int seuilBFBAssiste = 60;
    public String commentaire = "";
    public int position = 0;
    public int typeAnimation = -1;

    public ProgEnCours(Programme programme) {
        if (Main.getConfig().isVerrouille()) {
            Utils.popupAlert(TransientConfig.translate("appareil_verrouille"));
            return;
        }
        if (Main.getConfig().nbAvantBlocage <= 0) {
            Utils.popupAlert(TransientConfig.translate("nonActiveBloque"));
            Main.menu.goToConfig();
            return;
        }
        if (!Main.getConfig().modeDemo && (!UsbBiostim.isConnexionBioStim() || UsbBiostim.getEtatPoire() != 0 && programme.containStim())) {
            String diag = Autotest.getDiagString().replaceAll("<ul>", "").replaceAll("</ul>", "").replaceAll("<li/>", "\n- ");
            Utils.popupAlert(TransientConfig.translate("lancement_impossible") + "\n\n" + diag);
            return;
        }
        Main.currentController.exitAction();
        System.out.println();
        Utils.debugInfo("Lancement du prog %d dur\u00e9e %s : %s", programme.getId(), Utils.stringOfTime(programme.getDuree()), programme.getNom());
        int pos0 = 0;
        while (programme.getListPage().get(pos0).getType() == 2) {
            ++pos0;
        }
        Pageprogramme page0 = programme.getListPage().get(pos0);
        int typePage0 = page0.getType();
        if (typePage0 == 9) {
            page0.progs.clear();
            page0.nbRepet.clear();
            page0.initAleaIfNull(null);
            if (page0.aleaProgs.isEmpty()) {
                return;
            }
        }
        if ((typePage0 == 5 || typePage0 == 8) && page0.progs.isEmpty()) {
            return;
        }
        if (typePage0 == 12 && page0.motifs.isEmpty()) {
            return;
        }
        if (programme.getVoieBFB1() == -1) {
            programme.setVoieBFB1(Biostim.defaultVoie1());
        }
        if (programme.getVoieBFB1() == programme.getVoieBFB2()) {
            programme.setVoieBFB2(-1);
        }
        if (Biostim.isVoieBT(programme.getVoieBFB1()) || Biostim.isVoieBT(programme.getVoieBFB2()) || typePage0 == 13) {
            if (Biostim.isBTforbidden(programme.getVoieBFB1()) || Biostim.isBTforbidden(programme.getVoieBFB2()) || typePage0 == 13 && Biostim.isBTforbidden(9)) {
                Utils.popupAlert(TransientConfig.translate("lancement_impossible_BT"));
                return;
            }
            if (!(UsbBiostim.isConnexionBioStim() && Main.getConfig().optionBluetooth >= 2 || programme.getDuree() <= 60)) {
                programme.setDuree(60);
            }
        }
        if (programme.getType() == 8 && SondeBT.connectionBiomoov < 3) {
            return;
        }
        if (Main.getConfig().versionRecherche) {
            // empty if block
        }
        if (typePage0 == 8) {
            programme.page0 = page0;
            programme.getListPage().clear();
            ArrayList<Programme> allProgs = Programme.getAllProgrammes();
            for (int i = 0; i < page0.progs.size(); ++i) {
                int pid = page0.progs.get(i);
                for (Programme p : allProgs) {
                    if (pid != p.getId()) continue;
                    Pageprogramme pp = p.getFirstPage();
                    pp.setDuree(page0.nbRepet.get(i));
                    if (i == page0.progs.size() - 1) {
                        pp.setNext(1);
                    } else {
                        pp.setNext(i + 2);
                    }
                    programme.getListPage().add(pp);
                }
            }
        }
        if (!Version.isSAV()) {
            programme.ajouteReglagesStim(this);
        }
        programme.ajouteTarage();
        if (programme.getVoieBFB1() != -1) {
            this.initTarage(programme, programme.getVoieBFB1());
        }
        if (programme.getVoieBFB2() != -1) {
            if (programme.tarage2 == null) {
                this.initTarage(programme, programme.getVoieBFB2());
            } else {
                this.baseVoie[programme.getVoieBFB2()] = 0.0;
                this.affMinVoie[programme.getVoieBFB2()] = 0.0;
                this.affMaxVoie[programme.getVoieBFB2()] = programme.tarage2.intValue();
            }
        }
        this.currentProgram = programme;
        this.progDureeRestante = programme.getDuree();
        this.historique = new Historique(programme);
        this.epaisseurProfil = Main.getConfig().epaisseurProfil;
        Main.progEnCours = this;
        this.gotoPage(0);
    }

    public String getProgDureeRestanteString() {
        return Utils.stringOfTime(this.progDureeRestante);
    }

    public int getProgDureeRestante() {
        return this.progDureeRestante;
    }

    public void setProgDureeRestante(int duree) {
        this.progDureeRestante = duree;
    }

    public void decrProgDureeRestante() {
        if (this.progDureeRestante > 0) {
            --this.progDureeRestante;
        }
    }

    public String getPageDureeRestanteString() {
        return Utils.stringOfTime(this.pageDureeRestante);
    }

    public Integer getPageDureeRestante() {
        return this.pageDureeRestante;
    }

    public void setPageDureeRestante(Integer duree) {
        this.pageDureeRestante = duree;
    }

    public void decrPageDureeRestante() {
        if (this.pageDureeRestante != null && this.pageDureeRestante > 0) {
            Integer n = this.pageDureeRestante;
            Integer n2 = this.pageDureeRestante = Integer.valueOf(this.pageDureeRestante - 1);
        }
    }

    public void finProgramme() {
        if (this.progQuitte) {
            return;
        }
        this.progQuitte = true;
        Runtime runtime = Runtime.getRuntime();
        Utils.debugInfo("fin de prog : reussite %d, amplitude %d%nvoie 1 : %d/%d ; aff %.0f/%.0f/%.0f%nvoie 2 : %d/%d ; aff %.0f/%.0f/%.0f%n%nmem free %d Mo / total %d Mo / max %d Mo%n", this.getPourcentageReussite(), (int)this.getMaxStimAmplitudeA(), this.minPower, this.maxPower, this.getAffMin(this.currentProgram.getVoieBFB1()), this.getBase(this.currentProgram.getVoieBFB1()), this.getAffMax(this.currentProgram.getVoieBFB1()), this.minPower2, this.maxPower2, this.getAffMin(this.currentProgram.getVoieBFB2()), this.getBase(this.currentProgram.getVoieBFB2()), this.getAffMax(this.currentProgram.getVoieBFB2()), runtime.freeMemory() / 1024L / 1024L, runtime.totalMemory() / 1024L / 1024L, runtime.maxMemory() / 1024L / 1024L);
        int duree = this.currentProgram.getDuree() - this.getProgDureeRestante();
        Main.getConfig().incrDureeUtilisation(duree);
        boolean newPatient = false;
        if (duree > 10) {
            Seance seance;
            newPatient = ProgEnCours.askForPatient();
            if (Main.getCurrentPatient() != null) {
                seance = new Seance(Main.progEnCours);
                Main.getCurrentPatient().getSessions().get(0).getListSeances().add(seance);
                if (!newPatient) {
                    Main.getCurrentPatient().save(true);
                }
            } else {
                if (Main.tempPatient == null) {
                    Main.tempPatient = new Patient("000", "Patient");
                }
                Main.setCurrentPatient(Main.tempPatient);
                seance = new Seance(Main.progEnCours);
                Main.tempPatient.getSessions().get(0).getListSeances().add(seance);
                Main.setCurrentPatient(null);
            }
            if (UsbBiostim.isConnexionBioStim() && !Version.isSAV()) {
                CloudManager.sendSeanceCloud(seance);
            }
        }
        if (!this.currentProgram.forceNoTarage()) {
            TransientConfig.setTarage(this.currentProgram.getVoieBFB1());
            if (this.currentProgram.getVoieBFB2() != -1 && this.currentProgram.tarage2 == null) {
                TransientConfig.setTarage(this.currentProgram.getVoieBFB2());
            }
        }
        FtpBioPodBrut.close();
        this.ouvrePageSuivante(newPatient);
    }

    public void finBilan(ProgBilan progBilan) {
        if (this.progQuitte) {
            return;
        }
        this.progQuitte = true;
        boolean newPatient = false;
        if (progBilan.isNonVide()) {
            progBilan.bilan.printDebug();
            newPatient = ProgEnCours.askForPatient();
            if (Main.getCurrentPatient() != null) {
                progBilan.bilan.courbeSauvee = this.historique.saveHistory(100.0, 100.0);
                Main.getCurrentPatient().getSessions().get(0).getListBilans().add(progBilan.bilan);
                if (!newPatient) {
                    Main.getCurrentPatient().save(true);
                }
            } else {
                if (Main.tempPatient == null) {
                    Main.tempPatient = new Patient("000", "Patient");
                }
                Main.setCurrentPatient(Main.tempPatient);
                progBilan.bilan.courbeSauvee = this.historique.saveHistory(100.0, 100.0);
                Main.tempPatient.getSessions().get(0).getListBilans().add(progBilan.bilan);
                Main.setCurrentPatient(null);
            }
            if (UsbBiostim.isConnexionBioStim() && !Version.isSAV()) {
                CloudManager.sendBilanCloud(progBilan.bilan);
            }
        } else {
            Utils.debugInfo("bilan vide, on oublie");
        }
        this.ouvrePageSuivante(newPatient);
    }

    private void ouvrePageSuivante(boolean newPatient) {
        if (newPatient || "patient".equals(Main.getCategorie())) {
            Main.progEnCours = null;
            Main.changeCenterView("patient", "bilan", Main.menu.patientButton);
        } else {
            Main.changeCenterView("programme", "progList", Main.menu.homeButton);
        }
    }

    public static boolean askForPatient() {
        try {
            if (Main.getCurrentPatient() == null && Main.getConfig().forcePatient && Main.getConfig().optionPatients()) {
                ArrayList<PatientFile> listPatient = PatientFile.getPatientFiles(false);
                ChoiceDialog dialog = new ChoiceDialog(null, listPatient);
                FxUtils.setCssPopup((Parent)dialog.getDialogPane());
                dialog.setHeaderText(TransientConfig.translate("pas_de_patient"));
                ImageView iv = new ImageView(new Image("/res/img/logo/patients_bleu.png"));
                iv.setPreserveRatio(true);
                iv.setFitWidth(50.0);
                iv.setFitHeight(50.0);
                dialog.initOwner(Main.sceneMain.getWindow());
                dialog.setGraphic((Node)iv);
                ButtonType choisir = new ButtonType(TransientConfig.translate("select"));
                ButtonType nouveau = new ButtonType(TransientConfig.translate("newPatient"));
                ButtonType cancel = new ButtonType(TransientConfig.translate("doNotSave"), ButtonBar.ButtonData.CANCEL_CLOSE);
                dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{choisir, nouveau, cancel});
                dialog.setResultConverter(button -> {
                    if (button == choisir) {
                        Main.setCurrentPatient(Patient.patientFromJson(((PatientFile)dialog.getSelectedItem()).getFileName()));
                        return null;
                    }
                    if (button == nouveau) {
                        Main.setCurrentPatient(new Patient());
                        return new PatientFile();
                    }
                    return null;
                });
                Optional res = dialog.showAndWait();
                return res.isPresent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void gotoPage(int page) {
        Pageprogramme pageToPlay = this.currentProgram.getListPage().get(page);
        this.gotoPage(pageToPlay);
    }

    private void gotoPage(Pageprogramme pageToPlay) {
        try {
            int oldType = this.currentPageProgram == null ? -1 : this.currentPageProgram.getType();
            int newType = pageToPlay.getType();
            if (newType == 1 && oldType >= 4) {
                Computer.playSong(Main.getConfig().getSonPageStim());
            }
            if (oldType == 1 && newType >= 4) {
                Computer.playSong(Main.getConfig().getSonPageBFB());
            }
            this.currentPageProgram = pageToPlay;
            this.pageDureeRestante = pageToPlay.getDuree();
            switch (newType) {
                case 1: {
                    this.loadPage("stimulationView");
                    break;
                }
                case 2: {
                    this.loadPage("tarageView");
                    break;
                }
                case -2: 
                case -1: {
                    new ProgBilan();
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    this.loadPage("bfb/biofeedback");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void gotoSamePage() {
        this.gotoPage(this.currentPageProgram);
    }

    public void gotoNextPage() {
        try {
            if (Main.progEnCours.getProgDureeRestante() > 0 && this.currentPageProgram.getNext() != 0) {
                this.gotoPage(this.currentPageProgram.getNext() - 1);
            } else {
                this.finProgramme();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void gotoLastPage() {
        int currentIndex = this.currentProgram.getListPage().indexOf(this.currentPageProgram);
        if (currentIndex > 0) {
            this.gotoPage(currentIndex - 1);
        } else {
            this.finProgramme();
        }
    }

    private void loadPage(String type) {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(TransientConfig.langue);
            loader.setLocation(Main.class.getResource("view/programme/" + type + ".fxml"));
            Main.mainLayout.setCenter((Node)loader.load());
            Main.currentController = (Controller)loader.getController();
            Main.currentController.setMain();
            Main.mainLayout.setLeft(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTarage(Programme programme, int voie) {
        double niveau = Biostim.getVoie(voie);
        if (Version.isSAV()) {
            this.baseVoie[voie] = 0.0;
            this.affMaxVoie[voie] = niveau * 2.0;
            this.affMinVoie[voie] = 0.0;
        } else if (programme.forceNoTarage()) {
            this.baseVoie[voie] = niveau;
            this.affMaxVoie[voie] = niveau * 1.1;
            this.affMinVoie[voie] = 0.0;
        } else {
            int min = TransientConfig.getTarageMin(voie);
            int max = TransientConfig.getTarageMax(voie);
            this.affMinVoie[voie] = this.baseVoie[voie] = (double)min;
            this.affMaxVoie[voie] = max;
        }
    }

    public void incDansProfil() {
        ++this.dansProfil;
    }

    public void incHorsProfil() {
        ++this.horsProfil;
    }

    public int getPourcentageReussite() {
        return (int)(100L * this.dansProfil / (this.horsProfil + this.dansProfil));
    }

    public boolean hasPourcentageReussite() {
        return this.dansProfil + this.horsProfil > 1L;
    }

    public int getMinPower() {
        return this.minPower;
    }

    public int getMinPower2() {
        return this.minPower2;
    }

    public int getMaxPower() {
        return this.maxPower;
    }

    public int getMaxPower2() {
        return this.maxPower2;
    }

    public void updatePower(double power, double profilLevel, double dureeMilli, boolean pasDeStim) {
        if (power > (double)this.maxPower) {
            this.maxPower = (int)Math.ceil(power);
        }
        if (power < (double)this.minPower) {
            this.minPower = (int)power;
        }
        if (pasDeStim && profilLevel > 20.0) {
            ++this.nbContractions;
            this.sommeContractionMoyenne += power;
            if (this.lastProfilLevel <= 20.0) {
                this.contractionOK = true;
            }
            int voie = this.currentProgram.getVoieBFB1();
            double hauteurCourbeBaseTonus = profilLevel * (double)(100 - this.epaisseurProfil) / 100.0 / 100.0 * (this.getAffMax(voie) - this.getBase(voie));
            double delta = this.getBase(voie) + hauteurCourbeBaseTonus - power;
            if (delta > 0.0) {
                this.sommeDeficitContraction += delta;
                this.sommeDeficitContractionPourMille += 1000.0 * delta / hauteurCourbeBaseTonus;
            }
            if (profilLevel == this.lastProfilLevel) {
                if (this.startPlateau == null) {
                    this.startPlateau = dureeMilli;
                }
            } else {
                this.startPlateau = null;
            }
            if ((this.startPlateau != null && dureeMilli - this.startPlateau > 0.5 || profilLevel > 70.0) && power < this.getBase(voie) + 0.9 * hauteurCourbeBaseTonus) {
                this.contractionOK = false;
            }
        } else {
            ++this.nbRepos;
            this.sommeReposMoyen += power;
            if (this.lastProfilLevel > 20.0 && this.contractionOK) {
                ++this.nbContractionsCompletes;
            }
        }
        this.lastProfilLevel = profilLevel;
    }

    public void updatePower2(double power) {
        if (power > (double)this.maxPower2) {
            this.maxPower2 = (int)Math.ceil(power);
        }
        if (power < (double)this.minPower2) {
            this.minPower2 = (int)power;
        }
    }

    public double getContractionMoyenne() {
        return this.sommeContractionMoyenne / (double)this.nbContractions;
    }

    public double getReposMoyen() {
        return this.sommeReposMoyen / (double)this.nbRepos;
    }

    public double getDeficitContraction() {
        return this.sommeDeficitContraction / (double)this.nbContractions;
    }

    public int getDeficitContractionPourMille() {
        return (int)(this.sommeDeficitContractionPourMille / (double)this.nbContractions);
    }

    public double getStimAmplitudeA() {
        String freq = this.currentPageProgram.getFreq() + "/" + this.currentPageProgram.getLargeur();
        try {
            return this.stimAmplitudeA.get(freq);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getMaxStimAmplitudeA() {
        double res = 0.0;
        for (Map.Entry<String, Double> e : this.stimAmplitudeA.entrySet()) {
            res = Math.max(res, e.getValue());
        }
        return res;
    }

    public double getMaxStimAmplitudeB() {
        double res = 0.0;
        for (Map.Entry<String, Double> e : this.stimAmplitudeB.entrySet()) {
            res = Math.max(res, e.getValue());
        }
        return res;
    }

    public double setStimAmplitudeA(double amplitude) {
        if (amplitude < 0.0) {
            amplitude = 0.0;
        }
        if (amplitude > this.imaxA) {
            amplitude = this.imaxA;
        }
        String freq = this.currentPageProgram.getFreq() + "/" + this.currentPageProgram.getLargeur();
        this.stimAmplitudeA.put(freq, amplitude);
        return amplitude / this.imaxA;
    }

    public double getStimAmplitudeB() {
        String freq = this.currentPageProgram.getFreq2() + "/" + this.currentPageProgram.getLargeur2();
        try {
            return this.stimAmplitudeB.get(freq);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double setStimAmplitudeB(double amplitude) {
        if (amplitude < 0.0) {
            amplitude = 0.0;
        }
        if (amplitude > this.imaxB) {
            amplitude = this.imaxB;
        }
        String freq = this.currentPageProgram.getFreq2() + "/" + this.currentPageProgram.getLargeur2();
        this.stimAmplitudeB.put(freq, amplitude);
        return amplitude / this.imaxB;
    }

    public double getAffMax(int voie) {
        if (voie < 0) {
            return 0.0;
        }
        if (voie == 8) {
            return 100.0;
        }
        return this.affMaxVoie[voie];
    }

    public void forceAffMax(int voie, double val) {
        this.affMaxVoie[voie] = val;
        UsbBiostim.selectCalibre(voie, val);
    }

    public void setAffMax(int voie, double val) {
        if (val < this.affMinVoie[voie]) {
            val = this.affMinVoie[voie];
        }
        if (val < this.baseVoie[voie]) {
            val = this.baseVoie[voie];
        }
        if (val > Biostim.getMaxVoie(voie)) {
            val = Biostim.getMaxVoie(voie);
        }
        this.affMaxVoie[voie] = val;
        UsbBiostim.selectCalibre(voie, val);
    }

    public void incrAffMax(int voie, int delta) {
        this.setAffMax(voie, this.affMaxVoie[voie] + (double)delta * Utils.getDoubleDelta(this.affMaxVoie[voie] - this.getBase(voie)));
    }

    public double getBase(int voie) {
        if (Version.isSAV() || voie < 0) {
            return 0.0;
        }
        return this.baseVoie[voie];
    }

    public void setBase(int voie, double val) {
        if (val < 0.0) {
            val = 0.0;
        }
        boolean noNeg = this.baseVoie[voie] == this.affMinVoie[voie];
        this.baseVoie[voie] = val;
        if (noNeg || this.affMinVoie[voie] > val) {
            this.affMinVoie[voie] = val;
        }
    }

    public double getAffMin(int voie) {
        if (voie < 0) {
            return 0.0;
        }
        return this.affMinVoie[voie];
    }

    public void setAffMin(int voie, double val) {
        if (val < 0.0) {
            val = 0.0;
        }
        this.affMinVoie[voie] = val;
    }

    public void incrAffMin(int voie, int delta) {
        this.setAffMin(voie, this.affMinVoie[voie] + (double)delta * Utils.getDoubleDelta(this.affMinVoie[voie]));
    }

    public String relativeValue(int voie, double res) {
        if (Main.getConfig().baseZeroPatient) {
            res -= this.getBase(voie);
        }
        if (res < 10.0) {
            return String.format("%.1f", res);
        }
        return String.format("%.0f", res);
    }

    public void setImaxA() {
        this.imaxA = this.currentPageProgram.getImaxA();
        if (this.imaxA < 1.0) {
            Utils.popupAlert(TransientConfig.translate("motif_trop_energetique"));
        }
    }

    public void setImaxB() {
        this.imaxB = this.currentPageProgram.getImaxB();
        if (this.imaxB < 1.0) {
            Utils.popupAlert(TransientConfig.translate("motif_trop_energetique"));
        }
    }
}

