/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.comm;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.BioPod;
import com.mazet.biostim.comm.CommandesBiopod;
import com.mazet.biostim.comm.FtpBioPodBrut;
import com.mazet.biostim.comm.UsbBiopod;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Maths;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.configuration.BalanceConfig;
import com.mazet.biostim.view.configuration.BiopodTest;
import com.mazet.biostim.view.configuration.CloudManager;
import com.mazet.biostim.view.main.listViewController;
import com.mazet.biostim.view.programme.ProgListController;
import com.mazet.biostim.view.programme.TarageController;
import com.mazet.biostim.view.programme.bfb.AnimationAPA;
import com.mazet.biostim.view.programme.bfb.AnimationBalance;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.view.programme.bfb.BiofeedbackController;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javafx.application.Platform;

public abstract class SondeBT {
    public static int sondeBT = 0;
    public static int batterySonde = -1;
    public static int levelSonde1 = 0;
    public static int levelSonde2 = 0;
    public static int batteryBioPod = -1;
    public static int batteryHealthBioPod = 0;
    public static int batteryBiomoov = -1;
    public static double balanceX;
    public static double balanceY;
    public static double balanceV;
    public static double biomoovGonioX;
    public static double biomoovGonioY;
    public static double biomoovGonioZ;
    public static double biomoovGonio;
    public static int batteryBlueback;
    public static int levelBlueback;
    public static boolean bluebackCalibre;
    public static int connectionSonde;
    public static int connectionBiomoov;
    public static int connectionBioPod;
    public static int connectionBlueback;
    private static int dataReceivedSonde;
    private static int dataReceivedBiomoov;
    private static int dataReceivedBioPod;
    private static InputStream is;
    private static OutputStream os;
    private static String trameTemp;
    private static long lastReceptBiomoov;
    private static double refGonioX;
    private static double refGonioY;
    private static double refGonioZ;

    public static void start() {
        if (connectionSonde == 0) {
            if (SondeBT.isOsCompatible()) {
                Utils.debugInfo("D\u00e9marrage du service BLEconnect");
                connectionSonde = 1;
                SondeBT.setConnectionBiomoov(1);
                connectionBioPod = 1;
                connectionBlueback = 1;
                new Thread(SondeBT::read).start();
                new Thread(SondeBT::monitor).start();
                new Thread(SondeBT::lanceExe).start();
            } else {
                Utils.popupAlert(TransientConfig.translate("BT_impossible_OS"));
            }
        }
    }

    public static boolean isOsCompatible() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("windows 10") || os.contains("windows 11") || os.contains("mac os x");
    }

    public static void stop() {
        if (connectionSonde != 0) {
            Utils.debugInfo("Stop service BLEconnect");
            is = null;
            if (os != null) {
                try {
                    SondeBT.commandeBLEConnect(ActionBLEConnect.kill);
                    Thread.sleep(250L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                os = null;
            }
            SondeBT.osKill();
        }
        connectionSonde = 0;
        SondeBT.setConnectionBiomoov(0);
        connectionBioPod = 0;
        connectionBlueback = 0;
        batterySonde = -1;
        batteryBiomoov = -1;
        batteryBlueback = -1;
        batteryBioPod = -1;
        bluebackCalibre = false;
        sondeBT = 0;
        Main.menu.changeBTStatus();
        if (Main.currentController instanceof listViewController) {
            Platform.runLater(Main.menu::goToHome);
        }
        boolean isAPAOrBalance = false;
        if (Main.currentController instanceof BiofeedbackController) {
            BiofeedbackAnimation animation = ((BiofeedbackController)Main.currentController).biofeedbackAnimation;
            boolean bl = isAPAOrBalance = animation instanceof AnimationAPA || animation instanceof AnimationBalance;
        }
        if (Main.progEnCours != null && (Biostim.isVoieBT(Main.progEnCours.currentProgram.getVoieBFB1()) || Biostim.isVoieBT(Main.progEnCours.currentProgram.getVoieBFB2()) || isAPAOrBalance)) {
            Main.telecommandeStop();
        } else if (Main.currentController instanceof BalanceConfig) {
            Platform.runLater(() -> Main.menu.goToHome());
        }
    }

    private static void lanceExe() {
        try {
            Main.menu.changeBTStatus();
            SondeBT.osKill();
            String cmd = UsbBiopod.isConnexionBiopod() ? " -nopod" : "";
            for (Map.Entry<Integer, String> ble : Main.getConfig().lastAddrBLE.entrySet()) {
                if (UsbBiopod.isConnexionBiopod() && ble.getKey() == 5) continue;
                cmd = cmd + " " + ble.getValue();
            }
            Process p = Runtime.getRuntime().exec(SondeBT.osExe() + cmd);
            Utils.copyToOut(p.getErrorStream());
            is = p.getInputStream();
            os = p.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            Utils.popupAlert(TransientConfig.translate("noBleConnect", SondeBT.osExe()));
            SondeBT.stop();
        }
    }

    private static void osKill() {
        try {
            String cmd = Computer.isMac() ? "killall -9 MacBle" : "taskkill /F /IM BLEconnect.exe";
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String osExe() {
        if (Computer.isMac()) {
            return "./MacBle";
        }
        return Computer.absolutePath + "appData/BLEconnect.exe";
    }

    private static void monitor() {
        int countdownActivite = 600;
        while (connectionSonde != 0) {
            try {
                if (Main.progEnCours != null && (Biostim.isVoieBT(Main.progEnCours.currentProgram.getVoieBFB1()) || Biostim.isVoieBT(Main.progEnCours.currentProgram.getVoieBFB2()) || connectionBiomoov != 0) || Main.currentController instanceof BiopodTest) {
                    countdownActivite = 600;
                } else if (--countdownActivite < 0) {
                    Utils.debugInfo("deconnexion de la sonde BT pour inactivit\u00e9 prolong\u00e9e");
                    SondeBT.stop();
                }
                SondeBT.checkDevice(connectionSonde, --dataReceivedSonde, "Sonde BT");
                SondeBT.checkDevice(connectionBiomoov, --dataReceivedBiomoov, "Biomoov");
                if (!Main.getConfig().versionRecherche) {
                    SondeBT.checkDevice(connectionBioPod, --dataReceivedBioPod, "BioPod");
                }
                Utils.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void checkDevice(int connection, int dataReceived, String name) {
        if (connection >= 2 && dataReceived < 0) {
            if (connection == 2) {
                Utils.popupAlert(TransientConfig.translate("BT_sonde_appairee"));
            }
            Utils.debugInfo("deconnexion %s (aucune donn\u00e9e re\u00e7ue)", name);
            SondeBT.stop();
        }
    }

    private static void read() {
        trameTemp = "";
        while (connectionSonde != 0) {
            try {
                if (is != null) {
                    byte[] bread = new byte[256];
                    int nb = is.read(bread);
                    if (nb == -1) {
                        SondeBT.stop();
                        return;
                    }
                    char[] cread = new char[nb];
                    for (int i = 0; i < nb; ++i) {
                        cread[i] = bread[i] >= 0 ? (char)bread[i] : (char)(bread[i] + 256);
                    }
                    trameTemp = trameTemp + new String(cread);
                    SondeBT.decodeBuffer();
                    continue;
                }
                Utils.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                Utils.debugInfo("perte de COM avec BLEconnect : " + e);
                SondeBT.stop();
            }
        }
    }

    private static void decodeBuffer() {
        boolean continu = true;
        while (continu) {
            continu = false;
            int posDeb = trameTemp.indexOf(60);
            if (posDeb >= 0) {
                int posFin = (trameTemp = trameTemp.substring(posDeb)).indexOf(62);
                if (posFin < 0) continue;
                String trame = trameTemp.substring(1, posFin);
                boolean crcOK = true;
                if (trame.charAt(0) != '@') {
                    int crc = Integer.parseInt(trameTemp.substring(posFin - 4, posFin), 16);
                    boolean bl = crcOK = crc == SondeBT.calculate_crc(trameTemp.substring(1, posFin - 4));
                }
                if (crcOK) {
                    SondeBT.decodeTrame(trame);
                } else {
                    Utils.debugInfo("CRC incorrect, trame ignor\u00e9e : %s", trame);
                }
                trameTemp = trameTemp.substring(posFin + 1);
                continu = true;
                continue;
            }
            trameTemp = "";
        }
    }

    private static int calculate_crc(String trame) {
        byte[] buffer = trame.getBytes();
        int crc = 65535;
        for (byte b : buffer) {
            crc = (crc >>> 8 | crc << 8) & 0xFFFF;
            crc ^= b & 0xFF;
            crc ^= (crc & 0xFF) >> 4;
            crc ^= crc << 12 & 0xFFFF;
            crc ^= (crc & 0xFF) << 5 & 0xFFFF;
        }
        return crc &= 0xFFFF;
    }

    private static void decodeTrame(String trame) {
        try {
            if (trame.charAt(0) == '@') {
                if (!trame.contains("Device trouve") || connectionSonde < 2 && connectionBiomoov < 2 && connectionBioPod < 2 && batteryBlueback == -1) {
                    System.out.format("    BLEconnect : %s%n", trame.substring(1));
                    if (trame.contains("Demarrage de BLEconnect") && !trame.endsWith("2.05")) {
                        Platform.runLater(() -> Utils.makeToast("Version de BLEconnect non optimale. V\u00e9rifier votre installation", new Object[0]));
                    } else if (trame.contains("Demarrage de MacBle") && !trame.endsWith("1.04")) {
                        Platform.runLater(() -> Utils.makeToast("Version de MacBle non optimale. V\u00e9rifier votre installation", new Object[0]));
                    }
                }
                return;
            }
            String[] decoupe = trame.split(";");
            block16 : switch (decoupe[0]) {
                case "C": {
                    int type = Integer.parseInt(decoupe[1]);
                    switch (type) {
                        case 1: 
                        case 2: {
                            sondeBT = type;
                            SondeBT.dataReceivedSonde();
                            break;
                        }
                        case 3: {
                            SondeBT.dataReceivedBiomoov();
                            break;
                        }
                        case 4: {
                            if (connectionBlueback == 1) {
                                connectionBlueback = 2;
                                if (Main.currentController instanceof listViewController) {
                                    Platform.runLater(Main.menu::goToHome);
                                }
                            }
                            batteryBlueback = Integer.parseInt(decoupe[3]);
                            Utils.debugInfo("Connexion Blueback OK. Bat = %d", batteryBlueback);
                            bluebackCalibre = false;
                            Main.menu.changeBTStatus();
                            if (Integer.parseInt(decoupe[4]) == 0) break;
                            SondeBT.bluebackEnCharge();
                            break;
                        }
                        case 5: {
                            dataReceivedBioPod = Main.getConfig().timeOutBT;
                            SondeBT.connectBiopod(decoupe);
                        }
                    }
                    Main.getConfig().setLastAddrBLE(type, decoupe[2]);
                    break;
                }
                case "S": {
                    SondeBT.setBatterySonde(decoupe[1]);
                    levelSonde1 = Integer.parseInt(decoupe[2]);
                    if (levelSonde1 > 30000) {
                        levelSonde1 = 0;
                    }
                    levelSonde2 = Integer.parseInt(decoupe[3]);
                    if (connectionSonde == 2) {
                        Utils.debugInfo("Connexion sonde OK. Bat = %d", batterySonde);
                    }
                    SondeBT.dataReceivedSonde();
                    break;
                }
                case "B": {
                    SondeBT.decodeTrameBiomoov(decoupe);
                    break;
                }
                case "P0": {
                    SondeBT.setBatteryBioPod(decoupe);
                    break;
                }
                case "P1": {
                    SondeBT.dataReceivedBioPod();
                    BioPod.setBiopodA((double)Integer.parseInt(decoupe[1]) / 10.0);
                    break;
                }
                case "P2": {
                    BioPod.setBiopodB((double)Integer.parseInt(decoupe[1]) / 10.0);
                    break;
                }
                case "PLO": {
                    BioPod.biopodLeadOff = Integer.parseInt(decoupe[1], 16);
                    Utils.debugLine("lead off : %02X", BioPod.biopodLeadOff);
                    break;
                }
                case "PR1": {
                    FtpBioPodBrut.addData(decoupe[1]);
                    BioPod.rawBiopodA.decodeBTRawBioPod(decoupe);
                    break;
                }
                case "PR2": {
                    BioPod.rawBiopodB.decodeBTRawBioPod(decoupe);
                    break;
                }
                case "PJSON": {
                    BioPod.saveJson(decoupe[1]);
                    break;
                }
                case "K": {
                    SondeBT.decodeTrameBlueback(trame, decoupe);
                    break;
                }
                case "V": {
                    SondeBT.bluebackEnCharge();
                    break;
                }
                case "Z": {
                    Utils.debugInfo("trame erreur BLEConnect : " + trame);
                    switch (decoupe[1]) {
                        default: {
                            Utils.popupAlert(TransientConfig.translate("BT_impossible_HW"));
                            break block16;
                        }
                        case "2": {
                            Utils.popupAlert(TransientConfig.translate("activer_BT"));
                            break block16;
                        }
                        case "1": {
                            Utils.popupAlert(TransientConfig.translate("BT_impossible_OS"));
                            break block16;
                        }
                        case "4": 
                    }
                    Utils.popupAlert(TransientConfig.translate("BT_Mac_interdit"));
                    break;
                }
                default: {
                    Utils.debugInfo("trame BLEconnect inconnue : " + trame);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void bluebackEnCharge() {
        Utils.popupAlert(TransientConfig.translate("blueback_en_charge"));
        SondeBT.stop();
    }

    public static void commandeBLEConnect(ActionBLEConnect actionBLEConnect) {
        try {
            os.write(actionBLEConnect.code.getBytes());
            os.write(10);
            os.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void commandeBLEConnect(ActionBLEConnect actionBLEConnect, int command, int valeur) {
        try {
            os.write(String.format("%s %d %d\n", actionBLEConnect.code, command, valeur).getBytes());
            os.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void decodeTrameBlueback(String trame, String[] decoupe) {
        switch (decoupe[1]) {
            case "MC": {
                levelBlueback = Integer.parseInt(decoupe[2]);
                if (Integer.parseInt(decoupe[3]) == 0) break;
                SondeBT.bluebackDecollee();
                break;
            }
            case "EC": {
                int pb = Integer.parseInt(decoupe[2]);
                Utils.debugInfo("trame re\u00e7ue : %s", trame);
                if ((pb & 1) != 0) {
                    SondeBT.bluebackDecollee();
                    break;
                }
                if (Main.currentController instanceof TarageController) {
                    ((TarageController)Main.currentController).retourCalibBlueback(pb);
                    break;
                }
                Utils.debugInfo("retour calib recu hors page de tarage => non trait\u00e9");
                break;
            }
            default: {
                Utils.debugInfo("trame re\u00e7ue : %s", trame);
            }
        }
    }

    private static void bluebackDecollee() {
        Main.telecommandeStop();
        Utils.popupAlert(TransientConfig.translate("blueback_decollee"));
        SondeBT.stop();
    }

    private static void setBatterySonde(String strBatt) {
        int new_batt = Integer.parseInt(strBatt);
        if (new_batt != batterySonde) {
            batterySonde = new_batt;
            Platform.runLater(() -> Main.menu.updateBattSonde());
        }
    }

    private static void setBatteryBiomoov(String strBatt) {
        int new_batt = Integer.parseInt(strBatt);
        if (new_batt != batteryBiomoov) {
            batteryBiomoov = new_batt;
            Platform.runLater(() -> Main.menu.updateBattBiomoov());
        }
    }

    private static void setBatteryBioPod(String[] strBatt) {
        int new_batt = Integer.parseInt(strBatt[1]);
        batteryHealthBioPod = Integer.parseInt(strBatt[2]);
        if (new_batt != batteryBioPod) {
            Utils.debugInfo("Bat Biopod : %d%% (health %d)", new_batt, batteryHealthBioPod);
            batteryBioPod = new_batt;
            Platform.runLater(() -> Main.menu.updateBattBioPod());
        }
    }

    private static void dataReceivedSonde() {
        dataReceivedSonde = Main.getConfig().timeOutBT;
        if (connectionSonde == 1 || connectionSonde == 2) {
            ++connectionSonde;
            Main.menu.changeBTStatus();
        }
    }

    private static void setConnectionBiomoov(int connectionBiomoov) {
        if (SondeBT.connectionBiomoov != connectionBiomoov) {
            if (connectionBiomoov == 3 != (SondeBT.connectionBiomoov == 3) && (Main.currentController instanceof listViewController || Main.currentController instanceof ProgListController && Main.getCategorie().equals("Balance"))) {
                Platform.runLater(() -> Main.menu.goToHome());
            }
            SondeBT.connectionBiomoov = connectionBiomoov;
        }
    }

    private static void decodeTrameBiomoov(String[] decoupe) {
        SondeBT.setBatteryBiomoov(decoupe[1]);
        if (connectionBiomoov == 2) {
            Utils.debugInfo("Connexion biomoov OK. Bat = %d", batteryBiomoov);
        }
        SondeBT.dataReceivedBiomoov();
        ArrayList<Integer> matrix = new ArrayList<Integer>();
        for (int i = 2; i < 11; ++i) {
            matrix.add(Integer.parseInt(decoupe[i]));
        }
        int balx = (Integer)matrix.get(6) * 1000 / 16384;
        int baly = (Integer)matrix.get(7) * 1000 / 16384;
        biomoovGonioX = (double)((Integer)matrix.get(0)).intValue() / 16384.0;
        biomoovGonioY = (double)((Integer)matrix.get(3)).intValue() / 16384.0;
        biomoovGonioZ = (double)((Integer)matrix.get(6)).intValue() / 16384.0;
        long now = System.currentTimeMillis();
        if (lastReceptBiomoov != 0L && now - lastReceptBiomoov > 10L) {
            double dx = (double)balx - balanceX;
            double dy = (double)baly - balanceY;
            balanceV = 10.0 * Math.sqrt(dx * dx + dy * dy) / (double)(now - lastReceptBiomoov);
            balanceX = balx;
            balanceY = baly;
        }
        lastReceptBiomoov = now;
        double scalaire = biomoovGonioX * refGonioX + biomoovGonioY * refGonioY + biomoovGonioZ * refGonioZ;
        double biomoov2 = biomoovGonioX * biomoovGonioX + biomoovGonioY * biomoovGonioY + biomoovGonioZ * biomoovGonioZ;
        double ref2 = refGonioX * refGonioX + refGonioY * refGonioY + refGonioZ * refGonioZ;
        biomoovGonio = Math.acos(scalaire /= Math.sqrt(biomoov2 * ref2)) * 180.0 / Math.PI;
    }

    public static void setRefGonio() {
        refGonioX = biomoovGonioX;
        refGonioY = biomoovGonioY;
        refGonioZ = biomoovGonioZ;
    }

    private static void dataReceivedBiomoov() {
        dataReceivedBiomoov = Main.getConfig().timeOutBT;
        if (connectionBiomoov < 3) {
            SondeBT.setConnectionBiomoov(connectionBiomoov + 1);
            Main.menu.changeBTStatus();
        }
    }

    public static void connectBiopod(String[] decoupe) {
        connectionBioPod = 2;
        Main.getConfig().numSerieBiopod = Integer.parseInt(decoupe[3]);
        Main.getConfig().modelBiopod = Integer.parseInt(decoupe[4]);
        Main.getConfig().fwBiopod = Maths.readableDecOfHex(Integer.parseInt(decoupe[5]));
        Main.getConfig().hwBiopod = Integer.parseInt(decoupe[6]);
        Main.getConfig().idBiopod = Integer.parseInt(decoupe[7]);
        Utils.debugInfo("--------------- Connexion Bluetooth Biopod BF-%05d (model %d) ---------------%n    FW : %d ; HW : %d ; id : %d", Main.getConfig().numSerieBiopod, Main.getConfig().modelBiopod, Main.getConfig().fwBiopod, Main.getConfig().hwBiopod, Main.getConfig().idBiopod);
        CloudManager.connectBiopod();
        try {
            BioPod.commandesBiopod = Utils.fromJsonFileWithException(BioPod.getCommandePath(), CommandesBiopod.class);
        }
        catch (Exception ignored) {
            SondeBT.commandeBLEConnect(ActionBLEConnect.biopodGetJson);
        }
    }

    private static void dataReceivedBioPod() {
        dataReceivedBioPod = Main.getConfig().timeOutBT;
        if (connectionBioPod == 2) {
            Utils.debugInfo("Data received biopod OK");
            connectionBioPod = 3;
            Main.menu.changeBTStatus();
        }
    }

    static {
        balanceV = 0.0;
        biomoovGonio = 0.0;
        batteryBlueback = -1;
        levelBlueback = 0;
        bluebackCalibre = false;
        connectionSonde = 0;
        connectionBiomoov = 0;
        connectionBioPod = 0;
        connectionBlueback = 0;
        is = null;
        os = null;
        trameTemp = "";
        lastReceptBiomoov = 0L;
        refGonioX = 0.0;
        refGonioY = 0.0;
        refGonioZ = 1.0;
    }

    public static enum ActionBLEConnect {
        kill("kill"),
        debutCalibration("BB_debutCalib"),
        finCalibration("BB_finCalib"),
        debutAcquisition("BB_debutAcquisition"),
        finAcquisition("BB_finAcquisition"),
        startBioPodRaw("BP_startRaw"),
        stopBioPodRaw("BP_stopRaw"),
        startBioPodRaw2("BP_startRaw2"),
        stopBioPodRaw2("BP_stopRaw2"),
        biopodGetJson("BP_getJson"),
        biopodCmdWriteInt("BP_cmdWriteInt"),
        biopodCmdWriteByte("BP_cmdWriteByte");

        final String code;

        private ActionBLEConnect(String code) {
            this.code = code;
        }
    }
}

