/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

public abstract class Fft {
    public static final int maxSize = 16384;
    public static int n = 512;
    static int bits = (int)(Math.log(n) / Math.log(2.0));
    static double[] cos;
    static double[] sin;

    public static synchronized void resetSize(int n) {
        Fft.n = n;
        bits = (int)(Math.log(n) / Math.log(2.0));
        cos = new double[n / 2];
        sin = new double[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            Fft.cos[i] = Math.cos(Math.PI * -2 * (double)i / (double)n);
            Fft.sin[i] = Math.sin(Math.PI * -2 * (double)i / (double)n);
        }
    }

    public static synchronized void fft(double[] real, double[] imag) {
        double t1;
        int n1;
        int i;
        int j = 0;
        int n2 = n / 2;
        for (i = 1; i < n - 1; ++i) {
            for (n1 = n2; j >= n1; j -= n1, n1 /= 2) {
            }
            if (i >= (j += n1)) continue;
            t1 = real[i];
            real[i] = real[j];
            real[j] = t1;
            t1 = imag[i];
            imag[i] = imag[j];
            imag[j] = t1;
        }
        n2 = 1;
        for (i = 0; i < bits; ++i) {
            n1 = n2;
            n2 += n2;
            int a = 0;
            for (j = 0; j < n1; ++j) {
                double c = cos[a];
                double s = sin[a];
                a += 1 << bits - i - 1;
                for (int k = j; k < n; k += n2) {
                    t1 = c * real[k + n1] - s * imag[k + n1];
                    double t2 = s * real[k + n1] + c * imag[k + n1];
                    real[k + n1] = real[k] - t1;
                    imag[k + n1] = imag[k] - t2;
                    real[k] = real[k] + t1;
                    imag[k] = imag[k] + t2;
                }
            }
        }
    }

    static {
        Fft.resetSize(n);
    }
}

