/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimationSpecif;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class AnimationNiveau
extends BiofeedbackAnimationSpecif {
    private static final double voie1RelativePosX = 0.5;
    private static final double voie1RelativeLarg = 0.2;
    double largeur;
    private Rectangle fleche;
    private ImagePattern imFlecheMonte;
    private ImagePattern imFlecheDescend;
    private Rectangle objGauche;
    private Rectangle objDroit;
    private Rectangle voie1;
    private Rectangle barreVoie1;
    private DropShadow ombre1;

    @Override
    public void updateSpecifique() {
        super.updateSpecifique();
        try {
            this.barreVoie1.setY(this.transformNiveauY(this.controller.niveauVoie1Aff));
            this.barreVoie1.setHeight(this.transformNiveauHeight(this.controller.niveauVoie1Aff));
            double niveauProfAff = this.profToAff(this.controller.profilLevel);
            if (this.fleche != null) {
                if (this.controller.isInProfile < 0 && this.controller.profilLevel > 0.0) {
                    this.fleche.setFill((Paint)this.imFlecheMonte);
                    this.fleche.setY(this.transformNiveauY(this.controller.niveauVoie1Aff) - this.largeur);
                    this.ombre1.setColor(Color.RED);
                } else if (this.controller.isInProfile > 0 && this.controller.profilLevel <= 0.0) {
                    this.fleche.setFill((Paint)this.imFlecheDescend);
                    this.fleche.setY(this.transformNiveauY(this.controller.niveauVoie1Aff));
                    this.ombre1.setColor(Color.RED);
                } else {
                    this.fleche.setFill((Paint)Color.TRANSPARENT);
                    this.ombre1.setColor(Color.GREEN);
                }
                this.objGauche.setY(this.transformNiveauY(niveauProfAff));
                this.objDroit.setY(this.transformNiveauY(niveauProfAff));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initGame() {
        try {
            this.voie1 = new Rectangle();
            this.voie1.setFill((Paint)Color.WHITE);
            this.voie1.setStroke((Paint)Color.web((String)Main.getConfig().couleurVoie1));
            this.voie1.setStrokeWidth(5.0);
            this.barreVoie1 = new Rectangle();
            this.barreVoie1.getStyleClass().add((Object)"barreVoieNiveau");
            this.controller.gameAnchor.getChildren().addAll((Object[])new Node[]{this.voie1, this.barreVoie1});
            if (this.controller.profil.typeProfil() == 2) {
                this.ombre1 = new DropShadow();
                this.ombre1.setOffsetX(10.0);
                this.ombre1.setOffsetY(10.0);
                this.voie1.setEffect((Effect)this.ombre1);
                Image imageFM = new Image("/res/img/div_anim/flecheplus.png");
                Image imageFD = new Image("/res/img/div_anim/flechemoins.png");
                this.imFlecheMonte = new ImagePattern(imageFM);
                this.imFlecheDescend = new ImagePattern(imageFD);
                this.fleche = new Rectangle();
                this.objGauche = new Rectangle();
                this.objGauche.setFill((Paint)new ImagePattern(new Image("/res/img/div_anim/flechegauche.png")));
                this.objDroit = new Rectangle();
                this.objDroit.setFill((Paint)new ImagePattern(new Image("/res/img/div_anim/flechedroite.png")));
                this.controller.gameAnchor.getChildren().addAll((Object[])new Node[]{this.objDroit, this.objGauche, this.fleche});
            }
            this.updateSizeGame();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void updateSizeGame() {
        this.largeur = this.widthGame * 0.2;
        this.largeur = Math.min(this.largeur, this.anchorHeight / 4.0);
        double posx = this.widthGame * 0.5 - this.largeur / 2.0;
        this.minProgress = (this.largeur - 15.0) / (this.anchorHeight * 0.9 - 15.0);
        this.voie1.setX(posx);
        this.voie1.setY(this.anchorHeight * 0.05);
        this.voie1.setWidth(this.largeur);
        this.voie1.setHeight(this.anchorHeight * 0.9);
        this.voie1.setArcWidth(this.largeur);
        this.voie1.setArcHeight(this.largeur);
        this.barreVoie1.setX(posx + 7.5);
        this.barreVoie1.setWidth(this.largeur - 15.0);
        this.barreVoie1.setArcWidth(this.largeur - 15.0);
        this.barreVoie1.setArcHeight(this.largeur - 15.0);
        if (this.controller.profil.typeProfil() == 2) {
            this.fleche.setX(posx);
            this.fleche.setWidth(this.largeur);
            this.fleche.setHeight(this.largeur);
            this.objGauche.setX(posx - this.largeur);
            this.objGauche.setWidth(this.largeur);
            this.objGauche.setHeight(this.largeur);
            this.objDroit.setX(posx + this.largeur);
            this.objDroit.setWidth(this.largeur);
            this.objDroit.setHeight(this.largeur);
        }
    }
}

