/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class MethodParameter
implements Cloneable {
    private int nameIndex;
    private int accessFlags;

    public MethodParameter() {
    }

    MethodParameter(DataInput input) throws IOException {
        this.nameIndex = input.readUnsignedShort();
        this.accessFlags = input.readUnsignedShort();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int name_index) {
        this.nameIndex = name_index;
    }

    public String getParameterName(ConstantPool constant_pool) {
        if (this.nameIndex == 0) {
            return null;
        }
        return ((ConstantUtf8)constant_pool.getConstant(this.nameIndex, (byte)1)).getBytes();
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int access_flags) {
        this.accessFlags = access_flags;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isSynthetic() {
        return (this.accessFlags & 0x1000) != 0;
    }

    public boolean isMandated() {
        return (this.accessFlags & Short.MIN_VALUE) != 0;
    }

    public void accept(Visitor v) {
        v.visitMethodParameter(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.nameIndex);
        file.writeShort(this.accessFlags);
    }

    public MethodParameter copy() {
        try {
            return (MethodParameter)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

