/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.ObjectType;

public final class CodeExceptionGen
implements InstructionTargeter,
Cloneable {
    private InstructionHandle startPc;
    private InstructionHandle endPc;
    private InstructionHandle handlerPc;
    private ObjectType catchType;

    public CodeExceptionGen(InstructionHandle startPc, InstructionHandle endPc, InstructionHandle handlerPc, ObjectType catchType) {
        this.setStartPC(startPc);
        this.setEndPC(endPc);
        this.setHandlerPC(handlerPc);
        this.catchType = catchType;
    }

    public CodeException getCodeException(ConstantPoolGen cp) {
        return new CodeException(this.startPc.getPosition(), this.endPc.getPosition() + this.endPc.getInstruction().getLength(), this.handlerPc.getPosition(), this.catchType == null ? 0 : cp.addClass(this.catchType));
    }

    public void setStartPC(InstructionHandle start_pc) {
        BranchInstruction.notifyTarget(this.startPc, start_pc, this);
        this.startPc = start_pc;
    }

    public void setEndPC(InstructionHandle end_pc) {
        BranchInstruction.notifyTarget(this.endPc, end_pc, this);
        this.endPc = end_pc;
    }

    public void setHandlerPC(InstructionHandle handler_pc) {
        BranchInstruction.notifyTarget(this.handlerPc, handler_pc, this);
        this.handlerPc = handler_pc;
    }

    @Override
    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.startPc == old_ih) {
            targeted = true;
            this.setStartPC(new_ih);
        }
        if (this.endPc == old_ih) {
            targeted = true;
            this.setEndPC(new_ih);
        }
        if (this.handlerPc == old_ih) {
            targeted = true;
            this.setHandlerPC(new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih + ", but {" + this.startPc + ", " + this.endPc + ", " + this.handlerPc + "}");
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle ih) {
        return this.startPc == ih || this.endPc == ih || this.handlerPc == ih;
    }

    public void setCatchType(ObjectType catchType) {
        this.catchType = catchType;
    }

    public ObjectType getCatchType() {
        return this.catchType;
    }

    public InstructionHandle getStartPC() {
        return this.startPc;
    }

    public InstructionHandle getEndPC() {
        return this.endPc;
    }

    public InstructionHandle getHandlerPC() {
        return this.handlerPc;
    }

    public String toString() {
        return "CodeExceptionGen(" + this.startPc + ", " + this.endPc + ", " + this.handlerPc + ")";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }
}

