/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    public static byte[] readExactlyNBytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = IOUtils.readNBytesOrEOF(inputStream, n);
        if (byArray.length < n) {
            throw new EOFException();
        }
        return byArray;
    }

    public static byte[] readNBytesOrEOF(InputStream inputStream, int n) throws IOException {
        int n2;
        if (n < 0) {
            throw new IOException("length cannot be negative: " + n);
        }
        ArrayList<byte[]> arrayList = null;
        byte[] byArray = null;
        int n3 = 0;
        int n4 = n;
        do {
            byte[] byArray2 = new byte[Math.min(n4, 8192)];
            int n5 = 0;
            while ((n2 = inputStream.read(byArray2, n5, Math.min(byArray2.length - n5, n4))) > 0) {
                n5 += n2;
                n4 -= n2;
            }
            if (n5 <= 0) continue;
            if (0x7FFFFFF7 - n3 < n5) {
                throw new OutOfMemoryError("Required array size too large");
            }
            n3 += n5;
            if (byArray == null) {
                byArray = byArray2;
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<byte[]>();
                arrayList.add(byArray);
            }
            arrayList.add(byArray2);
        } while (n2 >= 0 && n4 > 0);
        if (arrayList == null) {
            if (byArray == null) {
                return new byte[0];
            }
            return byArray.length == n3 ? byArray : Arrays.copyOf(byArray, n3);
        }
        byArray = new byte[n3];
        int n6 = 0;
        n4 = n3;
        for (byte[] byArray3 : arrayList) {
            int n7 = Math.min(byArray3.length, n4);
            System.arraycopy(byArray3, 0, byArray, n6, n7);
            n6 += n7;
            n4 -= n7;
        }
        return byArray;
    }

    public static byte[] readFully(InputStream inputStream, int n, boolean bl) throws IOException {
        int n2;
        byte[] byArray = new byte[]{};
        if (n == -1) {
            n = Integer.MAX_VALUE;
        }
        for (int i = 0; i < n; i += n2) {
            int n3;
            if (i >= byArray.length) {
                n3 = Math.min(n - i, byArray.length + 1024);
                if (byArray.length < i + n3) {
                    byArray = Arrays.copyOf(byArray, i + n3);
                }
            } else {
                n3 = byArray.length - i;
            }
            if ((n2 = inputStream.read(byArray, i, n3)) >= 0) continue;
            if (bl && n != Integer.MAX_VALUE) {
                throw new EOFException("Detect premature EOF");
            }
            if (byArray.length == i) break;
            byArray = Arrays.copyOf(byArray, i);
            break;
        }
        return byArray;
    }

    public static byte[] readNBytes(InputStream inputStream, int n) throws IOException {
        if (n < 0) {
            throw new IOException("length cannot be negative: " + n);
        }
        return IOUtils.readFully(inputStream, n, true);
    }
}

