/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.configuration;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.BioPod;
import com.mazet.biostim.comm.UsbBiopod;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Config;
import com.mazet.biostim.utils.Security;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.configuration.Autotest;
import com.mazet.biostim.view.configuration.CloudManager;
import com.mazet.biostim.view.main.MenuController;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipOutputStream;
import javafx.application.Platform;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public abstract class DebugView
extends Controller {
    static long lastMail = 0L;

    public static void sendDebugMail(ComboBox<String> contactMotif, String mail, TextField nom, TextField adresse, TextArea contactInput, String stateString) {
        String titre = String.format("Message de debug Biostim %d (%d)", Main.getConfig().numero_serie, 20250210);
        String body = String.format("Message de %s%nemail : %s%nadresse : %s%nBiostim %s (%s)    https://mazetsante.fr/biostim/seances.php?code=%s%n%nSujet : %s%n%n%s%n%n%s%n%n%s", nom.getText(), mail, adresse.getText(), Main.getConfig().numero_serie, "2025.2j", Main.getConfig().numero_serie, contactMotif.getSelectionModel().getSelectedItem(), contactInput.getText(), stateString, DebugView.getenv()).replaceAll("\n", "<br>\n");
        new Thread(() -> {
            int res = DebugView.sendMail(titre, body, mail, "sav@mazetsante.fr", stateString);
            DebugView.alertEnvoieMail(res);
        }).start();
    }

    public static void alertEnvoieMail(int nb) {
        if (nb == 0) {
            Platform.runLater(() -> Utils.makeToast(TransientConfig.translate("msgEnvoye"), new Object[0]));
        } else if (nb == 1) {
            Utils.popupAlert(TransientConfig.translate("tropDeMail"));
        } else {
            Utils.popupAlert(TransientConfig.translate("msgNonEnvoye"));
        }
    }

    public static int sendMail(String titre, String body, String mailReply, String mailTo, String stateString) {
        long now = System.currentTimeMillis();
        if (now - lastMail < 60000L) {
            return 1;
        }
        lastMail = now;
        if (!titre.startsWith("Mail auto")) {
            Platform.runLater(() -> Utils.makeToast("Sending...", new Object[0]));
        }
        try {
            final String from = "biostim@mazetsante.fr";
            Properties properties = System.getProperties();
            properties.setProperty("mail.smtp.host", "ssl0.ovh.net");
            properties.put("mail.smtp.auth", "true");
            properties.put("mail.smtp.port", "587");
            properties.put("mail.smtp.starttls.enable", "true");
            properties.put("mail.smtp.connectiontimeout", "10000");
            properties.put("mail.smtp.timeout", "15000");
            properties.put("mail.smtp.writetimeout", "10000");
            Authenticator auth = new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(from, "mazetbiostim2.2");
                }
            };
            Session session = Session.getInstance(properties, auth);
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress(from));
            if (mailReply != null) {
                Address[] replyto = new InternetAddress[]{new InternetAddress(mailReply)};
                message.setReplyTo(replyto);
            }
            message.addRecipient(Message.RecipientType.TO, new InternetAddress(mailTo));
            message.setSubject(titre);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent(body, "text/html; charset=utf-8");
            ((Multipart)multipart).addBodyPart(messageBodyPart);
            if (stateString != null) {
                FileOutputStream fos = new FileOutputStream("debug.zip");
                ZipOutputStream zos = new ZipOutputStream(fos);
                Utils.addToZipFile("state.html", stateString, zos);
                Utils.addToZipFile(Config.configJson, zos);
                Utils.addToZipFile(Main.getConfig().getKineJson(), zos);
                Utils.addToZipFile(Main.getConfig().getProgCustom(), zos);
                Utils.addToZipFile(Main.getConfig().getProgFav(), zos);
                File rep = new File(Main.getConfig().getSauvegarde_auto());
                try {
                    for (String file : Objects.requireNonNull(rep.list())) {
                        if (!file.startsWith("debug")) continue;
                        Utils.addToZipFile(Main.getConfig().getSauvegarde_auto() + "/" + file, zos);
                    }
                }
                catch (Exception e) {
                    Utils.debugLine("impossible d'ajouter les fichiers du rep de sauvegarde : " + e, new Object[0]);
                }
                rep = new File(".");
                try {
                    for (String file : Objects.requireNonNull(rep.list())) {
                        if (!file.startsWith("hs_err_pid")) continue;
                        Utils.addToZipFile(file, zos);
                    }
                }
                catch (Exception e) {
                    Utils.debugLine("impossible fichier hs_err_pid : " + e, new Object[0]);
                }
                zos.close();
                fos.close();
                messageBodyPart = new MimeBodyPart();
                String filename = "debug.zip";
                FileDataSource source = new FileDataSource(filename);
                messageBodyPart.setDataHandler(new DataHandler(source));
                messageBodyPart.setFileName(filename);
                ((Multipart)multipart).addBodyPart(messageBodyPart);
            }
            message.setContent(multipart);
            Transport.send(message);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
    }

    public static void sendCommande(String msg, Autotest controller) {
        Utils.debugInfo("Commande debug : " + msg);
        msg = msg.toLowerCase().replaceAll(" ", "");
        if (msg.startsWith("1.0") || msg.startsWith("2.0") || msg.startsWith("2.1") || msg.startsWith("2.2")) {
            if (!UsbBiostim.isConnexionBioStim()) {
                Main.getConfig().setVersionProtocole(1);
                Main.getConfig().setMem_interne(msg.contains("+") ? 1 : 0);
                Main.getConfig().setOptionBT(msg.contains("bt") ? 1 : -1);
                if (msg.startsWith("1")) {
                    Main.getConfig().setCavaliers(4);
                } else {
                    int cavaliers = 0;
                    if (msg.charAt(2) == '1') {
                        cavaliers = 1;
                    }
                    if (msg.charAt(2) == '2') {
                        cavaliers = 3;
                    }
                    Main.getConfig().setCavaliers(cavaliers);
                }
                Main.setCSS();
                Main.menu.updateMenuWidth();
            }
        } else {
            if (msg.equals("console")) {
                try {
                    controller.webEngine.loadContent(String.format("<html><body><pre>%s</pre></body></html>", new String(Files.readAllBytes(Paths.get(Main.debugFileName, new String[0])))));
                }
                catch (Exception ignored) {
                    Utils.makeToast("pas de fichier de debug", new Object[0]);
                }
                return;
            }
            if (msg.equals("getenv")) {
                controller.webEngine.loadContent(String.format("<html><body><pre>%s</pre></body></html>", DebugView.getenv()));
                return;
            }
            if (msg.equals("mailauto")) {
                String stateString = Autotest.getState();
                String body = String.format("Biostim %s (%s)    https://mazetsante.fr/biostim/seances.php?code=%s%n%n%n%s%n%n%s", Main.getConfig().numero_serie, "2025.2j", Main.getConfig().numero_serie, stateString, DebugView.getenv()).replaceAll("\n", "<br>\n");
                new Thread(() -> {
                    int res = DebugView.sendMail("Mail auto Biostim " + Main.getConfig().numero_serie, body, "sav@mazetsante.fr", "sav@mazetsante.fr", stateString);
                    Utils.debugInfo("Mail auto : " + res);
                }).start();
                return;
            }
            if (msg.startsWith("style=")) {
                Main.getConfig().style = Integer.parseInt(msg.substring(6));
                Main.getConfig().saveConfig();
                Main.setCSS();
            } else if (msg.startsWith("pass=")) {
                TransientConfig.password = msg.substring(5);
            } else if (msg.startsWith("delaiactivation") || msg.startsWith("delayactivation")) {
                Main.getConfig().nbAvantBlocage = 50;
                Main.getConfig().saveConfig();
                Main.menu.changeHomeStatus();
            } else if (msg.startsWith("compte=")) {
                Main.getConfig().comptePass = Integer.parseInt(msg.substring(7));
                Main.getConfig().nbAvantBlocage = 50;
                if (Main.getConfig().compteOK()) {
                    Main.getConfig().compteSerie = Main.getConfig().numero_serie;
                    new Thread(() -> {
                        CloudManager.sendCompte();
                        CloudManager.sendJdd("Activation \u00e0 dist OK : %s", Main.getConfig().compteMail);
                    }).start();
                }
                Main.getConfig().saveConfig();
            } else if (msg.startsWith("out=")) {
                Main.getConfig().outToFile = !msg.equals("out=0");
                Main.getConfig().saveConfig();
            } else if (msg.startsWith("recherche=")) {
                Main.getConfig().versionRecherche = msg.equals("recherche=1");
                Main.getConfig().saveConfig();
            } else {
                if (msg.startsWith("biopodtest")) {
                    Main.menu.toPageBiopodForce();
                    return;
                }
                if (msg.startsWith("dfumode")) {
                    UsbBiopod.sendCommandTrame(BioPod.commandesBiopod.DFU_MODE);
                } else if (msg.startsWith("podmodel=")) {
                    BioPod.setModel(msg.substring(9));
                } else if (msg.startsWith("distrib=")) {
                    Main.getConfig().setDistributeur(msg.substring(8));
                } else if (msg.startsWith("nosecu=")) {
                    Main.getConfig().ignoreSecu = Integer.parseInt(msg.substring(7));
                    Main.getConfig().saveConfig();
                } else if (msg.startsWith("timeoutbt=")) {
                    Main.getConfig().timeOutBT = Integer.parseInt(msg.substring(10));
                    Main.getConfig().saveConfig();
                } else if (msg.startsWith("cavaliers=")) {
                    if (!UsbBiostim.isConnexionBioStim()) {
                        Main.getConfig().setCavaliers(Integer.parseInt(msg.substring(10)));
                    }
                } else if (msg.startsWith("protocole=")) {
                    if (!UsbBiostim.isConnexionBioStim()) {
                        Main.getConfig().setVersionProtocole(Integer.parseInt(msg.substring(10)));
                    }
                } else if (msg.startsWith("meminterne=")) {
                    if (!UsbBiostim.isConnexionBioStim()) {
                        Main.getConfig().setMem_interne(Integer.parseInt(msg.substring(11)));
                    }
                } else if (msg.startsWith("demo=")) {
                    Main.getConfig().modeDemo = Integer.parseInt(msg.substring(5)) != 0;
                    Main.getConfig().saveConfig();
                } else if (msg.startsWith("mousemove=")) {
                    Main.getConfig().mouseMove = Integer.parseInt(msg.substring(10));
                    Main.getConfig().saveConfig();
                } else if (msg.startsWith("biopodusb=")) {
                    Main.getConfig().biopodUsb = msg.equals("biopodusb=1");
                    Main.getConfig().saveConfig();
                } else if (msg.startsWith("dureetarage=")) {
                    Main.getConfig().dureeTarage = Integer.parseInt(msg.substring(12));
                    Main.getConfig().saveConfig();
                } else if (msg.startsWith("dureereglagestim=")) {
                    Main.getConfig().dureeReglageStim = Integer.parseInt(msg.substring(17));
                    Main.getConfig().saveConfig();
                } else {
                    if (msg.startsWith("action=")) {
                        String cde;
                        int pos = msg.indexOf(61, 7);
                        if (pos == -1) {
                            String num = msg.substring(7);
                            cde = String.format("https://www.mazetsante.fr/biostim/getinfo.php?num_serie=%s", num);
                        } else {
                            String num = msg.substring(7, pos);
                            String act = msg.substring(pos + 1);
                            cde = String.format("https://www.mazetsante.fr/biostim/actionset.php?num_serie=%s&action=%s", num, act);
                        }
                        new Thread(() -> {
                            try {
                                String res = Utils.getHttp(cde);
                                Platform.runLater(() -> controller.webEngine.loadContent(res));
                            }
                            catch (Exception e) {
                                Utils.debugInfo("Erreur php : %s", e.toString());
                            }
                        }).start();
                        return;
                    }
                    if (msg.startsWith("activms=99")) {
                        try {
                            int num = Integer.parseInt(msg.substring(10));
                            int act = Security.oneWayFunction(num);
                            String cde = String.format("https://www.mazetsante.fr/biostim/actionset.php?num_serie=99%06d&action=%s", num, act);
                            new Thread(() -> {
                                try {
                                    String res = Utils.getHttp(cde);
                                    Platform.runLater(() -> controller.webEngine.loadContent(cde + "\n<p/>\n" + res));
                                }
                                catch (Exception e) {
                                    Utils.debugInfo("Erreur php : %s", e.toString());
                                }
                            }).start();
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (msg.startsWith("activmsbt=99")) {
                        try {
                            int num = Integer.parseInt(msg.substring(12));
                            int act = Security.oneWayFunction(num);
                            int actbt = Security.oneWayFunction(num + 1357);
                            String cde = String.format("https://www.mazetsante.fr/biostim/actionset.php?num_serie=99%06d&action=%s%%3Abt%%3D%s", num, act, actbt);
                            new Thread(() -> {
                                try {
                                    String res = Utils.getHttp(cde);
                                    Platform.runLater(() -> controller.webEngine.loadContent(cde + "\n<p/>\n" + res));
                                }
                                catch (Exception e) {
                                    Utils.debugInfo("Erreur php : %s", e.toString());
                                }
                            }).start();
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        if (msg.endsWith(".php")) {
                            String url = String.format("https://www.mazetsante.fr/biostim/%s?num_serie=%d&soft=%d&lang=%s", msg, Main.getConfig().numero_serie, 20250210, TransientConfig.langueSuffixe.substring(1));
                            new Thread(() -> {
                                try {
                                    String res = Utils.getHttp(url);
                                    Platform.runLater(() -> controller.webEngine.loadContent(res));
                                }
                                catch (Exception e) {
                                    Utils.debugInfo("Erreur php : %s", e.toString());
                                }
                            }).start();
                            return;
                        }
                        if (Main.getConfig().versionProtocole == 0) {
                            try {
                                if (msg.startsWith("bt=")) {
                                    Main.getConfig().setBtKey(Integer.parseInt(msg.substring(3)));
                                }
                                Main.getConfig().setActivationKey(Integer.parseInt(msg));
                            }
                            catch (Exception ignored) {
                                Utils.makeToast("commande incompr\u00e9hensible : %s", msg);
                                return;
                            }
                        } else {
                            boolean ok = DebugView.sendMessage(msg);
                            if (!ok) {
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (controller != null) {
            Utils.makeToast("%s => OK", msg);
            Main.changeCenterView("configuration/autotest.fxml", Main.menu.autotestButton);
        }
    }

    private static String getenv() {
        StringBuilder res = new StringBuilder();
        String bootTime = Computer.getBootTime();
        String proc = Computer.getProcName();
        Runtime runtime = Runtime.getRuntime();
        Config config = Main.getConfig();
        res.append(String.format("version %s%nprotocole v%d : activation %s (bt %d)%ncode FTDI %06d (%s)%s%njre %s %s bit (%s)%nos : %s (%s %s)%nProc : %s%n%d proc, mem free %d Mo / total %d Mo / max %d Mo%nBoot time : %s%n%n%n", MenuController.logoName, config.versionProtocole, config.isActivated, config.optionBluetooth, Security.getHardKey(), Security.getBiostimPort(), config.versionProtocole != 0 ? String.format(" / id Biostim %06d", config.idBiostim) : String.format(" / activation %06d / bt %06d", config.activationKey, config.btKey), System.getProperty("java.version"), System.getProperty("sun.arch.data.model"), System.getProperty("java.vendor"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), proc, runtime.availableProcessors(), runtime.freeMemory() / 1024L / 1024L, runtime.totalMemory() / 1024L / 1024L, runtime.maxMemory() / 1024L / 1024L, bootTime));
        Map<String, String> env = System.getenv();
        env.forEach((cle, val) -> res.append(String.format("%s = %s%n", cle, val)));
        return res.toString();
    }

    private static boolean sendMessage(String msg) {
        String[] decoupe = msg.split(";");
        if (Main.getConfig().versionProtocole != 0 && decoupe.length == 3 && msg.charAt(0) >= '0' && msg.charAt(0) <= '2' && msg.charAt(1) == ';' && Utils.isInteger(decoupe[1]) && Utils.isInteger(decoupe[2])) {
            UsbBiostim.sendMessageAsync("&q" + msg, true);
            return true;
        }
        Utils.makeToast("commande incompr\u00e9hensible : %s", msg);
        return false;
    }
}

