/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.configuration;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.AlertQueue;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Config;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.configuration.Autotest;
import com.mazet.biostim.view.configuration.CloudManager;
import com.mazet.biostim.view.configuration.DebugView;
import com.mazet.biostim.zdata.AnimationStyle;
import com.mazet.biostim.zdata.Programme;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Future;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.web.WebView;
import org.json.JSONObject;

public class configurationMainViewController
extends Controller {
    @FXML
    TabPane tabPane;
    @FXML
    private VBox configVBox;
    @FXML
    private VBox animationVBox;
    @FXML
    private VBox diversVBox;
    @FXML
    private Tab tabSauvegarde;
    @FXML
    private Tab tabSauvegardeSpacer;
    @FXML
    private Tab tabMonCompte;
    @FXML
    private Tab tabMonCompteSpacer;
    @FXML
    private WebView stat;
    @FXML
    private Button formations;
    @FXML
    private Label monCompte;
    @FXML
    private Button activer;
    @FXML
    private Label isActive;
    @FXML
    private TextField compteNom;
    @FXML
    private TextField comptePrenom;
    @FXML
    private TextField compteMail;
    @FXML
    private TextField compteAddresse;
    @FXML
    private CheckBox compteOptin;
    @FXML
    private TextField repSauvegarde;
    @FXML
    private TextField repPatients;
    @FXML
    private TextField fichierDeRecup;
    @FXML
    private HBox choixVoieAnorectale;
    @FXML
    private ComboBox<String> listDeroulanteVoieAnorectale;
    @FXML
    private CheckBox voiesSeparees;
    @FXML
    private Label nbCombineLines;
    @FXML
    private Label nbConcatLines;
    @FXML
    private CheckBox pauseEtapesBilan;
    @FXML
    private ComboBox<String> typePageTarage;
    @FXML
    private CheckBox autoTarage;
    @FXML
    private CheckBox autoStart;
    @FXML
    private CheckBox baseZeroPatient;
    @FXML
    private CheckBox reposAvantTravail;
    @FXML
    private CheckBox decomptePageStim;
    @FXML
    private CheckBox decomptePageBFB;
    @FXML
    private CheckBox stimBFB;
    @FXML
    private CheckBox toujoursCurseur;
    @FXML
    private ComboBox<String> traitParSeconde;
    @FXML
    private CheckBox noParallax;
    @FXML
    private ComboBox<String> eventClicDroit;
    @FXML
    private ComboBox<String> listDeroulanteTypeScore;
    @FXML
    private ComboBox<String> listDeroulanteActionBalance;
    @FXML
    private ComboBox<String> listDeroulanteBilanDefaut;
    private final ArrayList<Integer> listNumProgBilan = new ArrayList();
    @FXML
    private HBox boxChoixBilan;
    @FXML
    private Tab tabAnimationPerso;
    @FXML
    private Tab tabAnimationPersoSpacer;
    @FXML
    private VBox boxPatient;
    @FXML
    private GridPane selectionAnimation;
    @FXML
    private ComboBox<String> nom_animation;
    @FXML
    private TextField background;
    @FXML
    private ComboBox<String> ruban;
    @FXML
    private TextField curseur1;
    @FXML
    private TextField curseur2;
    @FXML
    private TextField objet1;
    @FXML
    private TextField objet2;
    @FXML
    private TextField objet3;
    @FXML
    private TextField objet4;
    @FXML
    private TextField objet5;
    @FXML
    private Button creerAnimation;
    @FXML
    private Button supprAnimation;
    @FXML
    private CheckBox activSonFinDeProgram;
    @FXML
    private TextField sonFinDeProgram;
    @FXML
    private CheckBox activSonPageBFB;
    @FXML
    private TextField sonPageBFB;
    @FXML
    private CheckBox activSonDebutContraction;
    @FXML
    private TextField sonDebutContraction;
    @FXML
    private CheckBox activSonFinContraction;
    @FXML
    private TextField sonFinContraction;
    @FXML
    private CheckBox activSonPageStim;
    @FXML
    private TextField sonPageStim;
    @FXML
    private CheckBox activSonDebutStim;
    @FXML
    private TextField sonDebutStim;
    @FXML
    private ComboBox<String> bfbSonore;
    @FXML
    private Label vitesse;
    @FXML
    private Label epaisseurVoie;
    @FXML
    private ColorPicker couleurVoie1;
    @FXML
    private ColorPicker couleurVoie2;
    @FXML
    private ComboBox<String> freqBackup;
    @FXML
    private ComboBox<String> listeLangue;
    @FXML
    private ComboBox<String> listeUnite;
    @FXML
    private ComboBox<String> listeTriPatients;
    @FXML
    private CheckBox multiKine;
    @FXML
    private CheckBox forcePatient;
    @FXML
    private CheckBox triSeances;
    @FXML
    private CheckBox graphBilan;
    @FXML
    private TextField newForm;
    @FXML
    private ComboBox<String> listForm;
    @FXML
    private CheckBox noPraticienInForm;
    @FXML
    private TextField logoPerso;
    @FXML
    private Label tailleChar;
    @FXML
    private Label lissage;
    @FXML
    private Label epaisseurProfil;
    @FXML
    private ToggleGroup styleGroup;
    @FXML
    private ToggleButton style1;
    @FXML
    private ToggleButton style2;
    @FXML
    private ToggleButton style3;
    @FXML
    private ComboBox<String> contactMotif;
    @FXML
    private TextField email;
    @FXML
    private TextField nom;
    @FXML
    private TextField adresse;
    @FXML
    private TextArea contactInput;
    private Config config;
    boolean forceEndMail = false;
    private String modifForm;

    @Override
    public void setMain() {
        this.config = Main.getConfig();
        this.initCompte();
        this.contactMotif.getItems().setAll((Object[])new String[]{TransientConfig.translate("idee_amelioration"), TransientConfig.translate("probleme"), TransientConfig.translate("autre")});
        if (Main.getConfig().nbVoiesPression() == 0) {
            this.configVBox.getChildren().remove((Object)this.stimBFB);
            this.config.setStimBFB(false);
        }
        if (!this.config.isActivated) {
            this.autoTarage.setDisable(true);
            this.multiKine.setDisable(true);
            this.eventClicDroit.setDisable(true);
        }
        if (this.config.option10()) {
            this.animationVBox.getChildren().remove((Object)this.voiesSeparees);
        }
        if (this.config.nbVoiesPression() == 0) {
            this.configVBox.getChildren().remove((Object)this.choixVoieAnorectale);
        }
        if (!this.config.optionPatients()) {
            this.configVBox.getChildren().remove((Object)this.boxChoixBilan);
            this.diversVBox.getChildren().remove((Object)this.boxPatient);
            this.tabPane.getTabs().remove((Object)this.tabSauvegarde);
            this.tabPane.getTabs().remove((Object)this.tabSauvegardeSpacer);
        }
        if (!this.config.optionAnimationPerso()) {
            this.tabPane.getTabs().remove((Object)this.tabAnimationPerso);
            this.tabPane.getTabs().remove((Object)this.tabAnimationPersoSpacer);
        }
        if (Main.getConfig().distributeur.equals("menfis")) {
            this.tabPane.getTabs().remove((Object)this.tabMonCompte);
            this.tabPane.getTabs().remove((Object)this.tabMonCompteSpacer);
        } else {
            new Thread(() -> CloudManager.getPubHtml(this.stat)).start();
            if (TransientConfig.langueSuffixe.equals("_fr")) {
                FxUtils.setVisibility((Node)this.formations, true);
            }
        }
        this.eventClicDroit.getItems().add((Object)TransientConfig.translate("addEvent"));
        this.eventClicDroit.getItems().add((Object)TransientConfig.translate("addObject"));
        this.eventClicDroit.getSelectionModel().select(this.config.eventClicDroit ? 0 : 1);
        this.listDeroulanteTypeScore.getItems().add((Object)TransientConfig.translate("aucun"));
        this.listDeroulanteTypeScore.getItems().add((Object)TransientConfig.translate("pourcentage"));
        this.listDeroulanteTypeScore.getItems().add((Object)TransientConfig.translate("points"));
        this.listDeroulanteTypeScore.getSelectionModel().select(this.config.typeScore);
        this.listDeroulanteActionBalance.getItems().add((Object)TransientConfig.translate("neRienAfficher"));
        this.listDeroulanteActionBalance.getItems().add((Object)TransientConfig.translate("afficherBalanceNeutre"));
        this.listDeroulanteActionBalance.getItems().add((Object)TransientConfig.translate("afficherBalanceExercice"));
        this.listDeroulanteActionBalance.getSelectionModel().select(this.config.actionBalanceBFB);
        for (Programme prog : Programme.getAllProgrammes()) {
            if (!prog.containBFB() && prog.getType() != 4) continue;
            this.listDeroulanteBilanDefaut.getItems().add((Object)prog.getNom());
            this.listNumProgBilan.add(prog.getId());
            if (prog.getId() != Main.getConfig().progBilan) continue;
            this.listDeroulanteBilanDefaut.getSelectionModel().select(this.listDeroulanteBilanDefaut.getItems().size() - 1);
        }
        this.typePageTarage.getItems().add((Object)TransientConfig.translate("jamais"));
        this.typePageTarage.getItems().add((Object)TransientConfig.translate("pasTarageValide"));
        this.typePageTarage.getItems().add((Object)TransientConfig.translate("toujours"));
        this.typePageTarage.getSelectionModel().select(this.config.typePageTarage);
        this.freqBackup.getItems().addAll((Object[])new String[]{TransientConfig.translate("jamais"), TransientConfig.translate("1semaine"), TransientConfig.translate("2semaines"), TransientConfig.translate("1mois")});
        this.freqBackup.getSelectionModel().select(Config.freqsBackup.indexOf(Main.getConfig().freqSauvegarde));
        this.listeLangue.getItems().add((Object)TransientConfig.translate("langueSysteme"));
        this.listeLangue.getItems().addAll(TransientConfig.getListeLangue());
        this.listeLangue.getSelectionModel().select(TransientConfig.getShortListeLangue().indexOf(this.config.lang) + 1);
        this.listeUnite.getItems().addAll((Object[])new String[]{TransientConfig.translate("mbar"), TransientConfig.translate("cmH2O"), TransientConfig.translate("mmHg")});
        this.listeUnite.getSelectionModel().select(this.config.unite);
        this.listeTriPatients.getItems().addAll((Object[])new String[]{TransientConfig.translate("firstName"), TransientConfig.translate("name")});
        this.listeTriPatients.getSelectionModel().select(this.config.triPatients);
        this.tailleChar.setText(this.config.tailleChar + "/6");
        this.vitesse.setText(this.config.getVitesseDefilement() + "/20");
        this.listDeroulanteVoieAnorectale.getItems().addAll((Object[])new String[]{Biostim.nomOfVoie(0), Biostim.nomOfVoie(2)});
        this.listDeroulanteVoieAnorectale.getSelectionModel().select(this.config.anorectalPression ? 1 : 0);
        this.nbConcatLines.setText(Integer.toString(this.config.nbConcatLines));
        this.nbCombineLines.setText(Integer.toString(this.config.nbCombineLines));
        this.pauseEtapesBilan.setSelected(this.config.pauseEtapesBilan);
        this.autoTarage.setSelected(this.config.autoTarage);
        this.autoStart.setSelected(this.config.autoStart);
        this.baseZeroPatient.setSelected(this.config.baseZeroPatient);
        this.reposAvantTravail.setSelected(this.config.reposAvantTravail);
        this.decomptePageStim.setSelected(this.config.decomptePageStim);
        this.decomptePageBFB.setSelected(this.config.decomptePageBFB);
        this.voiesSeparees.setSelected(this.config.voiesSeparees);
        this.stimBFB.setSelected(this.config.stimBFB);
        this.lissage.setText(this.config.lissage + "/20");
        this.epaisseurVoie.setText(Integer.toString(this.config.epaisseurVoie));
        this.epaisseurProfil.setText(this.config.epaisseurProfil + "%");
        this.toujoursCurseur.setSelected(this.config.toujoursCurseur);
        this.traitParSeconde.getSelectionModel().select(this.config.traitParSeconde ? 0 : 1);
        this.noParallax.setSelected(this.config.noParallax);
        this.couleurVoie1.setValue((Object)Color.web((String)this.config.couleurVoie1));
        this.couleurVoie2.setValue((Object)Color.web((String)this.config.couleurVoie2));
        this.ruban.getItems().setAll((Object[])new String[]{TransientConfig.translate("ruban_jaune"), TransientConfig.translate("ruban_blanc"), TransientConfig.translate("ruban_bleu"), TransientConfig.translate("no_ruban")});
        this.ruban.getSelectionModel().selectFirst();
        this.repSauvegarde.setText(this.config.getSauvegarde_auto());
        this.multiKine.setSelected(this.config.multiKine);
        this.forcePatient.setSelected(this.config.forcePatient);
        this.triSeances.setSelected(this.config.triSeances);
        this.graphBilan.setSelected(this.config.afficheGraphiquePagePatient);
        this.noPraticienInForm.setSelected(this.config.noPraticienInForm);
        this.logoPerso.setText(this.config.logoPerso);
        this.repPatients.setText(this.config.getRepPatients());
        this.fichierDeRecup.setText(this.config.getSauvegarde_auto());
        this.activSonFinDeProgram.setSelected(this.config.activSonFinProgramme);
        this.sonFinDeProgram.setText(Computer.makeAbsolute(this.config.sonFinProgramme));
        this.activSonPageBFB.setSelected(this.config.activSonPageBFB);
        this.sonPageBFB.setText(Computer.makeAbsolute(this.config.sonPageBFB));
        this.activSonDebutContraction.setSelected(this.config.activSonDebutBFB);
        this.sonDebutContraction.setText(Computer.makeAbsolute(this.config.sonDebutBfb));
        this.activSonFinContraction.setSelected(this.config.activSonFinBFB);
        this.sonFinContraction.setText(Computer.makeAbsolute(this.config.sonFinBfb));
        this.activSonPageStim.setSelected(this.config.activSonPageStim);
        this.sonPageStim.setText(Computer.makeAbsolute(this.config.sonPageStim));
        this.activSonDebutStim.setSelected(this.config.activSonDebutStim);
        this.sonDebutStim.setText(Computer.makeAbsolute(this.config.sonDebutStim));
        this.bfbSonore.getItems().setAll((Object[])new String[]{TransientConfig.translate("aucun"), TransientConfig.translate("sonContinuModule"), TransientConfig.translate("bipRapproches")});
        this.bfbSonore.getSelectionModel().select(this.config.getBfbSonore());
        this.initForm();
        for (int i = 0; i < AnimationStyle.staticAnimationList.size(); ++i) {
            CheckBox cb = new CheckBox(AnimationStyle.staticAnimationList.get(i).getTranslatedName());
            cb.setSelected(this.config.selectedAnimationsNb.contains(i));
            this.selectionAnimation.add((Node)cb, i % 4, i / 4);
        }
        this.nom_animation.getItems().add((Object)TransientConfig.translate("nouvelle_animation"));
        for (AnimationStyle anim : this.config.customAnimationList) {
            this.nom_animation.getItems().add((Object)anim.getTranslatedName());
        }
        this.nom_animation.getSelectionModel().selectFirst();
        this.nom_animation.getSelectionModel().selectedItemProperty().addListener((a, b, c) -> this.changeAnimation());
        if (this.config.style == 2) {
            this.style2.setSelected(true);
        } else if (this.config.style == 3) {
            this.style3.setSelected(true);
        } else {
            this.style1.setSelected(true);
        }
        Platform.runLater(() -> {
            ObservableList tabs = FXCollections.observableArrayList((Collection)this.tabPane.lookupAll(".tab"));
            for (int i = 0; i < tabs.size(); ++i) {
                Node tab = (Node)tabs.get(i);
                if (!(tab instanceof Region) || i % 2 != 1) continue;
                tab.setStyle("-fx-border-width: 0; -fx-padding: 4;");
            }
        });
    }

    @Override
    public void exitAction() {
        this.save();
    }

    private void save() {
        try {
            this.saveCompte();
            this.config.setSauvegarde_auto(this.repSauvegarde.getText());
            this.config.setRepPatients(this.repPatients.getText());
            this.config.anorectalPression = this.listDeroulanteVoieAnorectale.getSelectionModel().getSelectedIndex() == 1;
            this.config.typeScore = this.listDeroulanteTypeScore.getSelectionModel().getSelectedIndex();
            this.config.actionBalanceBFB = this.listDeroulanteActionBalance.getSelectionModel().getSelectedIndex();
            boolean bl = this.config.eventClicDroit = this.eventClicDroit.getSelectionModel().getSelectedIndex() == 0;
            if (this.listDeroulanteBilanDefaut.getSelectionModel().getSelectedIndex() != -1) {
                this.config.progBilan = this.listNumProgBilan.get(this.listDeroulanteBilanDefaut.getSelectionModel().getSelectedIndex());
            }
            Main.menu.changeAlertes();
            this.config.pauseEtapesBilan = this.pauseEtapesBilan.isSelected();
            this.config.setTypePageTarage(this.typePageTarage.getSelectionModel().getSelectedIndex());
            this.config.setAutoTarage(this.autoTarage.isSelected());
            this.config.setAutoStart(this.autoStart.isSelected());
            this.config.baseZeroPatient = this.baseZeroPatient.isSelected();
            this.config.setReposAvantTravail(this.reposAvantTravail.isSelected());
            this.config.decomptePageStim = this.decomptePageStim.isSelected();
            this.config.decomptePageBFB = this.decomptePageBFB.isSelected();
            this.config.setVoiesSeparees(this.voiesSeparees.isSelected());
            this.config.setStimBFB(this.stimBFB.isSelected());
            this.config.toujoursCurseur = this.toujoursCurseur.isSelected();
            this.config.traitParSeconde = this.traitParSeconde.getSelectionModel().getSelectedIndex() == 0;
            this.config.noParallax = this.noParallax.isSelected();
            this.config.couleurVoie1 = String.format("#%08X", ((Color)this.couleurVoie1.getValue()).hashCode());
            this.config.couleurVoie2 = String.format("#%08X", ((Color)this.couleurVoie2.getValue()).hashCode());
            this.config.activSonFinProgramme = this.activSonFinDeProgram.isSelected();
            this.config.setSonFinProgramme(this.sonFinDeProgram.getText());
            this.config.activSonPageBFB = this.activSonPageBFB.isSelected();
            this.config.setSonPageBFB(this.sonPageBFB.getText());
            this.config.activSonDebutBFB = this.activSonDebutContraction.isSelected();
            this.config.setSonDebutBfb(this.sonDebutContraction.getText());
            this.config.activSonFinBFB = this.activSonFinContraction.isSelected();
            this.config.setSonFinBfb(this.sonFinContraction.getText());
            this.config.activSonPageStim = this.activSonPageStim.isSelected();
            this.config.setSonPageStim(this.sonPageStim.getText());
            this.config.activSonDebutStim = this.activSonDebutStim.isSelected();
            this.config.setSonDebutStim(this.sonDebutStim.getText());
            this.config.setBfbSonore(this.bfbSonore.getSelectionModel().getSelectedIndex());
            this.config.setLang((String)this.listeLangue.getSelectionModel().getSelectedItem());
            try {
                this.config.freqSauvegarde = Config.freqsBackup.get(this.freqBackup.getSelectionModel().getSelectedIndex());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.config.setUnite(this.listeUnite.getSelectionModel().getSelectedIndex());
            this.config.triPatients = this.listeTriPatients.getSelectionModel().getSelectedIndex();
            this.config.multiKine = this.multiKine.isSelected();
            this.config.forcePatient = this.forcePatient.isSelected();
            this.config.triSeances = this.triSeances.isSelected();
            this.config.afficheGraphiquePagePatient = this.graphBilan.isSelected();
            this.config.noPraticienInForm = this.noPraticienInForm.isSelected();
            this.config.logoPerso = this.logoPerso.getText();
            if (!this.config.multiKine) {
                this.config.kine = -1;
            }
            this.config.selectedAnimationsNb.clear();
            for (int i = 0; i < this.selectionAnimation.getChildren().size(); ++i) {
                CheckBox cb = (CheckBox)this.selectionAnimation.getChildren().get(i);
                if (!cb.isSelected()) continue;
                this.config.selectedAnimationsNb.add(i);
            }
            AnimationStyle.initSelectedStaticAnimationList();
            this.config.saveConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void mouseCliqueOpenWindowFolder(MouseEvent event) {
        Utils.chooseDir(event);
    }

    @FXML
    private void chooseFile(MouseEvent event) {
        Utils.chooseFile(event, this.background, false);
    }

    @FXML
    private void chooseFileInRep(MouseEvent event) {
        Utils.chooseFile(event, this.background, true);
    }

    private void initCompte() {
        this.compteNom.setText(this.config.compteNom);
        this.comptePrenom.setText(this.config.comptePrenom);
        this.compteMail.setText(this.config.compteMail);
        this.compteAddresse.setText(this.config.compteAddresse);
        this.compteOptin.setSelected(this.config.compteOptin);
        this.affichageAlerteCompte();
        this.compteMail.textProperty().addListener((a, b, c) -> {
            this.forceEndMail = true;
            this.config.compteNom = this.compteNom.getText();
            this.config.comptePrenom = this.comptePrenom.getText();
            this.config.compteMail = this.compteMail.getText();
            this.config.compteAddresse = this.compteAddresse.getText();
            this.config.compteOptin = this.compteOptin.isSelected();
            this.affichageAlerteCompte();
        });
        this.email.setText(this.config.compteMail);
        this.nom.setText(this.config.comptePrenom + " " + this.config.compteNom);
        this.adresse.setText(this.config.compteAddresse);
    }

    private void affichageAlerteCompte() {
        boolean ok = this.config.compteOK();
        FxUtils.setVisibility((Node)this.activer, !ok);
        this.monCompte.getStyleClass().remove((Object)"texteRouge");
        if (ok) {
            this.isActive.setText("");
        } else {
            this.monCompte.getStyleClass().add((Object)"texteRouge");
            if (this.config.nbAvantBlocage > 0) {
                this.isActive.setText(TransientConfig.translate("nbAvantBlocage", this.config.nbAvantBlocage - 1));
            } else {
                this.isActive.setText(TransientConfig.translate("nonActiveBloque"));
            }
        }
        Main.menu.changeAlertes();
    }

    private void saveCompte() {
        if (!(!this.forceEndMail && this.config.compteNom.equals(this.compteNom.getText()) && this.config.comptePrenom.equals(this.comptePrenom.getText()) && this.config.compteMail.equals(this.compteMail.getText()) && this.config.compteAddresse.equals(this.compteAddresse.getText()) && this.config.compteOptin == this.compteOptin.isSelected())) {
            this.config.compteNom = this.compteNom.getText();
            this.config.comptePrenom = this.comptePrenom.getText();
            this.config.compteMail = this.compteMail.getText();
            this.config.compteAddresse = this.compteAddresse.getText();
            this.config.compteOptin = this.compteOptin.isSelected();
            this.forceEndMail = false;
            if (this.config.compteOK()) {
                if (this.config.compteSerie == 0) {
                    this.config.compteSerie = this.config.numero_serie;
                }
            } else {
                this.config.compteSerie = 0;
            }
            if (!Version.isSAV()) {
                new Thread(CloudManager::sendCompte).start();
            }
        }
    }

    @FXML
    private void activer(MouseEvent event) {
        this.saveCompte();
        if (!Utils.isValidEmail(this.compteMail.getText())) {
            Utils.popupAlert(TransientConfig.translate("renseignerEmail"));
            return;
        }
        if (this.config.compteNom.isEmpty() || this.config.comptePrenom.isEmpty() || this.config.compteAddresse.isEmpty()) {
            Utils.popupAlert(TransientConfig.translate("renseignerCompte"));
            return;
        }
        if (!UsbBiostim.isConnexionBioStim()) {
            Utils.popupAlert(TransientConfig.translate("nonConnecte"));
            return;
        }
        if (event.getButton() != MouseButton.SECONDARY) {
            this.sendActivationMail();
        } else {
            this.readActivationCode();
        }
    }

    public void sendActivationMail() {
        String titre = TransientConfig.translate("mailActivation");
        int pass = Main.getConfig().calcComptePass();
        String body = String.format("%s : <b>%s</b>", titre, pass);
        new Thread(() -> {
            int res = DebugView.sendMail(titre, body, "noreply@mazetsante.fr", Main.getConfig().compteMail, null);
            DebugView.alertEnvoieMail(res);
            if (res == 0) {
                Platform.runLater(this::readActivationCode);
            }
        }).start();
    }

    private void readActivationCode() {
        Optional<String> res = Utils.popupReadInt("codeActivation", "");
        if (res.isPresent()) {
            try {
                this.config.comptePass = Integer.parseInt(res.get());
                if (this.config.compteOK()) {
                    this.config.compteSerie = this.config.numero_serie;
                    this.affichageAlerteCompte();
                    this.config.nbAvantBlocage = 50;
                    new Thread(() -> {
                        CloudManager.sendCompte();
                        CloudManager.sendJdd("Activation OK : %s", this.config.compteMail);
                    }).start();
                    return;
                }
                CloudManager.sendJdd("Erreur code activation %s %s %s", this.config.compteSerie, this.config.comptePass, this.config.compteMail);
            }
            catch (Exception ignored) {
                CloudManager.sendJdd("Exception activation %s %s %s", this.config.compteSerie, res.get(), this.config.compteMail);
            }
            Utils.makeToast(TransientConfig.translate("erreurActivation"), new Object[0]);
        } else {
            CloudManager.sendJdd("Abandon activation %s %s", this.config.compteSerie, this.config.compteMail);
        }
        this.config.compteSerie = 0;
    }

    @FXML
    private void oneTimeBackup() {
        configurationMainViewController.staticOneTimeBackup();
    }

    private static void staticOneTimeBackup() {
        boolean ok;
        String dir = Utils.chooseDir(TransientConfig.translate("repOneTimeBackup"));
        Utils.debugInfo("one time backup dans %s", dir);
        if (dir != null && (ok = Main.getConfig().createBackup(dir, false))) {
            Utils.popupAlert(TransientConfig.translate("backupOK"));
            Main.getConfig().setLastSauvegarde();
        }
    }

    public static void verifNewVersion() {
        if (Main.getConfig().num_version_soft != 20250210) {
            AlertQueue.addAlerte(() -> {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                FxUtils.setCssPopup((Parent)alert.getDialogPane());
                alert.setHeaderText(TransientConfig.translate("newVersion", "2025.2j"));
                Hyperlink hyperlink = new Hyperlink();
                hyperlink.setVisible(true);
                hyperlink.setManaged(true);
                hyperlink.setOnAction(e -> Main.main.getHostServices().showDocument(Version.getUrlDocVersion()));
                hyperlink.setText(TransientConfig.translate("nouveautesEnDetail"));
                alert.getDialogPane().setContent((Node)hyperlink);
                return alert;
            });
            if (Main.getConfig().num_version_soft < 12500 && Main.getConfig().couleurVoie1.equals("#0000FFFF") && Main.getConfig().couleurVoie2.equals("#FF0000FF")) {
                Main.getConfig().couleurVoie1 = "#FF0000FF";
                Main.getConfig().couleurVoie2 = "#0000FFFF";
            }
            CloudManager.sendJdd("MAJ : %d -> %d", Main.getConfig().num_version_soft, 20250210);
            Main.getConfig().num_version_soft = 20250210;
            Main.getConfig().setEtatCloud(0);
            Main.getConfig().setNextAptitude(30);
            Main.getConfig().saveConfig();
            Programme.resetPng();
        }
    }

    public static void verifOneTimeBackupAndAptitude() {
        block10: {
            Config config = Main.getConfig();
            if (config.lastSauvegarde == 0L) {
                config.setLastSauvegarde();
            }
            if (config.askAptitude == 0L) {
                config.setNextAptitude(30);
            }
            boolean save = false;
            long date = System.currentTimeMillis() / 1000L;
            if (config.freqSauvegarde != 0 && config.hasPatient() && date > config.lastSauvegarde + (long)config.freqSauvegarde * 3600L * 24L) {
                save = true;
                if (Utils.popupDialog(TransientConfig.translate("propositionBackup", LocalDate.ofEpochDay(config.lastSauvegarde / 86400L).format(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG))), false)) {
                    Platform.runLater(configurationMainViewController::staticOneTimeBackup);
                }
            }
            if (!save && config.askAptitude != -1L && date > config.askAptitude) {
                try {
                    String url = String.format("https://www.mazetsante.fr/biostim/aptitude.php?lang=%s", TransientConfig.langueSuffixe.substring(1));
                    String res = Utils.getHttp(url);
                    JSONObject jsonVersion = new JSONObject(res);
                    String aptitude = String.format(jsonVersion.getString("url"), config.numero_serie, config.compteMail);
                    try {
                        Future<Boolean> future = AlertQueue.showAlertAndWait(() -> {
                            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                            FxUtils.setCssPopup((Parent)alert.getDialogPane());
                            alert.setTitle(null);
                            alert.setHeaderText(TransientConfig.translate("remplirQuestionnaireAptitude"));
                            ButtonType OK = new ButtonType(TransientConfig.translate("oui"));
                            ButtonType plusTard = new ButtonType(TransientConfig.translate("plusTard"));
                            alert.getButtonTypes().clear();
                            alert.getButtonTypes().addAll((Object[])new ButtonType[]{OK, plusTard});
                            return alert;
                        });
                        if (future.get().booleanValue()) {
                            Desktop desktop = Desktop.getDesktop();
                            desktop.browse(new URI(aptitude));
                            config.setNextAptitude(-1);
                            break block10;
                        }
                        config.setNextAptitude(15);
                    }
                    catch (Exception e) {
                        Utils.debugLine(e.toString(), new Object[0]);
                    }
                }
                catch (Exception e) {
                    Utils.debugLine(e.toString(), new Object[0]);
                }
            }
        }
    }

    @FXML
    private void actionrecup() {
        try {
            this.save();
            new Thread(() -> {
                if (Utils.popupDialog(TransientConfig.translate("Toutes_les_donnees_seront_effacees"))) {
                    this.config.restoreBackup(this.fichierDeRecup.getText());
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void creation_animation() {
        String background = Computer.tryRelative(this.background.getText());
        int typeRuban = this.ruban.getSelectionModel().getSelectedIndex();
        String curseur1 = Computer.tryRelative(this.curseur1.getText());
        String curseur2 = Computer.tryRelative(this.curseur2.getText());
        ArrayList<String> objets = new ArrayList<String>();
        if (this.objet1.getText().length() > 1) {
            objets.add(Computer.tryRelative(this.objet1.getText()));
        }
        if (this.objet2.getText().length() > 1) {
            objets.add(Computer.tryRelative(this.objet2.getText()));
        }
        if (this.objet3.getText().length() > 1) {
            objets.add(Computer.tryRelative(this.objet3.getText()));
        }
        if (this.objet4.getText().length() > 1) {
            objets.add(Computer.tryRelative(this.objet4.getText()));
        }
        if (this.objet5.getText().length() > 1) {
            objets.add(Computer.tryRelative(this.objet5.getText()));
        }
        if (this.nom_animation.getSelectionModel().getSelectedIndex() == 0) {
            String name;
            Optional<String> readName = Utils.popupReadVal("donner_nom_animation", "");
            if (readName.isPresent() && !(name = readName.get()).isEmpty()) {
                AnimationStyle animationStyle = new AnimationStyle(name, background, typeRuban, curseur1, curseur2, objets);
                this.config.customAnimationList.add(animationStyle);
                this.config.saveConfig();
                this.nom_animation.getItems().add((Object)name);
                this.nom_animation.getSelectionModel().selectLast();
                Utils.popupAlert(TransientConfig.translate("animation_ajoutee") + name);
            }
        } else {
            int pos = this.nom_animation.getSelectionModel().getSelectedIndex() - 1;
            String name = this.config.customAnimationList.get(pos).getTranslatedName();
            AnimationStyle animationStyle = new AnimationStyle(name, background, typeRuban, curseur1, curseur2, objets);
            this.config.customAnimationList.set(pos, animationStyle);
            this.config.saveConfig();
            Utils.popupAlert(TransientConfig.translate("animation_mise_a_jour") + name);
        }
    }

    @FXML
    private void suppression_animation() {
        int anim = this.nom_animation.getSelectionModel().getSelectedIndex() - 1;
        if (anim >= 0) {
            this.nom_animation.getSelectionModel().selectFirst();
            this.config.customAnimationList.remove(anim);
            this.nom_animation.getItems().remove(anim + 1);
            this.config.saveConfig();
        }
    }

    private void changeAnimation() {
        int pos = this.nom_animation.getSelectionModel().getSelectedIndex();
        if (pos == 0) {
            this.creerAnimation.setText(TransientConfig.translate("creation"));
            this.supprAnimation.setVisible(false);
        } else {
            this.creerAnimation.setText(TransientConfig.translate("update"));
            this.supprAnimation.setVisible(true);
            AnimationStyle animationStyle = this.config.customAnimationList.get(pos - 1);
            this.background.setText(Computer.makeAbsolute(animationStyle.background));
            this.ruban.getSelectionModel().select(animationStyle.typeRuban);
            this.curseur1.setText(Computer.makeAbsolute(animationStyle.curseur1));
            this.curseur2.setText(Computer.makeAbsolute(animationStyle.curseur2));
            ArrayList<String> objets = animationStyle.objets;
            if (objets.size() >= 1) {
                this.objet1.setText(Computer.makeAbsolute(objets.get(0)));
            } else {
                this.objet1.setText("");
            }
            if (objets.size() >= 2) {
                this.objet2.setText(Computer.makeAbsolute(objets.get(1)));
            } else {
                this.objet2.setText("");
            }
            if (objets.size() >= 3) {
                this.objet3.setText(Computer.makeAbsolute(objets.get(2)));
            } else {
                this.objet3.setText("");
            }
            if (objets.size() >= 4) {
                this.objet4.setText(Computer.makeAbsolute(objets.get(3)));
            } else {
                this.objet4.setText("");
            }
            if (objets.size() >= 5) {
                this.objet5.setText(Computer.makeAbsolute(objets.get(4)));
            } else {
                this.objet5.setText("");
            }
        }
    }

    @FXML
    private void addForm() {
        try {
            Path source = Paths.get(this.newForm.getText(), new String[0]);
            Path dest = Paths.get(Computer.absolutePath + "appData/bilan" + TransientConfig.langueSuffixe + "/" + source.getFileName().toString(), new String[0]);
            Files.copy(source, dest, new CopyOption[0]);
            this.newForm.setText("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initForm() {
        this.listForm.setItems(Computer.getListFormulaires());
        this.listForm.setPromptText(TransientConfig.translate("select_formulaire"));
        this.listForm.getSelectionModel().selectedItemProperty().addListener((ov, old_val, new_val) -> {
            this.modifForm = new_val;
        });
    }

    @FXML
    private void modifierFormulaire() {
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.open(new File(Computer.absolutePath + "appData/bilan" + TransientConfig.langueSuffixe + "/" + this.modifForm));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void clicPlusConcatLines() {
        if (this.config.nbConcatLines < 10) {
            ++this.config.nbConcatLines;
            this.nbConcatLines.setText(Integer.toString(this.config.nbConcatLines));
        }
    }

    @FXML
    private void clicMoinsConcatLines() {
        if (this.config.nbConcatLines > 2) {
            --this.config.nbConcatLines;
            this.nbConcatLines.setText(Integer.toString(this.config.nbConcatLines));
        }
    }

    @FXML
    private void clicPlusCombineLines() {
        if (this.config.nbCombineLines < 10) {
            ++this.config.nbCombineLines;
            this.nbCombineLines.setText(Integer.toString(this.config.nbCombineLines));
        }
    }

    @FXML
    private void clicMoinsCombineLines() {
        if (this.config.nbCombineLines > 2) {
            --this.config.nbCombineLines;
            this.nbCombineLines.setText(Integer.toString(this.config.nbCombineLines));
        }
    }

    @FXML
    private void clicPlusEpaisseurVoie() {
        if (this.config.epaisseurVoie < 15) {
            ++this.config.epaisseurVoie;
            this.epaisseurVoie.setText(Integer.toString(this.config.epaisseurVoie));
        }
    }

    @FXML
    private void clicMoinsEpaisseurVoie() {
        if (this.config.epaisseurVoie > 5) {
            --this.config.epaisseurVoie;
            this.epaisseurVoie.setText(Integer.toString(this.config.epaisseurVoie));
        }
    }

    @FXML
    private void clicPlusEpaisseurProfil() {
        if (this.config.epaisseurProfil < 30) {
            ++this.config.epaisseurProfil;
            this.epaisseurProfil.setText(this.config.epaisseurProfil + "%");
        }
    }

    @FXML
    private void clicMoinsEpaisseurProfil() {
        if (this.config.epaisseurProfil > 5) {
            --this.config.epaisseurProfil;
            this.epaisseurProfil.setText(this.config.epaisseurProfil + "%");
        }
    }

    @FXML
    private void clicPlusLissage() {
        if (this.config.lissage < 20) {
            ++this.config.lissage;
            this.lissage.setText(this.config.lissage + "/20");
        }
    }

    @FXML
    private void clicMoinsLissage() {
        if (this.config.lissage > 0) {
            --this.config.lissage;
            this.lissage.setText(this.config.lissage + "/20");
        }
    }

    @FXML
    private void clicPlusVitesse() {
        if (this.config.getVitesseDefilement() < 20) {
            this.config.setAjouteVitesseDefilement(1);
            this.vitesse.setText(this.config.getVitesseDefilement() + "/20");
        }
    }

    @FXML
    private void clicMoinsVitesse() {
        if (this.config.getVitesseDefilement() > 1) {
            this.config.setAjouteVitesseDefilement(-1);
            this.vitesse.setText(this.config.getVitesseDefilement() + "/20");
        }
    }

    public void getNotice() {
        try {
            Desktop.getDesktop().open(new File(Computer.absolutePath + "doc"));
        }
        catch (Exception e) {
            Utils.debugLine("%s", e.toString());
        }
    }

    public void getNouveautes() {
        Main.main.getHostServices().showDocument(Version.getUrlDocVersion());
    }

    public void openLink(ActionEvent actionEvent) {
        try {
            String link = (String)((Button)actionEvent.getSource()).getUserData();
            Desktop.getDesktop().browse(new URI(link));
        }
        catch (Exception e) {
            Utils.debugLine("%s", e.toString());
        }
    }

    public void sendMail() {
        String mail = this.email.getText();
        if (!Utils.isValidEmail(mail)) {
            Utils.popupAlert(TransientConfig.translate("renseignerEmail"));
            return;
        }
        DebugView.sendDebugMail(this.contactMotif, mail, this.nom, this.adresse, this.contactInput, Autotest.getState());
    }

    public void style1() {
        Main.getConfig().style = 1;
        Main.setCSS();
    }

    public void style2() {
        Main.getConfig().style = 2;
        Main.setCSS();
    }

    public void style3() {
        Main.getConfig().style = 3;
        Main.setCSS();
    }

    @FXML
    private void clicPlusTaille() {
        if (this.config.tailleChar < 6) {
            this.config.setAJouteTailleChar(1);
            this.tailleChar.setText(this.config.tailleChar + "/6");
        }
    }

    @FXML
    private void clicMoinsTaille() {
        if (this.config.tailleChar > 1) {
            this.config.setAJouteTailleChar(-1);
            this.tailleChar.setText(this.config.tailleChar + "/6");
        }
    }

    @FXML
    private void testSonFinProg() {
        Computer.playSong(this.sonFinDeProgram.getText());
    }

    @FXML
    private void testSonPageBFB() {
        Computer.playSong(this.sonPageBFB.getText());
    }

    @FXML
    private void testSonDebutContraction() {
        Computer.playSong(this.sonDebutContraction.getText());
    }

    @FXML
    private void testSonFinContraction() {
        Computer.playSong(this.sonFinContraction.getText());
    }

    @FXML
    private void testSonPageStim() {
        Computer.playSong(this.sonPageStim.getText());
    }

    @FXML
    private void testSonDebutStim() {
        Computer.playSong(this.sonDebutStim.getText());
    }
}

