/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.main;

import com.mazet.biostim.Main;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.zdata.Programme;
import java.util.ArrayList;
import java.util.Optional;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;

public class listViewController
extends Controller {
    @FXML
    private AnchorPane mainPane;
    @FXML
    private AnchorPane logo;
    ArrayList<Button> buttons = new ArrayList();

    @Override
    public void setMain() {
        if (Version.isVersionTest()) {
            Label version = new Label("2025.2j : TEST\nUNIQUEMENT");
            version.getStyleClass().add((Object)"bigRouge");
            AnchorPane.setRightAnchor((Node)version, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)version, (Double)0.0);
            this.logo.getChildren().add((Object)version);
        } else if (Version.isSAV()) {
            Button version = new Button("2025.2j");
            version.getStyleClass().add((Object)"bigRouge");
            AnchorPane.setRightAnchor((Node)version, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)version, (Double)0.0);
            this.logo.getChildren().add((Object)version);
            version.setOnMouseClicked(e -> Main.changeCenterView("_sav", "sav", null));
            Button visa = new Button("Ouvrir Oscillo");
            AnchorPane.setLeftAnchor((Node)visa, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)visa, (Double)0.0);
            this.logo.getChildren().add((Object)visa);
            visa.setOnMouseClicked(e -> this.openVISA());
        } else {
            FxUtils.setVisibility((Node)this.logo, false);
        }
        this.mainPane.widthProperty().addListener((observable, oldValue, newValue) -> this.updateButtons());
        this.mainPane.heightProperty().addListener((observable, oldValue, newValue) -> this.updateButtons());
        this.createButtons();
    }

    private void createButtons() {
        for (String categorie : Programme.getListCategorie()) {
            Button button = new Button(TransientConfig.persoTranslate(categorie).toUpperCase());
            button.getStyleClass().add((Object)"buttonRond");
            button.setOnMouseClicked(e -> this.mouseClique(categorie, (MouseEvent)e));
            this.buttons.add(button);
            this.mainPane.getChildren().add((Object)button);
        }
    }

    private void updateButtons() {
        double widthPane = this.mainPane.getWidth();
        double heightPane = this.mainPane.getHeight();
        if (widthPane != 0.0 && heightPane != 0.0) {
            this.updateButtons1(widthPane, heightPane);
        }
    }

    private void updateButtons1(double widthPane, double heightPane) {
        int nb = this.buttons.size();
        int nbLines = (nb + 1) / 2;
        double width = widthPane / 3.5;
        double height = heightPane * 0.12;
        double space = (heightPane - (double)(nbLines + 1) * height) / (double)(nbLines + 1);
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button b = this.buttons.get(i);
            b.setStyle(String.format("-fx-font-size: %.0f", (height - 8.0) / 3.5));
            int col = i % 2;
            int line = i / 2;
            double posx = 0.5 + (double)col * 1.5;
            if (i % 2 == 0 && i == this.buttons.size() - 1) {
                posx = 1.25;
            }
            double posy = height * 0.5 + space + (double)line * (space + height);
            b.setLayoutX(posx * width);
            b.setLayoutY(posy);
            b.setPrefWidth(width);
            b.setPrefHeight(height);
        }
        this.logo.setPrefWidth(0.98 * widthPane);
        this.logo.setPrefHeight(0.2 * heightPane);
        this.logo.setLayoutX(0.0);
        this.logo.setLayoutY(0.78 * heightPane);
    }

    private void mouseClique(String categorie, MouseEvent event) {
        try {
            if (event.getButton() == MouseButton.SECONDARY) {
                ContextMenu contextMenu = new ContextMenu();
                MenuItem item1 = new MenuItem(TransientConfig.translate("rename"));
                item1.setOnAction(e -> {
                    Optional<String> result = Utils.popupReadVal("renameContent", "");
                    if (result.isPresent()) {
                        if (result.get().isEmpty()) {
                            Main.getConfig().resetTraduction(categorie);
                        } else {
                            Main.getConfig().addTraduction(categorie, result.get());
                        }
                        Main.menu.goToHome();
                    }
                });
                contextMenu.getItems().addAll((Object[])new MenuItem[]{item1});
                contextMenu.show(Main.sceneMain.getWindow(), event.getScreenX(), event.getScreenY());
            } else {
                Main.progEnCours = null;
                Main.setCategorie(categorie);
                Main.changeCenterView("programme", "progList", Main.menu.homeButton);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    void openVISA() {
        if (Version.isSAV()) {
            try {
                FXMLLoader loader = new FXMLLoader();
                loader.setLocation(Main.class.getResource("view/_sav/visaView.fxml"));
                Parent visaLayout = (Parent)loader.load();
                visaLayout.getStylesheets().add((Object)Main.class.getResource("/res/style/style_home.css").toExternalForm());
                Controller visaController = (Controller)loader.getController();
                visaController.setMain();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

