/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.graph.AreaChartWithMarkers;
import com.mazet.biostim.graph.CircularProgress;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.programme.MenuBasController;
import com.mazet.biostim.zdata.Pageprogramme;
import javafx.animation.AnimationTimer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.util.Duration;

public class StimulationController
extends Controller {
    private AnimationTimer timerPageProgramme;
    private double dureeMilli = 0.0;
    private double dureePage = 9999.0;
    private int compteurTemp = 0;
    private String targetElement;
    private Timeline timelineMouse;
    @FXML
    private Label title;
    @FXML
    private AnchorPane gameAnchor;
    @FXML
    private HBox hboxVoieA;
    @FXML
    private AnchorPane gameAnchor2;
    @FXML
    private HBox hboxVoieB;
    @FXML
    private AreaChartWithMarkers<Double, Double> graph1;
    @FXML
    private AreaChartWithMarkers<Double, Double> graph2;
    @FXML
    private NumberAxis xAxis1;
    @FXML
    private NumberAxis xAxis2;
    @FXML
    private NumberAxis yAxis2;
    @FXML
    private Label labelSlider1;
    @FXML
    private Label labelSlider2;
    @FXML
    private Label nomVoie2;
    @FXML
    private TextArea commentaire;
    @FXML
    private AnchorPane anchorControl1;
    @FXML
    private AnchorPane anchorControl2;
    @FXML
    private Label tempTotal;
    @FXML
    private MenuBasController menuBasController;
    CircularProgress cp1;
    CircularProgress cp2;
    private XYChart.Data<Double, Double> verticalMarker1;
    private XYChart.Data<Double, Double> verticalMarker2;
    private XYChart.Series<Double, Double> series;
    private XYChart.Series<Double, Double> seriesDirect;
    private XYChart.Series<Double, Double> series2;
    private XYChart.Series<Double, Double> series2Direct;
    private boolean pause;
    private boolean pageQuittee;
    private boolean stimStopAnticipe = false;
    private boolean pressionBFB = false;
    int nbPage = -1;
    int nbPage2 = -1;
    private double lastStim1 = 0.0;
    private double lastStim2 = 0.0;
    private static final double delaiAnticipationSon = 0.5;

    @Override
    public void setMain() {
        try {
            Computer.loadSong(Main.getConfig().getSonDebutStim());
            UsbBiostim.initBioStim();
            FxUtils.adjustLabelWidth(this.tempTotal, "00:00", 1.2);
            this.menuBasController.initLogo();
            this.pause = false;
            this.pressionBFB = Main.progEnCours.currentPageProgram.getNbVoie() == 1 && Main.getConfig().stimBFB;
            FxUtils.adjustHboxReglageStyle(this.hboxVoieA, "A", 2.0, null);
            FxUtils.adjustHboxReglageStyle(this.hboxVoieB, "A", 2.0, null);
            String stitle = Main.progEnCours.currentPageProgram.getInfo() != null ? TransientConfig.translate(Main.progEnCours.currentPageProgram.getInfo()) : Main.progEnCours.currentProgram.getNom();
            String sfreq = "(" + Main.progEnCours.currentPageProgram.getFreq();
            if (Main.progEnCours.currentPageProgram.getFreqF2() != 0) {
                sfreq = sfreq + " ~ " + Main.progEnCours.currentPageProgram.getFreqF2();
            }
            if (Main.progEnCours.currentPageProgram.getNbVoie() == 2 && Main.progEnCours.currentPageProgram.getFreq() != Main.progEnCours.currentPageProgram.getFreq2()) {
                sfreq = sfreq + " Hz - " + Main.progEnCours.currentPageProgram.getFreq2();
            }
            if (!stitle.contains(sfreq = sfreq + " Hz)")) {
                stitle = stitle + " " + sfreq;
            }
            this.title.setText(stitle);
            this.commentaire.setText(Main.progEnCours.commentaire);
            this.menuBasController.getLabelSuivant().setOnMouseClicked(event -> this.suivantAction());
            this.menuBasController.getLabelPrecedent().setOnMouseClicked(event -> this.precedentAction());
            this.menuBasController.getLabelStop().setOnMouseClicked(event -> this.stopAction());
            this.menuBasController.getLabelPause().setOnMouseClicked(event -> this.pauseAction());
            this.tempTotal.setText(Main.progEnCours.getProgDureeRestanteString());
            this.menuBasController.afficheDureeRestante();
            if (Main.progEnCours.currentPageProgram.getDuree() != null) {
                this.dureePage = Main.progEnCours.currentPageProgram.getDuree().intValue();
            }
            this.dureePage = Math.min((double)Main.progEnCours.getProgDureeRestante(), this.dureePage);
            Platform.runLater(this::init);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        try {
            this.initCurseur();
            this.initCurseurDefilant();
            this.updateCurseurDefilant();
            if (Version.isSAV()) {
                Button a02 = new Button("A = 2");
                a02.setOnMouseClicked(e -> this.setStimAmplitudeA(2.0));
                AnchorPane.setRightAnchor((Node)a02, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)a02, (Double)60.0);
                Button a50 = new Button("A = 50");
                a50.setOnMouseClicked(e -> this.setStimAmplitudeA(50.0));
                AnchorPane.setRightAnchor((Node)a50, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)a50, (Double)30.0);
                Button a10 = new Button("A + 10");
                a10.setOnMouseClicked(e -> this.setStimAmplitudeA(Main.progEnCours.getStimAmplitudeA() + 10.0));
                AnchorPane.setRightAnchor((Node)a10, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)a10, (Double)0.0);
                this.anchorControl1.getChildren().addAll((Object[])new Node[]{a02, a50, a10});
                Button b02 = new Button("B = 2");
                b02.setOnMouseClicked(e -> this.setStimAmplitudeB(2.0));
                AnchorPane.setRightAnchor((Node)b02, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)b02, (Double)60.0);
                Button b50 = new Button("B = 50");
                b50.setOnMouseClicked(e -> this.setStimAmplitudeB(50.0));
                AnchorPane.setRightAnchor((Node)b50, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)b50, (Double)30.0);
                Button b10 = new Button("B + 10");
                b10.setOnMouseClicked(e -> this.setStimAmplitudeB(Main.progEnCours.getStimAmplitudeB() + 10.0));
                AnchorPane.setRightAnchor((Node)b10, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)b10, (Double)0.0);
                this.anchorControl2.getChildren().addAll((Object[])new Node[]{b02, b50, b10});
            }
            boolean bl = this.started = !Main.getConfig().decomptePageStim;
            if (!this.started) {
                FxUtils.lanceDecompte(this, this.gameAnchor);
            }
            new Thread(() -> {
                while (!this.started) {
                    if (this.pageQuittee) {
                        return;
                    }
                    Utils.sleep(20L);
                }
                this.initStim();
                Platform.runLater(this::initAmplitude);
                int countBoucle = 0;
                while (UsbBiostim.isConnexionBioStim() && Main.progEnCours.currentPageProgram.getNbVoie() > UsbBiostim.getNbStartStim()) {
                    if (countBoucle > 50) {
                        Utils.debugInfo("impossible de d\u00e9marrer la stim (pas de reponse &j)");
                        return;
                    }
                    ++countBoucle;
                    Utils.sleep(20L);
                }
                this.creationTimerPageProgramme();
            }).start();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void initStim() {
        UsbBiostim.initStimInnervee(Main.progEnCours.currentPageProgram.getNbVoie(), Math.round(Main.progEnCours.currentPageProgram.getTtravail() * 10.0), Math.round(Main.progEnCours.currentPageProgram.getTrepos() * 10.0), Math.round(Main.progEnCours.currentPageProgram.getTmontee() * 10.0), Math.round(Main.progEnCours.currentPageProgram.getTdescente() * 10.0), Math.round(Main.progEnCours.currentPageProgram.getTtravail2() * 10.0), Math.round(Main.progEnCours.currentPageProgram.getTrepos2() * 10.0), Math.round(Main.progEnCours.currentPageProgram.getTmontee2() * 10.0), Math.round(Main.progEnCours.currentPageProgram.getTdescente2() * 10.0), Main.progEnCours.currentPageProgram.getBf(), Main.progEnCours.currentPageProgram.getFreq(), Main.progEnCours.currentPageProgram.getLargeur(), Main.progEnCours.currentPageProgram.getFreq2(), Main.progEnCours.currentPageProgram.getLargeur2(), Main.progEnCours.currentPageProgram.getAttente2Impulsion(), Main.progEnCours.currentPageProgram.getLargeurL2(), Main.progEnCours.currentPageProgram.getFreqF2(), Main.progEnCours.currentPageProgram.getDissymetrique(), Main.progEnCours.currentPageProgram.getHauteTension(), Main.progEnCours.currentPageProgram.getImpulsionMono(), Main.progEnCours.currentPageProgram.getPolarite(), Main.progEnCours.currentPageProgram.getLargeurL3(), Main.progEnCours.currentPageProgram.getFreqF3(), Main.progEnCours.currentPageProgram.getReposActif(), Main.progEnCours.currentPageProgram.getReposActif2());
    }

    private void initCurseurDefilant() {
        this.series = new XYChart.Series();
        this.seriesDirect = new XYChart.Series();
        this.graph1.getData().addAll((Object[])new XYChart.Series[]{this.series, this.seriesDirect});
        this.verticalMarker1 = new XYChart.Data((Object)0.0, (Object)0.0);
        this.graph1.addVerticalValueMarker(this.verticalMarker1);
        this.verticalMarker1.getNode().setStyle("-fx-stroke-width:10; -fx-stroke : blue");
        for (Node n : this.graph1.lookupAll(".series1")) {
            n.setStyle("-fx-stroke: black; -fx-stroke-width:6; -fx-fill : #f0f0f0");
        }
        if (Main.progEnCours.currentPageProgram.getNbVoie() == 2 || this.pressionBFB) {
            this.series2 = new XYChart.Series();
            this.graph2.getData().add(this.series2);
            if (!this.pressionBFB) {
                this.series2Direct = new XYChart.Series();
                this.graph2.getData().add(this.series2Direct);
                for (Node n : this.graph2.lookupAll(".series1")) {
                    n.setStyle("-fx-stroke: #000000; -fx-stroke-width:6; -fx-fill: #f0f0f0;");
                }
            } else {
                this.setLimMaxP(Main.progEnCours.getAffMax(2));
                this.nomVoie2.setText(Biostim.nomOfVoie(2));
                this.yAxis2.setTickUnit(20.0);
            }
            this.verticalMarker2 = new XYChart.Data((Object)0.0, (Object)0.0);
            this.graph2.addVerticalValueMarker(this.verticalMarker2);
            this.verticalMarker2.getNode().setStyle("-fx-stroke-width:10; -fx-stroke : blue");
        }
    }

    private void initCurseur() {
        this.cp1 = new CircularProgress(this.anchorControl1);
        if (Main.progEnCours.currentPageProgram.getNbVoie() == 2) {
            this.cp2 = new CircularProgress(this.anchorControl2);
        } else {
            FxUtils.setVisibility((Node)this.gameAnchor2, this.pressionBFB);
        }
    }

    private void initAmplitude() {
        try {
            Main.progEnCours.setImaxA();
            this.setStimAmplitudeA(Main.progEnCours.getStimAmplitudeA());
            if (Main.progEnCours.currentPageProgram.getNbVoie() == 2) {
                Main.progEnCours.setImaxB();
                this.setStimAmplitudeB(Main.progEnCours.getStimAmplitudeB());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void creationTimerPageProgramme() {
        this.timerPageProgramme = new AnimationTimer(){
            private long seconde = 0L;
            private long initTime = 0L;

            public void handle(long now) {
                try {
                    if (this.initTime == 0L) {
                        this.initTime = now;
                        this.seconde = now;
                    }
                    if (now - this.seconde >= 1000000000L) {
                        Computer.keepAwake();
                        Main.progEnCours.decrPageDureeRestante();
                        Main.progEnCours.decrProgDureeRestante();
                        StimulationController.this.menuBasController.afficheDureeRestante();
                        StimulationController.this.tempTotal.setText(Main.progEnCours.getProgDureeRestanteString());
                        this.seconde = now;
                    }
                    if (Main.progEnCours.getProgDureeRestante() <= 0) {
                        Computer.playSong(Main.getConfig().getSonFinProgramme());
                        StimulationController.this.stopAction();
                    } else if (Main.progEnCours.getPageDureeRestante() != null && Main.progEnCours.getPageDureeRestante() <= 0) {
                        StimulationController.this.suivantAction();
                    } else {
                        StimulationController.this.dureeMilli = (double)(now - this.initTime) / 1.0E9;
                        if (!StimulationController.this.pageQuittee) {
                            StimulationController.this.updateCurseurDefilant();
                            StimulationController.this.cp1.setAction(Main.progEnCours.currentPageProgram.getStimAmplitude1(StimulationController.this.dureeMilli));
                            if (StimulationController.this.cp2 != null) {
                                StimulationController.this.cp2.setAction(Main.progEnCours.currentPageProgram.getStimAmplitude2(StimulationController.this.dureeMilli));
                            }
                            StimulationController.this.manageSound();
                            if (!StimulationController.this.stimStopAnticipe && Main.progEnCours.currentPageProgram.getZeroTime(StimulationController.this.dureeMilli) >= StimulationController.this.dureePage - StimulationController.this.dureeMilli) {
                                UsbBiostim.activateGenerateur(Main.progEnCours.currentPageProgram.getNbVoie(), false);
                                StimulationController.this.stimStopAnticipe = true;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (!this.pageQuittee) {
            this.timerPageProgramme.start();
        }
    }

    private void updateCurseurDefilant() {
        Pageprogramme pp = Main.progEnCours.currentPageProgram;
        double periode = pp.getPeriode1();
        if (this.dureeMilli >= (double)(this.nbPage + 1) * periode) {
            ++this.nbPage;
            this.xAxis1.setLowerBound((double)this.nbPage * periode);
            this.xAxis1.setUpperBound((double)(this.nbPage + 1) * periode);
            this.series.getData().clear();
            this.series.getData().add((Object)new XYChart.Data((Object)((double)this.nbPage * periode), (Object)0.0));
            this.series.getData().add((Object)new XYChart.Data((Object)((double)this.nbPage * periode + pp.getTmontee()), (Object)1.0));
            this.series.getData().add((Object)new XYChart.Data((Object)((double)this.nbPage * periode + pp.getTtravail() - pp.getTdescente()), (Object)1.0));
            this.series.getData().add((Object)new XYChart.Data((Object)((double)this.nbPage * periode + pp.getTtravail()), (Object)0.0));
            this.series.getData().add((Object)new XYChart.Data((Object)((double)(this.nbPage + 1) * periode), (Object)0.0));
            this.seriesDirect.getData().clear();
            if (this.pressionBFB) {
                this.series2.getData().clear();
                this.xAxis2.setLowerBound((double)this.nbPage * periode);
                this.xAxis2.setUpperBound((double)(this.nbPage + 1) * periode);
            }
        }
        this.seriesDirect.getData().add((Object)new XYChart.Data((Object)this.dureeMilli, (Object)pp.getStimAmplitude1(this.dureeMilli)));
        this.verticalMarker1.setXValue((Object)this.dureeMilli);
        if (Main.progEnCours.currentPageProgram.getNbVoie() == 2) {
            double periode2 = pp.getPeriode2();
            if (this.dureeMilli >= (double)(this.nbPage2 + 1) * periode2) {
                ++this.nbPage2;
                this.xAxis2.setLowerBound((double)this.nbPage2 * periode2);
                this.xAxis2.setUpperBound((double)(this.nbPage2 + 1) * periode2);
                this.series2.getData().clear();
                this.series2.getData().add((Object)new XYChart.Data((Object)((double)this.nbPage2 * periode2), (Object)0.0));
                this.series2.getData().add((Object)new XYChart.Data((Object)((double)this.nbPage2 * periode2 + pp.getTmontee2()), (Object)1.0));
                this.series2.getData().add((Object)new XYChart.Data((Object)((double)this.nbPage2 * periode2 + pp.getTtravail2() - pp.getTdescente2()), (Object)1.0));
                this.series2.getData().add((Object)new XYChart.Data((Object)((double)this.nbPage2 * periode2 + pp.getTtravail2()), (Object)0.0));
                this.series2.getData().add((Object)new XYChart.Data((Object)((double)(this.nbPage2 + 1) * periode2), (Object)0.0));
                this.series2Direct.getData().clear();
            }
            this.series2Direct.getData().add((Object)new XYChart.Data((Object)this.dureeMilli, (Object)pp.getStimAmplitude2(this.dureeMilli)));
            this.verticalMarker2.setXValue((Object)this.dureeMilli);
        }
        if (this.pressionBFB) {
            double niv = Math.min(Biostim.getVoie(2), Main.progEnCours.getAffMax(2));
            this.series2.getData().add((Object)new XYChart.Data((Object)this.dureeMilli, (Object)niv));
        }
    }

    private void manageSound() {
        double stim1 = Main.progEnCours.currentPageProgram.getStimAmplitude1(this.dureeMilli + 0.5);
        boolean needSound = this.lastStim1 == 0.0 && stim1 != 0.0;
        this.lastStim1 = stim1;
        if (Main.progEnCours.currentPageProgram.getNbVoie() == 2) {
            double stim2 = Main.progEnCours.currentPageProgram.getStimAmplitude2(this.dureeMilli + 0.5);
            if (this.lastStim2 == 0.0 && stim2 != 0.0) {
                needSound = true;
            }
            this.lastStim2 = stim2;
        }
        if (needSound) {
            Computer.playSongIfNotIntro(Main.getConfig().getSonDebutStim(), Main.getConfig().getSonPageStim());
        }
    }

    @FXML
    private void mousePressed(MouseEvent event) {
        Button targetObject = (Button)event.getSource();
        this.targetElement = (String)targetObject.getUserData();
        this.compteurTemp = 0;
        if (this.timelineMouse != null) {
            this.timelineMouse.stop();
        }
        this.timelineMouse = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)50.0), ae -> {
            if (this.pageQuittee) {
                this.timelineMouse.stop();
            }
            if (this.compteurTemp > 10) {
                this.methodeHoldMouse();
            }
            ++this.compteurTemp;
        }, new KeyValue[0])});
        this.timelineMouse.setCycleCount(-1);
        this.timelineMouse.playFromStart();
    }

    @FXML
    private void mouseReleased() {
        if (this.timelineMouse != null) {
            this.timelineMouse.stop();
            this.timelineMouse = null;
            this.methodeHoldMouse();
        }
    }

    private void methodeHoldMouse() {
        try {
            switch (this.targetElement) {
                case "s1+": {
                    if (!Main.progEnCours.currentPageProgram.isPlateau1(this.dureeMilli) || !UsbBiostim.isEnableIncrStim() || this.pause) break;
                    this.setStimAmplitudeA(Main.progEnCours.getStimAmplitudeA() + UsbBiostim.deltaStim);
                    break;
                }
                case "s1-": {
                    this.setStimAmplitudeA(Main.progEnCours.getStimAmplitudeA() - UsbBiostim.deltaStim);
                    break;
                }
                case "s2+": {
                    if (this.pressionBFB) {
                        this.setLimMaxP(Main.progEnCours.getAffMax(2) + 1.0);
                        break;
                    }
                    if (!Main.progEnCours.currentPageProgram.isPlateau2(this.dureeMilli) || !UsbBiostim.isEnableIncrStim2() || this.pause) break;
                    this.setStimAmplitudeB(Main.progEnCours.getStimAmplitudeB() + UsbBiostim.deltaStim);
                    break;
                }
                case "s2-": {
                    if (this.pressionBFB) {
                        this.setLimMaxP(Main.progEnCours.getAffMax(2) - 1.0);
                        break;
                    }
                    this.setStimAmplitudeB(Main.progEnCours.getStimAmplitudeB() - UsbBiostim.deltaStim);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateAffichageStim() {
        double ampli = Main.progEnCours.getStimAmplitudeA();
        this.labelSlider1.textProperty().setValue(String.format("%.1f mA", ampli));
        this.cp1.setIntensite(ampli / Main.progEnCours.imaxA);
        if (Main.progEnCours.currentPageProgram.getNbVoie() == 2) {
            ampli = Main.progEnCours.getStimAmplitudeB();
            this.labelSlider2.textProperty().setValue(String.format("%.1f mA", ampli));
            this.cp2.setIntensite(ampli / Main.progEnCours.imaxB);
        }
    }

    private void setStimAmplitudeA(double ampli) {
        double value = Main.progEnCours.setStimAmplitudeA(ampli);
        this.cp1.setIntensite(value);
        ampli = Main.progEnCours.getStimAmplitudeA();
        UsbBiostim.amplitudeVoie(0, ampli);
        this.labelSlider1.textProperty().setValue(String.format("%.1f mA", ampli));
    }

    private void setStimAmplitudeB(double ampli) {
        double value = Main.progEnCours.setStimAmplitudeB(ampli);
        this.cp2.setIntensite(value);
        ampli = Main.progEnCours.getStimAmplitudeB();
        UsbBiostim.amplitudeVoie(1, ampli);
        this.labelSlider2.textProperty().setValue(String.format("%.1f mA", ampli));
    }

    private void setLimMaxP(double ampli) {
        Main.progEnCours.setAffMax(2, Math.max(5.0, Math.min(ampli, Biostim.getMaxVoie(2))));
        ampli = Main.progEnCours.getAffMax(2);
        this.yAxis2.setUpperBound(ampli * 1.1);
        this.labelSlider2.textProperty().setValue(String.format("%d %s", (int)ampli, Main.getConfig().getPressureUnite()));
    }

    private void stopStim() {
        try {
            Main.progEnCours.commentaire = this.commentaire.getText();
            if (!this.stimStopAnticipe) {
                UsbBiostim.activateGenerateur(Main.progEnCours.currentPageProgram.getNbVoie(), false);
            }
            if (this.timerPageProgramme != null) {
                this.timerPageProgramme.stop();
            }
            this.pageQuittee = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @FXML
    public void stopAction() {
        try {
            this.stopStim();
            Platform.runLater(() -> Main.progEnCours.finProgramme());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @FXML
    public void pauseAction() {
        try {
            if (!this.pause) {
                this.setStimAmplitudeA(0.0);
                if (Main.progEnCours.currentPageProgram.getNbVoie() == 2) {
                    this.setStimAmplitudeB(0.0);
                }
                this.pause = true;
                this.stopStim();
                this.menuBasController.getLabelPause().getStyleClass().setAll((Object[])new String[]{"buttonNav", "restartButton"});
            } else {
                this.pause = false;
                Main.progEnCours.commentaire = this.commentaire.getText();
                Main.progEnCours.gotoSamePage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void precedentAction() {
        try {
            if (Main.progEnCours.getProgDureeRestante() > 0 && (Main.progEnCours.getPageDureeRestante() == null || Main.progEnCours.getPageDureeRestante() > 0)) {
                Utils.debugInfo("sortie de page par appui sur precedent");
            }
            this.stopStim();
            Main.progEnCours.gotoLastPage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void suivantAction() {
        try {
            if (Main.progEnCours.getProgDureeRestante() > 0 && (Main.progEnCours.getPageDureeRestante() == null || Main.progEnCours.getPageDureeRestante() > 0)) {
                Utils.debugInfo("sortie de page par appui sur suivant");
            }
            this.stopStim();
            Main.progEnCours.gotoNextPage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void aPlusAction() {
        this.targetElement = "s1+";
        this.methodeHoldMouse();
    }

    @Override
    public void aMoinsAction() {
        this.targetElement = "s1-";
        this.methodeHoldMouse();
    }

    @Override
    public void bPlusAction() {
        this.targetElement = "s2+";
        this.methodeHoldMouse();
    }

    @Override
    public void bMoinsAction() {
        this.targetElement = "s2-";
        this.methodeHoldMouse();
    }

    @Override
    public void a50() {
        this.setStimAmplitudeA(50.0);
    }

    @Override
    public void a2() {
        this.setStimAmplitudeA(2.0);
    }

    @Override
    public void b50() {
        this.setStimAmplitudeB(50.0);
    }

    @Override
    public void b2() {
        this.setStimAmplitudeB(2.0);
    }
}

