/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.zdata;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Maths;
import com.mazet.biostim.utils.Skin;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.zdata.Csv;
import com.mazet.biostim.zdata.ProfilConcatSimple;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Profil {
    private String name;
    public ArrayList<Double> temps = new ArrayList();
    public ArrayList<Double> val = new ArrayList();
    private static ArrayList<Profil> listStaticProfils;

    public Profil(Csv csv, int row) {
        this.name = csv.get(row, 0);
        int col = 2;
        while (!csv.get(row, col).isEmpty() && !csv.get(row + 1, col).isEmpty()) {
            this.temps.add(csv.getDouble(row, col));
            this.val.add((double)csv.getInt(row + 1, col) / 100.0);
            ++col;
        }
        if (!csv.get(row, col).isEmpty() || !csv.get(row + 1, col).isEmpty()) {
            Utils.debugLine("profil incoh\u00e9rent : temps et val de longueurs diff\u00e9rentes (ligne %d)", row);
        }
    }

    public Profil(Profil temp, double dureeRepos) {
        this.name = temp.name;
        double delta = 0.0;
        if (Main.getConfig().reposAvantTravail && dureeRepos > 0.0) {
            delta = dureeRepos;
            this.addPoint(0.0, temp.val.get(0));
        }
        for (int i = 0; i < temp.size(); ++i) {
            this.addPoint(temp.temps.get(i) + delta, temp.val.get(i));
        }
        if (!Main.getConfig().reposAvantTravail && dureeRepos > 0.0) {
            int pos = temp.size() - 1;
            this.addPoint(temp.temps.get(pos) + dureeRepos, temp.val.get(pos));
        }
    }

    public Profil(ArrayList<Double> dessineT, ArrayList<Double> dessineY, double dureeTravail, double dureeRepos, double init) {
        double delta = 0.0;
        if (Main.getConfig().reposAvantTravail) {
            delta = dureeRepos;
            this.addPoint(0.0, init);
        }
        this.addPoint(delta, init);
        for (int i = 0; i < dessineT.size(); ++i) {
            double t = dessineT.get(i) * dureeTravail;
            double y = dessineY.get(i);
            this.addPoint(t + delta, y);
        }
        if (!Main.getConfig().reposAvantTravail) {
            this.addPoint(dureeTravail, init);
        }
        this.addPoint(dureeTravail + dureeRepos, init);
    }

    public Profil(double nivHaut, double montee, double travail, double repos) {
        if (Main.getConfig().reposAvantTravail) {
            if (montee + repos > 0.0) {
                this.addPoint(0.0, 0.0);
            }
            if (montee + repos > 0.0) {
                this.addPoint(repos, 0.0);
            }
            if (montee + travail > 0.0) {
                this.addPoint(repos + montee, nivHaut);
            }
            if (montee + travail > 0.0) {
                this.addPoint(repos + montee + travail, nivHaut);
            }
            if (montee + repos > 0.0) {
                this.addPoint(repos + 2.0 * montee + travail, 0.0);
            }
        } else {
            if (montee + repos > 0.0) {
                this.addPoint(0.0, 0.0);
            }
            if (montee + travail > 0.0) {
                this.addPoint(montee, nivHaut);
            }
            if (montee + travail > 0.0) {
                this.addPoint(montee + travail, nivHaut);
            }
            if (montee + repos > 0.0) {
                this.addPoint(2.0 * montee + travail, 0.0);
            }
            if (montee + repos > 0.0) {
                this.addPoint(2.0 * montee + travail + repos, 0.0);
            }
        }
    }

    public Profil() {
    }

    void addPoint(Double t, double y) {
        this.temps.add(t);
        this.val.add(y);
    }

    static void addTempProfil(Profil profil) {
        listStaticProfils.add(profil);
    }

    static boolean existTempProfil(String name) {
        for (Profil temp : Profil.getStaticProfils()) {
            if (!temp.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    static double getProfilDureeByName(String name) {
        for (Profil temp : Profil.getStaticProfils()) {
            if (!temp.name.equalsIgnoreCase(name)) continue;
            return temp.temps.get(temp.temps.size() - 1);
        }
        Utils.debugInfo("Profil inconnu : " + name);
        Thread.dumpStack();
        return -1.0;
    }

    static Profil getProfilByName(String name, double dureeRepos) {
        for (Profil temp : Profil.getStaticProfils()) {
            if (!temp.name.equalsIgnoreCase(name)) continue;
            return new Profil(temp, dureeRepos);
        }
        Utils.debugInfo("Profil inconnu : " + name);
        Thread.dumpStack();
        return new Profil(Profil.getStaticProfils().get(0), dureeRepos);
    }

    private static ArrayList<Profil> getStaticProfils() {
        if (listStaticProfils == null) {
            listStaticProfils = new ArrayList();
            Csv csv = new Csv("res/profils.csv");
            for (int row = 0; row < csv.nbRows() - 1; row += 2) {
                listStaticProfils.add(new Profil(csv, row));
            }
        }
        return listStaticProfils;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getDuree() {
        if (this.temps.isEmpty()) {
            return 0.0;
        }
        return this.temps.get(this.temps.size() - 1);
    }

    public Profil getProfilUnitaire(double now) {
        return this;
    }

    public int typeProfil() {
        if ("Vide".equals(this.name)) {
            return 0;
        }
        double x = this.val.get(0);
        for (int i = 1; i < this.val.size(); ++i) {
            if (this.val.get(i) == x) continue;
            return 2;
        }
        return 1;
    }

    void savePNG(File name) {
        try {
            Color fond = Skin.getCouleurFondPng();
            int width = 100;
            int height = 50;
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics2D graph = bi.createGraphics();
            graph.setColor(fond);
            graph.fillRect(0, 0, width, height);
            graph.setPaint(Color.BLACK);
            double total = this.getDuree();
            for (int i = 1; i < this.temps.size(); ++i) {
                int x1 = (int)((double)width * this.temps.get(i - 1) / total);
                int y1 = (int)((double)height * (0.9 - 0.8 * this.val.get(i - 1)));
                int x2 = (int)((double)width * this.temps.get(i) / total);
                int y2 = (int)((double)height * (0.9 - 0.8 * this.val.get(i)));
                graph.drawLine(x1, y1, x2, y2);
            }
            ImageIO.write((RenderedImage)bi, "png", name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double getVal(double t) {
        double v2;
        t %= this.temps.get(this.temps.size() - 1).doubleValue();
        int i = 1;
        while (t > this.temps.get(i)) {
            ++i;
        }
        double v1 = this.val.get(i - 1);
        if (v1 == (v2 = this.val.get(i).doubleValue())) {
            return 100.0 * v1;
        }
        double t1 = this.temps.get(i - 1);
        double t2 = this.temps.get(i);
        return 100.0 * Maths.interpolation(t1, t2, v1, v2, t);
    }

    public int size() {
        return this.temps.size();
    }

    public double getMax() {
        double res = 0.0;
        for (double d : this.val) {
            if (!(d > res)) continue;
            res = d;
        }
        return res;
    }

    public boolean hasStim() {
        return false;
    }

    public ProfilConcatSimple.Motif getStimMotif(int i) {
        return null;
    }

    public boolean isStim(double t) {
        return false;
    }

    public ProfilConcatSimple.Motif getStimMotif(double t) {
        return null;
    }

    public ProfilConcatSimple.Motif getStimMotifNext(double t) {
        return null;
    }

    public double dateFinStim(double t) {
        return 0.0;
    }
}

