/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.actions.AbstractStatisticsEvent;
import com.itextpdf.text.pdf.statistics.NumberOfPagesStatisticsEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberOfPagesStatisticsAggregator
extends AbstractStatisticsAggregator {
    private static final int ONE = 1;
    private static final int TEN = 10;
    private static final int HUNDRED = 100;
    private static final int THOUSAND = 1000;
    private static final String STRING_FOR_ONE_PAGE = "1";
    private static final String STRING_FOR_TEN_PAGES = "2-10";
    private static final String STRING_FOR_HUNDRED_PAGES = "11-100";
    private static final String STRING_FOR_THOUSAND_PAGES = "101-1000";
    private static final String STRING_FOR_INF = "1001+";
    private static final Map<Integer, String> NUMBERS_OF_PAGES;
    private static final List<Integer> SORTED_UPPER_BOUNDS_OF_PAGES;
    private final Object lock = new Object();
    private final Map<String, Long> numberOfDocuments = new LinkedHashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(AbstractStatisticsEvent event) {
        if (!(event instanceof NumberOfPagesStatisticsEvent)) {
            return;
        }
        int numberOfPages = ((NumberOfPagesStatisticsEvent)event).getNumberOfPages();
        String range = STRING_FOR_INF;
        Object object = SORTED_UPPER_BOUNDS_OF_PAGES.iterator();
        while (object.hasNext()) {
            int upperBound = object.next();
            if (numberOfPages > upperBound) continue;
            range = NUMBERS_OF_PAGES.get(upperBound);
            break;
        }
        object = this.lock;
        synchronized (object) {
            Long documentsOfThisRange = this.numberOfDocuments.get(range);
            Long currentValue = documentsOfThisRange == null ? 1L : documentsOfThisRange + 1L;
            this.numberOfDocuments.put(range, currentValue);
        }
    }

    public Object retrieveAggregation() {
        return Collections.unmodifiableMap(this.numberOfDocuments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(AbstractStatisticsAggregator aggregator) {
        if (!(aggregator instanceof NumberOfPagesStatisticsAggregator)) {
            return;
        }
        Map<String, Long> numberOfDocuments = ((NumberOfPagesStatisticsAggregator)aggregator).numberOfDocuments;
        Object object = this.lock;
        synchronized (object) {
            NumberOfPagesStatisticsAggregator.merge(this.numberOfDocuments, numberOfDocuments);
        }
    }

    private static void merge(Map<String, Long> destination, Map<String, Long> source) {
        if (destination == source) {
            return;
        }
        for (Map.Entry<String, Long> entry : source.entrySet()) {
            Long value = destination.get(entry.getKey());
            if (value == null) {
                destination.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() == null) {
                destination.put(entry.getKey(), value);
                continue;
            }
            destination.put(entry.getKey(), value + entry.getValue());
        }
    }

    static {
        SORTED_UPPER_BOUNDS_OF_PAGES = Arrays.asList(1, 10, 100, 1000);
        HashMap<Integer, String> temp = new HashMap<Integer, String>();
        temp.put(1, STRING_FOR_ONE_PAGE);
        temp.put(10, STRING_FOR_TEN_PAGES);
        temp.put(100, STRING_FOR_HUNDRED_PAGES);
        temp.put(1000, STRING_FOR_THOUSAND_PAGES);
        NUMBERS_OF_PAGES = Collections.unmodifiableMap(temp);
    }
}

