/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utilsfx;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Skin;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimationSkin;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public abstract class FxUtils {
    private static String cacheImageName = null;
    private static Image cacheImage = null;
    public static final ArrayList<Color> colors = new ArrayList<Color>(Arrays.asList(null, Color.web((String)"#F3CD59"), Color.web((String)"#76F359"), Color.web((String)"#59A5F3"), Color.ORCHID, null));

    public static void setCssPopup(Parent parent) {
        parent.getStylesheets().clear();
        URL skin = Skin.getCssPopup();
        if (skin != null) {
            parent.getStylesheets().add((Object)skin.toExternalForm());
        }
        parent.setStyle(String.format("-fx-font-size: %d", (int)(Font.getDefault().getSize() * (0.55 + (double)Main.getConfig().tailleChar * 0.15))));
    }

    public static void adjustLabelWidth(Label labelTemps, String biggest, double scale) {
        labelTemps.applyCss();
        Text text = new Text(biggest);
        text.setFont(labelTemps.getFont());
        double tempsWidth = text.getLayoutBounds().getWidth() * scale;
        labelTemps.setMinWidth(tempsWidth);
    }

    public static void adjustLabelAndBackgroundWidth(Label labelTemps, String biggest) {
        labelTemps.applyCss();
        Text text = new Text(biggest);
        text.setFont(labelTemps.getFont());
        double tempsWidth = text.getLayoutBounds().getWidth() * 1.2;
        labelTemps.setMinWidth(tempsWidth + 40.0);
        Platform.runLater(() -> {
            String style = String.format("-fx-background-size: %.0fpx %.0fpx;", tempsWidth, labelTemps.getHeight());
            labelTemps.setStyle(style);
        });
    }

    public static void adjustLabelTimeAndBackgroundWidth(Label labelTemps) {
        FxUtils.adjustLabelAndBackgroundWidth(labelTemps, "00:00");
    }

    public static void adjustHboxReglageStyle(HBox hBox, String biggest, double space, Region option) {
        Label label = hBox.getChildren().stream().filter(n -> n instanceof Label).findFirst().orElse(null);
        hBox.getStyleClass().add((Object)"hboxPlusMoins");
        hBox.setPrefWidth(-1.0);
        hBox.setMaxWidth(Double.NEGATIVE_INFINITY);
        if (label != null) {
            label.applyCss();
            Text text = new Text(biggest == null ? label.getText() : biggest);
            text.setFont(label.getFont());
            double size = text.getLayoutBounds().getHeight();
            for (Node n2 : hBox.getChildren()) {
                if (!(n2 instanceof Button)) continue;
                FxUtils.adjustRegion((Region)((Button)n2), size);
            }
            if (option != null) {
                FxUtils.adjustRegion(option, size + 10.0);
            }
            label.setAlignment(Pos.CENTER);
            double tempsWidth = text.getLayoutBounds().getWidth() * space;
            label.setMinWidth(tempsWidth);
        }
    }

    public static void adjustHboxReglageStyle(HBox hBox) {
        FxUtils.adjustHboxReglageStyle(hBox, "00:00", 1.2, null);
    }

    public static void adjustHboxReglageStyle(HBox hBox, Region option) {
        FxUtils.adjustHboxReglageStyle(hBox, "00:00", 1.2, option);
    }

    private static void adjustRegion(Region region, double size) {
        region.setMinHeight(size);
        region.setPrefHeight(size);
        if (region instanceof Button) {
            Button b = (Button)region;
            b.setMinWidth(size);
            b.setPrefWidth(size);
            b.setStyle(String.format("-fx-background-size: %.0fpx;", size));
        }
    }

    public static Rectangle creationObjet(Pane container, ImagePattern obj, double size) {
        double sizex = obj.getImage().getWidth();
        double sizey = obj.getImage().getHeight();
        double prop = size / Math.max(sizex, sizey);
        Rectangle rect = new Rectangle(0.0, 0.0, sizex * prop, sizey * prop);
        rect.setFill((Paint)obj);
        container.getChildren().add((Object)rect);
        return rect;
    }

    public static void resizeObj(Rectangle r, double size, double posx) {
        double sizex = r.getWidth();
        double sizey = r.getHeight();
        double prop = size / Math.max(sizex, sizey);
        r.setHeight(sizey *= prop);
        r.setWidth(sizex *= prop);
        r.setX(posx - sizex / 2.0);
    }

    public static double getCursorWidth(Shape curseur, int voie, BiofeedbackAnimationSkin animation) {
        if (curseur instanceof Rectangle) {
            return ((Rectangle)curseur).getWidth();
        }
        double size = animation.getSizeObj() * 1.2;
        return voie == 1 ? size * 1.5 : size;
    }

    public static double getCursorHeight(Shape curseur, int voie, BiofeedbackAnimationSkin animation) {
        if (curseur instanceof Rectangle) {
            return ((Rectangle)curseur).getHeight();
        }
        double size = animation.getSizeObj() * 1.2;
        return voie == 1 ? size * 1.5 : size;
    }

    public static String center(String text, int len) {
        if (len <= text.length()) {
            return text.substring(0, len);
        }
        int before = (len - text.length()) / 2;
        if (before == 0) {
            return String.format("%-" + len + "s", text);
        }
        int rest = len - before;
        return String.format("%" + before + "s%-" + rest + "s", "", text);
    }

    public static void setVisibility(Node node, boolean isVisible) {
        node.setVisible(isVisible);
        node.setManaged(isVisible);
    }

    public static void setAnchorMargin(Node temp) {
        AnchorPane.setTopAnchor((Node)temp, (Double)0.0);
        AnchorPane.setRightAnchor((Node)temp, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)temp, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)temp, (Double)0.0);
    }

    public static void setAnchorMargin(Node temp, double top, double right, double bottom, double left) {
        AnchorPane.setTopAnchor((Node)temp, (Double)top);
        AnchorPane.setRightAnchor((Node)temp, (Double)right);
        AnchorPane.setBottomAnchor((Node)temp, (Double)bottom);
        AnchorPane.setLeftAnchor((Node)temp, (Double)left);
    }

    public static void setBackGround(Region region, String url, double width, boolean contain) {
        File file = new File(Computer.absolutePath + "appData/profils/" + url);
        Image imLogo = new Image(file.toURI().toASCIIString());
        BackgroundImage bgLogo = new BackgroundImage(imLogo, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, new BackgroundSize(width, -1.0, false, false, contain, false));
        region.setBackground(new Background(new BackgroundImage[]{bgLogo}));
    }

    public static Image getResourceImage(String src) {
        return new Image(Objects.requireNonNull(Main.class.getResourceAsStream(src)));
    }

    private static Image getImage(String url) {
        if (!url.equals(cacheImageName)) {
            cacheImageName = url;
            try {
                cacheImage = FxUtils.getResourceImage("/img/" + url);
            }
            catch (Exception ignored) {
                Utils.debugInfo("setBackGroundInJar : impossible de trouver l'img " + url);
                cacheImage = FxUtils.getResourceImage("/img/logo.png");
            }
        }
        return cacheImage;
    }

    public static void setBackGroundInJar(Region region, String url, double width, boolean contain) {
        Image imLogo = FxUtils.getImage(url);
        BackgroundImage bgLogo = new BackgroundImage(imLogo, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, new BackgroundSize(width, -1.0, false, false, contain, false));
        region.setBackground(new Background(new BackgroundImage[]{bgLogo}));
    }

    public static void setBackGroundIntoInJar(Region region, String url) {
        Image imLogo = FxUtils.getImage(url);
        BackgroundImage bgLogo = new BackgroundImage(imLogo, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, new BackgroundSize(100.0, 100.0, true, true, true, false));
        region.setBackground(new Background(new BackgroundImage[]{bgLogo}));
    }

    public static Background getBackGroundQuadrille(boolean doubleVoie, int type, int hauteur, double pixCursor, double largeurExacte) {
        BackgroundCache temp = new BackgroundCache(doubleVoie, type, hauteur, pixCursor, largeurExacte);
        for (BackgroundCache bgc : BackgroundCache.liste) {
            if (!temp.equals(bgc)) continue;
            return bgc.background;
        }
        temp.createBackground();
        if (BackgroundCache.liste.size() > 5) {
            BackgroundCache.liste.removeFirst();
        }
        BackgroundCache.liste.add(temp);
        return temp.background;
    }

    public static void addLabelTemps(Pane animRoot, double dureeAffichage, double pixOf0, double nbPixPerSecond, double hauteur) {
        int dateEtiquette = 0;
        ArrayList<Label> labels = new ArrayList<Label>();
        while ((double)dateEtiquette <= dureeAffichage) {
            Label label = new Label(Utils.stringOfTime(dateEtiquette));
            label.setLayoutY(-100.0);
            label.setUserData((Object)dateEtiquette);
            label.getStyleClass().add((Object)"timing");
            animRoot.getChildren().add((Object)label);
            labels.add(label);
            dateEtiquette += 5;
        }
        ((Label)labels.getLast()).heightProperty().addListener(observable -> {
            for (Label label : labels) {
                BiofeedbackAnimation.postPositionneEvent(label, pixOf0 + (double)((Integer)label.getUserData()).intValue() * nbPixPerSecond, hauteur);
            }
        });
    }

    public static void lanceDecompte(Controller rc, AnchorPane gameAnchor) {
        Text decompte = new Text();
        FxUtils.setAnchorMargin((Node)decompte);
        decompte.getStyleClass().add((Object)"decompte");
        StackPane sp = new StackPane(new Node[]{decompte});
        FxUtils.setAnchorMargin((Node)sp);
        gameAnchor.getChildren().add((Object)sp);
        FxUtils.updateDecompte(rc, gameAnchor, sp, decompte, 3);
    }

    private static void updateDecompte(final Controller rc, final AnchorPane gameAnchor, final StackPane sp, final Text decompte, final int reste) {
        if (reste == 0) {
            gameAnchor.getChildren().remove((Object)sp);
            rc.started = true;
        } else {
            decompte.setText("" + reste);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater(() -> FxUtils.updateDecompte(rc, gameAnchor, sp, decompte, reste - 1));
                }
            }, 1000L);
        }
    }

    private static class BackgroundCache {
        private static final ArrayList<BackgroundCache> liste = new ArrayList();
        boolean doubleVoie;
        int type;
        int hauteur;
        double pixCursor;
        double largeurExacte;
        boolean traitParSeconde;
        Background background;

        public BackgroundCache(boolean doubleVoie, int type, int hauteur, double pixCursor, double largeurExacte) {
            this.doubleVoie = doubleVoie;
            this.type = type;
            this.hauteur = hauteur;
            this.pixCursor = pixCursor;
            this.largeurExacte = largeurExacte;
            this.traitParSeconde = Main.getConfig().traitParSeconde;
        }

        private boolean equals(BackgroundCache bgc) {
            return this.doubleVoie == bgc.doubleVoie && this.type == bgc.type && this.hauteur == bgc.hauteur && this.pixCursor == bgc.pixCursor && this.largeurExacte == bgc.largeurExacte && this.traitParSeconde == bgc.traitParSeconde;
        }

        void createBackground() {
            int largeur = (int)this.largeurExacte;
            int decal = (int)(this.pixCursor % this.largeurExacte);
            if (decal == 0) {
                decal = 1;
            }
            if (decal > largeur - 2) {
                decal = largeur - 2;
            }
            WritableImage img = new WritableImage(largeur, this.hauteur);
            PixelWriter pixelWriter = img.getPixelWriter();
            int min = (int)((double)this.hauteur * 0.04);
            int max = (int)((double)this.hauteur * 0.96);
            Color fond = this.type == 2 ? Color.BLACK : Color.WHITE;
            Color trait = this.type == 2 ? Color.GRAY : Color.LIGHTGRAY;
            for (int y = 0; y < this.hauteur; ++y) {
                for (int x = 0; x < largeur; ++x) {
                    pixelWriter.setColor(x, y, fond);
                }
                Color c = y < min || y > max ? fond : trait;
                pixelWriter.setColor(decal, y, c);
                pixelWriter.setColor(decal - 1, y, c);
                if (!this.traitParSeconde) continue;
                pixelWriter.setColor(decal + 1, y, c);
                for (int i = 1; i <= 4; ++i) {
                    int pos = (int)(((double)decal + (double)i * this.largeurExacte / 5.0) % (double)largeur);
                    pixelWriter.setColor(pos, y, c);
                }
            }
            if (this.doubleVoie) {
                epaisseur = Math.max(2, (int)((double)this.hauteur / 400.0));
                for (int i = 0; i <= 5; ++i) {
                    Color c = trait;
                    if (this.type == 1 && colors.get(i) != null) {
                        c = colors.get(i);
                    }
                    int y1 = min + (max - min) * i / 11;
                    int y2 = min + (max - min) * (i + 6) / 11;
                    for (int x = 0; x < largeur; ++x) {
                        for (int dy = 0; dy <= epaisseur; ++dy) {
                            pixelWriter.setColor(x, y1 + dy - epaisseur / 2, c);
                            pixelWriter.setColor(x, y2 + dy - epaisseur / 2, c);
                        }
                    }
                }
            } else {
                epaisseur = Math.max(3, (int)((double)this.hauteur / 200.0));
                for (int i = 0; i <= 10; ++i) {
                    int y = min + (max - min) * i / 10;
                    for (int x = 0; x < largeur; ++x) {
                        pixelWriter.setColor(x, y, trait);
                        pixelWriter.setColor(x, y + 1, trait);
                        if (i != 0 && i != 10 && (this.type != 1 || i % 2 != 0)) continue;
                        Color c = colors.get(i / 2);
                        if (c == null) {
                            c = trait;
                        }
                        for (int dy = 0; dy <= epaisseur; ++dy) {
                            pixelWriter.setColor(x, y + dy - epaisseur / 2, c);
                        }
                    }
                }
            }
            BackgroundSize bgSize = new BackgroundSize(this.largeurExacte, (double)this.hauteur, false, false, false, false);
            this.background = new Background(new BackgroundImage[]{new BackgroundImage((Image)img, BackgroundRepeat.REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, bgSize)});
        }
    }
}

