/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.configuration;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.configuration.Autotest;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.application.Platform;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.net.ssl.HttpsURLConnection;

public abstract class Update {
    public static Autotest autotest = null;
    public static int telechargement = -1;
    public static int lengthDownload = 0;
    private static int telechargementEnCours = 0;

    static void download() {
        boolean newStart;
        boolean bl = newStart = telechargementEnCours != 1;
        if (newStart) {
            telechargement = 0;
            telechargementEnCours = 1;
            Update.autotest.buttonDownload.setDisable(true);
            Update.autotest.buttonDownload.setMinWidth(Update.autotest.buttonDownload.getWidth());
            new Thread(() -> {
                try {
                    String url = Autotest.jsonVersion.getString("url");
                    String filename = url.substring(url.lastIndexOf(47) + 1);
                    Utils.debugInfo("telechargement de " + filename);
                    Update.saveHttp(url, filename);
                    Utils.debugInfo("fin de telechargement");
                    telechargementEnCours = 2;
                }
                catch (Exception e) {
                    telechargementEnCours = 0;
                    Utils.debugLine("telechargement ko : %s", e);
                }
            }).start();
        }
        new Thread(() -> {
            while (telechargementEnCours == 1 && Main.currentController == autotest) {
                Update.autotest.statusDownload.setFill((Paint)Color.ORANGE);
                Utils.sleep(500L);
                String total = lengthDownload > 0 ? String.format(" / %,d ko", lengthDownload / 1024) : "";
                Platform.runLater(() -> Update.autotest.labelDownload.setText(String.format("%,d ko%s", telechargement / 1024, total)));
            }
            if (telechargementEnCours == 2) {
                Update.autotest.statusDownload.setFill((Paint)Color.GREEN);
                Update.install();
            } else {
                Update.autotest.statusDownload.setFill((Paint)Color.RED);
            }
        }).start();
    }

    public static void saveHttp(String url, String file) throws Exception {
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.setRequestProperty("Accept-Encoding", "identity");
        lengthDownload = con.getContentLength();
        try (InputStream is = con.getInputStream();
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(Computer.newBiostimFile(file)), 262144);){
            int len;
            byte[] buf = new byte[262144];
            while ((len = is.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, len);
                telechargement += len;
            }
        }
    }

    private static void install() {
        Platform.runLater(() -> Update.autotest.labelDownload.setText("Install starting"));
        new Thread(() -> {
            try {
                String url = Autotest.jsonVersion.getString("url");
                String filename = url.substring(url.lastIndexOf(47) + 1);
                Utils.debugInfo("installation de " + filename);
                ZipInputStream zis = new ZipInputStream(Files.newInputStream(Computer.newBiostimFile(filename).toPath(), new OpenOption[0]), Charset.forName("CP850"));
                while (zis.getNextEntry() != null) {
                }
                zis.closeEntry();
                zis.close();
                Utils.debugInfo("Fichier zip conforme");
                Update.unzip(filename);
                if (Computer.isMac()) {
                    new ProcessBuilder("/bin/bash", Computer.absolutePath + "update.sh").start();
                } else {
                    Utils.debugInfo("decompression OK, lancement de l'installation");
                    String rep = Computer.absolutePath + filename.substring(0, filename.lastIndexOf(".")) + "/";
                    new ProcessBuilder("cmd", "/c", "start", "\"Biostim Install\" cmd /c \"timeout /t 2 /nobreak >nul && installation.cmd\"").directory(new File(rep)).start();
                    System.exit(0);
                }
                Utils.debugInfo("decompression OK");
                System.exit(0);
            }
            catch (Exception e) {
                Platform.runLater(() -> {
                    Update.autotest.statusDownload.setFill((Paint)Color.RED);
                    Update.autotest.labelDownload.setText(TransientConfig.translate("Erreur"));
                });
                e.printStackTrace();
            }
        }).start();
    }

    private static void unzip(String zipFile) throws Exception {
        byte[] buffer = new byte[16384];
        ZipInputStream zis = new ZipInputStream(Files.newInputStream(Computer.newBiostimFile(zipFile).toPath(), new OpenOption[0]), Charset.forName("CP850"));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int pos = ze.getName().indexOf("BiostimData");
            if (!(ze.isDirectory() || Computer.isMac() && pos == -1)) {
                int len;
                String dest = Computer.isMac() ? ze.getName().substring(pos + 12) : ze.getName();
                File newFile = Computer.newBiostimFile(dest);
                newFile.getParentFile().mkdirs();
                System.out.println("file unzip : " + String.valueOf(newFile.getAbsoluteFile()));
                Platform.runLater(() -> Update.autotest.labelDownload.setText("unzip : " + String.valueOf(newFile.getAbsoluteFile())));
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }
}

