/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.patient;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.utilsfx.Pdf;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.main.MenuController;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.zdata.Patient;
import com.mazet.biostim.zdata.Profil;
import com.mazet.biostim.zdata.Programme;
import com.mazet.biostim.zdata.Seance;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PauseTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Polyline;
import javafx.util.Duration;
import org.json.JSONArray;
import org.json.JSONObject;

public class RevoirController
extends Controller {
    static ArrayList<Seance> listSeances;
    static final ArrayList<String> couleurs;
    @FXML
    private HBox entete;
    @FXML
    private HBox hboxLimMax1;
    @FXML
    private VBox vboxLimMax2;
    @FXML
    private HBox hboxLimMax2;
    @FXML
    private CheckBox checkA;
    @FXML
    private CheckBox checkB;
    @FXML
    private CheckBox checkMvt;
    @FXML
    public Label valLimMax1;
    @FXML
    public Label valLimMax2;
    @FXML
    private ScrollPane scrollPaneRevoir;
    @FXML
    private Label logoMenuBasBiostim;
    @FXML
    private ComboBox<String> choixTypeAff;
    @FXML
    private CheckBox profilBox;
    private Pane animRoot;
    private double nbPixelParSeconde;
    private final double hauteurScroll = 20.0;
    private final double positionCursor = 0.2;
    private Profil profil;
    private static final int epaisseurProfil = 7;
    private double maxDuree = 0.0;
    private final ArrayList<double[]> tabTemps = new ArrayList();
    private final ArrayList<double[]> tabNiveauVoie1 = new ArrayList();
    private final ArrayList<double[]> tabNiveauVoie2 = new ArrayList();
    private final ArrayList<double[]> tabMvt = new ArrayList();
    private final ArrayList<double[]> tabTempsEvt = new ArrayList();
    private final ArrayList<String[]> tabEvents = new ArrayList();
    private boolean hasVoie2 = false;
    private boolean hasMvt = false;
    private final ArrayList<double[]> tabMoyenne1 = new ArrayList();
    private final ArrayList<double[]> tabMoyenne2 = new ArrayList();
    private final ArrayList<double[]> tabMoyenneMvt = new ArrayList();
    private final ArrayList<int[]> tabNbVal = new ArrayList();
    private int max1;
    private int max2;
    private ArrayList<Polyline> courbesVoie1;
    private ArrayList<Polyline> courbesVoie2;
    private ArrayList<Polyline> courbesVoieMvt;
    private ArrayList<ArrayList<Node>> events;
    private final ArrayList<CheckBox> checkBoxes = new ArrayList();
    private final ArrayList<String> checkTexts = new ArrayList();
    private final Polyline marqueurSouris = new Polyline();
    private final Label labelSouris = new Label();
    private final Polyline marqueurStart = new Polyline();
    private Double marqueurStartTime = null;
    private final Polyline startPrint = new Polyline();
    private final Polyline stopPrint = new Polyline();
    private Double tStartPrint;
    private Double tStopPrint;
    private boolean menuOuvert = false;
    private double dureeAffichage;
    private double totalWidthGame;
    private ProgressIndicator waiting;
    private boolean showProfil = false;
    private double currentSuperpTime;
    Polyline lastCourbeVoie1;
    Polyline lastCourbeVoie2;
    Polyline lastCourbeMvt;
    private Timeline holdBouton;
    private int compteurTemp;

    @Override
    public void setMain() {
        super.setMain();
        try {
            Main.mainLayout.setLeft(null);
            FxUtils.setBackGroundInJar((Region)this.logoMenuBasBiostim, MenuController.logoName, 150.0, false);
            Platform.runLater(this::init);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        if (Main.currentController == this && (this.scrollPaneRevoir.getWidth() < 20.0 || this.scrollPaneRevoir.getHeight() < 20.0)) {
            Platform.runLater(this::init);
            return;
        }
        try {
            Programme prevoir;
            FxUtils.adjustHboxReglageStyle(this.hboxLimMax1, "0000", 1.2, null);
            FxUtils.adjustHboxReglageStyle(this.hboxLimMax2, "0000", 1.2, null);
            int nbCompar = listSeances.size();
            double size = (this.scrollPaneRevoir.getWidth() - (double)(nbCompar * 20) - 20.0) / (double)(nbCompar == 4 ? 4 : 3);
            for (int i = 0; i < nbCompar; ++i) {
                CheckBox checkBox = new CheckBox();
                this.checkBoxes.add(checkBox);
                checkBox.setSelected(true);
                checkBox.selectedProperty().addListener((observableValue, bl, bl2) -> this.updateSelection());
                StackPane.setAlignment((Node)checkBox, (Pos)Pos.CENTER_LEFT);
                StackPane anchorPane = new StackPane(new Node[]{checkBox});
                anchorPane.setPrefWidth(size);
                anchorPane.setMaxWidth(size);
                anchorPane.setMinWidth(size);
                this.entete.getChildren().add((Object)anchorPane);
            }
            this.checkB.setSelected(nbCompar == 1);
            this.checkMvt.setSelected(nbCompar == 1);
            if (listSeances.size() == 1) {
                Seance seance = listSeances.getFirst();
                if (seance.deficitContractionPourMille >= 0) {
                    this.showStats(seance);
                }
                if (seance.hasTendance()) {
                    this.afficheTendance();
                }
            }
            if ((prevoir = listSeances.getFirst().getProg()) != null && prevoir.countBFBPages() == 1) {
                this.profil = prevoir.getFirstProfil();
            }
            for (Seance seance : listSeances) {
                this.max1 = Math.max(this.max1, seance.getMaxAff());
                this.max2 = Math.max(this.max2, seance.getMaxAff2());
                this.decodeSeance(seance);
            }
            this.exitMouse();
            FxUtils.setVisibility((Node)this.checkB, this.hasVoie2);
            FxUtils.setVisibility((Node)this.vboxLimMax2, this.hasVoie2);
            FxUtils.setVisibility((Node)this.checkMvt, this.hasMvt);
            this.scrollPaneRevoir.setOnScroll(this::deplaceScroll);
            this.scrollPaneRevoir.hvalueProperty().addListener(observable -> this.deplaceScroll(null));
            this.scrollPaneRevoir.setHbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
            this.scrollPaneRevoir.setOnMouseMoved(this::moveMouse);
            this.scrollPaneRevoir.setOnMouseExited(mouseEvent -> this.exitMouse());
            this.nbPixelParSeconde = this.scrollPaneRevoir.getWidth() * (double)Main.getConfig().getVitesseDefilement() / 200.0;
            this.animRoot = new Pane();
            this.animRoot.setBackground(FxUtils.getBackGroundQuadrille(false, 0, (int)(this.scrollPaneRevoir.getHeight() - 20.0), this.scrollPaneRevoir.getWidth() * 0.2, this.nbPixelParSeconde * 5.0));
            this.scrollPaneRevoir.setContent((Node)this.animRoot);
            this.waiting = new ProgressIndicator();
            this.waiting.getStyleClass().add((Object)"waiting");
            this.waiting.setVisible(false);
            this.choixTypeAff.setVisible(this.profil != null);
            this.choixTypeAff.getItems().addAll((Object[])new String[]{TransientConfig.translate("Complet"), TransientConfig.translate("Moyenne")});
            if (listSeances.size() == 1) {
                this.choixTypeAff.getItems().add((Object)TransientConfig.translate("Superposition"));
            }
            this.choixTypeAff.getSelectionModel().select(0);
            this.choixTypeAff.valueProperty().addListener(observable -> this.drawPane());
            this.profilBox.setVisible(this.profil != null);
            this.showProfil = this.profil != null && this.profil.typeProfil() == 2;
            this.profilBox.setSelected(this.showProfil);
            this.profilBox.selectedProperty().addListener(observable -> {
                this.showProfil = this.profilBox.isSelected();
                this.drawPane();
            });
            this.marqueurStart.getStyleClass().add((Object)"courbeZeroSouris");
            this.startPrint.getStyleClass().add((Object)"courbeSeuil");
            this.stopPrint.getStyleClass().add((Object)"courbeSeuil");
            this.drawPane();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void moveMouse(MouseEvent e) {
        if (!this.menuOuvert) {
            double post = this.setMarqueur(this.marqueurSouris, e);
            this.labelSouris.setText(String.format("%.1f", this.marqueurStartTime == null ? post : post - this.marqueurStartTime));
            this.labelSouris.setLayoutX(this.pixOfTime(post) - this.labelSouris.getHeight() / 2.0);
            this.labelSouris.setLayoutY(this.scrollPaneRevoir.getHeight() - 20.0 - this.labelSouris.getHeight());
            this.labelSouris.setVisible(true);
            for (int i = 0; i < this.checkTexts.size(); ++i) {
                Object text = this.checkTexts.get(i);
                Programme prog = listSeances.get(i).getProg();
                if (this.choixTypeAff.getSelectionModel().isSelected(1)) {
                    int[] nbval = this.tabNbVal.get(i);
                    int posi = (int)(post * (double)nbval.length / this.dureeAffichage - 0.5);
                    text = (String)text + "Val: " + Biostim.nomOfVoie(prog.getVoieBFB1()) + "=" + (int)(this.tabMoyenne1.get(i)[posi] / (double)nbval[posi]);
                    if (this.checkB.isSelected() && this.tabNiveauVoie2.get(i) != null) {
                        text = (String)text + " / " + Biostim.nomOfVoie(prog.getVoieBFB2()) + "=" + (int)(this.tabMoyenne2.get(i)[posi] / (double)nbval[posi]);
                    }
                } else if (this.choixTypeAff.getSelectionModel().isSelected(0)) {
                    text = (String)text + "Val: " + Biostim.nomOfVoie(prog.getVoieBFB1()) + "=" + this.getNiv(post, this.tabTemps.get(i), this.tabNiveauVoie1.get(i));
                    if (this.checkB.isSelected() && this.tabNiveauVoie2.get(i) != null) {
                        text = (String)text + " / " + Biostim.nomOfVoie(prog.getVoieBFB2()) + "=" + this.getNiv(post, this.tabTemps.get(i), this.tabNiveauVoie2.get(i));
                    }
                }
                this.checkBoxes.get(i).setText((String)text);
            }
        }
    }

    private int getNiv(double t, double[] tabt, double[] tabNiv) {
        double res = 0.0;
        for (int i = 0; i < tabNiv.length; ++i) {
            res = tabNiv[i];
            if (!(tabt[i] >= t)) continue;
            return (int)res;
        }
        return (int)res;
    }

    private void exitMouse() {
        if (!this.menuOuvert) {
            this.marqueurSouris.setVisible(false);
            this.labelSouris.setVisible(false);
            for (int i = 0; i < this.checkTexts.size(); ++i) {
                Programme prog = listSeances.get(i).getProg();
                String text = this.checkTexts.get(i) + Biostim.nomOfVoie(prog.getVoieBFB1());
                if (this.tabNiveauVoie2.get(i) != null) {
                    text = text + " / " + Biostim.nomOfVoie(prog.getVoieBFB2());
                }
                this.checkBoxes.get(i).setText(text);
            }
        }
    }

    @FXML
    private void setMarqueurSouris(MouseEvent event) {
        try {
            if (event.getButton() == MouseButton.SECONDARY) {
                ContextMenu contextMenu = new ContextMenu();
                MenuItem item1 = new MenuItem(TransientConfig.translate("debut_impr"));
                item1.setOnAction(actionEvent -> {
                    this.tStartPrint = this.setMarqueur(this.startPrint, event);
                    if (this.tStopPrint != null && this.tStopPrint < this.tStartPrint) {
                        this.tStopPrint = null;
                        this.stopPrint.setVisible(false);
                    }
                });
                MenuItem item2 = new MenuItem(TransientConfig.translate("fin_impr"));
                item2.setOnAction(actionEvent -> {
                    this.tStopPrint = this.setMarqueur(this.stopPrint, event);
                    if (this.tStartPrint != null && this.tStopPrint < this.tStartPrint) {
                        this.tStartPrint = null;
                        this.startPrint.setVisible(false);
                    }
                });
                contextMenu.getItems().addAll((Object[])new MenuItem[]{item1, item2});
                this.menuOuvert = true;
                contextMenu.setOnHiding(windowEvent -> {
                    this.menuOuvert = false;
                });
                contextMenu.show(Main.sceneMain.getWindow(), event.getScreenX(), event.getScreenY());
            } else {
                double post = this.setMarqueur(this.marqueurStart, event);
                if (this.marqueurStartTime != null && post == this.marqueurStartTime) {
                    this.marqueurStartTime = null;
                    this.marqueurStart.setVisible(false);
                } else {
                    this.marqueurStartTime = post;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double setMarqueur(Polyline marqueur, MouseEvent e) {
        marqueur.getPoints().clear();
        double post = this.scrollPaneRevoir.getHvalue() + (e.getX() - 0.2 * this.scrollPaneRevoir.getWidth()) / this.nbPixelParSeconde;
        post = post < 0.0 ? 0.0 : Math.min(post, this.dureeAffichage);
        double posx = this.pixOfTime(post);
        marqueur.getPoints().addAll((Object[])new Double[]{posx, this.pixOfProfil(0.0)});
        marqueur.getPoints().addAll((Object[])new Double[]{posx, this.pixOfProfil(100.0)});
        marqueur.setVisible(true);
        return post;
    }

    private void decodeSeance(Seance seance) {
        try {
            this.decodeJSON(seance, seance.getMax(), seance.getMax2());
            String desc = seance.getDate() + "\n" + seance.getNom() + "\nMax: " + (seance.getMax() - seance.getIntTonus()) + "\n";
            if (seance.getPourcentage() != null && Main.getConfig().typeScore == 1) {
                desc = desc + TransientConfig.translate("Reussite") + ": " + seance.getPourcentage() + "%\n";
            }
            if (seance.getPoints() != null && Main.getConfig().typeScore == 2) {
                desc = desc + TransientConfig.translate("Reussite") + ": " + seance.getPoints() + "\n";
            }
            CheckBox checkBox = this.checkBoxes.get(this.tabTemps.size() - 1);
            checkBox.getStyleClass().add((Object)"labelVoie");
            if (listSeances.size() > 1) {
                checkBox.setStyle("-fx-text-fill:" + couleurs.get(this.tabTemps.size() - 1));
            }
            this.checkTexts.add(desc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void decodeJSON(Seance seance, Integer maxSeanceVoie1, Integer maxSeanceVoie2) {
        try {
            File file = Utils.findFileWhateverEncoded(Main.getConfig().getRepPatients() + "/seances/", seance.getCourbeSauvee());
            String contents = Utils.readFileWithFallbackEncoding(file.toPath());
            JSONObject obj = new JSONObject(contents);
            int tonus1 = seance.getIntTonus();
            int tonus2 = seance.getIntTonus2();
            JSONArray tempsJSON = (JSONArray)obj.get("temps");
            JSONArray voie1JSON = (JSONArray)obj.get("niveauVoie1");
            JSONArray voie2JSON = (JSONArray)obj.get("niveauVoie2");
            int nbTotal = tempsJSON.length();
            double[] temps = new double[nbTotal];
            double[] niveauVoie1 = new double[nbTotal];
            double[] niveauVoie2 = null;
            if (!voie2JSON.isEmpty()) {
                niveauVoie2 = new double[nbTotal];
                this.hasVoie2 = true;
            }
            for (int i = 0; i < nbTotal; ++i) {
                temps[i] = (float)((Integer)tempsJSON.get(i)).intValue() / 100.0f;
                niveauVoie1[i] = (double)((Integer)voie1JSON.get(i) * maxSeanceVoie1) / 1000.0 - (double)tonus1;
                if (niveauVoie2 == null) continue;
                niveauVoie2[i] = (double)((Integer)voie2JSON.get(i) * maxSeanceVoie2) / 1000.0 - (double)tonus2;
            }
            this.tabTemps.add(temps);
            this.tabNiveauVoie1.add(niveauVoie1);
            this.tabNiveauVoie2.add(niveauVoie2);
            if (temps[temps.length - 1] > this.maxDuree) {
                this.maxDuree = temps[temps.length - 1];
            }
            double[] mvt = new double[nbTotal];
            try {
                JSONArray mvtJSON = (JSONArray)obj.get("mvt");
                for (int i = 0; i < nbTotal; ++i) {
                    mvt[i] = ((Integer)mvtJSON.get(i)).intValue();
                }
                this.hasMvt = true;
                this.tabMvt.add(mvt);
            }
            catch (Exception e) {
                this.tabMvt.add(null);
                mvt = null;
            }
            JSONArray tempsEvtJSON = new JSONArray();
            try {
                tempsEvtJSON = (JSONArray)obj.get("tempsEvt");
            }
            catch (Exception i) {
                // empty catch block
            }
            JSONArray eventsJSON = new JSONArray();
            try {
                eventsJSON = (JSONArray)obj.get("events");
            }
            catch (Exception exception) {
                // empty catch block
            }
            int nbEvents = tempsEvtJSON.length();
            double[] tempsEvt = new double[nbEvents];
            String[] events = new String[nbEvents];
            for (int i = 0; i < nbEvents; ++i) {
                tempsEvt[i] = (float)((Integer)tempsEvtJSON.get(i)).intValue() / 100.0f;
                events[i] = (String)eventsJSON.get(i);
            }
            this.tabTempsEvt.add(tempsEvt);
            this.tabEvents.add(events);
            if (this.profil != null) {
                double delta = temps[nbTotal - 1] / (double)nbTotal + 0.03;
                double dureeProf = this.profil.getDuree();
                int nb = (int)(dureeProf / delta);
                double[] moyenne1 = new double[nb];
                double[] moyenne2 = new double[nb];
                double[] moyenneMvt = new double[nb];
                int[] nbVal = new int[nb];
                int lastPos = -1;
                for (int i = 0; i < nbTotal; ++i) {
                    int pos = (int)(temps[i] / dureeProf * (double)nb) % nb;
                    if (pos == lastPos) continue;
                    lastPos = pos;
                    int n = pos;
                    moyenne1[n] = moyenne1[n] + niveauVoie1[i];
                    if (niveauVoie2 != null) {
                        int n2 = pos;
                        moyenne2[n2] = moyenne2[n2] + niveauVoie2[i];
                    }
                    if (mvt != null) {
                        int n3 = pos;
                        moyenneMvt[n3] = moyenneMvt[n3] + mvt[i];
                    }
                    int n4 = pos;
                    nbVal[n4] = nbVal[n4] + 1;
                }
                this.tabMoyenne1.add(moyenne1);
                this.tabMoyenne2.add(moyenne2);
                this.tabMoyenneMvt.add(moyenneMvt);
                this.tabNbVal.add(nbVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawPane() {
        this.valLimMax1.setText(Integer.toString(this.max1));
        this.valLimMax2.setText(Integer.toString(this.max2));
        this.animRoot.getChildren().clear();
        this.animRoot.getChildren().add((Object)this.waiting);
        this.dureeAffichage = this.profil == null || this.choixTypeAff.getSelectionModel().isSelected(0) ? this.maxDuree : this.profil.getDuree();
        this.scrollPaneRevoir.setHvalue(0.0);
        this.scrollPaneRevoir.setHmax(this.dureeAffichage);
        this.totalWidthGame = this.dureeAffichage * this.nbPixelParSeconde + this.scrollPaneRevoir.getWidth();
        this.animRoot.setPrefSize(this.totalWidthGame, this.scrollPaneRevoir.getHeight() - 20.0);
        if (this.profil != null && this.showProfil) {
            double posY;
            double posX;
            Polyline profilLine = new Polyline();
            int profilWidth = (int)(this.scrollPaneRevoir.getHeight() - 20.0) * 7 / 100;
            profilLine.setStrokeWidth((double)profilWidth);
            profilLine.getStyleClass().add((Object)"rubanBleu");
            for (double time = 0.0; time < this.dureeAffichage; time += this.profil.getDuree()) {
                for (int indice = 0; indice <= this.profil.temps.size() - 1 && time + this.profil.temps.get(indice) <= this.dureeAffichage; ++indice) {
                    posX = this.pixOfTime(this.profil.temps.get(indice) + time);
                    posY = this.pixOfProfil(this.profil.val.get(indice) * 93.0 + 3.5);
                    profilLine.getPoints().addAll((Object[])new Double[]{posX, posY});
                }
            }
            posX = this.pixOfTime(this.dureeAffichage);
            posY = this.pixOfProfil(this.profil.getVal(this.dureeAffichage) * 93.0 / 100.0 + 3.5);
            profilLine.getPoints().addAll((Object[])new Double[]{posX, posY});
            this.animRoot.getChildren().add((Object)profilLine);
        }
        this.courbesVoie1 = new ArrayList();
        this.courbesVoie2 = new ArrayList();
        this.courbesVoieMvt = new ArrayList();
        this.events = new ArrayList();
        for (int i = 0; i < this.tabTemps.size(); ++i) {
            this.dessineCourbe(i);
        }
        FxUtils.addLabelTemps(this.animRoot, this.dureeAffichage, this.pixOfTime(0.0), this.nbPixelParSeconde, this.scrollPaneRevoir.getHeight() - 20.0);
        this.marqueurSouris.setVisible(false);
        this.labelSouris.setVisible(false);
        this.marqueurStart.setVisible(false);
        this.marqueurStartTime = null;
        this.animRoot.getChildren().addAll((Object[])new Node[]{this.marqueurSouris, this.labelSouris, this.marqueurStart, this.startPrint, this.stopPrint});
        this.deplaceScroll(null);
        this.updateSelection();
    }

    private void dessineCourbe(int pos) {
        if (this.profil == null || this.choixTypeAff.getSelectionModel().isSelected(0)) {
            this.dessineComplet(pos);
        } else if (this.choixTypeAff.getSelectionModel().isSelected(1)) {
            this.dessineMoyenne(pos);
        } else {
            this.currentSuperpTime = 0.0;
            this.lastCourbeVoie1 = null;
            this.lastCourbeVoie2 = null;
            this.lastCourbeMvt = null;
            this.dessineSuperposition();
        }
    }

    private Polyline createPolyline(int pos, ArrayList<Polyline> courbesVoie, int nb, double epaisseur) {
        Polyline courbe = new Polyline();
        this.animRoot.getChildren().add((Object)courbe);
        courbesVoie.add(courbe);
        courbe.getStyleClass().add((Object)"courbeVoie");
        courbe.setStrokeWidth((double)Main.getConfig().epaisseurVoie * epaisseur);
        courbe.setStyle("-fx-stroke:" + (listSeances.size() > 1 ? couleurs.get(pos) : (nb == 0 ? "black" : (nb == 1 ? Main.getConfig().couleurVoie1 : Main.getConfig().couleurVoie2))));
        if (nb == 0) {
            courbe.getStrokeDashArray().addAll((Object[])new Double[]{20.0, 10.0, 5.0, 10.0});
        }
        return courbe;
    }

    private void dessineComplet(int pos) {
        Polyline courbeVoie1 = this.createPolyline(pos, this.courbesVoie1, 1, 1.0);
        Polyline courbeVoie2 = this.createPolyline(pos, this.courbesVoie2, 2, 0.6);
        Polyline courbeVoieMvt = this.createPolyline(pos, this.courbesVoieMvt, 0, 0.6);
        double[] niveauVoie1 = this.tabNiveauVoie1.get(pos);
        double[] niveauVoie2 = this.tabNiveauVoie2.get(pos);
        double[] mvt = this.tabMvt.get(pos);
        double[] temps = this.tabTemps.get(pos);
        for (int i = 0; i < temps.length; ++i) {
            double posX = this.pixOfTime(temps[i]);
            double posY = this.pixOfNiv1(niveauVoie1[i]);
            courbeVoie1.getPoints().addAll((Object[])new Double[]{posX, posY});
            if (niveauVoie2 != null) {
                posY = this.pixOfNiv2(niveauVoie2[i]);
                courbeVoie2.getPoints().addAll((Object[])new Double[]{posX, posY});
            }
            if (mvt == null) continue;
            posY = this.pixOfMvt(mvt[i]);
            courbeVoieMvt.getPoints().addAll((Object[])new Double[]{posX, posY});
        }
        double[] tempsEvent = this.tabTempsEvt.get(pos);
        String[] events = this.tabEvents.get(pos);
        ArrayList<Object> objs = new ArrayList<Object>();
        this.events.add(objs);
        for (int i = 0; i < tempsEvent.length; ++i) {
            double labelX = this.pixOfTime(tempsEvent[i]);
            double labelY = this.scrollPaneRevoir.getHeight() - 20.0;
            Polyline p = new Polyline(new double[]{labelX, labelY * 0.96, labelX, labelY * 0.04});
            if (listSeances.size() > 1) {
                p.setStyle("-fx-stroke:" + couleurs.get(pos));
            }
            Label event = new Label(events[i]);
            if (listSeances.size() > 1) {
                event.setStyle("-fx-text-fill:" + couleurs.get(pos));
            }
            event.getStyleClass().add((Object)"event");
            this.animRoot.getChildren().addAll((Object[])new Node[]{p, event});
            objs.add(p);
            objs.add(event);
            BiofeedbackAnimation.postPositionneEvent(event, labelX, labelY);
        }
    }

    private void dessineMoyenne(int pos) {
        Polyline courbeVoie1 = this.createPolyline(pos, this.courbesVoie1, 1, 1.0);
        Polyline courbeVoie2 = this.createPolyline(pos, this.courbesVoie2, 2, 0.6);
        Polyline courbeVoieMvt = this.createPolyline(pos, this.courbesVoieMvt, 0, 0.6);
        double[] niveauVoie2 = this.tabNiveauVoie2.get(pos);
        double[] mvt = this.tabMvt.get(pos);
        double[] moyenne1 = this.tabMoyenne1.get(pos);
        double[] moyenne2 = this.tabMoyenne2.get(pos);
        double[] moyenneMvt = this.tabMoyenneMvt.get(pos);
        int[] nbVal = this.tabNbVal.get(pos);
        for (int i = 0; i < moyenne1.length; ++i) {
            if (nbVal[i] <= 0) continue;
            double posX = this.pixOfTime(((double)i + 0.5) * this.dureeAffichage / (double)moyenne1.length);
            double posY = this.pixOfNiv1(moyenne1[i] / (double)nbVal[i]);
            courbeVoie1.getPoints().addAll((Object[])new Double[]{posX, posY});
            if (niveauVoie2 != null) {
                posY = this.pixOfNiv2(moyenne2[i] / (double)nbVal[i]);
                courbeVoie2.getPoints().addAll((Object[])new Double[]{posX, posY});
            }
            if (mvt == null) continue;
            posY = this.pixOfMvt(moyenneMvt[i]);
            courbeVoieMvt.getPoints().addAll((Object[])new Double[]{posX, posY});
        }
    }

    private void dessineSuperposition() {
        if (this.lastCourbeVoie1 != null) {
            this.lastCourbeVoie1.setStrokeWidth((double)Main.getConfig().epaisseurVoie * 0.3);
        }
        if (this.lastCourbeVoie2 != null) {
            this.lastCourbeVoie2.setStrokeWidth((double)Main.getConfig().epaisseurVoie * 0.2);
        }
        if (this.lastCourbeMvt != null) {
            this.lastCourbeMvt.setStrokeWidth((double)Main.getConfig().epaisseurVoie * 0.2);
        }
        Polyline courbeVoie1 = this.lastCourbeVoie1 = this.createPolyline(0, this.courbesVoie1, 1, 1.0);
        Polyline courbeVoie2 = this.lastCourbeVoie2 = this.createPolyline(0, this.courbesVoie2, 2, 0.6);
        Polyline courbeVoieMvt = this.lastCourbeMvt = this.createPolyline(0, this.courbesVoieMvt, 0, 0.6);
        double[] niveauVoie1 = this.tabNiveauVoie1.getFirst();
        double[] niveauVoie2 = this.tabNiveauVoie2.getFirst();
        double[] mvt = this.tabMvt.getFirst();
        double[] temps = this.tabTemps.getFirst();
        for (int i = 0; i < temps.length; ++i) {
            if (temps[i] >= this.currentSuperpTime + this.dureeAffichage) {
                this.currentSuperpTime += this.dureeAffichage;
                PauseTransition pause = new PauseTransition(Duration.millis((double)200.0));
                pause.setOnFinished(e -> this.dessineSuperposition());
                pause.play();
                return;
            }
            if (!(temps[i] >= this.currentSuperpTime)) continue;
            double posX = this.pixOfTime(temps[i] % this.dureeAffichage);
            double posY = this.pixOfNiv1(niveauVoie1[i]);
            courbeVoie1.getPoints().addAll((Object[])new Double[]{posX, posY});
            if (niveauVoie2 != null) {
                posY = this.pixOfNiv2(niveauVoie2[i]);
                courbeVoie2.getPoints().addAll((Object[])new Double[]{posX, posY});
            }
            if (mvt == null) continue;
            posY = this.pixOfMvt(mvt[i]);
            courbeVoieMvt.getPoints().addAll((Object[])new Double[]{posX, posY});
        }
        if (this.lastCourbeVoie1 != null) {
            this.lastCourbeVoie1.setStrokeWidth((double)Main.getConfig().epaisseurVoie * 0.3);
        }
        if (this.lastCourbeVoie2 != null) {
            this.lastCourbeVoie2.setStrokeWidth((double)Main.getConfig().epaisseurVoie * 0.2);
        }
        if (this.lastCourbeMvt != null) {
            this.lastCourbeMvt.setStrokeWidth((double)Main.getConfig().epaisseurVoie * 0.2);
        }
        this.deplaceScroll(null);
    }

    @FXML
    private void printHistory() {
        Patient patient = Main.getCurrentPatient();
        String titre = patient.getNameAndId();
        int deltaDeb = this.tStartPrint != null ? (int)this.pixOfTime(this.tStartPrint) + 2 : (int)(0.2 * this.scrollPaneRevoir.getWidth()) - 10;
        int deltaFin = this.tStopPrint != null ? (int)(this.animRoot.getWidth() - this.pixOfTime(this.tStopPrint)) + 2 : (int)(0.8 * this.scrollPaneRevoir.getWidth()) - 10;
        this.waiting.setLayoutX(this.scrollPaneRevoir.getHvalue() / this.dureeAffichage * (this.totalWidthGame - this.scrollPaneRevoir.getWidth()) + this.scrollPaneRevoir.getWidth() / 2.0 - 200.0);
        this.waiting.toFront();
        Pdf.createHistPDF(this.animRoot, !this.choixTypeAff.getSelectionModel().isSelected(0), this.waiting, deltaDeb, deltaFin, titre, null, (Region)this.entete, this.max1, this.checkB.isSelected() ? this.max2 : 0);
    }

    private void deplaceScroll(ScrollEvent e) {
        double posScroll = this.scrollPaneRevoir.getHvalue();
        if (e != null) {
            posScroll -= e.getDeltaY() / 20.0;
        }
        if (posScroll < 0.0) {
            posScroll = 0.0;
        }
        if (posScroll > this.dureeAffichage) {
            posScroll = this.dureeAffichage;
        }
        this.scrollPaneRevoir.setHvalue(posScroll);
        this.marqueurSouris.setVisible(false);
    }

    @FXML
    private void clicStop() {
        Main.changeCenterView("patient", "bilan", Main.menu.patientButton);
    }

    @FXML
    private void updateSelection() {
        boolean voieA = this.checkA.isSelected();
        boolean voieB = this.checkB.isSelected();
        boolean voieMvt = this.checkMvt.isSelected();
        for (int i = 0; i < this.courbesVoie1.size(); ++i) {
            boolean courbei = listSeances.size() == 1 || this.checkBoxes.get(i).isSelected();
            this.courbesVoie1.get(i).setVisible(voieA && courbei);
            this.courbesVoie2.get(i).setVisible(voieB && courbei);
            this.courbesVoieMvt.get(i).setVisible(voieMvt && courbei);
            if (this.events.size() <= i) continue;
            for (Node n : this.events.get(i)) {
                n.setVisible(courbei);
            }
        }
    }

    @FXML
    private void updateProfil() {
    }

    @FXML
    private void mouseReleased() {
        if (this.holdBouton != null) {
            this.holdBouton.stop();
            this.holdBouton = null;
        }
    }

    @FXML
    private void mousePressed(MouseEvent event) {
        Button targetObject = (Button)event.getSource();
        String action = (String)targetObject.getUserData();
        this.compteurTemp = 0;
        if (this.holdBouton != null) {
            this.holdBouton.stop();
        }
        this.holdBouton = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)40.0), actionEvent -> {
            if (this.compteurTemp >= 8) {
                this.methodeHoldMouse(action);
            }
            ++this.compteurTemp;
        }, new KeyValue[0])});
        this.holdBouton.setCycleCount(-1);
        this.holdBouton.playFromStart();
        this.methodeHoldMouse(action);
    }

    private synchronized void methodeHoldMouse(String action) {
        try {
            switch (action) {
                case "-1": {
                    this.max1 -= Utils.getIntDelta(this.max1);
                    if (this.max1 >= 1) break;
                    this.max1 = 1;
                    break;
                }
                case "+1": {
                    this.max1 += Utils.getIntDelta(this.max1);
                    if (this.max1 <= 4000) break;
                    this.max1 = 4000;
                    break;
                }
                case "-2": {
                    this.max2 -= Utils.getIntDelta(this.max2);
                    if (this.max2 >= 1) break;
                    this.max2 = 1;
                    break;
                }
                case "+2": {
                    this.max2 += Utils.getIntDelta(this.max2);
                    if (this.max2 <= 4000) break;
                    this.max2 = 4000;
                    break;
                }
                default: {
                    Thread.dumpStack();
                }
            }
            this.drawPane();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double pixOfTime(double temps) {
        return this.nbPixelParSeconde * temps + this.scrollPaneRevoir.getWidth() * 0.2;
    }

    private double pixOfNiv1(double niv) {
        return (this.scrollPaneRevoir.getHeight() - 20.0) * (0.96 - 0.92 * niv / (double)this.max1);
    }

    private double pixOfNiv2(double niv) {
        return (this.scrollPaneRevoir.getHeight() - 20.0) * (0.96 - 0.92 * niv / (double)this.max2);
    }

    private double pixOfMvt(double niv) {
        return (this.scrollPaneRevoir.getHeight() - 20.0) * (0.96 - 0.92 * niv / 1000.0);
    }

    private double pixOfProfil(double niv) {
        return (this.scrollPaneRevoir.getHeight() - 20.0) * (0.96 - 0.92 * niv / 100.0);
    }

    private void showStats(Seance seance) {
        GridPane stats = new GridPane();
        this.entete.getChildren().add((Object)stats);
        stats.setAlignment(Pos.CENTER);
        stats.setMinWidth(this.scrollPaneRevoir.getWidth() * 0.33);
        stats.setPrefWidth(this.scrollPaneRevoir.getWidth() * 0.33);
        stats.setMaxWidth(this.scrollPaneRevoir.getWidth() * 0.33);
        stats.setStyle("-fx-grid-lines-visible: true; -fx-grid-line-color: black;");
        int tonus = seance.getIntTonus();
        this.addInfoStat(stats, "contractionMoyenne", 0, 0);
        this.addInfoStat(stats, String.format("%.1f", seance.contractionMoyenne - (double)tonus), 1, 0);
        this.addInfoStat(stats, "reposMoyen", 0, 1);
        this.addInfoStat(stats, String.format("%.1f", seance.reposMoyen - (double)tonus), 1, 1);
        this.addInfoStat(stats, "deficitContraction", 0, 2);
        this.addInfoStat(stats, String.format("%.1f", seance.deficitContraction), 1, 2);
        this.addInfoStat(stats, "deficitContractionPourcent", 0, 3);
        this.addInfoStat(stats, String.format("%.1f%%", (double)seance.deficitContractionPourMille / 10.0), 1, 3);
        this.addInfoStat(stats, "nbContractionsCompletes", 0, 4);
        this.addInfoStat(stats, String.format("%d", seance.nbContractionsCompletes), 1, 4);
    }

    private void addInfoStat(GridPane stats, String str, int col, int row) {
        if (col == 0) {
            str = TransientConfig.translate(str);
        }
        Label label = new Label(str);
        label.getStyleClass().add((Object)"labelConfiguration");
        label.setPadding(new Insets(3.0, 20.0, 3.0, 10.0));
        stats.add((Node)label, col, row);
    }

    private void afficheTendance() {
        Canvas canvas = listSeances.getFirst().getCanvasTendance(this.entete.getWidth() * 0.3, this.entete.getHeight() * 0.8);
        this.entete.getChildren().add((Object)canvas);
    }

    @FXML
    private void setFullScreen() {
        MenuController.setFullScreen();
    }

    static {
        couleurs = new ArrayList<String>(Arrays.asList("limegreen", "orchid", "blue", "orange"));
    }
}

