/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimationSpecif;
import java.util.ArrayList;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;

public class AnimationConcentrique
extends BiofeedbackAnimationSpecif {
    private static final double voie1RelativePosX = 0.5;
    private static final double voie1RelativePosY = 0.45;
    private static final double rapportRayonsMax = 0.9;
    private static final double contractionMax = 0.9;
    private static final int nbRayons = 20;
    double rinMax;
    double routMax;
    private Circle cercleContraction;
    private final ArrayList<Arc> listArc = new ArrayList();

    @Override
    public void initGame() {
        try {
            for (int i = 0; i < 20; ++i) {
                Arc a = new Arc();
                a.setType(ArcType.OPEN);
                a.setFill((Paint)Color.TRANSPARENT);
                a.setStroke((Paint)Color.BLACK);
                a.setStrokeWidth(2.0);
                this.listArc.add(a);
                this.controller.gameAnchor.getChildren().add((Object)a);
            }
            this.cercleContraction = new Circle();
            this.cercleContraction.getStyleClass().setAll((Object[])new String[]{"StyleDisqueContraction"});
            this.controller.gameAnchor.getChildren().add((Object)this.cercleContraction);
            super.initGame();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void updateSizeGame() {
        super.updateSizeGame();
        this.routMax = Math.min(this.widthGame / 2.0, this.anchorHeight * 0.45);
        this.rinMax = this.routMax * 0.9;
        this.cercleContraction.setCenterX(0.5 * this.widthGame);
        this.cercleContraction.setCenterY(0.45 * this.anchorHeight);
    }

    @Override
    public void updateSpecifique() {
        super.updateSpecifique();
        try {
            double pourcent_cercle = 1.0 - 0.9 * this.controller.niveauVoie1Aff / 100.0;
            this.cercleContraction.setRadius(this.rinMax * pourcent_cercle);
            this.cercleContraction.getStyleClass().clear();
            if (this.controller.profilLevel > 0.01) {
                this.cercleContraction.getStyleClass().setAll((Object[])new String[]{"StyleDisqueContractionContract"});
            } else {
                this.cercleContraction.getStyleClass().setAll((Object[])new String[]{"StyleDisqueContraction"});
            }
            this.updateArc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateArc() {
        double x0 = 0.5 * this.widthGame;
        double y0 = 0.45 * this.anchorHeight;
        double pourcent_cercle = 1.0 - 0.9 * this.controller.niveauVoie1Aff / 100.0;
        double ri = this.rinMax * pourcent_cercle;
        double r = (this.routMax + ri) / 2.0;
        double rc = this.routMax - r;
        for (int i = 0; i < 20; ++i) {
            double theta = Math.PI * 2 * (double)i / 20.0;
            Arc a = this.listArc.get(i);
            a.setCenterX(x0 + rc * Math.sin(theta));
            a.setCenterY(y0 + rc * Math.cos(theta));
            a.setRadiusX(r);
            a.setRadiusY(r);
            a.setStartAngle(360.0 * (double)i / 20.0);
            a.setLength(180.0);
        }
    }
}

