/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.zdata;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.view.programme.bfb.AnimationConcentrique;
import com.mazet.biostim.view.programme.bfb.AnimationDefilement;
import com.mazet.biostim.view.programme.bfb.AnimationLotus;
import com.mazet.biostim.view.programme.bfb.AnimationNiveau;
import com.mazet.biostim.view.programme.bfb.AnimationPompier;
import com.mazet.biostim.view.programme.bfb.AnimationStatic;
import com.mazet.biostim.view.programme.bfb.AnimationTachymetre;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimationSkin;
import com.mazet.biostim.view.programme.bfb.BiofeedbackController;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Pane;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public class AnimationStyle {
    public static ArrayList<AnimationStyle> staticAnimationList = new ArrayList();
    public static ArrayList<AnimationStyle> selectedAnimations = new ArrayList();
    public static final int animationDefilement = 0;
    static final int animationContract = 1;
    static final int animationNiveau = 2;
    static final int animationPompier = 3;
    public static final int animationCustom = 4;
    static final int animationLotus = 5;
    static final int animationTachymetre = 6;
    public transient int type;
    static final int rubanJaune = 0;
    public static final int rubanBlanc = 1;
    static final int rubanBleu = 2;
    static final int noRuban = 3;
    public final String name;
    public int nbBackgrounds = 0;
    public String background;
    transient String background_separe = null;
    public int typeRuban;
    public String curseur1 = null;
    public String curseur2 = null;
    public ArrayList<String> objets;
    public transient ImagePattern[] patternObjets;
    transient ImagePattern patternCurseur1;
    transient ImagePattern patternCurseur2;
    transient String couleurVoie1;
    transient String couleurVoie2;
    public static ImagePattern simpleEtoile = new ImagePattern(new Image(Computer.class.getResource("/img/etoile_bleu.png").toExternalForm()));
    public static ImagePattern patternPlus = new ImagePattern(new Image(Computer.class.getResource("/img/etoile_vert.png").toExternalForm()));
    public static ImagePattern patternMoins = new ImagePattern(new Image(Computer.class.getResource("/img/etoile_rouge.png").toExternalForm()));
    transient Image cacheBG;
    transient boolean vsCacheBG;
    transient Background[] cacheBGs;

    public static void initAnimationList() {
        try {
            AnimationStyle anim = new AnimationStyle("neutre", "__quadrillage", null, 2, null, null, null, null, new String[0]);
            staticAnimationList.add(anim);
            staticAnimationList.add(new AnimationStyle("montgolfiere", 0));
            staticAnimationList.add(new AnimationStyle("pacman", 1));
            staticAnimationList.add(new AnimationStyle("lapin", 1));
            staticAnimationList.add(new AnimationStyle(1, "concentrique"));
            staticAnimationList.add(new AnimationStyle(5, "lotus"));
            staticAnimationList.add(new AnimationStyle(6, "racing"));
            anim = new AnimationStyle("quadrillage", "__quadrillage_colore", "div_anim/quadrillage_colore_separe.png", 2, null, null, null, null, new String[0]);
            staticAnimationList.add(anim);
            anim = new AnimationStyle("contraste_fond_noir", "__quadrillage_inverse", null, 1, null, null, "red", "chartreuse", new String[0]);
            staticAnimationList.add(anim);
            anim = new AnimationStyle("contraste_fond_blanc", "__quadrillage", null, 2, null, null, "hotpink", "yellow", new String[0]);
            staticAnimationList.add(anim);
            staticAnimationList.add(new AnimationStyle("foot", 1));
            staticAnimationList.add(new AnimationStyle("astronaute", 2));
            staticAnimationList.add(new AnimationStyle("hiver", 2));
            staticAnimationList.add(new AnimationStyle("noel", 1));
            staticAnimationList.add(new AnimationStyle("valentine", 1));
            staticAnimationList.add(new AnimationStyle("halloween", 1));
            staticAnimationList.add(new AnimationStyle("paques", 1));
            staticAnimationList.add(new AnimationStyle("montagne", 1));
            staticAnimationList.add(new AnimationStyle("avion", 1));
            staticAnimationList.add(new AnimationStyle("lyon", 2));
            staticAnimationList.add(new AnimationStyle("perifit", 1));
            staticAnimationList.add(new AnimationStyle("emy", 2));
            staticAnimationList.add(new AnimationStyle(2, "niveau"));
            staticAnimationList.add(new AnimationStyle(3, "niveau_ludique"));
            AnimationStyle.initSelectedStaticAnimationList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initSelectedStaticAnimationList() {
        selectedAnimations.clear();
        for (int i : Main.getConfig().selectedAnimationsNb) {
            selectedAnimations.add(staticAnimationList.get(i));
        }
    }

    public AnimationStyle(int type, String name) {
        this.name = name;
        this.type = type;
    }

    public AnimationStyle(String name, int typeRuban) {
        String objet;
        this.type = 0;
        this.name = name;
        this.background = name + "/fond.png";
        this.typeRuban = typeRuban;
        this.curseur1 = this.getGoodImage(name + "/curseur1");
        this.curseur2 = this.getGoodImage(name + "/curseur2");
        this.objets = new ArrayList();
        int nb = 0;
        while ((objet = this.getGoodImage(name + "/objet" + nb)) != null) {
            this.objets.add(objet);
            ++nb;
        }
        this.nbBackgrounds = 0;
        while (Main.class.getResource("/img/" + name + "/" + this.nbBackgrounds + ".png") != null) {
            ++this.nbBackgrounds;
        }
        this.createPatterns();
    }

    public AnimationStyle(String name, String background, String background_separe, int typeRuban, String curseur1, String curseur2, String couleurVoie1, String couleurVoie2, String ... objets) {
        this.type = 0;
        this.name = name;
        this.background = background;
        this.background_separe = background_separe;
        this.typeRuban = typeRuban;
        this.curseur1 = curseur1;
        this.curseur2 = curseur2;
        this.couleurVoie1 = couleurVoie1;
        this.couleurVoie2 = couleurVoie2;
        this.objets = new ArrayList<String>(Arrays.asList(objets));
        this.createPatterns();
    }

    public AnimationStyle(String name, String background, int typeRuban, String curseur1, String curseur2, ArrayList<String> objets) {
        this.type = 4;
        this.name = name;
        this.background = background;
        this.typeRuban = typeRuban;
        this.curseur1 = curseur1;
        this.curseur2 = curseur2;
        this.objets = objets;
        this.createPatterns();
    }

    private String getGoodImage(String name) {
        if (Main.class.getResource("/img/" + name + ".png") != null) {
            return name + ".png";
        }
        if (Main.class.getResource("/img/" + name + ".gif") != null) {
            return name + ".gif";
        }
        return null;
    }

    public void createPatterns() {
        if (this.objets != null && !this.objets.isEmpty()) {
            this.patternObjets = new ImagePattern[this.objets.size()];
            for (int i = 0; i < this.objets.size(); ++i) {
                this.patternObjets[i] = new ImagePattern(Computer.getImage(this.objets.get(i), "no-image.png", this.isCustom()));
            }
        }
        this.patternCurseur1 = this.createCurseur(1);
        this.patternCurseur2 = this.createCurseur(2);
    }

    ImagePattern createCurseur(int voie) {
        String img;
        String string = img = voie == 1 ? this.curseur1 : this.curseur2;
        if (img != null) {
            try {
                String imgUrl = this.isCustom() ? Computer.newBiostimFile(img).toURI().toASCIIString() : "/img/" + img;
                Image res = imgUrl.startsWith("/") ? new Image(this.getClass().getResourceAsStream(imgUrl)) : new Image(imgUrl);
                if (res.getHeight() > 5.0) {
                    return new ImagePattern(res);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Utils.debugLine("pb avec le curseur : %s (%s)", img, this.isCustom() ? "custom" : "static");
        }
        return null;
    }

    public Shape getShapeCurseur(int voie, BiofeedbackAnimationSkin animation) {
        int choix = Main.getConfig().choixCurseur;
        if (choix == 0) {
            return null;
        }
        double size = animation.getSizeObj() * 1.2;
        if (voie == 1) {
            size *= 1.5;
        }
        if (choix == 3 || choix == 2 && Main.progEnCours.currentProgram.voie1EnHaut) {
            ImagePattern pattern;
            ImagePattern imagePattern = pattern = voie == 1 ? this.patternCurseur1 : this.patternCurseur2;
            if (pattern != null) {
                double sizex = size * pattern.getImage().getWidth() / pattern.getImage().getHeight();
                if (sizex > 2.0 * size) {
                    double tmp = size;
                    size *= 2.0 * size / sizex;
                    sizex = 2.0 * tmp;
                }
                Rectangle curseur = new Rectangle(0.0, 0.0, sizex, size);
                curseur.setFill((Paint)pattern);
                return curseur;
            }
        }
        Polygon polygon = new Polygon();
        polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, size, size / 2.0, 0.0, size});
        String color = voie == 1 ? this.getCouleurVoie1() : this.getCouleurVoie2();
        polygon.setStyle("-fx-fill:" + color);
        return polygon;
    }

    public void updateShapeCurseur(Shape curseur, int voie, BiofeedbackAnimationSkin animation) {
        if (curseur == null) {
            return;
        }
        double size = animation.getSizeObj() * 1.2;
        if (voie == 1) {
            size *= 1.5;
        }
        if (curseur instanceof Rectangle) {
            Rectangle rect = (Rectangle)curseur;
            double sizex = size * rect.getWidth() / rect.getHeight();
            if (sizex > 2.0 * size) {
                double tmp = size;
                size *= 2.0 * size / sizex;
                sizex = 2.0 * tmp;
            }
            rect.setHeight(size);
            rect.setWidth(sizex);
        } else if (curseur instanceof Polygon) {
            Polygon polygon = (Polygon)curseur;
            polygon.getPoints().setAll((Object[])new Double[]{0.0, 0.0, size, size / 2.0, 0.0, size});
        }
    }

    public String getCouleurVoie1() {
        return this.couleurVoie1 != null ? this.couleurVoie1 : Main.getConfig().couleurVoie1;
    }

    public String getCouleurVoie2() {
        return this.couleurVoie2 != null ? this.couleurVoie2 : Main.getConfig().couleurVoie2;
    }

    public String getRubanStyle() {
        switch (this.typeRuban) {
            case 2: {
                return "rubanBleu";
            }
            case 1: {
                return "rubanBlanc";
            }
            case 0: {
                return "rubanJaune";
            }
            case 3: {
                return "noRuban";
            }
        }
        Utils.debugInfo("ruban " + this.typeRuban);
        Thread.dumpStack();
        return "rubanBleu";
    }

    public BiofeedbackAnimation getBiofeedBackAnimation(BiofeedbackController controller) {
        switch (this.type) {
            case 0: 
            case 4: {
                if (Main.progEnCours.currentProgram.isDefilement()) {
                    return new AnimationDefilement(this, controller);
                }
                return new AnimationStatic(this, controller);
            }
            case 1: {
                return new AnimationConcentrique();
            }
            case 5: {
                return new AnimationLotus();
            }
            case 6: {
                return new AnimationTachymetre();
            }
            case 2: {
                return new AnimationNiveau();
            }
            case 3: {
                return new AnimationPompier();
            }
        }
        Thread.dumpStack();
        return null;
    }

    public boolean isCustom() {
        return this.type == 4;
    }

    public String getTranslatedName() {
        if (this.type == 4) {
            return this.name;
        }
        return TransientConfig.translate("animation_" + this.name);
    }

    public void setBackground(Pane gameRoot, boolean voiesSeparees, int hauteur, double pixCursor, double largeurExacte) {
        if (this.background.startsWith("__")) {
            int type = 0;
            if (this.background.contains("colore")) {
                type = 1;
            }
            if (this.background.contains("inverse")) {
                type = 2;
            }
            gameRoot.setBackground(FxUtils.getBackGroundQuadrille(voiesSeparees, type, hauteur, pixCursor, largeurExacte));
        } else {
            if (this.cacheBG == null || this.vsCacheBG != voiesSeparees && this.background_separe != null) {
                this.vsCacheBG = voiesSeparees;
                String name = voiesSeparees && this.background_separe != null ? this.background_separe : this.background;
                this.cacheBG = Computer.getImage(name, "no-image.png", this.isCustom());
            }
            Image imgBg = this.cacheBG;
            BackgroundSize bgSize = new BackgroundSize(-1.0, 1.0, false, true, false, false);
            BackgroundImage bgLogo = new BackgroundImage(imgBg, BackgroundRepeat.REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, bgSize);
            gameRoot.setBackground(new Background(new BackgroundImage[]{bgLogo}));
        }
    }

    public Background getBackground(int num) {
        if (this.cacheBGs == null) {
            this.cacheBGs = new Background[this.nbBackgrounds];
            for (int i = 0; i < this.nbBackgrounds; ++i) {
                Image imgBg = new Image(this.getClass().getResourceAsStream(String.format("/img/%s/%d.png", this.name, i)));
                BackgroundSize bgSize = new BackgroundSize(-1.0, 1.0, false, true, false, false);
                this.cacheBGs[i] = new Background(new BackgroundImage[]{new BackgroundImage(imgBg, BackgroundRepeat.REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, bgSize)});
            }
        }
        return this.cacheBGs[num];
    }
}

