/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.zdata;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.CloudManager;
import com.mazet.biostim.zdata.Pageprogramme;
import com.mazet.biostim.zdata.Profil;
import java.util.ArrayList;
import java.util.Collections;

public class ProfilConcat
extends Profil {
    private final ArrayList<Pageprogramme> pages;
    private final ArrayList<Integer> repet;
    private final boolean reposIntra;
    private final boolean forceRepos;
    private final double dureeRepos;

    ProfilConcat(ArrayList<Pageprogramme> pages, ArrayList<Integer> repet, double dureeRepos, boolean reposIntra, boolean forceRepos) {
        this.pages = pages;
        this.repet = repet;
        this.dureeRepos = dureeRepos;
        this.reposIntra = reposIntra;
        this.forceRepos = forceRepos;
        double t_init = 0.0;
        for (int i = 0; i < pages.size(); ++i) {
            Profil profil;
            Pageprogramme pp = pages.get(i);
            Profil profil2 = profil = reposIntra ? pp.getProfil() : pp.getProfilForceRepos(0.0);
            if (!reposIntra && Main.getConfig().reposAvantTravail) {
                this.addPoint(t_init, profil.val.get(0));
                t_init += this.getDureeRepos(pp);
            }
            for (int j = 0; j < repet.get(i); ++j) {
                for (int k = 0; k < profil.temps.size(); ++k) {
                    this.addPoint(t_init + profil.temps.get(k), profil.val.get(k));
                }
                t_init += profil.getDuree();
            }
            if (reposIntra || Main.getConfig().reposAvantTravail) continue;
            this.addPoint(t_init += this.getDureeRepos(pp), (Double)this.val.get(this.val.size() - 1));
        }
    }

    @Override
    public Profil getProfilUnitaire(double now) {
        now %= this.getDuree();
        double t = 0.0;
        if (this.reposIntra) {
            for (int i = 0; i < this.pages.size(); ++i) {
                Pageprogramme profil = this.pages.get(i);
                if (!(now < (t += profil.getProfil().getDuree() * (double)this.repet.get(i).intValue()))) continue;
                return new ProfilConcat(new ArrayList<Pageprogramme>(Collections.singletonList(profil)), new ArrayList<Integer>(Collections.singletonList(1)), 0.0, true, this.forceRepos);
            }
        } else {
            for (int i = 0; i < this.pages.size(); ++i) {
                Pageprogramme profil = this.pages.get(i);
                if (!(now < (t += profil.getProfilForceRepos(0.0).getDuree() * (double)this.repet.get(i).intValue() + this.getDureeRepos(profil)))) continue;
                return new ProfilConcat(new ArrayList<Pageprogramme>(Collections.singletonList(profil)), new ArrayList<Integer>(Collections.singletonList(this.repet.get(i))), this.dureeRepos, false, this.forceRepos);
            }
        }
        CloudManager.sendJdd("Erreur getProfilUnitaire Concat", new Object[0]);
        Thread.dumpStack();
        return this;
    }

    private double getDureeRepos(Pageprogramme pp) {
        if (this.forceRepos) {
            return this.dureeRepos;
        }
        return pp.getTrepos();
    }
}

