#!/bin/bash

# popup d'attente
osascript -e 'display notification "Biostim : Please wait during update" with title "Biostim"'

sleep 2  # attend que Biostim s'arrête pour pouvoir le remplacer

if [ -e "$HOME/BiostimData/Biostim.zip" ]; then
    rm -rf "$HOME/BiostimData/Biostim_old.app"
    mv "$HOME/BiostimData/Biostim.app" "$HOME/BiostimData/Biostim_old.app"
    ditto -x -k "$HOME/BiostimData/Biostim.zip" "$HOME/BiostimData/"
fi

# === CONFIGURATION ===
TARGETDIR="$HOME/BiostimData"
TARGET="$TARGETDIR/Biostim.app"
ALIAS_NAME="Biostim"
DESKTOP="$HOME/Desktop"
ALIAS_PATH="$DESKTOP/$ALIAS_NAME"

# === SUPPRIMER ANCIEN ALIAS SI EXISTE ===
osascript <<END
tell application "Finder"
    try
        delete POSIX file "$ALIAS_PATH"
    end try
end tell
END

# === CREER LE NOUVEL ALIAS ===
osascript <<END
tell application "Finder"
    make alias file to (POSIX file "$TARGET") at (POSIX file "$DESKTOP")
    set name of result to "$ALIAS_NAME"
end tell
END

osascript -e 'display notification "Biostim : Update OK" with title "Biostim"'
