/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.actions.AbstractStatisticsEvent;
import com.itextpdf.commons.actions.data.ProductData;
import com.itextpdf.text.pdf.statistics.SizeOfPdfStatisticsAggregator;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeOfPdfStatisticsEvent
extends AbstractStatisticsEvent {
    private static final String PDF_SIZE_STATISTICS = "pdfSize";
    private final long amountOfBytes;

    public SizeOfPdfStatisticsEvent(long amountOfBytes, ProductData productData) {
        super(productData);
        if (amountOfBytes < 0L) {
            throw new IllegalArgumentException("Amount of bytes in the PDF document cannot be less than zero");
        }
        this.amountOfBytes = amountOfBytes;
    }

    public AbstractStatisticsAggregator createStatisticsAggregatorFromName(String statisticsName) {
        if (PDF_SIZE_STATISTICS.equals(statisticsName)) {
            return new SizeOfPdfStatisticsAggregator();
        }
        return super.createStatisticsAggregatorFromName(statisticsName);
    }

    public List<String> getStatisticsNames() {
        return Collections.singletonList(PDF_SIZE_STATISTICS);
    }

    public long getAmountOfBytes() {
        return this.amountOfBytes;
    }
}

