/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.comm;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.mazet.biostim.Main;
import com.mazet.biostim.comm.BioPod;
import com.mazet.biostim.comm.CommandesBiopod;
import com.mazet.biostim.comm.RS232;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.CloudManager;
import com.mazet.biostim.utils.Maths;
import com.mazet.biostim.utils.Utils;
import java.util.concurrent.locks.ReentrantLock;

public abstract class UsbBiopod {
    public static SerialPort serialPort = null;
    public static int connexionBiopod = 0;
    public static UsbBuffer usbBuffer = new UsbBuffer();
    public static boolean dataRecue = false;
    static boolean fisrtSOH = true;
    static boolean fisrtSOC = true;
    private static final ReentrantLock mutexInit = new ReentrantLock();

    public static boolean isConnexionBiopod() {
        return connexionBiopod >= 2;
    }

    static boolean searchBiopod() {
        return Main.getConfig().biopodUsb && connexionBiopod == 0 && SondeBT.connectionBioPod == 0;
    }

    static boolean stillSearchBiopod() {
        return Main.getConfig().biopodUsb && !BioPod.isConnected();
    }

    static void initConnexion(SerialPort portName) {
        if (mutexInit.tryLock()) {
            try {
                connexionBiopod = 1;
                serialPort = portName;
                Utils.debugInfo("Trying Biopod Port " + serialPort.getSystemPortName());
                serialPort.openPort();
                usbBuffer.clear();
                serialPort.addDataListener(new SerialPortDataListener(){

                    public int getListeningEvents() {
                        return 1;
                    }

                    public void serialEvent(SerialPortEvent event) {
                        UsbBiopod.rs232SerialEvent(event);
                    }
                });
                fisrtSOC = true;
                fisrtSOH = true;
                UsbBiopod.sendCommandTrame(BioPod.commandesBiopod.FIRM);
                Utils.sleep(500L);
                double timeWithoutComm = 0.0;
                while (connexionBiopod > 1) {
                    if (dataRecue) {
                        dataRecue = false;
                        timeWithoutComm = 0.0;
                    } else {
                        if (Main.getConfig().numSerieBiopod == 0) {
                            UsbBiopod.initRegistres();
                        } else {
                            UsbBiopod.sendByteTrame(BioPod.commandesBiopod.SWITCH_COM, 1);
                            UsbBiopod.sendByteTrame(BioPod.commandesBiopod.RMS_C1_STATUS, 1);
                            UsbBiopod.sendByteTrame(BioPod.commandesBiopod.RMS_C2_STATUS, 1);
                        }
                        timeWithoutComm += 1.0;
                    }
                    if (timeWithoutComm > 3.0) {
                        Utils.debugInfo("3s sans donnee BioPod sur %s (ports : %s)", serialPort.getSystemPortName(), RS232.getPortsListNames());
                        return;
                    }
                    Utils.sleep(1000L);
                }
            }
            catch (Exception e) {
                Utils.debugLine(e, 1, "%s", e);
            }
            finally {
                UsbBiopod.closeConnexion();
                mutexInit.unlock();
            }
        }
    }

    static void closeConnexion() {
        if (serialPort != null) {
            Utils.debugInfo("Close connexion USB Biopod");
            if (UsbBiopod.isConnexionBiopod() && Main.progEnCours != null && (Biostim.isVoieBiopod(Main.progEnCours.currentProgram.getVoieBFB1()) || Biostim.isVoieBiopod(Main.progEnCours.currentProgram.getVoieBFB2()))) {
                Main.telecommandeStop();
            }
            Utils.executeWithTimeout(() -> {
                try {
                    serialPort.removeDataListener();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    serialPort.closePort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 1000L);
            Utils.sleep(500L);
            serialPort = null;
        }
        if (connexionBiopod != 0) {
            connexionBiopod = 0;
            Main.menu.changeHomeStatus();
        }
    }

    static void ping() {
        new Thread(() -> {
            byte[] tramePing = new byte[]{-86, BioPod.commandesBiopod.PING, 0, 0};
            while (connexionBiopod >= 1) {
                UsbBiopod.sendTrame(tramePing);
                Utils.sleep(500L);
            }
        }).start();
    }

    static void initRegistres() {
        Main.getConfig().numSerieBiopod = 0;
        UsbBiopod.sendCommandTrame(BioPod.commandesBiopod.SERIAL);
        UsbBiopod.sendByteTrame(BioPod.commandesBiopod.SWITCH_COM, 1);
        UsbBiopod.sendByteTrame(BioPod.commandesBiopod.RMS_C1_STATUS, 1);
        UsbBiopod.sendByteTrame(BioPod.commandesBiopod.RMS_C2_STATUS, 1);
        BioPod.stopRawA();
        BioPod.stopRawB();
        UsbBiopod.sendCommandTrame(BioPod.commandesBiopod.MODEL);
        UsbBiopod.sendCommandTrame(BioPod.commandesBiopod.HARD);
        UsbBiopod.sendCommandTrame(BioPod.commandesBiopod.SYS_ID);
    }

    public static void sendCommandTrame(byte id) {
        byte[] trame = new byte[]{-86, id, 0, 0};
        UsbBiopod.sendTrame(trame);
    }

    public static void sendByteTrame(byte id, int data) {
        byte[] trame = new byte[]{-86, id, 1, 0, (byte)data};
        UsbBiopod.sendTrame(trame);
    }

    public static void sendIntTrame(byte id, int data) {
        byte[] trame = new byte[]{-86, id, 4, 0, (byte)(data & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 24 & 0xFF)};
        UsbBiopod.sendTrame(trame);
    }

    static synchronized void sendTrame(byte[] trame) {
        Utils.executeWithTimeout(() -> {
            try {
                serialPort.writeBytes(trame, trame.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 1000L);
    }

    static void rs232SerialEvent(SerialPortEvent event) {
        try {
            if (event.getEventType() == 1) {
                byte[] bread = new byte[serialPort.bytesAvailable()];
                serialPort.readBytes(bread, bread.length);
                usbBuffer.add(bread);
                while (UsbBiopod.traiteBuffer()) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static boolean traiteBuffer() {
        int pos;
        for (pos = 0; pos < usbBuffer.size() && UsbBiopod.usbBuffer.buffer[pos] != 170; ++pos) {
        }
        usbBuffer.clear(pos);
        if (usbBuffer.size() < 4) {
            return false;
        }
        int size = UsbBiopod.usbBuffer.buffer[2] + UsbBiopod.usbBuffer.buffer[3] * 256;
        if (size > 2000) {
            usbBuffer.clear(1);
            return true;
        }
        if (usbBuffer.size() < pos + 4 + size) {
            return false;
        }
        int[] trame = usbBuffer.consume(size + 4);
        UsbBiopod.decodeTrame(trame);
        return true;
    }

    static void decodeTrame(int[] trame) {
        if (trame[1] == BioPod.commandesBiopod.FIRM) {
            Main.getConfig().fwBiopod = Maths.readableDecOfHex(UsbBiopod.readIntInTab(trame, 4));
            try {
                BioPod.commandesBiopod = Utils.fromJsonFileWithException(BioPod.getCommandePath(), CommandesBiopod.class);
                UsbBiopod.ping();
            }
            catch (Exception e) {
                Utils.debugInfo("Nouvelle version, r\u00e9cup\u00e9ration du json");
                UsbBiopod.sendByteTrame(BioPod.commandesBiopod.SWITCH_COM, 1);
                UsbBiopod.sendCommandTrame(BioPod.commandesBiopod.GET_JSON);
            }
        } else if (trame[1] == BioPod.commandesBiopod.GET_JSON) {
            StringBuilder res = new StringBuilder();
            for (int i = 4; i < trame.length; ++i) {
                res.append((char)trame[i]);
            }
            String json = res.toString();
            BioPod.saveJson(json);
            UsbBiopod.ping();
        } else if (trame[1] == BioPod.commandesBiopod.PING) {
            if (connexionBiopod < 2) {
                connexionBiopod = 2;
                Main.menu.changeHomeStatus();
                UsbBiopod.initRegistres();
            }
        } else if (trame[1] == BioPod.commandesBiopod.RMS_C1) {
            dataRecue = true;
            BioPod.setBiopodA(UsbBiopod.readFloatInTab(trame, 4) * 1000000.0f);
        } else if (trame[1] == BioPod.commandesBiopod.RMS_C2) {
            BioPod.setBiopodB(UsbBiopod.readFloatInTab(trame, 4) * 1000000.0f);
        } else if (trame[1] == BioPod.commandesBiopod.RAW_C1) {
            BioPod.rawBiopodA.decodeUsbRawBioPod(trame);
        } else if (trame[1] == BioPod.commandesBiopod.RAW_C2) {
            BioPod.rawBiopodB.decodeUsbRawBioPod(trame);
        } else if (trame[1] == BioPod.commandesBiopod.MODEL) {
            Main.getConfig().setModelBiopod(UsbBiopod.readIntInTab(trame, 4));
        } else if (trame[1] == BioPod.commandesBiopod.SERIAL) {
            Main.getConfig().numSerieBiopod = UsbBiopod.readIntInTab(trame, 4);
        } else if (trame[1] == BioPod.commandesBiopod.HARD) {
            Main.getConfig().hwBiopod = UsbBiopod.readIntInTab(trame, 4);
        } else if (trame[1] == BioPod.commandesBiopod.SYS_ID) {
            Main.getConfig().idBiopod = UsbBiopod.readIntInTab(trame, 4);
            if (Main.getConfig().numSerieBiopod != 0) {
                Main.getConfig().saveConfig();
                Utils.debugInfo("--------------- Connexion USB Biopod BF-%05d (model %d) ---------------%n    FW : %d ; HW : %d ; id : %d", Main.getConfig().numSerieBiopod, Main.getConfig().modelBiopod, Main.getConfig().fwBiopod, Main.getConfig().hwBiopod, Main.getConfig().idBiopod);
                CloudManager.connectBiopod();
            } else {
                UsbBiopod.initRegistres();
            }
        } else if (trame[1] == BioPod.commandesBiopod.SOC) {
            if (fisrtSOC) {
                Utils.debugInfo("Batt Biopod = %d", trame[4]);
                fisrtSOC = false;
            }
        } else if (trame[1] == BioPod.commandesBiopod.SOH) {
            if (fisrtSOH) {
                Utils.debugInfo("Batt Health Biopod = %d", trame[4] + (trame[5] << 8));
                fisrtSOH = false;
            }
        } else if (trame[1] != BioPod.commandesBiopod.AVG_C && trame[1] != BioPod.commandesBiopod.AVG_V) {
            Utils.debugInfo("trame %d : %d octets", trame[1], trame.length);
        }
    }

    static float readFloatInTab(int[] tab, int pos) {
        int tmp = (tab[pos] << 0) + (tab[pos + 1] << 8) + (tab[pos + 2] << 16) + (tab[pos + 3] << 24);
        return Float.intBitsToFloat(tmp);
    }

    static int readIntInTab(int[] tab, int pos) {
        return (tab[pos] << 0) + (tab[pos + 1] << 8) + (tab[pos + 2] << 16) + (tab[pos + 3] << 24);
    }

    public static class UsbBuffer {
        public int[] buffer = new int[0];

        public void add(byte[] data) {
            int[] newBuf = new int[this.buffer.length + data.length];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            for (int i = 0; i < data.length; ++i) {
                newBuf[this.buffer.length + i] = data[i] & 0xFF;
            }
            this.buffer = newBuf;
        }

        public int size() {
            return this.buffer.length;
        }

        public void clear() {
            this.buffer = new int[0];
        }

        public void clear(int size) {
            if (size == 0) {
                return;
            }
            if (size >= this.buffer.length) {
                this.clear();
            } else {
                int[] tmp = this.buffer;
                this.buffer = new int[this.buffer.length - size];
                System.arraycopy(tmp, size, this.buffer, 0, this.buffer.length);
            }
        }

        public int[] consume(int size) {
            if (size > this.buffer.length) {
                return null;
            }
            if (size == this.buffer.length) {
                int[] tmp = this.buffer;
                this.buffer = new int[0];
                return tmp;
            }
            int[] res = new int[size];
            System.arraycopy(this.buffer, 0, res, 0, size);
            int[] tmp = this.buffer;
            this.buffer = new int[this.buffer.length - size];
            System.arraycopy(tmp, size, this.buffer, 0, this.buffer.length);
            return res;
        }
    }
}

