/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utilsfx;

import com.mazet.biostim.utilsfx.FxUtils;
import java.awt.Desktop;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;

public class HtmlToJavaFX {
    public static void toTextFlow(String html, TextFlow flow) {
        flow.getChildren().clear();
        flow.setLineSpacing(2.0);
        Document doc = Jsoup.parse((String)html);
        HtmlToJavaFX.parseElement(doc.body(), flow, new TextStyle(), false);
        flow.getChildren().add((Object)new Text("\n\n"));
    }

    private static void parseElement(Element element, TextFlow flow, TextStyle style, boolean preserveWhitespace) {
        for (org.jsoup.nodes.Node node : element.childNodes()) {
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                String text = preserveWhitespace ? textNode.getWholeText() : textNode.text();
                if (text.isEmpty() || !preserveWhitespace && text.trim().isEmpty()) continue;
                Text javafxText = new Text(text);
                HtmlToJavaFX.applyStyle(javafxText, style.copy());
                flow.getChildren().add((Object)javafxText);
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String tag = child.tagName().toLowerCase();
            TextStyle nextStyle = style.copy();
            boolean nextPreserveWhitespace = preserveWhitespace;
            if (tag.equals("pre")) {
                nextPreserveWhitespace = true;
                nextStyle.family = "Monospaced";
                nextStyle.weight = FontWeight.NORMAL;
            } else if (tag.equals("code")) {
                nextStyle.family = "Monospaced";
            } else if (tag.equals("b") || tag.equals("strong")) {
                nextStyle.weight = FontWeight.BOLD;
            } else if (tag.equals("i") || tag.equals("em")) {
                nextStyle.posture = FontPosture.ITALIC;
            } else if (tag.equals("font")) {
                if (child.hasAttr("color")) {
                    nextStyle.color = HtmlToJavaFX.parseColor(child.attr("color"));
                }
                if (child.hasAttr("size")) {
                    try {
                        nextStyle.size = HtmlToJavaFX.htmlSizeToPixels(Integer.parseInt(child.attr("size")));
                    }
                    catch (Exception exception) {}
                }
            } else if (tag.matches("h[1-6]")) {
                flow.getChildren().add((Object)new Text("\n"));
                try {
                    int size = 7 - Integer.parseInt(tag.substring(1));
                    nextStyle.size = HtmlToJavaFX.htmlSizeToPixels(size);
                    nextStyle.weight = FontWeight.BOLD;
                }
                catch (Exception exception) {}
            } else if (tag.equals("a")) {
                nextStyle.link = child.attr("href");
            } else {
                if (tag.equals("br")) {
                    flow.getChildren().add((Object)new Text("\n"));
                    continue;
                }
                if (tag.equals("p")) {
                    flow.getChildren().add((Object)new Text("\n\n"));
                } else if (tag.equals("ul")) {
                    flow.getChildren().add((Object)new Text("\n"));
                } else if (tag.equals("li")) {
                    flow.getChildren().add((Object)new Text(" \u2022 "));
                } else if (tag.equals("img")) {
                    HtmlToJavaFX.addImage(child, flow, nextStyle);
                }
            }
            if (child.hasAttr("style")) {
                HtmlToJavaFX.parseInlineStyle(child.attr("style").toLowerCase(), nextStyle);
            }
            HtmlToJavaFX.parseElement(child, flow, nextStyle, nextPreserveWhitespace);
            if (!tag.matches("p|div|h[1-6]|li") || nextPreserveWhitespace) continue;
            flow.getChildren().add((Object)new Text("\n"));
        }
    }

    private static void applyStyle(Text text, TextStyle style) {
        text.setStyle(String.format("-fx-font-family: '%s'; -fx-font-weight: %s; -fx-font-style: %s; -fx-font-size: %.1fpx; -fx-fill: %s; -fx-underline: %b; -fx-strikethrough: %b;", style.family, style.weight.toString().toLowerCase(), style.posture == FontPosture.ITALIC ? "italic" : "normal", style.size, HtmlToJavaFX.toRgbString(style.color), style.underline, style.strikethrough));
    }

    private static String toRgbString(Color color) {
        return String.format("rgb(%.0f, %.0f, %.0f)", color.getRed() * 255.0, color.getGreen() * 255.0, color.getBlue() * 255.0);
    }

    private static Color parseColor(String colorValue) {
        return switch (colorValue = colorValue.trim().toLowerCase()) {
            case "red" -> Color.RED;
            case "green" -> Color.GREEN;
            case "blue" -> Color.BLUE;
            case "yellow" -> Color.YELLOW;
            case "orange" -> Color.ORANGE;
            case "purple" -> Color.PURPLE;
            case "pink" -> Color.PINK;
            case "cyan" -> Color.CYAN;
            case "magenta" -> Color.MAGENTA;
            case "white" -> Color.WHITE;
            case "black" -> Color.BLACK;
            case "gray", "grey" -> Color.GRAY;
            case "darkgray", "darkgrey" -> Color.DARKGRAY;
            case "lightgray", "lightgrey" -> Color.LIGHTGRAY;
            case "brown" -> Color.BROWN;
            case "gold" -> Color.GOLD;
            case "silver" -> Color.SILVER;
            default -> Color.web((String)colorValue);
        };
    }

    private static double htmlSizeToPixels(int htmlSize) {
        return switch (htmlSize) {
            case 1 -> 10.0;
            case 2 -> 13.0;
            case 3 -> 16.0;
            case 4 -> 18.0;
            case 5 -> 24.0;
            case 6 -> 32.0;
            case 7 -> 48.0;
            default -> 16.0;
        };
    }

    private static void parseInlineStyle(String styleAttr, TextStyle style) {
        Pattern sizePattern;
        Matcher sizeMatcher;
        Pattern colorPattern = Pattern.compile("color:\\s*([^;]+)");
        Matcher colorMatcher = colorPattern.matcher(styleAttr);
        if (colorMatcher.find()) {
            try {
                String colorValue = colorMatcher.group(1).trim();
                style.color = HtmlToJavaFX.parseColor(colorValue);
            }
            catch (Exception colorValue) {
                // empty catch block
            }
        }
        if ((sizeMatcher = (sizePattern = Pattern.compile("font-size:\\s*(\\d+)px")).matcher(styleAttr)).find()) {
            try {
                style.size = Double.parseDouble(sizeMatcher.group(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (styleAttr.contains("font-weight:bold") || styleAttr.contains("font-weight: bold")) {
            style.weight = FontWeight.BOLD;
        }
        if (styleAttr.contains("font-style:italic") || styleAttr.contains("font-style: italic")) {
            style.posture = FontPosture.ITALIC;
        }
        if (styleAttr.contains("text-decoration:underline")) {
            style.underline = true;
        }
        if (styleAttr.contains("text-decoration:line-through")) {
            style.strikethrough = true;
        }
    }

    private static void addImage(Element imgElement, TextFlow flow, TextStyle style) {
        String src = imgElement.attr("src");
        try {
            Image image = src.startsWith("jar:") ? FxUtils.getResourceImage(src.substring(4)) : new Image(src, true);
            ImageView imageView = new ImageView(image);
            double proportion = 1.0;
            if (imgElement.hasAttr("width")) {
                try {
                    String strWidth = imgElement.attr("width");
                    if (strWidth.contains("%")) {
                        strWidth = strWidth.substring(0, strWidth.indexOf(37));
                        proportion = Double.parseDouble(strWidth) / 100.0;
                    } else {
                        proportion = Double.parseDouble(strWidth) / (flow.getWidth() - 30.0);
                    }
                }
                catch (Exception strWidth) {
                    // empty catch block
                }
            }
            if (imgElement.hasAttr("height")) {
                try {
                    double height = Double.parseDouble(imgElement.attr("height"));
                    imageView.setFitHeight(height);
                }
                catch (NumberFormatException height) {
                    // empty catch block
                }
            }
            imageView.setPreserveRatio(true);
            if (style.link != null) {
                imageView.setOnMouseClicked(mouseEvent -> {
                    try {
                        Desktop.getDesktop().browse(new URI(style.link));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                imageView.getStyleClass().add((Object)"hand");
            }
            HBox imageContainer = new HBox(new Node[]{imageView});
            imageView.fitWidthProperty().bind((ObservableValue)imageContainer.widthProperty().multiply(proportion));
            imageContainer.setAlignment(Pos.CENTER);
            imageContainer.minWidthProperty().bind((ObservableValue)flow.widthProperty().subtract(30));
            imageContainer.maxWidthProperty().bind((ObservableValue)flow.widthProperty().subtract(30));
            double finalProp = proportion;
            image.heightProperty().addListener((observableValue, number, newHeight) -> {
                if (newHeight.doubleValue() > 0.0) {
                    double ratio = image.getHeight() / image.getWidth();
                    DoubleBinding heightBinding = imageContainer.widthProperty().multiply(finalProp * ratio);
                    imageContainer.minHeightProperty().bind((ObservableValue)heightBinding);
                    imageContainer.prefHeightProperty().bind((ObservableValue)heightBinding);
                    imageContainer.maxHeightProperty().bind((ObservableValue)heightBinding);
                }
            });
            flow.getChildren().addAll((Object[])new Node[]{new Text("\n"), imageContainer, new Text("\n")});
        }
        catch (Exception e) {
            e.printStackTrace();
            Text placeholder = new Text("[Image: " + src + "]");
            placeholder.setFill((Paint)Color.GRAY);
            placeholder.setFont(Font.font((String)"System", (FontPosture)FontPosture.ITALIC, (double)12.0));
            flow.getChildren().add((Object)placeholder);
        }
    }

    private static class TextStyle {
        String family = "System";
        double size = 16.0;
        Color color = Color.BLACK;
        FontWeight weight = FontWeight.NORMAL;
        FontPosture posture = FontPosture.REGULAR;
        boolean underline = false;
        boolean strikethrough = false;
        String link = null;

        private TextStyle() {
        }

        TextStyle copy() {
            TextStyle copy = new TextStyle();
            copy.family = this.family;
            copy.size = this.size;
            copy.color = this.color;
            copy.weight = this.weight;
            copy.posture = this.posture;
            copy.underline = this.underline;
            copy.strikethrough = this.strikethrough;
            copy.link = this.link;
            return copy;
        }
    }
}

