/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.configuration;

import com.fazecast.jSerialComm.SerialPort;
import com.mazet.biostim.Main;
import com.mazet.biostim.comm.BioPod;
import com.mazet.biostim.comm.RS232;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiopod;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.CloudManager;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Security;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.utilsfx.HtmlToJavaFX;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.configuration.DebugView;
import com.mazet.biostim.view.configuration.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.shape.Circle;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;
import org.json.JSONArray;
import org.json.JSONObject;

public class Autotest
extends Controller {
    @FXML
    TextFlow resultat;
    @FXML
    private Button retry;
    @FXML
    private Button next;
    @FXML
    private TextFlow webDroite;
    @FXML
    private MediaView mediaDroite;
    @FXML
    private LineChart<Number, Number> graphique;
    @FXML
    private TextField commande;
    @FXML
    Region regionDroite;
    @FXML
    private VBox vboxInstall;
    @FXML
    private Label updateTitle;
    @FXML
    private Label features;
    @FXML
    private Hyperlink featuresUrl;
    @FXML
    Button buttonDownload;
    @FXML
    Circle statusDownload;
    @FXML
    Label labelDownload;
    static JSONObject jsonVersion;
    private Etape etape = Etape.VERSION;
    private boolean stimEnCours;
    private String valide = "";
    private String consigne = "";
    private int electrodeDecolleeA;
    private int electrodeDecolleeB = 0;
    private int stimMaxA;
    private int stimMaxB = 10;
    private int bfbCcRNA;
    private int bfbCcRNB = 0;
    private int bfbCcJNA;
    private int bfbCcJNB = 2000;
    private int testFini = 0;
    public boolean secuA = false;
    public boolean secuB = false;
    boolean firstRougeNoir = true;
    boolean firstJauneNoir = true;

    @Override
    public void setMain() {
        super.setMain();
        Update.autotest = this;
        this.graphique.setAnimated(false);
        this.graphique.setCreateSymbols(false);
        this.graphique.setLegendVisible(false);
        ((NumberAxis)this.graphique.getXAxis()).setForceZeroInRange(false);
        this.graphique.getXAxis().setAutoRanging(false);
        this.next();
    }

    private void animAffichage(String s) {
        while (!s.isEmpty()) {
            int pos = s.indexOf("<br>");
            String s1 = s;
            if (pos == -1) {
                s = "";
            } else {
                s1 = s.substring(0, pos + 4);
                s = s.substring(pos + 4);
            }
            this.valide = this.valide + s1;
            this.updateWebContent(false);
        }
    }

    private void updateWebContent(boolean encours) {
        Platform.runLater(() -> {
            if (encours) {
                HtmlToJavaFX.toTextFlow("<pre>" + this.valide + "<br><br><i>" + this.consigne + "</i></pre>", this.resultat);
            } else {
                HtmlToJavaFX.toTextFlow("<pre>" + this.valide + "<br><br><b>" + this.consigne + "</b></pre>", this.resultat);
            }
        });
        if (this.consigne.isEmpty()) {
            Utils.sleep(300L);
        }
    }

    @FXML
    void next() {
        this.showNext(false);
        this.showRetry(false);
        this.consigne = "";
        this.stopFilm();
        new Thread(() -> {
            switch (this.etape.ordinal()) {
                case 0: {
                    this.testVersion();
                    break;
                }
                case 1: {
                    this.testConnexionBiostim();
                    break;
                }
                case 2: {
                    this.testConnexionBiopod();
                    break;
                }
                case 3: {
                    this.testElectrodeDecollee();
                    break;
                }
                case 4: {
                    this.testCourtCircuitRougeNoir(0);
                    break;
                }
                case 5: {
                    this.testCourtCircuitRougeNoir(1);
                    break;
                }
                case 6: {
                    this.testCourtCircuitJauneNoir(0);
                    break;
                }
                case 7: {
                    this.testCourtCircuitJauneNoir(1);
                    break;
                }
                case 8: {
                    this.afficheDiagFinal();
                }
            }
        }).start();
    }

    @FXML
    void retry() {
        this.etape = this.etape.retry();
        this.next();
    }

    private void showNext(boolean state) {
        Platform.runLater(() -> FxUtils.setVisibility((Node)this.next, state));
    }

    private void showRetry(boolean state) {
        Platform.runLater(() -> FxUtils.setVisibility((Node)this.retry, state));
    }

    private void testVersion() {
        Utils.Tuple<Boolean, String> state = Autotest.getMainState();
        this.animAffichage(state.second());
        if (state.first().booleanValue()) {
            return;
        }
        if (Main.getConfig().etatCloud == 1 || Security.verifCheckSum == 2) {
            Platform.runLater(() -> {
                FxUtils.setVisibility((Node)this.vboxInstall, true);
                this.updateTitle.setText(String.format(TransientConfig.translate("updateVersion"), jsonVersion.getString("versionName")));
                try {
                    Object nouveautes = TransientConfig.translate("nouveautes");
                    JSONArray array = jsonVersion.getJSONArray("features");
                    for (int i = 0; i < array.length(); ++i) {
                        nouveautes = (String)nouveautes + "\n- " + array.getString(i);
                    }
                    this.features.setText((String)nouveautes);
                }
                catch (Exception nouveautes) {
                    // empty catch block
                }
                try {
                    String urlF = jsonVersion.getString("featuresUrl");
                    this.featuresUrl.setOnAction(actionEvent -> Main.main.getHostServices().showDocument(urlF));
                    this.featuresUrl.setText(TransientConfig.translate("enSavoirPlus"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        } else if (Main.getConfig().nbVoiesStimDispo > 0 || !Main.getConfig().biopodDispo) {
            this.gotoTestBiostim();
        } else {
            this.gotoTestBiopod();
        }
        this.updateWebContent(false);
    }

    @FXML
    private void download() {
        Update.download();
    }

    private void gotoTestBiostim() {
        this.consigne = Autotest.clicNext("branchement_biostim", new Object[0]);
        this.showNext(true);
        this.etape = Etape.CONNEXION_BIOSTIM;
    }

    private void testConnexionBiostim() {
        this.animAffichage(Autotest.getBiostimState());
        String diagString = Autotest.getDiagString();
        Platform.runLater(() -> {
            if (UsbBiostim.isConnexionBioStim()) {
                this.updateWebContent(false);
            }
            if (diagString != null) {
                FxUtils.setVisibility((Node)this.webDroite, true);
                HtmlToJavaFX.toTextFlow("<h1>" + TransientConfig.translate("help") + "</h1><font color=\"red\"><b>" + diagString + "</b></font>", this.webDroite);
            } else if (Main.getConfig().biopodDispo || BioPod.isConnected()) {
                this.gotoTestBiopod();
            }
        });
    }

    private void gotoTestBiopod() {
        this.consigne = Autotest.clicNext("branchement_biopod", new Object[0]);
        this.showNext(true);
        this.etape = Etape.CONNEXION_BIOPOD;
    }

    private void testConnexionBiopod() {
        this.animAffichage(Autotest.getBiopodState());
    }

    public static Utils.Tuple<Boolean, String> getMainState() {
        boolean stop = false;
        jsonVersion = CloudManager.checkLatestVersion();
        Object res = "";
        res = (String)res + String.format("<b>%20s : %s (%d)</b>", TransientConfig.translate("version"), Autotest.isOK(Main.getConfig().etatCloud == 0 || Main.getConfig().etatCloud == 2, Version.versionSoft), Version.numVersionSoft);
        if (Computer.isWindows()) {
            res = Security.verifCheckSum == 1 ? (String)res + "<br>              !! CheckSum ??? !!" : (String)res + String.format("<br>%20s : %s", "CheckSum", Autotest.isOK(Security.verifCheckSum == 0));
        }
        if (Main.getConfig().modeDemo) {
            res = (String)res + "<br>               !! Demo mode !!";
        }
        if (Main.getConfig().isVerrouilleTotal()) {
            res = (String)res + "<br><br>          <b>" + TransientConfig.translate("verrouille") + "</b>";
            stop = true;
        } else if (Main.getConfig().isVerrouillePartiel()) {
            res = (String)res + "<br>        " + TransientConfig.translate("verrouille_partiel");
        }
        if (Main.getConfig().biopodDispo || Main.getConfig().numSerieBiopod != 0 || Main.getConfig().nbVoiesStimDispo > 0) {
            res = (String)res + Autotest.addCenteredString(TransientConfig.translate("appareil_dispo"));
            if (Main.getConfig().nbVoiesStimDispo > 0) {
                res = (String)res + String.format("<br>%20s : %06d", "BioStim", Main.getConfig().numero_serie);
            }
            if (Main.getConfig().biopodDispo) {
                res = (String)res + String.format("<br>%20s : BF-%05d", "BioPod Full", Main.getConfig().numSerieBiopod);
            } else if (Main.getConfig().numSerieBiopod != 0) {
                res = (String)res + String.format("<br>%20s : BF-%05d", "BioPod Link", Main.getConfig().numSerieBiopod);
            }
        } else {
            res = (String)res + Autotest.addCenteredString(TransientConfig.translate("aucun_appareil"));
        }
        if (Main.getConfig().etatCloud == 2) {
            res = (String)res + "<br><h1>" + TransientConfig.translate("requireInternet") + "</h1>";
            stop = true;
        }
        return new Utils.Tuple<Boolean, Object>(stop, res);
    }

    private static String addCenteredString(String s) {
        int nb = 22 + s.length() / 2;
        return String.format("<br><br><b>%" + nb + "s</b>", s);
    }

    public static String getBiostimState() {
        String res = Autotest.addCenteredString("BioStim") + "<br>";
        int hardkey = Security.getHardKey();
        if (Computer.isWindows()) {
            boolean detection = hardkey != 0;
            res = res + String.format("%20s : %s %s<br>", TransientConfig.translate("Biostim_detecte"), Autotest.isOK(detection), detection ? " (" + Security.getBiostimPort() + " / " + Main.getConfig().version_biostim + ")" : "");
        }
        res = res + String.format("%20s : %s<br>", TransientConfig.translate("Connexion"), Autotest.isOK(UsbBiostim.isConnexionBioStim()));
        if (Main.getConfig().versionProtocole > 0) {
            res = res + String.format("%20s : ", TransientConfig.translate("Poire"));
            if (UsbBiostim.isConnexionBioStim()) {
                switch (UsbBiostim.getEtatPoire()) {
                    case 0: {
                        res = res + "<font color=\"green\">OK</font><br>";
                        break;
                    }
                    case 1: {
                        res = res + "<font color=\"red\">*** " + TransientConfig.translate("poire_debranchee") + " ***</font><br>";
                        break;
                    }
                    default: {
                        res = res + "<font color=\"red\">*** " + TransientConfig.translate("arret_urgence") + " ***</font><br>";
                        break;
                    }
                }
            } else {
                res = res + "---<br>";
            }
        }
        res = res + String.format("%20s : %s<br>", TransientConfig.translate("Biostim_active"), Autotest.isOK2(Main.getConfig().isActivated));
        res = res + String.format("%20s : %s (os %s)<br>", TransientConfig.translate("BT_active"), Autotest.isOK2(Main.getConfig().optionBluetooth), SondeBT.isOsCompatible() ? "OK" : "KO : " + System.getProperty("os.name"));
        if (Main.getConfig().versionProtocole != 0) {
            if (UsbBiostim.isConnexionBioStim()) {
                res = res + String.format("<br>%20s : %06d", TransientConfig.translate("serial"), Main.getConfig().numero_serie);
                res = res + String.format("<br>%20s : %06d", TransientConfig.translate("codeBiostim"), Main.getConfig().idBiostim);
            }
        } else {
            res = res + String.format("<br>%20s : %06d", TransientConfig.translate("codeBiostim"), hardkey);
            res = res + String.format("<br>%20s : %06d", "activation", Main.getConfig().activationKey);
            res = res + String.format("<br>%20s : %06d", "BT", Main.getConfig().btKey);
        }
        String port = UsbBiostim.serialPort != null && UsbBiostim.serialPort.isOpen() ? UsbBiostim.serialPort.getSystemPortName() : "---";
        res = res + String.format("<br>%20s : %s<br>", "port", port);
        if (!port.equals("---")) {
            res = res + String.format("%20s : %s<br>", TransientConfig.translate("connecte_depuis"), Utils.stringOfTime((int)((System.currentTimeMillis() - UsbBiostim.openDate) / 1000L)));
        }
        return res;
    }

    public static String getBiopodState() {
        String res = Autotest.addCenteredString("BioPod") + "<br>";
        res = res + String.format("%20s : %s<br>", TransientConfig.translate("Connexion"), Autotest.isOK(BioPod.isConnected()));
        if (BioPod.isConnected()) {
            String conn = SondeBT.connectionBioPod == 3 ? "Bluetooth" : UsbBiopod.serialPort.getSystemPortName();
            res = res + String.format("%20s : %s<br>", TransientConfig.translate("Connexion"), conn);
        }
        res = res + String.format("%20s : BF-%05d<br>", TransientConfig.translate("serial"), Main.getConfig().numSerieBiopod);
        res = res + String.format("%20s : %06d<br>", TransientConfig.translate("codeBiopod"), Main.getConfig().idBiopod);
        return res;
    }

    public static String getPortsState() {
        ArrayList<SerialPort> portsInit = RS232.getPortListWithConnected();
        Object res = String.format("<br><br>%20s : %s", TransientConfig.translate("ports"), Arrays.toString(portsInit.stream().map(port -> port.getSystemPortName() + " : " + port.getPortDescription()).toArray()));
        res = (String)res + String.format("<br>%20s : %s", TransientConfig.translate("portsBiostim"), portsInit.stream().filter(p -> p.getPortDescription().contains("BioStim")).map(SerialPort::getSystemPortName).collect(Collectors.toList()));
        res = (String)res + String.format("<br>%20s : %s", TransientConfig.translate("portsBiopod"), portsInit.stream().filter(p -> p.getPortDescription().contains("STM32")).map(SerialPort::getSystemPortName).collect(Collectors.toList()));
        return res;
    }

    public static String getState() {
        return "<pre>" + Autotest.getMainState().second() + Autotest.getBiostimState() + Autotest.getBiopodState() + Autotest.getPortsState() + "</pre>";
    }

    public static String getDiagString() {
        String diagString = null;
        if (Computer.isWindows() && Security.getHardKey() == 0) {
            diagString = TransientConfig.translate("brancher_biostim");
        } else if (!UsbBiostim.isConnexionBioStim()) {
            diagString = UsbBiostim.serialPort != null && UsbBiostim.serialPort.isOpen() && System.currentTimeMillis() - UsbBiostim.openDate > 10000L ? TransientConfig.translate("connexion_bloque") : TransientConfig.translate("allumer_biostim");
        } else if (UsbBiostim.getEtatPoire() != 0) {
            diagString = TransientConfig.translate("probleme_poire");
        }
        return diagString;
    }

    private void testElectrodeDecollee() {
        this.valide = this.valide + "<p/><b>" + TransientConfig.translate("test_circuit_ouvert") + "</b><br>";
        this.consigne = TransientConfig.translate("test_en_cours", "A");
        this.updateWebContent(true);
        try {
            this.electrodeDecolleeA = this.testStim(0);
            this.valide = this.valide + String.format("<br>%20s : %s", "A", Autotest.isOK(this.electrodeDecolleeA < 8, String.format("%d mA", this.electrodeDecolleeA)));
            if (Main.getConfig().nbVoiesStim() == 2) {
                this.consigne = TransientConfig.translate("test_en_cours", "B");
                this.updateWebContent(true);
                this.electrodeDecolleeB = this.testStim(1);
                this.valide = this.valide + String.format("<br>%20s : %s", "B", Autotest.isOK(this.electrodeDecolleeB < 8, String.format("%d mA", this.electrodeDecolleeB)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.stopStim();
        this.etape = Etape.CCRNA;
        this.consigne = Autotest.clicNext("connecter_rouge_noir", "A");
        this.startFilm("https://mazetsante.fr/biostim/videos/rougenoir.mp4");
        this.updateWebContent(false);
        this.showNext(true);
    }

    private void testCourtCircuitRougeNoir(int voie) {
        this.consigne = TransientConfig.translate("test_en_cours", voie == 0 ? "A" : "B");
        if (this.firstRougeNoir) {
            this.firstRougeNoir = false;
            this.valide = this.valide + "<p/><b>" + TransientConfig.translate("test_rouge_noir") + "</b><br>";
        }
        this.updateWebContent(true);
        Platform.runLater(() -> FxUtils.setVisibility(this.graphique, false));
        int niv = this.testStim(voie);
        if (voie == 0) {
            this.stimMaxA = niv;
        } else {
            this.stimMaxB = niv;
        }
        this.valide = this.valide + String.format("<br>%20s : %s", voie == 0 ? "A" : "B", Autotest.isOK(niv == 10, String.format("%d mA", niv)));
        int val = this.getValStab(voie);
        if (voie == 0) {
            this.bfbCcRNA = val;
        } else {
            this.bfbCcRNB = val;
        }
        if (niv != 10) {
            this.consigne = Autotest.clicRetry("err_cordon", new Object[0]);
            this.showRetry(true);
        } else {
            this.consigne = "";
        }
        if (voie == 0 && Main.getConfig().nbVoiesStim() == 2) {
            this.etape = Etape.CCRNB;
            this.consigne = this.consigne + Autotest.clicNext("connecter_rouge_noir", "B");
            this.startFilm("https://mazetsante.fr/biostim/videos/aversb.mp4");
        } else {
            this.etape = Etape.CCJNA;
            this.consigne = this.consigne + Autotest.clicNext("connecter_jaune_noir", "A");
            this.startFilm("https://mazetsante.fr/biostim/videos/jaunenoir.mp4");
        }
        this.showNext(true);
        this.updateWebContent(false);
    }

    private void testCourtCircuitJauneNoir(int voie) {
        this.consigne = TransientConfig.translate("test_en_cours", voie == 0 ? "A" : "B");
        if (this.firstJauneNoir) {
            this.firstJauneNoir = false;
            this.valide = this.valide + "<p><b>" + TransientConfig.translate("test_jaune_noir") + "</b><br>";
        }
        this.updateWebContent(true);
        Platform.runLater(() -> FxUtils.setVisibility(this.graphique, false));
        int niv = this.testStim(voie);
        this.afficheBFB(voie);
        int val = this.getValStab(voie);
        if (voie == 0) {
            this.bfbCcJNA = val;
        } else {
            this.bfbCcJNB = val;
        }
        val = Math.abs(val);
        this.valide = this.valide + String.format("<br>%20s : %s", voie == 0 ? "A" : "B", Autotest.isOK(val > 1000, String.format("%d \u00b5V", val)));
        if (niv > 8) {
            this.consigne = Autotest.clicRetry("err_rouge_noir", new Object[0]);
            this.showRetry(true);
        } else if (val < 1000) {
            this.consigne = Autotest.clicRetry("err_cordon", new Object[0]);
            this.showRetry(true);
        } else {
            Platform.runLater(() -> FxUtils.setVisibility(this.graphique, false));
            this.consigne = "";
        }
        if (voie == 0 && Main.getConfig().nbVoiesStim() == 2) {
            this.consigne = this.consigne + Autotest.clicNext("connecter_jaune_noir", "B");
            this.startFilm("https://mazetsante.fr/biostim/videos/aversb.mp4");
            this.showNext(true);
        } else {
            this.testFini = 1;
            if (this.consigne.isEmpty()) {
                this.sendCloud();
                this.afficheDiagFinal();
            } else {
                this.showNext(true);
                this.consigne = this.consigne + Autotest.clicNext("fin_diag", new Object[0]);
            }
        }
        this.updateWebContent(false);
        this.etape = Main.getConfig().nbVoiesStim() == 1 ? Etape.FIN : this.etape.suivant();
    }

    private void afficheDiagFinal() {
        Platform.runLater(() -> {
            this.consigne = "";
            this.updateWebContent(true);
            FxUtils.setVisibility(this.graphique, false);
            FxUtils.setVisibility((Node)this.webDroite, true);
            Object diagString = null;
            if (this.electrodeDecolleeA > 8 || this.electrodeDecolleeB > 8) {
                diagString = TransientConfig.translate("prevoir_maintenance");
            } else if (this.stimMaxA < 10 || this.stimMaxB < 10 || this.bfbCcJNA < 1000 || this.bfbCcJNB < 1000) {
                diagString = TransientConfig.translate("pb_cordon");
            }
            diagString = diagString == null ? "<h1><font color=\"green\">" + TransientConfig.translate("tout_ok") + "</font></h1>" : "<h1>" + TransientConfig.translate("help") + "</h1><font color=\"red\"><b>" + (String)diagString + "</b></font>";
            HtmlToJavaFX.toTextFlow((String)diagString, this.webDroite);
        });
    }

    private void sendCloud() {
        if (this.testFini == 1) {
            new Thread(() -> {
                Date now = new Date();
                String url = String.format("https://www.mazetsante.fr/biostim/send_autotest.php?date=%s&heure=%s&num_serie=%d&soft=%d&secua=%d&secub=%d&stima=%d&bfbrna=%d&stimb=%d&bfbrnb=%d&bfbjna=%d&bfbjnb=%d", Utils.cloudDateFormat.format(now), Utils.cloudTimeFormat.format(now), Main.getConfig().numero_serie, Version.numVersionSoft, this.electrodeDecolleeA, this.electrodeDecolleeB, this.stimMaxA, this.bfbCcRNA, this.stimMaxB, this.bfbCcRNB, this.bfbCcJNA, this.bfbCcJNB);
                try {
                    String res = Utils.getHttp(url);
                    System.out.format("autotest sent to cloud : %s\n%s\n", url, res);
                }
                catch (Exception e) {
                    Utils.debugInfo("Erreur cloud save : %s", e.toString());
                }
            }).start();
        }
        this.testFini = 2;
    }

    private int testStim(int voie) {
        int niv = 0;
        try {
            this.startStim();
            while (niv < 20 && !this.secuA && !this.secuB) {
                UsbBiostim.amplitudeVoie(voie, (double)(++niv) / 2.0);
                Utils.sleep(100L);
            }
            UsbBiostim.amplitudeVoie(voie, 0.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopStim();
        return niv / 2;
    }

    private void startStim() {
        this.stimEnCours = true;
        UsbBiostim.initStimInnervee(2, 50L, 0L, 0L, 0L, 50L, 0L, 0L, 0L, 0, 50, 350, 50, 350, 0, 0, 0, 0, 0, 0, 0, 0, 0, false, false);
        Utils.sleep(1000L);
        this.secuA = false;
        this.secuB = false;
    }

    private void stopStim() {
        if (this.stimEnCours) {
            UsbBiostim.activateGenerateur(2, false);
        }
        this.stimEnCours = false;
    }

    private void afficheBFB(int voie) {
        XYChart.Series series = new XYChart.Series();
        Platform.runLater(() -> {
            this.graphique.getData().clear();
            this.graphique.getData().add((Object)series);
            FxUtils.setVisibility(this.graphique, true);
            new Thread(() -> {
                double start = (double)System.currentTimeMillis() / 1000.0;
                while (this.graphique.isVisible() && this.etape != Etape.OUT) {
                    Platform.runLater(() -> {
                        double now = (double)System.currentTimeMillis() / 1000.0;
                        series.getData().add((Object)new XYChart.Data((Object)(now - start), (Object)this.getVal(voie)));
                        if (series.getData().size() > 200) {
                            series.getData().removeFirst();
                        }
                        double debutAff = Math.max(0.0, now - start - 20.0);
                        ((NumberAxis)this.graphique.getXAxis()).setLowerBound(debutAff);
                        ((NumberAxis)this.graphique.getXAxis()).setUpperBound(debutAff + 20.0);
                    });
                    Utils.sleep(100L);
                }
            }).start();
        });
    }

    private int getValStab(int voie) {
        int i;
        Utils.sleep(2000L);
        double val = 0.0;
        int good = 0;
        for (i = 0; i < 100 && good < 20; ++i) {
            double newVal = this.getVal(voie);
            double diff = Math.abs(val - newVal);
            if (diff < 10.0 || diff < 0.1 * val) {
                ++good;
            } else {
                val = newVal;
            }
            Utils.sleep(100L);
        }
        return (int)(i >= 100 ? -val : val);
    }

    private double getVal(int voie) {
        return Biostim.getVoie(voie == 0 ? 0 : 1);
    }

    private static String clicNext(String key, Object ... args) {
        return TransientConfig.translate(key, args) + ",\n" + TransientConfig.translate("clic_next");
    }

    private static String clicRetry(String key, Object ... args) {
        return TransientConfig.translate(key, args) + ",\n" + TransientConfig.translate("clic_retry") + "\n\n" + TransientConfig.translate("else") + ", ";
    }

    private static String isOK(boolean b) {
        if (b) {
            return "<font color=\"green\">OK</font>";
        }
        return "<font color=\"red\">*** KO ***</font>";
    }

    private static String isOK(boolean b, String s) {
        if (b) {
            return "<font color=\"green\">" + s + "</font>";
        }
        return "<font color=\"red\">*** " + s + " ***</font>";
    }

    private static String isOK2(boolean b) {
        if (b) {
            return "<font color=\"green\">OK</font>";
        }
        return TransientConfig.translate("non");
    }

    private static String isOK2(int option) {
        if (option == 2) {
            return "<font color=\"green\">OK</font>";
        }
        if (option == 1) {
            return "Demo";
        }
        return TransientConfig.translate("non");
    }

    private void startFilm(String film) {
        this.mediaDroite.setVisible(true);
        Platform.runLater(() -> {
            this.mediaDroite.setFitWidth(this.regionDroite.getWidth() - 10.0);
            Media media = new Media(film);
            MediaPlayer mediaPlayer = new MediaPlayer(media);
            mediaPlayer.setOnError(() -> Utils.debugInfo("Erreur MediaPlayer : " + String.valueOf(mediaPlayer.getError())));
            mediaPlayer.setCycleCount(-1);
            PauseTransition delay = new PauseTransition(Duration.millis((double)200.0));
            delay.setOnFinished(actionEvent -> {
                this.mediaDroite.setMediaPlayer(mediaPlayer);
                mediaPlayer.play();
            });
            delay.play();
        });
    }

    private void stopFilm() {
        try {
            if (this.mediaDroite.isVisible()) {
                this.mediaDroite.setVisible(false);
                MediaPlayer mp = this.mediaDroite.getMediaPlayer();
                if (mp != null) {
                    mp.stop();
                    mp.dispose();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void sendCommande() {
        String msg = this.commande.getText();
        if (msg.equals("next") && (this.etape == Etape.CONNEXION_BIOSTIM || this.etape == Etape.CONNEXION_BIOPOD)) {
            this.etape = Etape.ELECTRODE_DECOLLEE;
            this.consigne = Autotest.clicNext("debrancher_cables", new Object[0]);
            FxUtils.setVisibility((Node)this.next, true);
            this.updateWebContent(false);
        } else {
            DebugView.sendCommande(msg, this);
        }
    }

    @Override
    public void exitAction() {
        this.stopStim();
        this.stopFilm();
        this.etape = Etape.OUT;
        this.sendCloud();
    }

    private static enum Etape {
        VERSION,
        CONNEXION_BIOSTIM,
        CONNEXION_BIOPOD,
        ELECTRODE_DECOLLEE,
        CCRNA,
        CCRNB,
        CCJNA,
        CCJNB,
        FIN,
        OUT;


        public Etape suivant() {
            return Etape.values()[this.ordinal() + 1];
        }

        public Etape retry() {
            int delta = Main.getConfig().nbVoiesStim() == 2 ? 1 : 2;
            return Etape.values()[this.ordinal() - delta];
        }
    }
}

