/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.configuration;

import com.mazet.biostim.comm.BioPod;
import com.mazet.biostim.comm.RawDataBioPod;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Fft;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.utilsfx.HeatChart;
import com.mazet.biostim.view.Controller;
import java.io.FileWriter;
import java.util.Objects;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

public class BiopodTest
extends Controller {
    private static final double dureeVisu = 30.0;
    AnimationTimer timer;
    @FXML
    private CheckBox checkFFT;
    @FXML
    private ComboBox<String> nbFft;
    @FXML
    private ComboBox<String> voie;
    @FXML
    private CheckBox filtrage;
    @FXML
    private CheckBox reconstruction;
    @FXML
    private Button save;
    @FXML
    private Label pertes;
    @FXML
    private LineChart<Number, Number> chart;
    @FXML
    private NumberAxis xAxis;
    @FXML
    private NumberAxis yAxis;
    @FXML
    private ImageView ivHeatChart;
    HeatChart heatChart;
    @FXML
    private HBox hboxFft;
    @FXML
    private BarChart<String, Number> fft;
    @FXML
    private NumberAxis yFft;
    @FXML
    private TextField freqMin;
    @FXML
    private TextField freqMax;
    @FXML
    private TextField correction;
    private static final int minFftAff = 10;
    private static final int maxFftAff = 250;
    private XYChart.Series<Number, Number> series;
    private XYChart.Series<Number, Number> series2;
    int voieFft = 1;
    double rmsCalc = 0.0;
    int minFreq = 10;
    int maxFreq = 250;
    double facteurCorrection = 1.0;
    double[] base = new double[Fft.n];
    double[] r = new double[Fft.n];
    private static double[] real = new double[Fft.n];
    private double calibre = 0.0;
    public static FileWriter enregEnCours = null;

    @Override
    public void setMain() {
        super.setMain();
        BioPod.startRawA();
        this.initGraph();
        this.initHeatChart();
        this.initFft();
        this.voie.getSelectionModel().selectedIndexProperty().addListener((observableValue, number, number2) -> this.changeVoie());
        this.voie.getSelectionModel().select(0);
        this.timer = new AnimationTimer(this){
            final /* synthetic */ BiopodTest this$0;
            {
                BiopodTest biopodTest = this$0;
                Objects.requireNonNull(biopodTest);
                this.this$0 = biopodTest;
            }

            public void handle(long now) {
                if (this.this$0.filtrage.isSelected()) {
                    this.this$0.addDataToGraphique(this.this$0.voieFft == 1 ? Biostim.voieBioPodA : Biostim.voieBioPodB);
                } else {
                    this.this$0.addDataToGraphique(this.this$0.voieFft == 1 ? BioPod.biopodA : BioPod.biopodB);
                }
                if (this.this$0.checkFFT.isSelected()) {
                    this.this$0.afficheAnalyse();
                }
            }
        };
        this.timer.start();
    }

    @Override
    public void exitAction() {
        BioPod.stopRawA();
        BioPod.stopRawB();
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    private void initGraph() {
        this.xAxis.setForceZeroInRange(false);
        this.xAxis.setAutoRanging(false);
        this.xAxis.setTickLabelsVisible(false);
        this.xAxis.setTickUnit(1.0);
        this.yAxis.setAutoRanging(true);
        this.yAxis.setForceZeroInRange(true);
        this.yAxis.setTickLabelsVisible(true);
        this.chart.setAnimated(false);
        this.chart.setCreateSymbols(false);
        this.chart.setLegendVisible(false);
        this.series = new XYChart.Series();
        this.chart.getData().add(this.series);
        this.series2 = new XYChart.Series();
        this.chart.getData().add(this.series2);
    }

    private void initHeatChart() {
        if (this.chart.getWidth() > 30.0) {
            this.heatChart = new HeatChart(this.ivHeatChart, (int)this.chart.getWidth(), (int)this.chart.getHeight() * 2 / 3);
        } else {
            new Thread(() -> {
                Utils.sleep(50L);
                Platform.runLater(this::initHeatChart);
            }).start();
        }
    }

    private void initFft() {
        for (int i = 0; i < 10; ++i) {
            this.nbFft.getItems().add((Object)Integer.toString(1 << i + 6));
        }
        this.nbFft.getSelectionModel().selectedIndexProperty().addListener((observableValue, number, number2) -> this.changeSizes());
        this.nbFft.getSelectionModel().select(3);
        this.yFft.setAutoRanging(false);
        this.yFft.setForceZeroInRange(true);
        this.yFft.setTickLabelsVisible(true);
        this.fft.setAnimated(false);
        this.fft.setLegendVisible(false);
    }

    private void changeSizes() {
        Fft.resetSize(Integer.parseInt((String)this.nbFft.getSelectionModel().getSelectedItem()));
        this.base = new double[Fft.n];
        this.r = new double[Fft.n];
        real = new double[Fft.n];
    }

    private void changeVoie() {
        this.voieFft = 1 + this.voie.getSelectionModel().getSelectedIndex();
        if (this.voieFft == 2) {
            BioPod.startRawB();
        }
        this.resetCalibre();
    }

    @FXML
    private void activateFFT() {
        FxUtils.setVisibility((Node)this.ivHeatChart, this.checkFFT.isSelected());
        FxUtils.setVisibility((Node)this.hboxFft, this.checkFFT.isSelected());
    }

    private void addDataToGraphique(double data) {
        if (data < 1.0E-5) {
            data = 0.0;
        }
        double dureeMilli = (double)System.currentTimeMillis() / 1000.0;
        double debutAffichage = dureeMilli - 30.0;
        this.xAxis.setLowerBound(debutAffichage);
        this.xAxis.setUpperBound(dureeMilli);
        this.series.getData().add((Object)new XYChart.Data((Object)dureeMilli, (Object)data));
        while (((Number)((XYChart.Data)this.series.getData().getFirst()).getXValue()).doubleValue() < debutAffichage - 0.01) {
            this.series.getData().removeFirst();
        }
        if (this.reconstruction.isSelected()) {
            this.series2.getData().add((Object)new XYChart.Data((Object)dureeMilli, (Object)(this.rmsCalc * 100000.0)));
        }
        while (!this.series2.getData().isEmpty() && ((Number)((XYChart.Data)this.series2.getData().getFirst()).getXValue()).doubleValue() < debutAffichage - 0.01) {
            this.series2.getData().removeFirst();
        }
    }

    private void afficheAnalyse() {
        RawDataBioPod raw;
        RawDataBioPod rawDataBioPod = raw = this.voieFft == 1 ? BioPod.rawBiopodA : BioPod.rawBiopodB;
        if (raw.getTamponRaw(real, Fft.n)) {
            double[] img = new double[Fft.n];
            this.chooseFft(real, img);
        }
    }

    void chooseFft(double[] real, double[] img) {
        int i;
        Fft.fft(real, img);
        for (i = 0; i < Fft.n; ++i) {
            this.r[i] = this.affiche1(real[i], img[i]);
        }
        this.rmsCalc = 0.0;
        for (i = this.minFreq * Fft.n / 2000; i < this.maxFreq * Fft.n / 2000; ++i) {
            double val = Math.max(0.0, this.r[i] - this.base[i]);
            this.rmsCalc += val * val;
        }
        this.rmsCalc = this.facteurCorrection * Math.sqrt(this.rmsCalc) / (double)Fft.n;
        XYChart.Series series1 = new XYChart.Series();
        int minv = 10 * Fft.n / 2000;
        int maxv = 250 * Fft.n / 2000;
        int pas = Fft.n > 2048 ? Fft.n / 2048 : 1;
        double max = 0.0;
        for (int i2 = minv; i2 < maxv; i2 += pas) {
            int freq = i2 * 2000 / Fft.n;
            String label = Integer.toString(freq);
            max = Math.max(this.r[i2], max);
            series1.getData().add((Object)new XYChart.Data((Object)label, (Object)this.r[i2]));
        }
        if (max > this.calibre) {
            this.calibre = max;
            this.yFft.setUpperBound(this.calibre);
        }
        this.fft.getData().setAll((Object[])new XYChart.Series[]{series1});
        if (this.heatChart != null) {
            this.heatChart.addLine(this.r, minv, maxv);
        }
    }

    @FXML
    public void resetCalibre() {
        this.calibre = 0.0;
        if (this.heatChart != null) {
            this.heatChart.resetCalibre();
        }
        this.series.getData().clear();
        this.series2.getData().clear();
    }

    double affiche1(double real, double img) {
        return Math.sqrt(real * real + img * img);
    }

    double affiche2(double real, double img) {
        return Math.atan2(img, real);
    }

    public void enregistrer() {
        try {
            if (enregEnCours == null) {
                this.save.setText("Stopper Enregistrement");
                enregEnCours = new FileWriter(Computer.absolutePath + "raw_data_biopod.csv");
            } else {
                this.save.setText("D\u00e9marrer Enregistrement");
                enregEnCours.close();
                enregEnCours = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBase() {
        System.arraycopy(this.r, 0, this.base, 0, Fft.n);
    }

    public void setFreq() {
        this.minFreq = Integer.parseInt(this.freqMin.getText());
        this.maxFreq = Integer.parseInt(this.freqMax.getText());
        this.facteurCorrection = Double.parseDouble(this.correction.getText().replace(',', '.'));
    }

    @Override
    public void updateAffPertes(float pertesInst, int tramesParCoupure) {
        Platform.runLater(() -> this.pertes.setText(String.format("Pertes : %.1f%%, coupure toutes les %d trames)", Float.valueOf(pertesInst * 100.0f), tramesParCoupure)));
    }
}

