/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme;

import com.mazet.biostim.Main;
import com.mazet.biostim.ProgEnCours;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Config;
import com.mazet.biostim.utils.Skin;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.utilsfx.HtmlToJavaFX;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.programme.UserDataUpdate;
import com.mazet.biostim.zdata.AnimationStyle;
import com.mazet.biostim.zdata.Pageprogramme;
import com.mazet.biostim.zdata.Profil;
import com.mazet.biostim.zdata.ProfilConcatSimple;
import com.mazet.biostim.zdata.Programme;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.TextFlow;
import javafx.stage.FileChooser;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class ProgListController
extends Controller {
    @FXML
    private Label title;
    @FXML
    private GridPane mainGrid;
    @FXML
    private HBox hboxBoutonsFamille;
    @FXML
    private ToggleButton boutonPredef;
    @FXML
    private ToggleButton boutonPerso;
    @FXML
    private VBox listProgrammes;
    @FXML
    private FlowPane enteteBFB;
    @FXML
    private HBox hboxTempsProg;
    @FXML
    private Label tempsProg;
    @FXML
    private Button mainPlayButton;
    @FXML
    private Button save;
    @FXML
    private Button info;
    @FXML
    private Label titleProg;
    @FXML
    private VBox vboxContent;
    @FXML
    private ScrollPane scrollDroite;
    @FXML
    private ComboBox<String> choixVoie1;
    @FXML
    private ComboBox<String> choixVoie2;
    @FXML
    private ComboBox<String> choixAnimation;
    @FXML
    private ComboBox<String> choixDefilement;
    @FXML
    private ScrollPane infoPane;
    @FXML
    private TextFlow infoFlow;
    private ArrayList<ComboBox<Programme>> progList;
    private ArrayList<ComboBox<String>> repetList;
    private ArrayList<Label> dureeList;
    private Programme progSelect;
    private ToggleButton buttonSelected;
    private Pageprogramme firstPage;
    private boolean showCustom;
    private boolean saveAsEnCours = false;
    private Timeline holdBouton;
    private int compteurTemp;
    private boolean invalidateCallbacks = true;
    private ArrayList<Programme> progsOk;
    private static final ObservableList<String> comboRepet = FXCollections.observableArrayList((Object[])new String[]{"1 *", "2 *", "3 *", "4 *", "5 *", "6 *", "7 *", "8 *", "9 *", "10 *"});
    private static final double sizeObjet = 30.0;
    private final ArrayList<Rectangle> objetsCatch = new ArrayList();
    private ImagePattern pinceau;
    private int numPinceau = 0;
    private static final ImagePattern defaultImageCatch = new ImagePattern(new Image(Objects.requireNonNull(Main.class.getResourceAsStream("/img/icone.png"))));
    private boolean isDessinePressed;
    private boolean noDrag;
    private int dragPos;

    @Override
    public void afficheOuverture() {
        Utils.debugInfo("Ouverture de la page ProgListController %s", Main.getCategorie());
    }

    @Override
    public void setMain() {
        if (Main.progEnCours != null) {
            if (Main.getCategorie().equals("Balance") && SondeBT.connectionBiomoov < 3) {
                Main.menu.goToHome();
            }
            this.progSelect = Main.progEnCours.currentProgram;
            this.showCustom = this.progSelect.isCustom();
            Main.progEnCours = null;
        }
        super.setMain();
        this.title.setText(TransientConfig.persoTranslate(Main.getCategorie()));
        this.createCallbackBFB();
        FxUtils.adjustHboxReglageStyle(this.hboxTempsProg, "00:00", 1.2, (Region)this.mainPlayButton);
        this.refreshPage();
    }

    public void toCustom() {
        if (!this.showCustom) {
            this.showCustom = true;
            this.progSelect = null;
            this.refreshPage();
        } else {
            this.boutonPerso.setSelected(true);
        }
    }

    public void toPredef() {
        if (this.showCustom) {
            this.showCustom = false;
            this.progSelect = null;
            this.refreshPage();
        } else {
            this.boutonPredef.setSelected(true);
        }
    }

    private void refreshPage() {
        this.listProgrammes.getChildren().clear();
        this.listProgrammes.setPadding(new Insets(10.0, Main.primaryStage.getWidth() / 64.0, 30.0, Main.primaryStage.getWidth() / 32.0));
        boolean pageFavoris = Main.getCategorie().equals("favoris");
        ArrayList<Programme> customProg = Programme.getCustomProgrammes(Main.getCategorie(), pageFavoris, false);
        customProg = Programme.cleanList(customProg);
        if (customProg.isEmpty()) {
            this.showCustom = false;
        }
        FxUtils.setVisibility((Node)this.hboxBoutonsFamille, !pageFavoris && !customProg.isEmpty());
        this.boutonPredef.setSelected(!this.showCustom);
        this.boutonPerso.setSelected(this.showCustom);
        if (this.showCustom || pageFavoris) {
            for (Programme prog : customProg) {
                this.createButton(prog);
            }
        }
        if (!this.showCustom || pageFavoris) {
            ArrayList<Programme> staticProg = Programme.cleanList(Programme.getStaticProgrammes(Main.getCategorie(), pageFavoris));
            for (Programme prog : staticProg) {
                this.createButton(prog);
            }
        }
        if (!this.listProgrammes.getChildren().isEmpty()) {
            this.listProgrammes.getChildren().removeLast();
        }
        if (this.progSelect != null) {
            this.afficheDroite();
        } else {
            this.mainGrid.getChildren().clear();
        }
    }

    private void createButton(Programme progByButton) {
        if (this.progSelect == null) {
            this.progSelect = progByButton;
        } else if (this.progSelect.getId() == progByButton.getId()) {
            if (!this.saveAsEnCours) {
                progByButton.copyParams(this.progSelect);
            }
            this.progSelect = progByButton;
        }
        ToggleButton butProg = new ToggleButton(progByButton.getNom());
        butProg.setOnMouseClicked(e -> this.mouseCliqueProg((MouseEvent)e, butProg, progByButton));
        butProg.getStyleClass().add((Object)"buttonProg");
        if (progByButton.getId() == this.progSelect.getId()) {
            butProg.setSelected(true);
            this.buttonSelected = butProg;
        }
        Button butGo = new Button();
        butGo.getStyleClass().addAll((Object[])new String[]{"buttonListProgFavEtGo", "buttonListProgGO"});
        butGo.setOnMouseClicked(mouseEvent -> new ProgEnCours(progByButton));
        ToggleButton butFav = new ToggleButton();
        butFav.setSelected(progByButton.isFavoris());
        butFav.getStyleClass().addAll((Object[])new String[]{"buttonListProgFavEtGo", "buttonListProgFav"});
        butFav.setOnMouseClicked(mouseEvent -> progByButton.toggleFavoris());
        GridPane gridTemp = new GridPane();
        gridTemp.add((Node)butProg, 0, 0, 4, 1);
        gridTemp.add((Node)butGo, 3, 0);
        gridTemp.add((Node)butFav, 0, 0);
        int padRight = 80;
        if (progByButton.pngExist()) {
            double width = Main.primaryStage.getWidth() / 20.0;
            padRight += (int)(width * 1.2);
            Region profil = new Region();
            profil.setMouseTransparent(true);
            profil.getStyleClass().add((Object)"buttonListProgProfil");
            profil.setStyle(String.format("-fx-min-width: %.0fpx;", width));
            FxUtils.setBackGround(profil, progByButton.getId() + ".png", width, false);
            gridTemp.add((Node)profil, 2, 0);
        }
        butProg.setStyle(String.format("-fx-padding: 0px %dpx 0px 120px", padRight));
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.ALWAYS);
        gridTemp.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), columnConstraints});
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setValignment(VPos.CENTER);
        rowConstraints.setVgrow(Priority.ALWAYS);
        gridTemp.getRowConstraints().add((Object)rowConstraints);
        double sizeAnchor = Skin.getButtonHeight();
        gridTemp.setMaxHeight(sizeAnchor);
        gridTemp.setPrefHeight(sizeAnchor);
        gridTemp.setMinHeight(sizeAnchor);
        this.listProgrammes.getChildren().addAll((Object[])new Node[]{gridTemp, new Separator()});
    }

    public void afficheDroite() {
        boolean isBilan;
        this.vboxContent.getChildren().clear();
        this.scrollDroite.setVvalue(0.0);
        this.firstPage = this.progSelect.getFirstPage();
        this.titleProg.setText(this.progSelect.getNom().replace('\n', ' '));
        this.tempsProg.setText(Utils.stringOfTime(this.progSelect.getDuree()));
        FxUtils.setVisibility((Node)this.save, this.progSelect.isCustom());
        boolean containBFB = this.progSelect.containBFB();
        boolean bl2 = isBilan = this.firstPage.getType() == -1 || this.firstPage.getType() == -2;
        if (containBFB || isBilan) {
            this.invalidateCallbacks = true;
            int progType = this.progSelect.getType();
            this.choixVoie1.getItems().setAll((Collection)FXCollections.observableArrayList(Biostim.getVoies()));
            if (this.progSelect.getVoieBFB1() == -1) {
                this.progSelect.setVoieBFB1(Biostim.defaultVoie1());
            }
            if (this.progSelect.getVoieBFB2() == -1 && progType != 8) {
                this.progSelect.setVoieBFB2(Biostim.defaultVoie2());
            }
            this.choixVoie1.getSelectionModel().select(Biostim.getVoies().indexOf(Biostim.nomOfVoie(this.progSelect.getVoieBFB1())));
            if (this.choixVoie1.getSelectionModel().getSelectedIndex() == -1) {
                this.progSelect.setVoieBFB1(Biostim.defaultVoie1());
                this.choixVoie1.getSelectionModel().select(Biostim.getVoies().indexOf(Biostim.nomOfVoie(this.progSelect.getVoieBFB1())));
            }
            ObservableList l2 = FXCollections.observableArrayList((Object[])new String[]{"-"});
            l2.addAll(Biostim.getVoies());
            this.choixVoie2.getItems().setAll((Collection)l2);
            int pos2 = this.progSelect.getVoieBFB2() == -1 ? 0 : 1 + Biostim.getVoies().indexOf(Biostim.nomOfVoie(this.progSelect.getVoieBFB2()));
            this.choixVoie2.getSelectionModel().select(pos2);
            this.choixAnimation.getSelectionModel().select(this.progSelect.getChoixAnim_BFB());
            this.choixAnimation.setVisible(containBFB);
            this.choixDefilement.getSelectionModel().select(this.progSelect.isDefilement() ? (this.progSelect.ghost ? 2 : 0) : 1);
            this.choixDefilement.setVisible(containBFB);
            this.invalidateCallbacks = false;
            FxUtils.setVisibility(this.choixAnimation, progType != 8);
            FxUtils.setVisibility(this.choixDefilement, progType != 8);
            this.vboxContent.getChildren().addAll((Object[])new Node[]{this.enteteBFB, new Label()});
            if (this.progSelect.getCategorie().equals("Anorectal") && !isBilan) {
                CheckBox checkBox = new CheckBox(TransientConfig.translate("aidePlacementSonde"));
                checkBox.getStyleClass().add((Object)"labelConfiguration");
                checkBox.setSelected(this.progSelect.aidePlacementSondePression);
                checkBox.selectedProperty().addListener((observableValue, bl, n) -> {
                    this.progSelect.aidePlacementSondePression = n;
                });
                this.vboxContent.getChildren().add((Object)checkBox);
            }
        } else {
            this.vboxContent.getChildren().add((Object)new Label());
        }
        this.afficheFinDroite();
    }

    private void afficheFinDroite() {
        int phase = 1;
        int nbPages = this.progSelect.getListPage().size();
        boolean forceHtml = false;
        for (Pageprogramme pageProg : this.progSelect.getListPage()) {
            if (nbPages >= 2) {
                Object txt = pageProg.getType() >= 4 ? "biofeedback" : "stimulation";
                txt = " " + phase + ". " + TransientConfig.translate((String)txt);
                if (pageProg.getInfo() != null) {
                    txt = (String)txt + " (" + TransientConfig.translate(pageProg.getInfo()) + ")";
                }
                FlowPane fp = new FlowPane();
                if (pageProg.getDuree() != null) {
                    txt = (String)txt + " " + TransientConfig.translate("pendant") + " ";
                    Label duree = new Label(" " + Utils.stringOfTime(pageProg.getDuree()) + " ");
                    duree.getStyleClass().add((Object)"paramDyn");
                    fp.getChildren().addAll(this.creerBoutonReglable(duree, "dureePP", pageProg, null, null));
                }
                Label desc = new Label((String)txt);
                desc.getStyleClass().add((Object)"paramDyn");
                fp.getChildren().addFirst((Object)desc);
                fp.getStyleClass().add((Object)"titreCombine");
                this.vboxContent.getChildren().add((Object)fp);
            }
            switch (pageProg.getType()) {
                case 8: {
                    this.afficheCombine();
                    break;
                }
                case 5: {
                    this.afficheConcat(pageProg);
                    break;
                }
                case 12: {
                    this.afficheConcatSimple(pageProg);
                    break;
                }
                case 6: {
                    this.afficheDessineProfil();
                    break;
                }
                case 9: {
                    this.afficheAleatoire();
                    break;
                }
                case 7: {
                    this.afficheAjust(pageProg);
                    break;
                }
                case 10: {
                    this.afficheCatch(pageProg);
                    break;
                }
                case 13: {
                    this.afficheBalance();
                    break;
                }
                case 11: {
                    this.afficheBalance();
                    forceHtml = true;
                    break;
                }
                case -2: 
                case -1: {
                    forceHtml = true;
                    break;
                }
                case 1: {
                    this.vboxContent.getChildren().addAll((Object[])new Node[]{this.createTabStim(pageProg, true), new Label()});
                    break;
                }
                default: {
                    LineChart<Number, Number> profilChart = this.createGraphiqueBFB(pageProg);
                    this.vboxContent.getChildren().add(profilChart);
                    if (!(pageProg.getTrepos() > 0.01)) break;
                    this.vboxContent.getChildren().add((Object)this.createReglageRepos(pageProg, profilChart));
                }
            }
            ++phase;
        }
        this.afficheHtml();
        if (forceHtml) {
            this.info();
        }
    }

    private void createCallbackBFB() {
        if (Biostim.getVoies().size() < 2) {
            this.enteteBFB.getChildren().removeAll((Object[])new Node[]{this.choixVoie1, this.choixVoie2});
        } else {
            this.choixVoie1.getSelectionModel().selectedItemProperty().addListener((observableValue, string, string2) -> {
                if (!this.invalidateCallbacks) {
                    String nom = (String)this.choixVoie1.getSelectionModel().getSelectedItem();
                    this.progSelect.setVoieBFB1(Biostim.voieOfNom(nom));
                    this.afficheHtml();
                }
            });
            this.choixVoie2.getSelectionModel().selectedItemProperty().addListener((observableValue, string, string2) -> {
                if (!this.invalidateCallbacks) {
                    String nom = (String)this.choixVoie2.getSelectionModel().getSelectedItem();
                    this.progSelect.setVoieBFB2(Biostim.voieOfNom(nom));
                    this.afficheHtml();
                }
            });
        }
        ArrayList<AnimationStyle> animations = new ArrayList<AnimationStyle>();
        animations.addAll(AnimationStyle.selectedAnimations);
        animations.addAll(Main.getConfig().customAnimationList);
        String nom_defaut = String.format("%s: %s", TransientConfig.translate("animation_par_defaut"), ((AnimationStyle)animations.get(Main.getConfig().getAnimationParDefaut())).getTranslatedName());
        ObservableList animBFB = FXCollections.observableArrayList((Object[])new String[]{nom_defaut});
        for (AnimationStyle as : animations) {
            animBFB.add((Object)as.getTranslatedName());
        }
        this.choixAnimation.getItems().setAll((Collection)animBFB);
        this.choixAnimation.getSelectionModel().selectedItemProperty().addListener((observableValue, string, string2) -> {
            if (!this.invalidateCallbacks) {
                this.progSelect.setChoixAnim_BFB(this.choixAnimation.getSelectionModel().getSelectedIndex());
            }
        });
        this.choixDefilement.getItems().add((Object)TransientConfig.translate("defilement"));
        this.choixDefilement.getItems().add((Object)TransientConfig.translate("fixe"));
        this.choixDefilement.getItems().add((Object)TransientConfig.translate("reactif"));
        this.choixDefilement.getSelectionModel().selectedItemProperty().addListener((observableValue, string, string2) -> {
            if (!this.invalidateCallbacks) {
                int pos = this.choixDefilement.getSelectionModel().getSelectedIndex();
                this.progSelect.setDefilement(pos != 1);
                this.progSelect.ghost = pos == 2;
            }
        });
    }

    private void afficheHtml() {
        try {
            Object htmlString = Utils.readHtmlRes(this.progSelect.getLienHtml());
            if (this.progSelect.containBFB() || this.progSelect.getType() == 4) {
                String file;
                boolean gonio;
                int voie1 = this.progSelect.getVoieBFB1();
                int voie2 = this.progSelect.getVoieBFB2();
                boolean emg = voie1 == 0 || voie1 == 1 || voie2 == 0 || voie2 == 1;
                boolean pression = voie1 == 2 || voie1 == 3 || (voie2 == 2 || voie2 == 3) && this.progSelect.tarage2 == null;
                boolean bl = gonio = voie1 == 14 || voie2 == 14;
                if (pression) {
                    if (this.progSelect.getCategorie().equals("Anorectal") && voie2 == 3) {
                        file = Utils.readHtmlRes("double_ballonnet.html");
                        htmlString = (String)htmlString + file;
                    }
                    if (this.progSelect.getType() != 4) {
                        file = Utils.readHtmlRes("taragepression.html");
                        htmlString = (String)htmlString + file;
                    }
                }
                if (emg && !this.progSelect.forceNoTarage()) {
                    file = Utils.readHtmlRes("tarage.html");
                    htmlString = (String)htmlString + file;
                }
                if (gonio) {
                    file = Utils.readHtmlRes("tarage_gonio.html");
                    htmlString = (String)htmlString + file;
                }
            }
            FxUtils.setVisibility((Node)this.info, !((String)htmlString).isEmpty());
            HtmlToJavaFX.toTextFlow((String)htmlString, this.infoFlow);
            if (this.infoPane.isVisible()) {
                this.info();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private LineChart<Number, Number> createGraphiqueBFB(Pageprogramme pageProg) {
        final NumberAxis xAxis = new NumberAxis();
        xAxis.setAutoRanging(false);
        xAxis.setLowerBound(-1.0);
        xAxis.setTickUnit(1.0);
        xAxis.setMinorTickVisible(false);
        xAxis.setTickLabelFormatter((StringConverter)new StringConverter<Number>(this){
            {
                Objects.requireNonNull(this$0);
            }

            public String toString(Number object) {
                int mod;
                int n = mod = xAxis.getUpperBound() > 50.0 ? 10 : 5;
                if (object.intValue() % mod != 0) {
                    return null;
                }
                return String.valueOf(object.intValue());
            }

            public Number fromString(String string) {
                return 0;
            }
        });
        NumberAxis yAxis = new NumberAxis();
        yAxis.setAutoRanging(false);
        yAxis.setUpperBound(100.0);
        yAxis.setLowerBound(0.0);
        yAxis.setTickUnit(20.0);
        LineChart profilChart = new LineChart((Axis)xAxis, (Axis)yAxis);
        profilChart.setLegendVisible(false);
        profilChart.setCreateSymbols(false);
        profilChart.setVerticalZeroLineVisible(false);
        profilChart.setAnimated(false);
        profilChart.setMaxHeight(250.0);
        this.majGraphiqueBFB(pageProg, (LineChart<Number, Number>)profilChart);
        FxUtils.setAnchorMargin((Node)profilChart, 0.0, 20.0, 0.0, 0.0);
        return profilChart;
    }

    private Pane createReglageRepos(Pageprogramme pageProg, LineChart<Number, Number> profilChart) {
        GridPane ajustPane = this.createAjustGridPane();
        this.addAjustLine(ajustPane, pageProg, "repos", String.format("%.1f s", pageProg.getTrepos()), 0, profilChart);
        return ajustPane;
    }

    void majGraphiqueBFB(Pageprogramme pageProg, LineChart<Number, Number> chart) {
        Profil profil = pageProg.getProfil();
        if (profil != null) {
            chart.getData().clear();
            double pos = 0.0;
            double total = profil.getDuree();
            while (pos + 0.01 < total) {
                XYChart.Series profilSerie = new XYChart.Series();
                Profil profilUnit = profil.getProfilUnitaire(pos + 0.1);
                chart.getData().add((Object)profilSerie);
                if (profilUnit.hasStim()) {
                    ((Path)profilSerie.getNode()).setStrokeWidth(8.0);
                } else {
                    ((Path)profilSerie.getNode()).setStrokeWidth(4.0);
                }
                for (int j = 0; j < profilUnit.val.size(); ++j) {
                    profilSerie.getData().add((Object)new XYChart.Data((Object)(profilUnit.temps.get(j) + pos), (Object)(profilUnit.val.get(j) * 100.0)));
                }
                pos += profilUnit.getDuree();
            }
            ((NumberAxis)chart.getXAxis()).setUpperBound(total + 1.0);
        }
    }

    private Pane createTabStim(Pageprogramme page, boolean modifiable) {
        GridPane stimGrid = new GridPane();
        ColumnConstraints cc = new ColumnConstraints();
        cc.setHalignment(HPos.CENTER);
        cc.setHgrow(Priority.ALWAYS);
        for (int i = 0; i < 1 + 3 * page.getNbVoie(); ++i) {
            stimGrid.getColumnConstraints().add(i, (Object)cc);
        }
        Region regionLeft = new Region();
        regionLeft.getStyleClass().add((Object)(modifiable ? "tabStimLeft" : "grisfonce"));
        Region regionTop = new Region();
        regionTop.getStyleClass().add((Object)(modifiable ? "tabStimTop" : "grisfonce"));
        stimGrid.add((Node)regionLeft, 0, 1, 1, 6);
        stimGrid.add((Node)regionTop, 1, 0, 3 * page.getNbVoie() + 1, 1);
        Region regionCol1 = new Region();
        regionCol1.getStyleClass().add((Object)"blanc");
        stimGrid.add((Node)regionCol1, 1, 1, 3 * page.getNbVoie(), 3);
        Region regionCol2 = new Region();
        regionCol2.getStyleClass().add((Object)"grisclair");
        stimGrid.add((Node)regionCol2, 1, 4, 3 * page.getNbVoie(), 1);
        Region regionCol3 = new Region();
        regionCol3.getStyleClass().add((Object)"blanc");
        stimGrid.add((Node)regionCol3, 1, 5, 3 * page.getNbVoie(), 1);
        Region regionCol4 = new Region();
        regionCol4.getStyleClass().add((Object)"grisclair");
        stimGrid.add((Node)regionCol4, 1, 6, 3 * page.getNbVoie(), 1);
        this.addLabelTitle(stimGrid, "labelTravail", 1);
        this.addLabelTitleFin(stimGrid, "labelMontee", 2);
        this.addLabelTitleFin(stimGrid, "labelDescente", 3);
        this.addLabelTitle(stimGrid, "labelRepos", 4);
        this.addLabelTitle(stimGrid, "labelFrequence", 5);
        this.addLabelTitle(stimGrid, "labelLargeurImpulsion", 6);
        Label labelVoieA = new Label("A");
        labelVoieA.getStyleClass().add((Object)"timetableau");
        stimGrid.add((Node)labelVoieA, 1, 0, 3, 1);
        if (page.getNbVoie() == 2) {
            Label labelVoieB = new Label("B");
            labelVoieB.getStyleClass().add((Object)"timetableau");
            stimGrid.add((Node)labelVoieB, 4, 0, 3, 1);
            if (Main.getConfig().isActivated && modifiable) {
                Button addVoieB = new Button("-");
                addVoieB.getStyleClass().add((Object)"boutonMoins2");
                addVoieB.setOnMouseClicked(mouseEvent -> {
                    page.setNbVoie(1);
                    this.afficheDroite();
                });
                stimGrid.add((Node)addVoieB, 6, 0);
            }
        } else if (Main.getConfig().isActivated && modifiable && Main.getConfig().nbVoiesStim() >= 2) {
            Button addVoieB = new Button("+");
            addVoieB.getStyleClass().add((Object)"boutonPlus2");
            addVoieB.setOnMouseClicked(mouseEvent -> {
                page.setNbVoie(2);
                this.afficheDroite();
            });
            stimGrid.add((Node)addVoieB, 3, 0);
        }
        Button butDefault = null;
        if (modifiable) {
            butDefault = new Button();
            butDefault.getStyleClass().add((Object)"retryButtonTransp");
            butDefault.setOnMouseClicked(mouseEvent -> {
                this.progSelect = Programme.getProgById(this.progSelect.getId());
                this.afficheDroite();
            });
            FxUtils.setAnchorMargin((Node)butDefault);
            stimGrid.add((Node)new AnchorPane(new Node[]{butDefault}), 0, 0);
        }
        this.addLabelVal(stimGrid, page, String.format(Locale.ROOT, "%.1f", page.getTtravail()), "valtableau", "ttravailA", 1, 1, modifiable, butDefault);
        this.addLabelVal(stimGrid, page, String.format(Locale.ROOT, "%.1f", page.getTmontee()), "valtableauFin", "tmonteeA", 1, 2, modifiable, butDefault);
        this.addLabelVal(stimGrid, page, String.format(Locale.ROOT, "%.1f", page.getTdescente()), "valtableauFin", "tdescenteA", 1, 3, modifiable, butDefault);
        this.addLabelVal(stimGrid, page, String.format(Locale.ROOT, "%.1f", page.getTrepos()), "valtableau", "treposA", 1, 4, modifiable, butDefault);
        this.addLabelVal(stimGrid, page, page.getPrintFreq(), "valtableau", "freqA", 1, 5, modifiable, butDefault);
        this.addLabelVal(stimGrid, page, page.getPrintLargeur(), "valtableau", "largeurA", 1, 6, modifiable, butDefault);
        if (page.getNbVoie() == 2) {
            this.addLabelVal(stimGrid, page, String.format(Locale.ROOT, "%.1f", page.getTtravail2()), "valtableau", "ttravailB", 4, 1, modifiable, butDefault);
            this.addLabelVal(stimGrid, page, String.format(Locale.ROOT, "%.1f", page.getTmontee2()), "valtableauFin", "tmonteeB", 4, 2, modifiable, butDefault);
            this.addLabelVal(stimGrid, page, String.format(Locale.ROOT, "%.1f", page.getTdescente2()), "valtableau", "tdescenteB", 4, 3, modifiable, butDefault);
            this.addLabelVal(stimGrid, page, String.format(Locale.ROOT, "%.1f", page.getTrepos2()), "valtableau", "treposB", 4, 4, modifiable, butDefault);
            this.addLabelVal(stimGrid, page, page.getPrintFreq2(), "valtableau", "freqB", 4, 5, modifiable, butDefault);
            this.addLabelVal(stimGrid, page, page.getPrintLargeur2(), "valtableau", "largeurB", 4, 6, modifiable, butDefault);
        }
        FxUtils.setAnchorMargin((Node)stimGrid, 0.0, 35.0, 0.0, 0.0);
        return modifiable ? new AnchorPane(new Node[]{stimGrid}) : stimGrid;
    }

    private void addLabelTitle(GridPane stimGrid, String name, int row) {
        Label label = new Label(TransientConfig.translate(name));
        label.getStyleClass().add((Object)"timetableau");
        stimGrid.add((Node)label, 0, row);
    }

    private void addLabelTitleFin(GridPane stimGrid, String name, int row) {
        Label label = new Label(TransientConfig.translate(name));
        label.getStyleClass().add((Object)"timetableaufin");
        stimGrid.add((Node)label, 0, row);
    }

    private void addLabelVal(GridPane stimGrid, Pageprogramme page, String value, String style, String id, int col, int row, boolean modifiable, Button butDefault) {
        Label label = new Label(value);
        label.getStyleClass().add((Object)style);
        if (modifiable) {
            for (Node n : this.creerBoutonReglable(label, id, page, butDefault, null)) {
                stimGrid.add(n, col, row);
                ++col;
            }
        } else {
            stimGrid.add((Node)label, col, row, 3, 1);
        }
    }

    private ArrayList<Node> creerBoutonReglable(Label label, String id, Pageprogramme pageProg, Button butDefault, LineChart<Number, Number> profilChart) {
        UserDataUpdate udu = new UserDataUpdate(id, pageProg, label, this, butDefault, profilChart);
        label.setAlignment(Pos.CENTER);
        if (!id.startsWith("cs_")) {
            label.setUserData((Object)udu);
            label.setOnMouseClicked(this::labelDoubleClicked);
        }
        Button moin = new Button("-");
        moin.getStyleClass().add((Object)"boutonMoins");
        moin.setUserData((Object)udu);
        moin.setOnMousePressed(this::mousePressed);
        moin.setOnMouseReleased(mouseEvent -> this.mouseReleased());
        Button plus = new Button("+");
        plus.getStyleClass().add((Object)"boutonPlus");
        plus.setUserData((Object)udu);
        plus.setOnMousePressed(this::mousePressed);
        plus.setOnMouseReleased(mouseEvent -> this.mouseReleased());
        return new ArrayList<Labeled>(Arrays.asList(moin, label, plus));
    }

    private ArrayList<Node> creerBoutonReglable(String title, Label label, String id, Pageprogramme pageProg, LineChart<Number, Number> profilChart) {
        ArrayList<Node> res = this.creerBoutonReglable(label, id, pageProg, null, profilChart);
        res.addFirst((Node)new Label(TransientConfig.translate(title)));
        return res;
    }

    private void afficheCombine() {
        this.progsOk = Programme.getProgrammesCombinables(true);
        ObservableList comboList = FXCollections.observableArrayList();
        comboList.addAll(this.progsOk);
        this.progList = new ArrayList();
        this.dureeList = new ArrayList();
        for (int i = 0; i < Main.getConfig().nbCombineLines; ++i) {
            this.ajouteCombineLigne(i, (ObservableList<Programme>)comboList);
        }
    }

    private void ajouteCombineLigne(int nb, ObservableList<Programme> comboList) {
        ComboBox combine = new ComboBox(comboList);
        combine.setPromptText(TransientConfig.translate("choisir_programme"));
        int duree = 60;
        VBox desc = new VBox();
        if (this.firstPage.progs.size() > nb) {
            int progId = this.firstPage.progs.get(nb);
            for (int i = 0; i < this.progsOk.size(); ++i) {
                if (this.progsOk.get(i).getId() != progId) continue;
                combine.getSelectionModel().select(i);
                this.addPageDescr(desc, this.progsOk.get(i));
            }
            duree = this.firstPage.nbRepet.get(nb);
        }
        Label dureeCombine = new Label(Utils.stringOfTime(duree));
        dureeCombine.getStyleClass().add((Object)"paramDynBig");
        this.progList.add((ComboBox<Programme>)combine);
        this.dureeList.add(dureeCombine);
        combine.getSelectionModel().selectedItemProperty().addListener((observableValue, programme, programme2) -> this.combineChanged((ComboBox<Programme>)combine, desc));
        combine.setCellFactory(listView -> Programme.cellFactory());
        combine.setButtonCell(Programme.simpleCellFactory());
        combine.setMaxWidth(300.0);
        combine.setPrefWidth(300.0);
        combine.getStyleClass().add((Object)"paramDyn");
        FlowPane title = new FlowPane(new Node[]{new Label("  "), combine, new Label("  ")});
        title.getStyleClass().add((Object)"titreCombine");
        title.getChildren().addAll(this.creerBoutonReglable(dureeCombine, "combine", this.firstPage, null, null));
        this.vboxContent.getChildren().addAll((Object[])new Node[]{title, new Label(), desc, new Label()});
    }

    private void addPageDescr(VBox desc, Programme p) {
        Pageprogramme pp = p.getFirstPage();
        if (pp.getType() == 1) {
            desc.getChildren().add((Object)this.createTabStim(pp, false));
        } else {
            desc.getChildren().add(this.createGraphiqueBFB(pp));
        }
    }

    void combineChanged(ComboBox<Programme> combo, VBox desc) {
        this.firstPage.progs.clear();
        this.firstPage.nbRepet.clear();
        for (int i = 0; i < Main.getConfig().nbCombineLines; ++i) {
            if (this.progList.get(i).getSelectionModel().getSelectedIndex() < 0) continue;
            Programme p = this.progsOk.get(this.progList.get(i).getSelectionModel().getSelectedIndex());
            this.firstPage.progs.add(p.getId());
            this.firstPage.nbRepet.add(Utils.intOfTime(this.dureeList.get(i).getText()));
            if (combo != this.progList.get(i)) continue;
            desc.getChildren().clear();
            this.addPageDescr(desc, p);
        }
    }

    private void afficheConcat(Pageprogramme pageProg) {
        LineChart<Number, Number> profilChart = this.createGraphiqueBFB(pageProg);
        Pane reglRepos = this.createReglageRepos(pageProg, profilChart);
        GridPane concatGrid = this.createConcatGridPane();
        this.vboxContent.getChildren().addAll((Object[])new Node[]{profilChart, reglRepos, concatGrid});
        ArrayList<Programme> progsOk = Programme.getProgrammesConcat();
        ObservableList comboList = FXCollections.observableArrayList();
        comboList.addAll(progsOk);
        this.progList = new ArrayList();
        this.repetList = new ArrayList();
        CheckBox reposIntra = new CheckBox(TransientConfig.translate("repos_intra"));
        reposIntra.setSelected(pageProg.reposIntra);
        reposIntra.selectedProperty().addListener(observable -> this.concatChanged(pageProg, reposIntra, reglRepos, progsOk, profilChart));
        concatGrid.add((Node)reposIntra, 0, 0, 2, 1);
        reglRepos.setVisible(!pageProg.reposIntra);
        reglRepos.setManaged(!pageProg.reposIntra);
        int nb = this.progSelect.getId() < 100 ? pageProg.progs.size() : Main.getConfig().nbConcatLines;
        for (int i = 0; i < nb; ++i) {
            this.ajouteConcatLigne(concatGrid, pageProg, reposIntra, reglRepos, i, (ObservableList<Programme>)comboList, progsOk, profilChart);
        }
    }

    private GridPane createConcatGridPane() {
        GridPane concatGrid = new GridPane();
        concatGrid.getColumnConstraints().add(0, (Object)new ColumnConstraints(120.0, 120.0, 120.0, Priority.NEVER, HPos.CENTER, true));
        concatGrid.getColumnConstraints().add(1, (Object)new ColumnConstraints(400.0, 400.0, 400.0, Priority.ALWAYS, HPos.CENTER, true));
        concatGrid.getStyleClass().add((Object)"paramDyn");
        concatGrid.setVgap(10.0);
        return concatGrid;
    }

    private void ajouteConcatLigne(GridPane concatGrid, Pageprogramme pageProg, CheckBox reposIntra, Pane reglRepos, int nb, ObservableList<Programme> comboList, ArrayList<Programme> progsOk, LineChart<Number, Number> profilChart) {
        ComboBox concat = new ComboBox(comboList);
        concat.setPromptText(TransientConfig.translate("choisir_profil"));
        this.progList.add((ComboBox<Programme>)concat);
        ComboBox nbconcat = new ComboBox(comboRepet);
        this.repetList.add((ComboBox<String>)nbconcat);
        if (pageProg.progs.size() > nb) {
            int progId = pageProg.progs.get(nb);
            for (int i = 0; i < progsOk.size(); ++i) {
                if (progsOk.get(i).getId() != progId) continue;
                concat.getSelectionModel().select(i);
            }
            nbconcat.getSelectionModel().select(pageProg.nbRepet.get(nb) - 1);
        } else {
            nbconcat.getSelectionModel().selectFirst();
        }
        concat.getSelectionModel().selectedItemProperty().addListener((observableValue, programme, programme2) -> this.concatChanged(pageProg, reposIntra, reglRepos, progsOk, profilChart));
        nbconcat.getSelectionModel().selectedItemProperty().addListener((observableValue, string, string2) -> this.concatChanged(pageProg, reposIntra, reglRepos, progsOk, profilChart));
        concatGrid.add((Node)nbconcat, 0, nb + 1);
        concatGrid.add((Node)concat, 1, nb + 1);
        concat.setCellFactory(listView -> Programme.cellFactory());
        concat.setButtonCell(Programme.cellFactory());
    }

    private void concatChanged(Pageprogramme pageProg, CheckBox reposIntra, Pane reglRepos, ArrayList<Programme> progsOk, LineChart<Number, Number> profilChart) {
        pageProg.progs = new ArrayList();
        pageProg.nbRepet = new ArrayList();
        pageProg.reposIntra = reposIntra.isSelected();
        pageProg.forceRepos = !pageProg.reposIntra;
        FxUtils.setVisibility((Node)reglRepos, !pageProg.reposIntra);
        for (int i = 0; i < this.progList.size(); ++i) {
            if (this.progList.get(i).getSelectionModel().getSelectedIndex() < 0 || this.repetList.get(i).getSelectionModel().getSelectedIndex() < 0) continue;
            pageProg.progs.add(progsOk.get(this.progList.get(i).getSelectionModel().getSelectedIndex()).getId());
            pageProg.nbRepet.add(this.repetList.get(i).getSelectionModel().getSelectedIndex() + 1);
        }
        this.majGraphiqueBFB(pageProg, profilChart);
    }

    private void afficheConcatSimple(Pageprogramme pageProg) {
        LineChart<Number, Number> profilChart = this.createGraphiqueBFB(pageProg);
        this.vboxContent.getChildren().addAll((Object[])new Node[]{profilChart});
        ObservableList comboList = FXCollections.observableArrayList();
        comboList.addAll((Object[])new String[]{TransientConfig.translate("pic"), TransientConfig.translate("plateau"), TransientConfig.translate("stimulation"), TransientConfig.translate("repos")});
        int nb = this.progSelect.getId() < 100 ? pageProg.motifs.size() : Main.getConfig().nbConcatLines;
        for (int i = 0; i < nb; ++i) {
            this.ajouteConcatSimpleLigne(pageProg, i, (ObservableList<String>)comboList, profilChart);
        }
        this.concatSimpleChanged(pageProg, profilChart);
    }

    private void ajouteConcatSimpleLigne(Pageprogramme pageProg, int nb, ObservableList<String> comboList, LineChart<Number, Number> profilChart) {
        ComboBox nbrepet = new ComboBox(comboRepet);
        ComboBox choixMotif = new ComboBox(comboList);
        choixMotif.setPromptText(TransientConfig.translate("Profil"));
        ComboBox nbpic = new ComboBox(comboRepet);
        Label labNiveau = new Label("50%");
        ArrayList<Node> niveau = this.creerBoutonReglable("haut", labNiveau, "cs_haut", pageProg, profilChart);
        Label labTravail = new Label("5,0s");
        ArrayList<Node> travail = this.creerBoutonReglable("labelTravail", labTravail, "cs_travail", pageProg, profilChart);
        Label labFreq = new Label("50Hz");
        ArrayList<Node> freq = this.creerBoutonReglable("labelFrequence", labFreq, "cs_freq", pageProg, profilChart);
        Label labLargeur = new Label("300\u00b5s");
        ArrayList<Node> largeur = this.creerBoutonReglable("labelLargeurImpulsion", labLargeur, "cs_largeur", pageProg, profilChart);
        Label labRepos = new Label("10,0s");
        ArrayList<Node> repos = this.creerBoutonReglable("labelRepos", labRepos, "cs_repos", pageProg, profilChart);
        labFreq.setUserData((Object)labLargeur);
        labLargeur.setUserData((Object)labFreq);
        nbpic.getSelectionModel().selectFirst();
        nbrepet.getSelectionModel().selectFirst();
        if (pageProg.motifs.size() > nb) {
            ProfilConcatSimple.Motif motif = pageProg.motifs.get(nb);
            nbrepet.getSelectionModel().select(motif.repet - 1);
            labRepos.setText(String.format("%.1fs", motif.repos));
            if (motif.nbPic > 0) {
                choixMotif.getSelectionModel().select(0);
                nbpic.getSelectionModel().select(motif.nbPic - 1);
                labNiveau.setText(String.format("%.0f%%", motif.niveau * 100.0));
            } else if (motif.nbPic == 0) {
                choixMotif.getSelectionModel().select(1);
                labNiveau.setText(String.format("%.0f%%", motif.niveau * 100.0));
                labTravail.setText(String.format("%.1fs", motif.dureePlateau));
            } else if (motif.nbPic == -1) {
                choixMotif.getSelectionModel().select(2);
                labTravail.setText(String.format("%.1fs", motif.dureePlateau));
                labFreq.setText(motif.freq + "Hz");
                labLargeur.setText(motif.largeur + "\u00b5s");
            } else {
                choixMotif.getSelectionModel().select(3);
            }
        }
        choixMotif.getSelectionModel().selectedIndexProperty().addListener((observableValue, number, c) -> this.concatSimpleMotifChanged((Integer)c, labNiveau, pageProg, profilChart));
        nbpic.getSelectionModel().selectedItemProperty().addListener((observableValue, string, string2) -> this.concatSimpleChanged(pageProg, profilChart));
        nbrepet.getSelectionModel().selectedItemProperty().addListener((observableValue, string, string2) -> this.concatSimpleChanged(pageProg, profilChart));
        GridPane gridReglage = this.createGridReglage(new ArrayList<Control>(Arrays.asList(new Label(TransientConfig.translate("repetitions")), nbpic)), niveau, travail, freq, largeur, repos);
        HBox hBox = new HBox(new Node[]{nbrepet, choixMotif, gridReglage});
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setPadding(new Insets(5.0, 0.0, 5.0, 10.0));
        hBox.getStyleClass().addAll((Object[])new String[]{"paramDyn", nb % 2 == 0 ? "grisclair" : "blanc"});
        this.vboxContent.getChildren().add((Object)hBox);
    }

    @SafeVarargs
    private GridPane createGridReglage(ArrayList<Node> ... params) {
        GridPane gridReglage = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHalignment(HPos.CENTER);
        gridReglage.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints, columnConstraints});
        gridReglage.setVgap(0.0);
        gridReglage.setHgap(10.0);
        for (int i = 0; i < params.length; ++i) {
            ArrayList<Node> param = params[i];
            gridReglage.add(param.get(0), 0, i);
            if (param.size() == 2) {
                gridReglage.add(param.get(1), 1, i, 3, 1);
                continue;
            }
            gridReglage.add(param.get(1), 1, i);
            gridReglage.add(param.get(2), 2, i);
            gridReglage.add(param.get(3), 3, i);
        }
        return gridReglage;
    }

    public void concatSimpleMotifChanged(int type, Label labNiveau, Pageprogramme pageProg, LineChart<Number, Number> profilChart) {
        if (type == 0) {
            labNiveau.setText("100%");
        } else if (type == 1) {
            labNiveau.setText("50%");
        }
        this.concatSimpleChanged(pageProg, profilChart);
    }

    public void concatSimpleChanged(Pageprogramme pageProg, LineChart<Number, Number> profilChart) {
        pageProg.motifs.clear();
        for (Node n : this.vboxContent.getChildren()) {
            if (!(n instanceof HBox)) continue;
            HBox hBox = (HBox)n;
            GridPane droite = (GridPane)hBox.getChildren().get(2);
            ComboBox choixMotif = (ComboBox)hBox.getChildren().get(1);
            int type = choixMotif.getSelectionModel().getSelectedIndex();
            if (type != -1) {
                int nbrepet = ((ComboBox)hBox.getChildren().getFirst()).getSelectionModel().getSelectedIndex() + 1;
                int nbpic = ((ComboBox)droite.getChildren().get(1)).getSelectionModel().getSelectedIndex() + 1;
                pageProg.motifs.add(ProfilConcatSimple.Motif.createMotif(pageProg, nbrepet, choixMotif.getSelectionModel().getSelectedIndex(), nbpic, Utils.parseIntSuffix(((Label)droite.getChildren().get(4)).getText()), Utils.parseDoubleSuffix(((Label)droite.getChildren().get(8)).getText()), Utils.parseIntSuffix(((Label)droite.getChildren().get(12)).getText()), Utils.parseIntSuffix(((Label)droite.getChildren().get(16)).getText()), Utils.parseDoubleSuffix(((Label)droite.getChildren().get(20)).getText())));
            }
            for (int i = 0; i < droite.getChildren().size(); ++i) {
                boolean visible = type == 0 && i < 6 || type == 1 && i >= 2 && i < 10 || type == 2 && i >= 6 && i < 18 || type != -1 && i >= 18;
                FxUtils.setVisibility((Node)droite.getChildren().get(i), visible);
            }
        }
        this.majGraphiqueBFB(pageProg, profilChart);
    }

    private void afficheAjust(Pageprogramme pageProg) {
        LineChart<Number, Number> chart = this.createGraphiqueBFB(pageProg);
        GridPane ajustPane = this.createAjustGridPane();
        this.addAjustLine(ajustPane, pageProg, "haut", pageProg.dynHaut + "%", 0, chart);
        this.addAjustLine(ajustPane, pageProg, "montee", String.format("%.1f s", (double)pageProg.dynMontee / 10.0), 2, chart);
        this.addAjustLine(ajustPane, pageProg, "travail", String.format("%.1f s", (double)pageProg.dynTravail / 10.0), 3, chart);
        this.addAjustLine(ajustPane, pageProg, "repos", String.format("%.1f s", pageProg.getTrepos()), 4, chart);
        this.vboxContent.getChildren().addAll((Object[])new Node[]{chart, ajustPane});
        if (Main.getConfig().optionBFBAssiste()) {
            GridPane stimPane = this.createAjustGridPane();
            CheckBox relachement = new CheckBox(TransientConfig.translate("relachement"));
            relachement.getStyleClass().add((Object)"paramDynBig");
            relachement.setSelected(pageProg.relachement);
            relachement.selectedProperty().addListener(observable -> {
                pageProg.relachement = relachement.isSelected();
            });
            stimPane.add((Node)relachement, 0, 0, 4, 1);
            CheckBox insuffisant = new CheckBox(TransientConfig.translate("insuffisant"));
            insuffisant.getStyleClass().add((Object)"paramDynBig");
            insuffisant.setSelected(pageProg.insuffisant);
            insuffisant.selectedProperty().addListener(observable -> {
                pageProg.insuffisant = insuffisant.isSelected();
            });
            stimPane.add((Node)insuffisant, 0, 1, 4, 1);
            this.addAjustLine(stimPane, pageProg, "labelFrequence", Integer.toString(pageProg.getFreq()), 2, null);
            this.addAjustLine(stimPane, pageProg, "labelLargeurImpulsion", Integer.toString(pageProg.getLargeur()), 3, null);
            CheckBox stimAssistee = new CheckBox(TransientConfig.translate("bfbAssiste"));
            stimAssistee.getStyleClass().add((Object)"paramDynBig");
            stimAssistee.setSelected(pageProg.isBfbAssiste());
            stimAssistee.selectedProperty().addListener(observable -> this.onStimAssistee(stimAssistee, pageProg, stimPane));
            this.onStimAssistee(stimAssistee, pageProg, stimPane);
            this.vboxContent.getChildren().addAll((Object[])new Node[]{stimAssistee, stimPane});
        }
    }

    private void onStimAssistee(CheckBox stimAssistee, Pageprogramme pageProg, GridPane stimPane) {
        pageProg.setBfbAssiste(stimAssistee.isSelected());
        stimPane.setVisible(pageProg.isBfbAssiste());
        stimPane.setManaged(pageProg.isBfbAssiste());
    }

    private GridPane createAjustGridPane() {
        GridPane ajustPane = new GridPane();
        ajustPane.getColumnConstraints().add(0, (Object)new ColumnConstraints(250.0, 250.0, 250.0, Priority.NEVER, HPos.CENTER, true));
        ajustPane.getColumnConstraints().add(1, (Object)new ColumnConstraints(50.0, 50.0, 50.0, Priority.NEVER, HPos.CENTER, true));
        ajustPane.getColumnConstraints().add(2, (Object)new ColumnConstraints(150.0, 150.0, 150.0, Priority.NEVER, HPos.CENTER, true));
        ajustPane.getColumnConstraints().add(3, (Object)new ColumnConstraints(50.0, 50.0, 50.0, Priority.NEVER, HPos.CENTER, true));
        return ajustPane;
    }

    private void addAjustLine(GridPane ajustPane, Pageprogramme pageProg, String type, String val, int row, LineChart<Number, Number> chart) {
        Label label_name = new Label(TransientConfig.translate(type));
        label_name.getStyleClass().add((Object)"paramDynBig");
        ajustPane.add((Node)label_name, 0, row);
        Label label_val = new Label(val);
        label_val.getStyleClass().add((Object)"paramDynBig");
        ajustPane.add((Node)label_val, 2, row);
        UserDataUpdate udu = new UserDataUpdate("ajust_" + type, pageProg, label_val, this, null, chart);
        Button bmoins = new Button("-");
        bmoins.getStyleClass().add((Object)"boutonMoins");
        bmoins.setUserData((Object)udu);
        bmoins.setOnMousePressed(this::mousePressed);
        bmoins.setOnMouseReleased(mouseEvent -> this.mouseReleased());
        ajustPane.add((Node)bmoins, 1, row);
        Button bplus = new Button("+");
        bplus.getStyleClass().add((Object)"boutonPlus");
        bplus.setUserData((Object)udu);
        bplus.setOnMousePressed(this::mousePressed);
        bplus.setOnMouseReleased(mouseEvent -> this.mouseReleased());
        ajustPane.add((Node)bplus, 3, row);
    }

    private void afficheCatch(Pageprogramme pageProg) {
        AnchorPane dessin = new AnchorPane();
        dessin.getStyleClass().add((Object)"dessinCatch");
        dessin.setMinHeight(400.0);
        dessin.setMinWidth(500.0);
        this.objetsCatch.clear();
        this.pinceau = defaultImageCatch;
        try {
            this.pinceau = Config.listImagesCatch.get(Config.decodePosObj(pageProg.progs.getFirst()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        dessin.setOnMouseClicked(e -> this.addCatchObj(dessin, this.pinceau, pageProg, (MouseEvent)e, 0));
        GridPane ajustPane = this.createAjustGridPane();
        this.addAjustLine(ajustPane, this.firstPage, "duree_du_motif", String.format("%.1f s", Float.valueOf(this.firstPage.dureeTravail)), 3, null);
        CheckBox objetsAnimation = new CheckBox(TransientConfig.translate("objets_de_l_animation"));
        objetsAnimation.getStyleClass().add((Object)"paramDynBig");
        objetsAnimation.setSelected(this.pinceau == defaultImageCatch);
        FlowPane listPinceaux = new FlowPane();
        listPinceaux.setHgap(10.0);
        listPinceaux.setVgap(10.0);
        listPinceaux.getStyleClass().add((Object)"blanc");
        for (int i = 0; i < Config.listImagesCatch.size(); ++i) {
            StackPane sp = new StackPane();
            sp.setMinWidth(50.0);
            sp.setMinHeight(50.0);
            FxUtils.creationObjet((Pane)sp, Config.listImagesCatch.get(i), 50.0);
            if (this.pinceau == Config.listImagesCatch.get(i)) {
                sp.getStyleClass().add((Object)"dessinCatch");
                this.numPinceau = i;
            }
            listPinceaux.getChildren().add((Object)sp);
            sp.setOnMouseClicked(e -> {
                int num = listPinceaux.getChildren().indexOf((Object)sp);
                int code = Config.codePosObj(num);
                if (code >= 0 && e.getButton() != MouseButton.PRIMARY) {
                    ContextMenu contextMenuForm = new ContextMenu();
                    MenuItem item = new MenuItem(TransientConfig.translate("delete"));
                    item.setOnAction(actionEvent -> {
                        Main.getConfig().customObjetsCatch.remove(code);
                        Config.listImagesCatch.remove(num);
                        Main.getConfig().saveConfig();
                        this.afficheDroite();
                    });
                    contextMenuForm.getItems().add((Object)item);
                    contextMenuForm.show((Node)e.getSource(), e.getScreenX(), e.getScreenY());
                } else {
                    ((Node)listPinceaux.getChildren().get(this.numPinceau)).getStyleClass().clear();
                    this.numPinceau = num;
                    this.pinceau = Config.listImagesCatch.get(this.numPinceau);
                    ((Node)listPinceaux.getChildren().get(this.numPinceau)).getStyleClass().add((Object)"dessinCatch");
                    objetsAnimation.setSelected(false);
                }
            });
        }
        Button addPinceau = new Button();
        addPinceau.getStyleClass().add((Object)"boutonPlus");
        addPinceau.setMinWidth(50.0);
        addPinceau.setOnMouseClicked(mouseEvent -> this.addPinceau());
        HBox gestionPinceaux = new HBox(10.0, new Node[]{listPinceaux, addPinceau, new Region()});
        HBox.setHgrow((Node)listPinceaux, (Priority)Priority.ALWAYS);
        FxUtils.setVisibility((Node)gestionPinceaux, !objetsAnimation.isSelected());
        this.vboxContent.getChildren().addAll((Object[])new Node[]{dessin, ajustPane, objetsAnimation, gestionPinceaux});
        this.addInitCatchObj(dessin, pageProg);
        objetsAnimation.setOnMouseClicked(mouseEvent -> {
            FxUtils.setVisibility((Node)gestionPinceaux, !objetsAnimation.isSelected());
            if (objetsAnimation.isSelected()) {
                this.pinceau = defaultImageCatch;
                ((Node)listPinceaux.getChildren().get(this.numPinceau)).getStyleClass().clear();
            } else {
                this.pinceau = Config.listImagesCatch.get(this.numPinceau);
                ((Node)listPinceaux.getChildren().get(this.numPinceau)).getStyleClass().add((Object)"dessinCatch");
            }
        });
    }

    private void addPinceau() {
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.showOpenDialog(Main.sceneMain.getWindow());
        if (file == null) {
            return;
        }
        String s = file.toString();
        String obj = Computer.tryRelative(s);
        Main.getConfig().customObjetsCatch.add(obj);
        Main.getConfig().saveConfig();
        Config.addImageCatch(obj, true);
        this.afficheDroite();
    }

    private void addInitCatchObj(AnchorPane dessin, Pageprogramme pageProg) {
        if (dessin.getWidth() == 0.0) {
            Platform.runLater(() -> this.addInitCatchObj(dessin, pageProg));
        } else {
            for (int i = 0; i < pageProg.dessineT.size(); ++i) {
                ImagePattern pinceau = defaultImageCatch;
                try {
                    pinceau = Config.listImagesCatch.get(Config.decodePosObj(pageProg.progs.get(i)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.addCatchObj(dessin, pinceau, pageProg, null, i);
            }
        }
    }

    private void addCatchObj(AnchorPane dessin, ImagePattern pinceau, Pageprogramme pageProg, MouseEvent e, int nb) {
        Rectangle rect = FxUtils.creationObjet((Pane)dessin, pinceau, 30.0);
        if (e != null) {
            this.setPos(dessin, rect, e, pageProg);
        } else {
            rect.setX(pageProg.dessineT.get(nb) * dessin.getWidth() - rect.getWidth() / 2.0);
            rect.setY((1.0 - pageProg.dessineY.get(nb)) * dessin.getHeight() - rect.getHeight() / 2.0);
            this.objetsCatch.add(rect);
        }
        rect.setOnMousePressed(mouseEvent -> {
            this.noDrag = true;
        });
        rect.setOnMouseReleased(mouseEvent -> {
            if (this.noDrag) {
                dessin.getChildren().remove((Object)rect);
                this.removeCatchObj(rect, pageProg);
            }
        });
        rect.setOnMouseDragged(ee -> {
            this.noDrag = false;
            this.removeCatchObj(rect, pageProg);
            this.setPos(dessin, rect, (MouseEvent)ee, pageProg);
        });
        rect.setOnMouseClicked(Event::consume);
    }

    private void setPos(AnchorPane dessin, Rectangle rect, MouseEvent e, Pageprogramme pageProg) {
        int pos;
        double clicx = e.getX();
        double sizex = rect.getWidth() / 2.0;
        double sizey = rect.getHeight() / 2.0;
        clicx = Math.max(clicx, sizex);
        clicx = Math.min(clicx, dessin.getWidth() - sizex - 4.0);
        double clicy = e.getY();
        clicy = Math.max(clicy, sizey);
        clicy = Math.min(clicy, dessin.getHeight() - sizey - 4.0);
        double posX = clicx - sizex;
        double posY = clicy - sizey;
        rect.setX(posX);
        rect.setY(posY);
        double valt = clicx / dessin.getWidth();
        for (pos = 0; pos < pageProg.dessineT.size() && pageProg.dessineT.get(pos) < valt; ++pos) {
        }
        this.objetsCatch.add(pos, rect);
        pageProg.dessineT.add(pos, valt);
        pageProg.dessineY.add(pos, 1.0 - clicy / dessin.getHeight());
        pageProg.progs.add(pos, this.pinceau == defaultImageCatch ? null : Integer.valueOf(Config.codePosObj(this.numPinceau)));
    }

    private void removeCatchObj(Rectangle rect, Pageprogramme pageProg) {
        try {
            int pos = this.objetsCatch.indexOf(rect);
            this.objetsCatch.remove(pos);
            pageProg.dessineT.remove(pos);
            pageProg.dessineY.remove(pos);
            pageProg.progs.remove(pos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void afficheBalance() {
        if (this.firstPage.designBalance == 0) {
            Label labelDuree = new Label(TransientConfig.translate("dureeValidation"));
            ComboBox comboDuree = new ComboBox();
            comboDuree.getItems().setAll((Object[])new String[]{TransientConfig.translate("aleatoire"), "1s", "2s", "3s", "4s"});
            comboDuree.getSelectionModel().select(this.firstPage.vitesse);
            comboDuree.valueProperty().addListener((observableValue, string, string2) -> {
                this.firstPage.vitesse = comboDuree.getSelectionModel().getSelectedIndex();
            });
            HBox hBoxDuree = new HBox(10.0, new Node[]{labelDuree, comboDuree});
            hBoxDuree.setAlignment(Pos.CENTER_LEFT);
            hBoxDuree.getStyleClass().add((Object)"titleConfiguration");
            Label labelTaille = new Label(TransientConfig.translate("tailleCible"));
            ComboBox comboTaille = new ComboBox();
            comboTaille.getItems().setAll((Object[])new String[]{"1", "2", "3", "4"});
            comboTaille.getSelectionModel().select(this.firstPage.tailleCible);
            comboTaille.valueProperty().addListener((observableValue, string, string2) -> {
                this.firstPage.tailleCible = comboTaille.getSelectionModel().getSelectedIndex();
            });
            HBox hBoxTaille = new HBox(10.0, new Node[]{labelTaille, comboTaille});
            hBoxTaille.setAlignment(Pos.CENTER_LEFT);
            hBoxTaille.getStyleClass().add((Object)"titleConfiguration");
            this.vboxContent.getChildren().addAll((Object[])new Node[]{hBoxDuree, hBoxTaille});
        } else {
            Label labTaille = new Label(Integer.toString(this.firstPage.taille));
            ArrayList<Node> reglageTaille = this.creerBoutonReglable("taille", labTaille, "taille", this.firstPage, null);
            Label labVitesse = new Label(Integer.toString(this.firstPage.vitesse));
            ArrayList<Node> reglageVitesse = this.creerBoutonReglable("vitesse", labVitesse, "vitesse", this.firstPage, null);
            GridPane reglages = this.createGridReglage(reglageTaille, reglageVitesse);
            reglages.getStyleClass().add((Object)"titleConfiguration");
            this.vboxContent.getChildren().add((Object)reglages);
        }
    }

    private void afficheDessineProfil() {
        NumberAxis xAxis = new NumberAxis();
        xAxis.setTickMarkVisible(false);
        xAxis.setAutoRanging(false);
        xAxis.setUpperBound(1.0);
        xAxis.setLowerBound(0.0);
        xAxis.setTickUnit(0.1);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setTickMarkVisible(false);
        yAxis.setAutoRanging(false);
        yAxis.setUpperBound(1.0);
        yAxis.setLowerBound(0.0);
        yAxis.setTickUnit(0.2);
        LineChart profilChart = new LineChart((Axis)xAxis, (Axis)yAxis);
        profilChart.setLegendVisible(false);
        FxUtils.setAnchorMargin((Node)profilChart);
        profilChart.setAnimated(false);
        LineChart clicChart = new LineChart((Axis)xAxis, (Axis)yAxis);
        clicChart.setLegendVisible(false);
        FxUtils.setAnchorMargin((Node)clicChart);
        Node chartplot = clicChart.lookup(".chart-plot-background");
        chartplot.setOnMousePressed(e -> this.dessinePressed((MouseEvent)e, xAxis, yAxis, (LineChart<Number, Number>)profilChart));
        chartplot.setOnMouseDragged(e -> this.dessineDragged((MouseEvent)e, xAxis, yAxis, (LineChart<Number, Number>)profilChart));
        chartplot.setOnMouseReleased(mouseEvent -> this.dessineReleased((LineChart<Number, Number>)profilChart));
        clicChart.setOpacity(0.0);
        AnchorPane dessineGraph = new AnchorPane();
        dessineGraph.getChildren().addAll((Object[])new Node[]{profilChart, clicChart});
        this.updateDessineChart((LineChart<Number, Number>)profilChart);
        GridPane ajustPane = this.createAjustGridPane();
        this.addAjustLine(ajustPane, this.firstPage, "duree_du_motif", String.format("%.1f s", Float.valueOf(this.firstPage.dureeTravail)), 3, null);
        this.addAjustLine(ajustPane, this.firstPage, "repos", String.format("%.1f s", this.firstPage.getTrepos()), 4, null);
        this.vboxContent.getChildren().addAll((Object[])new Node[]{dessineGraph, ajustPane});
    }

    private void updateDessineChart(LineChart<Number, Number> profilChart) {
        profilChart.getData().clear();
        XYChart.Series profilSerie = new XYChart.Series();
        profilSerie.getData().add((Object)new XYChart.Data((Object)0.0, (Object)this.firstPage.initVal));
        for (int j = 0; j < this.firstPage.dessineT.size(); ++j) {
            profilSerie.getData().add((Object)new XYChart.Data((Object)this.firstPage.dessineT.get(j), (Object)this.firstPage.dessineY.get(j)));
        }
        profilSerie.getData().add((Object)new XYChart.Data((Object)1.0, (Object)this.firstPage.initVal));
        profilChart.getData().add((Object)profilSerie);
    }

    private void dessinePressed(MouseEvent e, NumberAxis xAxis, NumberAxis yAxis, LineChart<Number, Number> profilChart) {
        this.isDessinePressed = false;
        this.noDrag = true;
        double x = (Double)xAxis.getValueForDisplay(e.getX());
        double y = (Double)yAxis.getValueForDisplay(e.getY());
        double d = y < 0.0 ? 0.0 : (y = y > 1.0 ? 1.0 : y);
        if (x < 0.02 || x > 0.98) {
            this.firstPage.initVal = y;
        } else {
            this.dragPos = 0;
            for (int i = 0; i < this.firstPage.dessineT.size(); ++i) {
                double d2 = this.firstPage.dessineT.get(i);
                if (d2 - 0.02 < x && x < d2 + 0.02) {
                    this.isDessinePressed = true;
                }
                if (!(x > d2 + 0.02)) continue;
                this.dragPos = i + 1;
            }
            if (!this.isDessinePressed) {
                this.firstPage.dessineT.add(this.dragPos, x);
                this.firstPage.dessineY.add(this.dragPos, y);
                this.isDessinePressed = true;
                this.noDrag = false;
            }
        }
        this.updateDessineChart(profilChart);
    }

    private void dessineDragged(MouseEvent e, NumberAxis xAxis, NumberAxis yAxis, LineChart<Number, Number> profilChart) {
        if (this.isDessinePressed) {
            this.noDrag = false;
            this.firstPage.dessineT.remove(this.dragPos);
            this.firstPage.dessineY.remove(this.dragPos);
            double x = (Double)xAxis.getValueForDisplay(e.getX());
            x = x < 0.03 ? 0.03 : Math.min(x, 0.97);
            double y = (Double)yAxis.getValueForDisplay(e.getY());
            y = y < 0.0 ? 0.0 : (y > 1.0 ? 1.0 : y);
            this.dragPos = 0;
            for (int i = 0; i < this.firstPage.dessineT.size(); ++i) {
                double d = this.firstPage.dessineT.get(i);
                if (!(x > d)) continue;
                this.dragPos = i + 1;
            }
            if (this.dragPos == -1) {
                this.dragPos = this.firstPage.dessineT.size();
            }
            this.firstPage.dessineT.add(this.dragPos, x);
            this.firstPage.dessineY.add(this.dragPos, y);
            this.updateDessineChart(profilChart);
        }
    }

    private void dessineReleased(LineChart<Number, Number> profilChart) {
        if (this.isDessinePressed && this.noDrag) {
            this.firstPage.dessineT.remove(this.dragPos);
            this.firstPage.dessineY.remove(this.dragPos);
            this.updateDessineChart(profilChart);
        }
    }

    private void afficheAleatoire() {
        Pane reglRepos = this.createReglageRepos(this.firstPage, null);
        CheckBox reposAleatoire = new CheckBox(TransientConfig.translate("forcageReposAleatoire"));
        reposAleatoire.getStyleClass().add((Object)"paramDynBig");
        this.vboxContent.getChildren().addAll((Object[])new Node[]{reposAleatoire, reglRepos, new Label(" ")});
        reposAleatoire.setSelected(this.firstPage.forceRepos);
        reposAleatoire.selectedProperty().addListener(observable -> this.reposAleaChanged(reposAleatoire, reglRepos));
        FxUtils.setVisibility((Node)reglRepos, this.firstPage.forceRepos);
        ArrayList<Programme> progsOk = Programme.getProgrammesConcat();
        this.firstPage.initAleaIfNull(progsOk);
        for (Programme p : progsOk) {
            CheckBox cb = new CheckBox(p.getNom());
            cb.setSelected(this.firstPage.aleaProgs.contains(p.getId()));
            cb.getStyleClass().add((Object)"paramDyn");
            File file = new File(Computer.absolutePath + "appData/profils/" + p.getId() + ".png");
            Image image = new Image(file.toURI().toASCIIString());
            this.vboxContent.getChildren().add((Object)new HBox(new Node[]{new ImageView(image), cb}));
            cb.selectedProperty().addListener(observable -> this.progAleaChanged(cb, p));
        }
    }

    private void progAleaChanged(CheckBox cb, Programme p) {
        if (cb.isSelected()) {
            this.firstPage.aleaProgs.add(p.getId());
        } else {
            this.firstPage.aleaProgs.removeIf(id -> id.intValue() == p.getId());
        }
    }

    private void reposAleaChanged(CheckBox reposAleatoire, Pane reglRepos) {
        this.firstPage.forceRepos = reposAleatoire.isSelected();
        reglRepos.setVisible(this.firstPage.forceRepos);
        reglRepos.setManaged(this.firstPage.forceRepos);
    }

    private ContextMenu initContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        try {
            MenuItem itemRename = new MenuItem(TransientConfig.translate("rename"));
            itemRename.setOnAction(actionEvent -> {
                Optional<String> result = Utils.popupReadVal("renameContent", "");
                if (result.isPresent()) {
                    this.progSelect.setNom(this.progSelect.getPrefix() + result.get());
                    this.progSelect.updateProgrammePerso();
                    this.refreshPage();
                }
            });
            Menu menuCateg = new Menu(TransientConfig.translate("change_categorie"));
            for (String categorie : Programme.getListCategorie()) {
                if (categorie.equals(Main.getCategorie())) continue;
                MenuItem item = new MenuItem(TransientConfig.persoTranslate(categorie));
                item.setOnAction(actionEvent -> {
                    this.progSelect.setCategorie(categorie);
                    this.progSelect.updateProgrammePerso();
                    Main.setCategorie(categorie);
                    Main.changeCenterView("programme", "progList", Main.menu.homeButton);
                });
                menuCateg.getItems().add((Object)item);
            }
            MenuItem itemDelete = new MenuItem(TransientConfig.translate("delete"));
            itemDelete.setOnAction(actionEvent -> {
                this.progSelect.deleteProgrammePerso();
                this.progSelect = null;
                this.refreshPage();
            });
            contextMenu.getItems().addAll((Object[])new MenuItem[]{itemRename, menuCateg, itemDelete});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contextMenu;
    }

    @FXML
    private void labelDoubleClicked(MouseEvent event) {
        if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2) {
            try {
                Optional<String> result;
                Label temp = (Label)event.getSource();
                String input = temp.getText();
                if (input.indexOf(58) != -1) {
                    input = String.format("%d", Utils.intOfTime(input));
                }
                if ((result = Utils.popupReadVal("popupChangeValCont", input)).isPresent()) {
                    if ("time".equals(temp.getId())) {
                        this.progSelect.setDuree(Integer.parseInt(result.get()));
                        this.tempsProg.setText(Utils.stringOfTime(this.progSelect.getDuree()));
                    } else if (temp.getUserData() instanceof UserDataUpdate) {
                        ((UserDataUpdate)temp.getUserData()).set(result.get());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void mainPlay() {
        new ProgEnCours(this.progSelect);
    }

    private void mouseCliqueProg(MouseEvent event, ToggleButton target, Programme prog) {
        this.progSelect = prog;
        if (this.buttonSelected != null) {
            this.buttonSelected.setSelected(false);
        }
        this.buttonSelected = target;
        target.setSelected(true);
        if (event.getButton() == MouseButton.SECONDARY & this.progSelect.isCustom()) {
            ContextMenu contextMenuPerso = this.initContextMenu();
            contextMenuPerso.show((Node)event.getSource(), event.getScreenX(), event.getScreenY());
        } else {
            this.afficheDroite();
        }
    }

    @FXML
    private void mouseReleased() {
        if (this.holdBouton != null) {
            this.holdBouton.stop();
            this.holdBouton = null;
        }
    }

    @FXML
    private void mousePressed(MouseEvent event) {
        Button targetObject = (Button)event.getSource();
        int sign = targetObject.getText().equals("+") ? 1 : -1;
        this.compteurTemp = 0;
        if (this.holdBouton != null) {
            this.holdBouton.stop();
        }
        this.holdBouton = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)40.0), actionEvent -> {
            if (this.compteurTemp++ >= 8) {
                this.methodeHoldMouse(sign, targetObject.getUserData());
            }
        }, new KeyValue[0])});
        this.holdBouton.setCycleCount(-1);
        this.holdBouton.playFromStart();
        this.methodeHoldMouse(sign, targetObject.getUserData());
    }

    private synchronized void methodeHoldMouse(int sign, Object obj) {
        try {
            if ("time".equals(obj)) {
                this.progSelect.setDuree(this.progSelect.getDuree() + sign * Utils.getDeltaDuree(this.progSelect.getDuree()));
                this.tempsProg.setText(Utils.stringOfTime(this.progSelect.getDuree()));
            } else if (obj instanceof UserDataUpdate) {
                ((UserDataUpdate)obj).update(sign);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void save() {
        this.saveAsEnCours = true;
        try {
            if (!this.progSelect.isCustom()) {
                Optional<String> result = Utils.popupReadVal("nameCustomContent", "");
                if (result.isPresent()) {
                    this.progSelect.setNom(this.progSelect.getPrefix() + result.get());
                    this.progSelect.addProgrammePerso();
                    this.showCustom = true;
                    this.refreshPage();
                }
            } else {
                this.progSelect.updateProgrammePerso();
                this.refreshPage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveAsEnCours = false;
    }

    @FXML
    private void saveas() {
        this.saveAsEnCours = true;
        try {
            Optional<String> result = Utils.popupReadVal("nameCustomContent", "");
            if (result.isPresent()) {
                this.progSelect.setNom(this.progSelect.getPrefix() + result.get());
                this.progSelect.addProgrammePerso();
                this.showCustom = true;
                this.refreshPage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveAsEnCours = false;
    }

    @FXML
    private void info() {
        if (this.scrollDroite.isVisible()) {
            this.info.getStyleClass().setAll((Object[])new String[]{"enteteBFB", "fermer"});
            this.scrollDroite.setVisible(false);
            this.infoPane.setVisible(true);
        } else {
            this.info.getStyleClass().setAll((Object[])new String[]{"enteteBFB", "info"});
            this.scrollDroite.setVisible(true);
            this.infoPane.setVisible(false);
        }
    }
}

