/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme;

import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.programme.ProgListController;
import com.mazet.biostim.zdata.Pageprogramme;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.chart.LineChart;
import javafx.scene.control.Button;
import javafx.scene.control.Label;

public class UserDataUpdate {
    private final String type;
    private final Pageprogramme pageProgramme;
    private final Label label;
    private final ProgListController controller;
    private final Button butDefault;
    private final LineChart<Number, Number> BFBChart;

    UserDataUpdate(String type, Pageprogramme pageprogramme, Label label, ProgListController controller, Button butDefault, LineChart<Number, Number> BFBChart) {
        this.type = type;
        this.pageProgramme = pageprogramme;
        this.label = label;
        this.controller = controller;
        this.butDefault = butDefault;
        this.BFBChart = BFBChart;
    }

    public void update(int sign) {
        switch (this.type) {
            case "dureePP": {
                int duree = this.pageProgramme.getDuree();
                duree += sign * Utils.getDeltaDuree(duree);
                this.pageProgramme.setDuree(duree);
                this.label.setText(" " + Utils.stringOfTime(this.pageProgramme.getDuree()) + " ");
                break;
            }
            case "ttravailA": {
                double tempTtravail = Double.parseDouble(this.label.getText());
                tempTtravail += (double)sign * Utils.getDoubleDelta(tempTtravail);
                this.pageProgramme.setTtravail(tempTtravail);
                this.setDoubleLabel(this.label, this.pageProgramme.getTtravail());
                break;
            }
            case "tmonteeA": {
                double tempMontee = Double.parseDouble(this.label.getText());
                tempMontee += (double)sign * Utils.getDoubleDelta(tempMontee);
                this.pageProgramme.setTmontee(tempMontee);
                this.setDoubleLabel(this.label, this.pageProgramme.getTmontee());
                break;
            }
            case "tdescenteA": {
                double tempDescente = Double.parseDouble(this.label.getText());
                tempDescente += (double)sign * Utils.getDoubleDelta(tempDescente);
                this.pageProgramme.setTdescente(tempDescente);
                this.setDoubleLabel(this.label, this.pageProgramme.getTdescente());
                break;
            }
            case "treposA": {
                this.pageProgramme.incrTrepos(sign);
                this.setDoubleLabel(this.label, this.pageProgramme.getTrepos());
                break;
            }
            case "freqA": 
            case "ajust_labelFrequence": {
                int tempFreq = this.pageProgramme.getFreq();
                this.pageProgramme.setFreq(tempFreq + sign * Utils.getIntDelta(tempFreq));
                if (this.pageProgramme.getFreqF2() == 0) {
                    this.label.setText(this.pageProgramme.getPrintFreq());
                    break;
                }
                this.pageProgramme.setFreq2(this.pageProgramme.getFreq());
                this.adjustLargeurWobul();
                break;
            }
            case "largeurA": 
            case "ajust_labelLargeurImpulsion": {
                int tempLargeur = this.pageProgramme.getLargeur();
                this.pageProgramme.setLargeur(tempLargeur + sign * Utils.getIntDelta(tempLargeur));
                if (this.pageProgramme.getLargeurL2() == 0) {
                    this.label.setText(this.pageProgramme.getPrintLargeur());
                    break;
                }
                this.pageProgramme.setLargeur2(this.pageProgramme.getLargeur());
                this.adjustFreqWobul();
                break;
            }
            case "ttravailB": {
                double tempTtravailB = Double.parseDouble(this.label.getText());
                tempTtravailB += (double)sign * Utils.getDoubleDelta(tempTtravailB);
                this.pageProgramme.setTtravail2(tempTtravailB);
                this.setDoubleLabel(this.label, this.pageProgramme.getTtravail2());
                break;
            }
            case "tmonteeB": {
                double tempMonteeB = Double.parseDouble(this.label.getText());
                tempMonteeB += (double)sign * Utils.getDoubleDelta(tempMonteeB);
                this.pageProgramme.setTmontee2(tempMonteeB);
                this.setDoubleLabel(this.label, this.pageProgramme.getTmontee2());
                break;
            }
            case "tdescenteB": {
                double tempDescenteB = Double.parseDouble(this.label.getText());
                tempDescenteB += (double)sign * Utils.getDoubleDelta(tempDescenteB);
                this.pageProgramme.setTdescente2(tempDescenteB);
                this.setDoubleLabel(this.label, this.pageProgramme.getTdescente2());
                break;
            }
            case "treposB": {
                double tempReposB = Double.parseDouble(this.label.getText());
                tempReposB += (double)sign * Utils.getDoubleDelta(tempReposB);
                this.pageProgramme.setTrepos2(tempReposB);
                this.setDoubleLabel(this.label, this.pageProgramme.getTrepos2());
                break;
            }
            case "freqB": {
                int tempFreq2 = this.pageProgramme.getFreq2();
                this.pageProgramme.setFreq2(tempFreq2 + sign * Utils.getIntDelta(tempFreq2));
                if (this.pageProgramme.getFreqF2() == 0) {
                    this.label.setText(this.pageProgramme.getPrintFreq2());
                    break;
                }
                this.pageProgramme.setFreq(this.pageProgramme.getFreq2());
                this.adjustLargeurWobul();
                break;
            }
            case "largeurB": {
                int tempLargeur2 = this.pageProgramme.getLargeur2();
                this.pageProgramme.setLargeur2(tempLargeur2 + sign * Utils.getIntDelta(tempLargeur2));
                if (this.pageProgramme.getLargeurL2() == 0) {
                    this.label.setText(this.pageProgramme.getPrintLargeur2());
                    break;
                }
                this.pageProgramme.setLargeur(this.pageProgramme.getLargeur2());
                this.adjustFreqWobul();
                break;
            }
            case "combine": {
                int dc = Utils.intOfTime(this.label.getText());
                dc += sign * Utils.getDeltaDuree(dc);
                this.updateCombine(this.label, dc);
                break;
            }
            case "ajust_haut": {
                this.pageProgramme.incrDynHaut(sign);
                this.label.setText(this.pageProgramme.dynHaut + "%");
                this.controller.majGraphiqueBFB(this.pageProgramme, this.BFBChart);
                break;
            }
            case "ajust_montee": {
                this.pageProgramme.incrDynMontee(sign);
                this.label.setText(String.format("%.1f s", (double)this.pageProgramme.dynMontee / 10.0));
                this.controller.majGraphiqueBFB(this.pageProgramme, this.BFBChart);
                break;
            }
            case "ajust_travail": {
                this.pageProgramme.incrDynTravail(sign);
                this.label.setText(String.format("%.1f s", (double)this.pageProgramme.dynTravail / 10.0));
                this.controller.majGraphiqueBFB(this.pageProgramme, this.BFBChart);
                break;
            }
            case "repos": 
            case "ajust_repos": {
                this.pageProgramme.incrTrepos(sign);
                this.label.setText(String.format("%.1f s", this.pageProgramme.getTrepos()));
                if (this.BFBChart == null) break;
                this.controller.majGraphiqueBFB(this.pageProgramme, this.BFBChart);
                break;
            }
            case "ajust_duree_du_motif": {
                this.pageProgramme.incrDureeTravail(sign);
                this.label.setText(String.format("%.1f s", Float.valueOf(this.pageProgramme.dureeTravail)));
                break;
            }
            case "cs_haut": {
                int niv = Utils.parseIntSuffix(this.label.getText());
                niv = (niv += 5 * sign) < 0 ? 0 : Math.min(niv, 100);
                this.label.setText(niv + "%");
                this.controller.concatSimpleChanged(this.pageProgramme, this.BFBChart);
                break;
            }
            case "cs_travail": {
                double travail = Utils.parseDoubleSuffix(this.label.getText());
                travail = travail < 0.0 ? 0.0 : (travail > 60.0 ? 60.0 : (travail += (double)sign * 0.5));
                this.label.setText(String.format("%.1fs", travail));
                this.controller.concatSimpleChanged(this.pageProgramme, this.BFBChart);
                break;
            }
            case "cs_freq": {
                int csFreq = Utils.parseIntSuffix(this.label.getText());
                csFreq += sign * Utils.getIntDelta(csFreq);
                csFreq = Math.min(Math.max(csFreq, 1), 5000);
                int csTempLargeur = Utils.parseIntSuffix(((Label)this.label.getUserData()).getText());
                if (Pageprogramme.getImax(csFreq, csTempLargeur) < 1) break;
                this.label.setText(String.format("%dHz", csFreq));
                this.controller.concatSimpleChanged(this.pageProgramme, this.BFBChart);
                break;
            }
            case "cs_largeur": {
                int csLargeur = Utils.parseIntSuffix(this.label.getText());
                csLargeur += sign * Utils.getIntDelta(csLargeur);
                csLargeur = Math.min(Math.max(csLargeur, 100), 10000);
                int csTempFreq = Utils.parseIntSuffix(((Label)this.label.getUserData()).getText());
                if (Pageprogramme.getImax(csTempFreq, csLargeur) < 1) break;
                this.label.setText(String.format("%d\u00b5s", csLargeur));
                this.controller.concatSimpleChanged(this.pageProgramme, this.BFBChart);
                break;
            }
            case "cs_repos": {
                double csRepos = Utils.parseDoubleSuffix(this.label.getText());
                csRepos += (double)sign * Utils.getDoubleDelta(csRepos);
                csRepos = Math.min(60.0, Math.max(0.1, csRepos));
                this.label.setText(String.format("%.1fs", csRepos));
                this.controller.concatSimpleChanged(this.pageProgramme, this.BFBChart);
                break;
            }
            case "vitesse": {
                this.pageProgramme.vitesse = Math.min(10, Math.max(1, this.pageProgramme.vitesse + sign));
                this.label.setText(Integer.toString(this.pageProgramme.vitesse));
                break;
            }
            case "taille": {
                this.pageProgramme.taille = Math.min(10, Math.max(3, this.pageProgramme.taille + sign));
                this.label.setText(Integer.toString(this.pageProgramme.taille));
                break;
            }
            default: {
                Utils.debugLine("user data update (update), type inconnu : " + this.type, new Object[0]);
            }
        }
        this.updateButDefault();
    }

    private void updateButDefault() {
        if (this.butDefault != null) {
            this.butDefault.getStyleClass().clear();
            if (this.pageProgramme.getImaxA() > 1 && this.pageProgramme.getImaxB() > 1) {
                this.butDefault.getStyleClass().add((Object)"retryButtonTransp");
            } else {
                this.butDefault.getStyleClass().add((Object)"retryButtonRed");
            }
        }
    }

    private void updateCombine(Label label, int duree) {
        if (duree < 5) {
            duree = 5;
        }
        if (duree > 3600) {
            duree = 3600;
        }
        label.setText(Utils.stringOfTime(duree));
        this.controller.combineChanged(null, null);
    }

    public void set(String valeur) {
        try {
            Double value = Double.parseDouble(valeur);
            this.set(value);
            return;
        }
        catch (Exception value) {
            try {
                Pattern pattern = Pattern.compile("(\\d+)[^0-9]+(\\d+)");
                Matcher matcher = pattern.matcher(valeur);
                matcher.find();
                int v1 = Integer.parseInt(matcher.group(1));
                int v2 = Integer.parseInt(matcher.group(2));
                switch (this.type) {
                    case "freqA": 
                    case "freqB": {
                        this.pageProgramme.setFreq(v1);
                        this.pageProgramme.setFreq2(v1);
                        this.pageProgramme.setFreqF2(v2);
                        this.adjustLargeurWobul();
                        break;
                    }
                    case "largeurA": 
                    case "largeurB": {
                        this.pageProgramme.setLargeur(v1);
                        this.pageProgramme.setLargeur2(v1);
                        this.pageProgramme.setLargeurL2(v2);
                        this.label.setText(this.pageProgramme.getPrintLargeur());
                        this.adjustFreqWobul();
                    }
                }
            }
            catch (Exception e) {
                Utils.debugInfo("Erreur de lecture de wobul : %s (%s)", valeur, e);
            }
            return;
        }
    }

    private void adjustFreqWobul() {
        this.pageProgramme.setFreqF2(this.pageProgramme.getFreq() * this.pageProgramme.getLargeur() / this.pageProgramme.getLargeurL2());
        this.controller.afficheDroite();
    }

    private void adjustLargeurWobul() {
        this.pageProgramme.setLargeurL2(this.pageProgramme.getLargeur() * this.pageProgramme.getFreq() / this.pageProgramme.getFreqF2());
        this.controller.afficheDroite();
    }

    private void finWobul() {
        this.pageProgramme.setFreqF2(0);
        this.pageProgramme.setLargeurL2(0);
        this.controller.afficheDroite();
    }

    public void set(Double value) {
        switch (this.type) {
            case "dureePP": {
                this.pageProgramme.setDuree(value.intValue());
                this.label.setText(" " + Utils.stringOfTime(this.pageProgramme.getDuree()) + " ");
                break;
            }
            case "ttravailA": {
                this.pageProgramme.setTtravail(value);
                this.setDoubleLabel(this.label, this.pageProgramme.getTtravail());
                break;
            }
            case "tmonteeA": {
                this.pageProgramme.setTmontee(value);
                this.setDoubleLabel(this.label, this.pageProgramme.getTmontee());
                break;
            }
            case "tdescenteA": {
                this.pageProgramme.setTdescente(value);
                this.setDoubleLabel(this.label, this.pageProgramme.getTdescente());
                break;
            }
            case "treposA": {
                this.pageProgramme.setTrepos(value);
                this.setDoubleLabel(this.label, this.pageProgramme.getTrepos());
                break;
            }
            case "freqA": {
                this.pageProgramme.setFreq(value.intValue());
                if (this.pageProgramme.getFreqF2() == 0) {
                    this.label.setText(this.pageProgramme.getPrintFreq());
                    break;
                }
                this.finWobul();
                break;
            }
            case "largeurA": {
                this.pageProgramme.setLargeur(value.intValue());
                if (this.pageProgramme.getFreqF2() == 0) {
                    this.label.setText(this.pageProgramme.getPrintLargeur());
                    break;
                }
                this.finWobul();
                break;
            }
            case "ttravailB": {
                this.pageProgramme.setTtravail2(value);
                this.setDoubleLabel(this.label, this.pageProgramme.getTtravail2());
                break;
            }
            case "tmonteeB": {
                this.pageProgramme.setTmontee2(value);
                this.setDoubleLabel(this.label, this.pageProgramme.getTmontee2());
                break;
            }
            case "tdescenteB": {
                this.pageProgramme.setTdescente2(value);
                this.setDoubleLabel(this.label, this.pageProgramme.getTdescente2());
                break;
            }
            case "treposB": {
                this.pageProgramme.setTrepos2(value);
                this.setDoubleLabel(this.label, this.pageProgramme.getTrepos2());
                break;
            }
            case "freqB": {
                this.pageProgramme.setFreq2(value.intValue());
                if (this.pageProgramme.getFreqF2() == 0) {
                    this.label.setText(this.pageProgramme.getPrintFreq2());
                    break;
                }
                this.finWobul();
                break;
            }
            case "largeurB": {
                this.pageProgramme.setLargeur2(value.intValue());
                if (this.pageProgramme.getFreqF2() == 0) {
                    this.label.setText(this.pageProgramme.getPrintLargeur2());
                    break;
                }
                this.finWobul();
                break;
            }
            case "combine": {
                this.updateCombine(this.label, value.intValue());
                break;
            }
            case "repos": {
                this.pageProgramme.setTrepos(value);
                this.label.setText(String.format("%.1f s", this.pageProgramme.getTrepos()));
                if (this.BFBChart != null) {
                    this.controller.majGraphiqueBFB(this.pageProgramme, this.BFBChart);
                }
            }
            case "vitesse": {
                this.pageProgramme.vitesse = Math.min(10, Math.max(1, value.intValue()));
                this.label.setText(Integer.toString(this.pageProgramme.vitesse));
            }
            case "taille": {
                this.pageProgramme.taille = Math.min(10, Math.max(3, value.intValue()));
                this.label.setText(Integer.toString(this.pageProgramme.taille));
            }
            default: {
                Utils.debugLine("type inconnu : %s", this.type);
            }
        }
        this.updateButDefault();
    }

    private void setDoubleLabel(Label label, double val) {
        String res = String.format(Locale.ROOT, "%.1f", val);
        label.setText(res);
    }
}

