/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.view.programme.bfb.AnimationAPA;
import com.mazet.biostim.view.programme.bfb.AnimationBalance;
import com.mazet.biostim.view.programme.bfb.BalanceCible;
import com.mazet.biostim.view.programme.bfb.BalanceDesign;
import com.mazet.biostim.view.programme.bfb.BalanceLabyrinthe;
import com.mazet.biostim.view.programme.bfb.BiofeedbackController;
import com.mazet.biostim.view.programme.bfb.HistoriqueEmbarque;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public abstract class BiofeedbackAnimation {
    protected BiofeedbackController controller;
    BalanceDesign balanceDesign;
    double anchorHeight;
    private HistoriqueEmbarque historiqueEmbarque;
    double widthHistorique;
    double widthGame;
    double widthVoie2;
    double widthBalance;
    double oldFullAnchorWidth = 0.0;
    double oldFullAnchorHeight = 0.0;
    boolean needUpdateSize = false;
    static final double voie2RelativePosX = 0.5;
    static final double barreNiveauRelativePosY = 0.05;
    static final double barreNiveauRelativeHaut = 0.9;
    static final double barreNiveauRelativeLarg = 0.7;
    static final double strokeWidth = 5.0;
    private Rectangle voie2;
    private Rectangle barrevoie2;
    double minProgress;

    int getDefaultRelativeGameSize() {
        return 35;
    }

    void init(BiofeedbackController controller) {
        this.controller = controller;
        controller.checkHistorique.setSelected(controller.checkHistorique.isVisible() && Main.getConfig().afficheHistorique && !(this instanceof AnimationBalance));
        controller.checkTendance.setSelected(Main.getConfig().afficheTendance && !(this instanceof AnimationBalance));
        controller.checkPanel.setSelected(Main.getConfig().afficheSidePanel);
        if (this instanceof AnimationBalance) {
            FxUtils.setVisibility((Node)controller.dotButton, false);
        }
        if (!Main.getConfig().isActivated) {
            controller.checkPanel.setSelected(false);
            FxUtils.setVisibility((Node)controller.checkPanel, false);
            controller.checkTendance.setSelected(false);
            FxUtils.setVisibility((Node)controller.checkTendance, false);
        }
        if (controller.nbVoie == 1) {
            controller.checkVoie2.setSelected(false);
            FxUtils.setVisibility((Node)controller.checkVoie2, false);
        }
        boolean showBalance = this instanceof AnimationAPA || this instanceof AnimationBalance || SondeBT.connectionBiomoov >= 3 && !Biostim.isVoieBalance(controller.cvoie1) && !Biostim.isVoieBalance(controller.cvoie2) && Main.getConfig().actionBalanceBFB >= 1 && Main.getConfig().actionBalanceBFB <= 3;
        controller.checkBalance.setSelected(showBalance);
        FxUtils.setVisibility((Node)controller.checkBalance, SondeBT.connectionBiomoov >= 3);
        if (SondeBT.connectionBiomoov >= 3) {
            this.balanceDesign = Main.progEnCours.currentPageProgram.getType() == 13 ? (Main.progEnCours.currentPageProgram.designBalance == 1 ? new BalanceLabyrinthe(this) : new BalanceCible(this)) : (this instanceof AnimationAPA || Main.getConfig().actionBalanceBFB <= 2 ? new BalanceCible(this) : new BalanceLabyrinthe(this));
        }
        this.initSizes();
        if (controller.checkHistorique.isVisible()) {
            this.historiqueEmbarque = new HistoriqueEmbarque(this);
        }
        if (controller.checkVoie2.isVisible()) {
            this.initVoie2();
        }
        if (controller.checkBalance.isVisible()) {
            this.balanceDesign.init();
        }
        if (controller.checkTendance.isVisible()) {
            this.initTendance();
        }
        this.initGame();
        controller.fullAnchor.widthProperty().addListener((observableValue, number, number2) -> this.updateSize(false));
        controller.fullAnchor.heightProperty().addListener((observableValue, number, number2) -> this.updateSize(false));
    }

    abstract void initGame();

    private void initSizes() {
        double anchorWidth = this.controller.fullAnchor.getWidth();
        this.anchorHeight = this.controller.fullAnchor.getHeight();
        FxUtils.setVisibility((Node)this.controller.gameAnchor, this.controller.checkAnimation.isSelected());
        FxUtils.setVisibility((Node)this.controller.histoAnchor, this.controller.checkHistorique.isSelected());
        FxUtils.setVisibility((Node)this.controller.voie2Anchor, this.controller.checkVoie2.isSelected());
        FxUtils.setVisibility((Node)this.controller.balanceAnchor, this.controller.checkBalance.isSelected());
        FxUtils.setVisibility((Node)this.controller.sidePanel, this.controller.checkPanel.isSelected());
        FxUtils.setVisibility((Node)this.controller.menuHautBFBController.tendanceRegion, this.controller.checkTendance.isSelected());
        this.widthHistorique = 30.0;
        this.widthGame = this.getDefaultRelativeGameSize();
        this.widthVoie2 = 10.0;
        this.widthBalance = 25.0;
        double relativeSize = (this.controller.checkAnimation.isSelected() ? this.widthGame : 0.0) + (this.controller.checkHistorique.isSelected() ? this.widthHistorique : 0.0) + (this.controller.checkVoie2.isSelected() ? this.widthVoie2 : 0.0) + (this.controller.checkBalance.isSelected() ? this.widthBalance : 0.0);
        if (relativeSize == 0.0) {
            relativeSize = 50.0;
        }
        double widthPanel = this.controller.checkPanel.isSelected() ? relativeSize / 6.0 : 0.0;
        relativeSize += widthPanel;
        if (this.controller.checkAnimation.isSelected()) {
            this.widthGame *= anchorWidth / relativeSize;
            this.controller.gameAnchor.setMinWidth(this.widthGame);
            this.controller.gameAnchor.setMaxWidth(this.widthGame);
        }
        if (this.controller.checkHistorique.isSelected()) {
            this.widthHistorique *= anchorWidth / relativeSize;
            this.controller.histoAnchor.setMinWidth(this.widthHistorique);
            this.controller.histoAnchor.setMaxWidth(this.widthHistorique);
        }
        if (this.controller.checkVoie2.isSelected()) {
            this.widthVoie2 *= anchorWidth / relativeSize;
            this.controller.voie2Anchor.setMinWidth(this.widthVoie2);
            this.controller.voie2Anchor.setMaxWidth(this.widthVoie2);
        }
        if (this.controller.checkBalance.isSelected()) {
            this.widthBalance *= anchorWidth / relativeSize;
            this.controller.balanceAnchor.setMinWidth(this.widthBalance);
            this.controller.balanceAnchor.setMaxWidth(this.widthBalance);
        }
        if (this.controller.checkPanel.isSelected()) {
            this.controller.sidePanel.setMinWidth(widthPanel *= anchorWidth / relativeSize);
            this.controller.sidePanel.setMaxWidth(widthPanel);
        }
    }

    void updateSize(boolean force) {
        if (force || Math.abs(this.controller.fullAnchor.getHeight() - this.oldFullAnchorHeight) > 2.0 || Math.abs(this.controller.fullAnchor.getWidth() - this.oldFullAnchorWidth) > 2.0) {
            this.oldFullAnchorHeight = this.controller.fullAnchor.getHeight();
            this.oldFullAnchorWidth = this.controller.fullAnchor.getWidth();
            this.needUpdateSize = true;
            Platform.runLater(() -> {
                if (this.needUpdateSize) {
                    this.needUpdateSize = false;
                    this.initSizes();
                    if (this.controller.checkHistorique.isSelected()) {
                        this.historiqueEmbarque.updateSize();
                    }
                    if (this.controller.checkVoie2.isSelected()) {
                        this.updateSizeVoie2();
                    }
                    if (this.controller.checkBalance.isSelected()) {
                        this.balanceDesign.updateSizeBalance();
                    }
                    this.updateSizeGame();
                }
            });
        }
    }

    protected abstract void updateSizeGame();

    void updateSpecifique() {
        if (this.controller.checkHistorique.isSelected()) {
            this.historiqueEmbarque.update();
        }
        if (this.controller.checkBalance.isSelected()) {
            this.balanceDesign.updateBalance();
        }
        if (this.controller.checkVoie2.isSelected()) {
            this.updateVoie2Std();
        }
    }

    public void onResume() {
        FxUtils.setVisibility((Node)this.controller.pausePane, false);
        FxUtils.setVisibility((Node)this.controller.animationAnchor, true);
    }

    public void updateProfil() {
        if (this.controller.checkHistorique.isSelected()) {
            this.historiqueEmbarque.updateProfil();
        }
    }

    void nouvellesCourbes() {
    }

    void changeModeAveugle() {
    }

    public void addEvent(String event, double date) {
        Main.progEnCours.historique.addEvent(event, date + Main.progEnCours.revoir.startPageTime);
    }

    public static void postPositionneEvent(Label label, double labelX, double labelY) {
        if (label.getWidth() == 0.0) {
            label.setLayoutX(labelX);
            label.setLayoutY(labelY - 10.0);
            Platform.runLater(() -> BiofeedbackAnimation.postPositionneEvent(label, labelX, labelY));
        } else {
            label.setLayoutX(labelX - label.getWidth() / 2.0);
            label.setLayoutY(labelY - label.getHeight());
        }
    }

    boolean hasObjects() {
        return false;
    }

    public String getCouleurVoie1() {
        return Main.getConfig().couleurVoie1;
    }

    public String getCouleurVoie2() {
        return Main.getConfig().couleurVoie2;
    }

    void initVoie2() {
        this.voie2 = new Rectangle();
        this.voie2.setFill((Paint)Color.TRANSPARENT);
        this.voie2.setStroke((Paint)Color.web((String)Main.getConfig().couleurVoie2));
        this.voie2.setStrokeWidth(5.0);
        this.barrevoie2 = new Rectangle();
        this.barrevoie2.getStyleClass().add((Object)"barreVoieNiveau");
        this.updateSizeVoie2();
        this.controller.voie2Anchor.getChildren().addAll((Object[])new Node[]{this.voie2, this.barrevoie2});
    }

    protected void updateSizeVoie2() {
        double largeurvoie2 = this.widthVoie2 * 0.7;
        largeurvoie2 = Math.min(largeurvoie2, this.anchorHeight / 5.0);
        this.minProgress = (largeurvoie2 - 15.0) / (this.anchorHeight * 0.9 - 15.0);
        this.voie2.setX(0.5 * this.widthVoie2 - largeurvoie2 / 2.0);
        this.voie2.setY(this.anchorHeight * 0.05);
        this.voie2.setWidth(largeurvoie2);
        this.voie2.setHeight(this.anchorHeight * 0.9);
        this.voie2.setArcWidth(largeurvoie2);
        this.voie2.setArcHeight(largeurvoie2);
        this.barrevoie2.setX(0.5 * this.widthVoie2 - largeurvoie2 / 2.0 + 7.5);
        this.barrevoie2.setWidth(largeurvoie2 - 15.0);
        this.barrevoie2.setArcWidth(largeurvoie2 - 15.0);
        this.barrevoie2.setArcHeight(largeurvoie2 - 15.0);
    }

    void updateVoie2Std() {
        this.barrevoie2.setY(this.transformNiveauY(this.controller.niveauVoie2Aff));
        this.barrevoie2.setHeight(this.transformNiveauHeight(this.controller.niveauVoie2Aff));
    }

    double transformNiveauY(double valEntree) {
        valEntree = this.minProgress + (1.0 - this.minProgress) * valEntree / 100.0;
        return this.anchorHeight * 0.05 + 7.5 + (1.0 - valEntree) * (this.anchorHeight * 0.9 - 15.0);
    }

    double transformNiveauHeight(double valEntree) {
        valEntree = this.minProgress + (1.0 - this.minProgress) * valEntree / 100.0;
        return valEntree * (this.anchorHeight * 0.9 - 15.0);
    }

    private void initTendance() {
        this.controller.menuHautBFBController.graphTendance.getData().setAll((Object[])new XYChart.Series[]{Main.progEnCours.historique.tendanceTravail, Main.progEnCours.historique.tendanceRepos});
    }

    void setMarqueurBFBAssiste() {
    }

    void setPositionCurseur() {
    }

    double niv1AffOfReel(double reel) {
        double nivAff = 100.0 * (reel - Main.progEnCours.getAffMin(this.controller.cvoie1)) / (Main.progEnCours.getAffMax(this.controller.cvoie1) - Main.progEnCours.getAffMin(this.controller.cvoie1));
        if (nivAff < 0.0) {
            return 0.0;
        }
        if (nivAff > 100.0) {
            return 100.0;
        }
        return nivAff;
    }

    double niv2AffOfReel(double reel) {
        double nivAff = 100.0 * (reel - Main.progEnCours.getAffMin(this.controller.cvoie2)) / (Main.progEnCours.getAffMax(this.controller.cvoie2) - Main.progEnCours.getAffMin(this.controller.cvoie2));
        if (nivAff < 0.0) {
            return 0.0;
        }
        if (nivAff > 100.0) {
            return 100.0;
        }
        return nivAff;
    }

    double profToAff(double niv) {
        double affmin = Main.progEnCours.getAffMin(this.controller.cvoie1);
        double zeroProf = 100.0 * (Main.progEnCours.getBase(this.controller.cvoie1) - affmin) / (Main.progEnCours.getAffMax(this.controller.cvoie1) - affmin);
        return zeroProf + (100.0 - zeroProf) * niv / 100.0;
    }

    double baseToAff1() {
        double affmin = Main.progEnCours.getAffMin(this.controller.cvoie1);
        return 100.0 * (Main.progEnCours.getBase(this.controller.cvoie1) - affmin) / (Main.progEnCours.getAffMax(this.controller.cvoie1) - affmin);
    }

    double baseToAff2() {
        double affmin = Main.progEnCours.getAffMin(this.controller.cvoie2);
        return 100.0 * (Main.progEnCours.getBase(this.controller.cvoie2) - affmin) / (Main.progEnCours.getAffMax(this.controller.cvoie2) - affmin);
    }
}

