/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utilsfx.LineChartWithMarkers;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.view.programme.bfb.BiofeedbackController;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;

class HistoriqueEmbarque {
    private final BiofeedbackController controller;
    private static final double sizey = 0.85;
    private final LineChartWithMarkers<Number, Number> historyChart;
    private final XYChart.Data<Number, Number> verticalMarker;
    private final NumberAxis xAxis;
    private final XYChart.Series<Number, Number> pointsHistorique;
    private final XYChart.Series<Number, Number> pointsProfil;
    private int dureeHistorique = 20;
    private final int dureeAvance;
    private boolean firstStart = true;

    HistoriqueEmbarque(BiofeedbackAnimation animation) {
        this.controller = animation.controller;
        this.dureeHistorique = this.dureeHistorique * 10 / Main.getConfig().getVitesseDefilement();
        this.dureeAvance = Main.progEnCours.currentProgram.ghost ? 1 : (this.controller.profil.typeProfil() == 1 ? this.dureeHistorique : this.dureeHistorique / 6);
        this.xAxis = new NumberAxis();
        this.xAxis.setTickLabelsVisible(false);
        this.xAxis.setTickMarkVisible(false);
        this.xAxis.setMinorTickVisible(false);
        this.xAxis.setForceZeroInRange(false);
        this.xAxis.setAutoRanging(false);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setTickLabelsVisible(false);
        yAxis.setTickMarkVisible(false);
        yAxis.setMinorTickVisible(false);
        yAxis.setTickUnit(10.0);
        yAxis.setAutoRanging(false);
        yAxis.setLowerBound(-10.0);
        yAxis.setUpperBound(110.0);
        this.historyChart = new LineChartWithMarkers(this.xAxis, yAxis);
        this.historyChart.setId("historique");
        this.updateSize();
        this.historyChart.setVerticalZeroLineVisible(false);
        this.historyChart.setVerticalGridLinesVisible(false);
        this.verticalMarker = new XYChart.Data((Object)0.0, (Object)0.0);
        this.historyChart.addVerticalValueMarker(this.verticalMarker);
        this.historyChart.setAnimated(false);
        this.historyChart.setCreateSymbols(false);
        this.pointsHistorique = new XYChart.Series();
        this.pointsHistorique.setName(Biostim.nomOfVoie(this.controller.cvoie1));
        this.historyChart.getData().add(this.pointsHistorique);
        this.pointsProfil = new XYChart.Series();
        this.pointsProfil.setName(TransientConfig.translate("Profil"));
        this.updateProfil();
        this.historyChart.getData().add(this.pointsProfil);
        this.controller.histoAnchor.getChildren().add(this.historyChart);
    }

    void updateSize() {
        if (this.historyChart != null) {
            this.historyChart.setLayoutY(this.controller.biofeedbackAnimation.anchorHeight * 0.15000000000000002 * 0.7);
            this.historyChart.setPrefSize(this.controller.biofeedbackAnimation.widthHistorique, this.controller.biofeedbackAnimation.anchorHeight * 0.85);
        }
    }

    void updateProfil() {
        if (this.controller.checkHistorique.isSelected()) {
            double debut;
            this.pointsProfil.getData().clear();
            for (double x = debut = Math.max(-this.controller.dureeMilli, (double)(-this.dureeHistorique)); x < (double)this.dureeAvance; x += 0.1) {
                double d = x + this.controller.dureeMilli;
                double nivProfil = this.controller.biofeedbackAnimation.profToAff(this.controller.profil.getVal(d));
                this.pointsProfil.getData().add((Object)new XYChart.Data((Object)d, (Object)nivProfil));
            }
            this.pointsHistorique.getData().clear();
            ArrayList<Integer> temps = Main.progEnCours.historique.temps;
            ArrayList<Double> voie1 = Main.progEnCours.historique.niveauVoie1;
            for (int j = 0; j < temps.size(); ++j) {
                double t = (double)temps.get(j).intValue() / 100.0 - Main.progEnCours.revoir.startPageTime;
                if (!(t > debut)) continue;
                this.pointsHistorique.getData().add((Object)new XYChart.Data((Object)t, (Object)this.controller.biofeedbackAnimation.niv1AffOfReel(voie1.get(j))));
            }
        }
    }

    void update() {
        if (this.firstStart) {
            this.firstStart = false;
            String color = Main.getConfig().couleurVoie1;
            String style = String.format("-fx-stroke: %s;  -fx-background-color: %s;", color, color);
            for (Node n : this.controller.histoAnchor.lookupAll(".default-color0")) {
                n.setStyle(style);
            }
        }
        if (this.controller.started && this.controller.checkHistorique.isSelected()) {
            this.xAxis.setLowerBound(this.controller.dureeMilli - (double)this.dureeHistorique);
            this.xAxis.setUpperBound(this.controller.dureeMilli + (double)this.dureeAvance);
            this.verticalMarker.setXValue((Object)this.controller.dureeMilli);
            this.pointsHistorique.getData().add((Object)new XYChart.Data((Object)this.controller.dureeMilli, (Object)this.controller.niveauVoie1Aff));
            double nivProfil = this.controller.biofeedbackAnimation.profToAff(this.controller.profil.getVal(this.controller.dureeMilli + (double)this.dureeAvance));
            this.pointsProfil.getData().add((Object)new XYChart.Data((Object)(this.controller.dureeMilli + (double)this.dureeAvance), (Object)nivProfil));
            XYChart.Data data = (XYChart.Data)this.pointsHistorique.getData().get(0);
            while ((Double)data.getXValue() < this.controller.dureeMilli - (double)this.dureeHistorique) {
                this.pointsHistorique.getData().remove(0);
                data = (XYChart.Data)this.pointsHistorique.getData().get(0);
            }
            data = (XYChart.Data)this.pointsProfil.getData().get(0);
            while ((Double)data.getXValue() < this.controller.dureeMilli - (double)this.dureeHistorique) {
                this.pointsProfil.getData().remove(0);
                data = (XYChart.Data)this.pointsProfil.getData().get(0);
            }
        }
    }
}

