/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.comm;

import com.fazecast.jSerialComm.SerialPort;
import com.mazet.biostim.comm.UsbBiopod;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.utils.Security;
import com.mazet.biostim.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public abstract class RS232 {
    private static int portNb = 0;
    private static final ArrayList<String> portTestesBiostim = new ArrayList();

    public static void init() {
        System.setProperty("com.fazecast.jSerialComm.withNativeLibrary", "false");
        new Thread(UsbBiostim::activerChienGarde).start();
        new Thread(RS232::chercheUsbDevice).start();
    }

    private static void chercheUsbDevice() {
        String ftdiPort = Security.getBiostimPort();
        ArrayList<SerialPort> portsInit = RS232.getPortList();
        Utils.debugInfo("Liste des ports : %s", Arrays.toString(Arrays.stream(SerialPort.getCommPorts()).map(port -> port.getSystemPortName() + " : " + port.getPortDescription()).toArray()));
        ArrayList<SerialPort> portsPrioBiostim = new ArrayList<SerialPort>();
        ArrayList<SerialPort> portsPrioBiopod = new ArrayList<SerialPort>();
        for (SerialPort port2 : portsInit) {
            if (port2.getPortDescription().contains("STM32")) {
                portTestesBiostim.add(port2.getSystemPortName());
                portsPrioBiopod.add(port2);
                continue;
            }
            if (port2.getPortDescription().contains("Biostim")) {
                portsPrioBiostim.add(port2);
                continue;
            }
            if (ftdiPort == null || !port2.getSystemPortName().equals(ftdiPort)) continue;
            portsPrioBiostim.add(0, port2);
        }
        Utils.debugInfo("ports Biostim : %s", portsPrioBiostim.stream().map(SerialPort::getSystemPortName).collect(Collectors.toList()));
        Utils.debugInfo("ports Biopod : %s", portsPrioBiopod.stream().map(SerialPort::getSystemPortName).collect(Collectors.toList()));
        while (true) {
            try {
                while (true) {
                    ArrayList<SerialPort> ports = RS232.getPortList();
                    if ((UsbBiostim.searchBiostim() || UsbBiopod.searchBiopod()) && !ports.isEmpty()) {
                        SerialPort port2;
                        port2 = null;
                        if (UsbBiostim.searchBiostim() && !portsPrioBiostim.isEmpty()) {
                            port2 = (SerialPort)portsPrioBiostim.get(0);
                            portsPrioBiostim.remove(0);
                        } else if (UsbBiopod.searchBiopod() && !portsPrioBiopod.isEmpty()) {
                            port2 = (SerialPort)portsPrioBiopod.get(0);
                            portsPrioBiopod.remove(0);
                        }
                        if (port2 == null) {
                            portNb = (portNb + 1) % ports.size();
                            port2 = ports.get(portNb);
                        }
                        SerialPort finalPort = port2;
                        String portName = port2.getSystemPortName();
                        if (!(!UsbBiostim.searchBiostim() || portTestesBiostim.contains(portName) && UsbBiopod.searchBiopod())) {
                            portTestesBiostim.add(portName);
                            new Thread(() -> UsbBiostim.initConnexion(finalPort)).start();
                        } else {
                            portTestesBiostim.remove(portName);
                            new Thread(() -> UsbBiopod.initConnexion(finalPort)).start();
                        }
                        Utils.sleep(300L);
                        continue;
                    }
                    Utils.sleep(300L);
                }
            }
            catch (Exception e) {
                Utils.debugLine(e.toString(), new Object[0]);
                Utils.sleep(300L);
                continue;
            }
            break;
        }
    }

    static ArrayList<SerialPort> getPortList() {
        ArrayList<SerialPort> ports = new ArrayList<SerialPort>(Arrays.asList(SerialPort.getCommPorts()));
        ports.removeIf(p -> p.getSystemPortName().contains("Incoming-Port"));
        ports.removeIf(p -> p.getSystemPortName().contains("/dev/tty"));
        if (UsbBiostim.serialPort != null) {
            ports.removeIf(p -> p.getSystemPortName().equals(UsbBiostim.serialPort.getSystemPortName()));
        }
        if (UsbBiopod.serialPort != null) {
            ports.removeIf(p -> p.getSystemPortName().equals(UsbBiopod.serialPort.getSystemPortName()));
        }
        return ports;
    }

    static String getPortsListNames() {
        return Arrays.toString(Arrays.stream(SerialPort.getCommPorts()).map(SerialPort::getSystemPortName).toArray());
    }
}

