/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.BioPod;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.utils.CloudManager;
import com.mazet.biostim.utils.Maths;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import java.util.ArrayList;

public abstract class Biostim {
    public static final int nbVoies = 17;
    public static final int voie_A = 0;
    public static final int voie_B = 1;
    public static final int voie_P = 2;
    public static final int voie_P1 = 2;
    public static final int voie_P2 = 3;
    public static final int voie_Emy = 4;
    public static final int voie_Perifit = 5;
    public static final int voie_Perifit1 = 6;
    public static final int voie_Perifit2 = 7;
    public static final int voie_Blueback = 8;
    public static final int voie_BalanceDG = 9;
    public static final int voie_BalanceAA = 10;
    public static final int voie_BalanceV = 11;
    public static final int voie_BluebackBrut1 = 12;
    public static final int voie_BluebackBrut2 = 13;
    public static final int voie_Gonio = 14;
    public static final int voie_BioPodA = 15;
    public static final int voie_BioPodB = 16;
    public static double voieBfbA;
    public static double voieBfbB;
    public static double voiePression;
    public static double voiePression2;
    public static double voieSonde1;
    public static double voieSonde2;
    public static double voieBioPodA;
    public static double voieBioPodB;
    public static double voieBalanceGD;
    public static double voieBalanceAA;
    public static double voieBalanceV;
    public static double voieGonio;
    public static double voieBlueback;
    public static double voieBluebackBrut1;
    public static double voieBluebackBrut2;

    public static String nomOfVoie(int voie) {
        switch (voie) {
            case 0: {
                return "A";
            }
            case 1: {
                return "B";
            }
            case 2: {
                return Main.getConfig().nbVoiesPression() > 1 ? "P1" : "P";
            }
            case 3: {
                return "P2";
            }
            case 4: {
                return "Emy";
            }
            case 5: {
                return "Perifit";
            }
            case 6: {
                return "Perifit1";
            }
            case 7: {
                return "Perifit2";
            }
            case 8: {
                return "Blueback";
            }
            case 9: {
                return TransientConfig.translate("BalanceDG");
            }
            case 10: {
                return TransientConfig.translate("BalanceAA");
            }
            case 11: {
                return TransientConfig.translate("mouvements");
            }
            case 12: {
                return "Blueback Brut1";
            }
            case 13: {
                return "Blueback Brut2";
            }
            case 14: {
                return TransientConfig.translate("goniometre");
            }
            case 15: {
                return "BioPodA";
            }
            case 16: {
                return "BioPodB";
            }
        }
        Utils.debugLine("voie inconnue : %d", voie);
        return "?";
    }

    public static String shortNomOfVoie(int voie) {
        switch (voie) {
            case 0: {
                return "A";
            }
            case 1: {
                return "B";
            }
            case 2: {
                return Main.getConfig().nbVoiesPression() > 1 ? "P1" : "P";
            }
            case 3: {
                return "P2";
            }
            case 4: {
                return "E";
            }
            case 5: {
                return "PF";
            }
            case 6: {
                return "PF1";
            }
            case 7: {
                return "PF2";
            }
            case 8: {
                return "BB";
            }
            case 9: {
                return TransientConfig.translate("BDG");
            }
            case 10: {
                return TransientConfig.translate("BAA");
            }
            case 11: {
                return TransientConfig.translate("mvt");
            }
            case 12: {
                return "BB1";
            }
            case 13: {
                return "BB2";
            }
            case 14: {
                return "Deg";
            }
            case 15: {
                return "BA";
            }
            case 16: {
                return "BB";
            }
        }
        Utils.debugLine("voie inconnue : %d", voie);
        return "?";
    }

    public static boolean isVoieBT(int voie) {
        return voie >= 4 && voie <= 11 || voie == 14 || voie == 15 || voie == 16;
    }

    public static boolean isVoieBiopod(int voie) {
        return voie == 15 || voie == 16;
    }

    public static boolean isVoieBalance(int voie) {
        return voie >= 9 && voie <= 11 || voie == 14;
    }

    public static boolean isBTforbidden(int voie) {
        return voie == 8 && SondeBT.connectionBlueback < 2 || voie >= 4 && voie <= 7 && SondeBT.connectionSonde <= 2 || (voie == 9 || voie == 10 || voie == 11 || voie == 14) && SondeBT.connectionBiomoov <= 2 || (voie == 15 || voie == 16) && !BioPod.isConnected();
    }

    public static boolean isBTinvisible(int voie) {
        return voie == 8 && SondeBT.connectionBlueback < 2 || voie >= 4 && voie <= 7 && SondeBT.connectionSonde <= 2 || (voie == 9 || voie == 10 || voie == 11 || voie == 14) && SondeBT.connectionBiomoov <= 2 || (voie == 15 || voie == 16) && !BioPod.isConnected() && (!Main.getConfig().biopodDispo || Main.getConfig().nbVoiesStimDispo != 0);
    }

    public static double getMaxVoie(int voie) {
        switch (voie) {
            case 0: 
            case 1: {
                return UsbBiostim.getGainReel(0);
            }
            case 2: 
            case 3: {
                return 400.0;
            }
            case 12: 
            case 13: {
                return 1.6777215E7;
            }
            case 15: 
            case 16: {
                return 4000.0;
            }
        }
        return 6000.0;
    }

    public static int voieOfNom(String voie) {
        if (voie == null) {
            return 0;
        }
        if (voie.equals(TransientConfig.translate("mouvements"))) {
            return 11;
        }
        if (voie.equals(TransientConfig.translate("goniometre"))) {
            return 14;
        }
        if (voie.equals(TransientConfig.translate("BalanceDG"))) {
            return 9;
        }
        if (voie.equals(TransientConfig.translate("BalanceAA"))) {
            return 10;
        }
        switch (voie) {
            case "-": {
                return -1;
            }
            case "A": {
                return 0;
            }
            case "B": {
                return 1;
            }
            case "P": 
            case "P1": {
                return 2;
            }
            case "P2": {
                return 3;
            }
            case "Emy": {
                return 4;
            }
            case "Perifit": {
                return 5;
            }
            case "Perifit1": {
                return 6;
            }
            case "Perifit2": {
                return 7;
            }
            case "Blueback": {
                return 8;
            }
            case "Blueback Brut1": {
                return 12;
            }
            case "Blueback Brut2": {
                return 13;
            }
            case "BioPodA": {
                return 15;
            }
            case "BioPodB": {
                return 16;
            }
        }
        Utils.debugLine("voie inconnue : %s", voie);
        return -1;
    }

    public static ArrayList<String> getVoies() {
        ArrayList<String> voies = new ArrayList<String>();
        if (Main.getConfig().nbVoiesStimDispo > 0) {
            voies.add(Biostim.nomOfVoie(0));
        }
        if (Main.getConfig().nbVoiesStimDispo > 1) {
            voies.add(Biostim.nomOfVoie(1));
        }
        if (Main.getConfig().nbVoiesPressionDispo > 0) {
            voies.add(Biostim.nomOfVoie(2));
        }
        if (Main.getConfig().nbVoiesPressionDispo > 1) {
            voies.add(Biostim.nomOfVoie(3));
        }
        if (Main.getConfig().biopodDispo || BioPod.isConnected()) {
            voies.add(Biostim.nomOfVoie(15));
            voies.add(Biostim.nomOfVoie(16));
        }
        if (SondeBT.sondeBT == 1) {
            voies.add(Biostim.nomOfVoie(4));
        } else if (SondeBT.sondeBT == 2) {
            voies.add(Biostim.nomOfVoie(5));
            voies.add(Biostim.nomOfVoie(6));
            voies.add(Biostim.nomOfVoie(7));
        }
        if (SondeBT.connectionBlueback >= 2) {
            voies.add(Biostim.nomOfVoie(8));
        }
        if (SondeBT.connectionBiomoov > 2) {
            voies.add(Biostim.nomOfVoie(14));
            if (Main.getConfig().typeBalance == 0 || Main.getConfig().typeBalance == 1) {
                voies.add(Biostim.nomOfVoie(9));
            }
            if (Main.getConfig().typeBalance == 0 || Main.getConfig().typeBalance == 2) {
                voies.add(Biostim.nomOfVoie(10));
            }
        }
        return voies;
    }

    public static int defaultVoie1() {
        if (SondeBT.connectionBioPod > 2) {
            return 15;
        }
        if (SondeBT.sondeBT == 1) {
            return 4;
        }
        if (SondeBT.sondeBT == 2) {
            return 6;
        }
        if (Main.getConfig().nbVoiesStimDispo == 0) {
            return 15;
        }
        return 0;
    }

    public static int defaultVoie2() {
        return -1;
    }

    public static void simulation() {
        int tot = 0;
        while (true) {
            double aa;
            double gd;
            Utils.sleep(10L);
            long time = System.currentTimeMillis();
            voieBfbA = Maths.filtre(0, voieBfbA, UsbBiostim.voieBfbABrut);
            voieBfbB = Maths.filtre(1, voieBfbB, UsbBiostim.voieBfbBBrut);
            voiePression = Maths.filtre(2, voiePression, UsbBiostim.voiePressionBrut);
            voiePression2 = Maths.filtre(3, voiePression2, UsbBiostim.voiePression2Brut);
            voieSonde1 = Maths.filtre(-1, voieSonde1, SondeBT.levelSonde1);
            voieSonde2 = Maths.filtre(-1, voieSonde2, SondeBT.levelSonde2);
            voieBioPodA = Maths.filtre(15, voieBioPodA, BioPod.biopodA);
            voieBioPodB = Maths.filtre(16, voieBioPodB, BioPod.biopodB);
            voieBlueback = Maths.filtreLight(8, voieBlueback, SondeBT.levelBlueback);
            if (Main.progEnCours == null) {
                UsbBiostim.selectCalibre(0, voieBfbA);
                UsbBiostim.selectCalibre(1, voieBfbB);
            }
            if (Main.getConfig().inversionAxesBalance) {
                gd = SondeBT.balanceY / (double)Main.getConfig().coefBalanceGD;
                aa = SondeBT.balanceX / (double)Main.getConfig().coefBalanceAA;
            } else {
                gd = SondeBT.balanceX / (double)Main.getConfig().coefBalanceGD;
                aa = SondeBT.balanceY / (double)Main.getConfig().coefBalanceAA;
            }
            switch (Main.getConfig().typeBalance) {
                case 1: {
                    aa = 0.0;
                    break;
                }
                case 2: {
                    gd = 0.0;
                }
            }
            if (aa > 1.0) {
                aa = 1.0;
            }
            if (aa < -1.0) {
                aa = -1.0;
            }
            if (gd > 1.0) {
                gd = 1.0;
            }
            if (gd < -1.0) {
                gd = -1.0;
            }
            voieBalanceAA = Maths.filtreLight(10, voieBalanceAA, 50.0 + 50.0 * aa);
            voieBalanceGD = Maths.filtreLight(9, voieBalanceGD, 50.0 + 50.0 * gd);
            voieBalanceV = Maths.filtreLight(11, voieBalanceV, SondeBT.balanceV);
            voieGonio = Maths.filtreLight(14, voieGonio, SondeBT.biomoovGonio);
            if (UsbBiostim.isConnexionBioStim()) continue;
            if (++tot % 6 == 0) {
                double dtime = (double)time / 25000.0;
                UsbBiostim.voieBfbABrut = 80.0 + 60.0 * Math.sin(Math.PI * 2 * dtime);
                UsbBiostim.voieBfbBBrut = 20.0 + 20.0 * Math.cos(1.0 + Math.PI * 2 * dtime * 2.0);
                long tmp = time / 2000L % 3L;
                UsbBiostim.voiePressionBrut = (double)(20L + 25L * tmp * tmp) + 30.0 * (Math.random() - 0.5);
            }
            voiePression2 = UsbBiostim.voiePressionBrut;
        }
    }

    public static double getVoie(int voie) {
        switch (voie) {
            case 0: {
                return voieBfbA;
            }
            case 1: {
                return voieBfbB;
            }
            case 2: {
                return voiePression / Main.getConfig().getPressureFactor();
            }
            case 3: {
                return voiePression2 / Main.getConfig().getPressureFactor();
            }
            case 4: 
            case 6: {
                return voieSonde1;
            }
            case 7: {
                return voieSonde2;
            }
            case 5: {
                return (voieSonde1 + voieSonde2) / 2.0;
            }
            case 8: {
                return voieBlueback;
            }
            case 9: {
                return voieBalanceGD;
            }
            case 10: {
                return voieBalanceAA;
            }
            case 11: {
                return voieBalanceV;
            }
            case 12: {
                return voieBluebackBrut1;
            }
            case 13: {
                return voieBluebackBrut2;
            }
            case 14: {
                return voieGonio;
            }
            case 15: {
                return voieBioPodA;
            }
            case 16: {
                return voieBioPodB;
            }
        }
        CloudManager.sendJdd("getvoie inconnue (%d)", voie);
        Thread.dumpStack();
        return 0.0;
    }

    static {
        voieBalanceV = 0.0;
    }
}

