/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Config;
import com.mazet.biostim.utils.Security;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.utilsfx.HtmlToJavaFX;
import com.mazet.biostim.view.configuration.DebugView;
import com.mazet.biostim.zdata.Bilan;
import com.mazet.biostim.zdata.Patient;
import com.mazet.biostim.zdata.Programme;
import com.mazet.biostim.zdata.Seance;
import java.util.Date;
import javafx.application.Platform;
import javafx.scene.text.TextFlow;
import org.json.JSONObject;

public abstract class CloudManager {
    public static void sendSeanceCloud(Seance seance) {
        try {
            Programme prog = Main.progEnCours.currentProgram;
            Date now = new Date();
            Patient patient = Main.getCurrentPatient();
            String idPatient = patient == null ? "" : Main.getCurrentPatient().id;
            int motif = patient == null ? -2 : patient.motif;
            int type = prog.getType();
            String url = String.format("https://www.mazetsante.fr/biostim/send_seance.php?date=%s&time=%s&num_serie=%d&soft=%d&prog=%d&parentprog=%d&duree=%d&patient=%s&motif=%d&voie1=%d&voie2=%d&type=%d&freq=%d&largeur=%d&pourc_travail=%d&max=%d&min=%d&base=%d&affmin=%d&affmax=%d&max2=%d&min2=%d&base2=%d&affmin2=%d&affmax2=%d&pourcentage=%d&points=%d&stimamplitude=%d&stimamplitudeb=%d&animation=%d&fpsBFB=%d&contraction_moy=%d&repos_moy=%d&deficit=%d&deficit_pourmille=%d&contractions_completes=%d&compteur=%d", Utils.cloudDateFormat.format(now), Utils.cloudTimeFormat.format(now), Main.getConfig().numero_serie, Version.numVersionSoft, prog.getId(), prog.getParentId(), prog.getDuree() - Main.progEnCours.getProgDureeRestante(), idPatient, motif, prog.getVoieBFB1(), type != 1 ? prog.getVoieBFB2() : prog.getVoieStim2(), type | (SondeBT.connectionBiomoov == 3 && Main.getConfig().actionBalanceBFB != 0 ? 16 : 0), prog.getStimFreq(), prog.getStimLarg(), prog.getPourcentTravail(), CloudManager.nonNull(seance.getMax()), CloudManager.nonNull(seance.getMin()), (int)Main.progEnCours.getBase(prog.getVoieBFB1()), (int)Main.progEnCours.getAffMin(prog.getVoieBFB1()), (int)Main.progEnCours.getAffMax(prog.getVoieBFB1()), CloudManager.nonNull(seance.getMax2()), Main.progEnCours.getMinPower2(), (int)Main.progEnCours.getBase(prog.getVoieBFB2()), (int)Main.progEnCours.getAffMin(prog.getVoieBFB2()), (int)Main.progEnCours.getAffMax(prog.getVoieBFB2()), CloudManager.nonNull(seance.getPourcentage()), CloudManager.nonNull(seance.getPoints()), seance.getStimAmplitude(), seance.getStimAmplitudeB(), Main.progEnCours.typeAnimation, Main.progEnCours.fpsBFB, CloudManager.nonNullDixieme(seance.contractionMoyenne), CloudManager.nonNullDixieme(seance.reposMoyen), CloudManager.nonNullDixieme(seance.deficitContraction), seance.deficitContractionPourMille, seance.nbContractionsCompletes, Main.getConfig().dureeUtilisation);
            new Thread(() -> {
                try {
                    String res = Utils.getHttp(url);
                    System.out.format("cloud save : %s\n%s\n", url, res);
                }
                catch (Exception e) {
                    Utils.debugInfo("Erreur cloud save : %s", e.toString());
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendBilanCloud(Bilan bilan) {
        try {
            Programme prog = Main.progEnCours.currentProgram;
            Date now = new Date();
            Patient patient = Main.getCurrentPatient();
            String idPatient = patient == null ? "" : Main.getCurrentPatient().id;
            int motif = patient == null ? -2 : patient.motif;
            String url = String.format("https://www.mazetsante.fr/biostim/send_bilan.php?date=%s&heure=%s&num_serie=%d&soft=%d&prog=%d&patient=%s&motif=%d&voie1=%d&voie2=%d&pression_anale=%d&reflexe_anal=%d&vol_reflexe_anal=%d&vol_1_sens=%d&vol_sens_cste=%d&volume_rectal=%d&max=%d&nb_rapides=%d&maintien=%d&reflexe=%d&verrouillage=%d&vitesse_contract=%d&vitesse_relax=%d", Utils.cloudDateFormat.format(now), Utils.cloudTimeFormat.format(now), Main.getConfig().numero_serie, Version.numVersionSoft, prog.getParentId(), idPatient, motif, prog.getVoieBFB1(), prog.getVoieBFB2(), CloudManager.nonNull(bilan.pressionAnale), bilan.reflexeAnal, bilan.volReflexeAnal, bilan.volPremiereSensation, bilan.volSensationConstante, CloudManager.nonNull(bilan.volumeRectal), (int)bilan.levelMax, CloudManager.nonNull(bilan.nbRapides), CloudManager.nonNullDixieme(bilan.maintien), bilan.reflexe, bilan.verrouillage, CloudManager.nonNullDixieme(bilan.vitesseContraction), CloudManager.nonNullDixieme(bilan.vitesseRelachement));
            new Thread(() -> {
                try {
                    String res = Utils.getHttp(url);
                    System.out.format("cloud save : %s\n%s\n", url, res);
                }
                catch (Exception e) {
                    Utils.debugInfo("Erreur cloud save : %s", e.toString());
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendCompte() {
        try {
            Config config = Main.getConfig();
            String url = String.format("https://www.mazetsante.fr/biostim/send_compte.php?num_serie=%d&nom=%s&prenom=%s&mail=%s&addr=%s&optin=%d&serie=%d", config.numero_serie, Utils.UrlSqlEncode(config.compteNom), Utils.UrlSqlEncode(config.comptePrenom), Utils.UrlSqlEncode(config.compteMail), Utils.UrlSqlEncode(config.compteAddresse), config.compteOptin ? 1 : 0, config.compteSerie);
            String res = Utils.getHttp(url);
            Utils.debugInfo("sendCompte : %s", res);
        }
        catch (Exception e) {
            Utils.debugLine("sendCompte : %s", e);
        }
    }

    public static void sendJdd(String msg, Object ... args) {
        if (Version.isSAV() || Main.getConfig().numero_serie == 777) {
            return;
        }
        msg = String.format(msg, args);
        try {
            String url = String.format("https://www.mazetsante.fr/biostim/send_jdd.php?num_serie=%d&soft=%d&msg=%s", Main.getConfig().numero_serie, Version.numVersionSoft, Utils.SQLformat(msg)).replaceAll(" ", "%20");
            String res = Utils.getHttp(url);
            Utils.debugInfo("Envoi dans le JDD : %s%nRetour : %s", msg, res);
        }
        catch (Exception e) {
            Utils.debugLine("%s", e);
        }
    }

    public static void sendDistantJdd(int numeroSerie, String msg, Object ... args) {
        msg = String.format(msg, args);
        try {
            String url = String.format("https://www.mazetsante.fr/biostim/send_jdd.php?num_serie=%d&soft=%d&msg=%s", numeroSerie, Version.numVersionSoft, Utils.SQLformat(msg)).replaceAll(" ", "%20");
            String res = Utils.getHttp(url);
            Utils.debugInfo("Envoi dans le JDD : %s%nRetour : %s", msg, res);
        }
        catch (Exception e) {
            Utils.debugLine("%s", e);
        }
    }

    public static void connectBiopod() {
        int numSerie = Main.getConfig().numSerieBiopod;
        if (numSerie == 0 || numSerie == 999999) {
            return;
        }
        int numSerieBiostim = Version.isSAV() ? 888 : Main.getConfig().numero_serie;
        try {
            String exe = Main.getConfig().isExe ? (Computer.isMac() ? "app " : "exe ") : "";
            String url = String.format("https://www.mazetsante.fr/biostim/biopod.php?num_serie=%d&biostim=%d&model=%d&soft=%d&OS=%s / %s %s / %d proc %d Mo&java=%s%s %s bits&FW=%d&HW=%d&id=%d", Main.getConfig().numSerieBiopod, numSerieBiostim, Main.getConfig().modelBiopod, Version.numVersionSoft, System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().maxMemory() / 1024L / 1024L, exe, System.getProperty("java.version"), System.getProperty("sun.arch.data.model"), Main.getConfig().fwBiopod, Main.getConfig().hwBiopod, Main.getConfig().idBiopod).replaceAll(" ", "%20");
            String res = Utils.getHttp(url);
            JSONObject jsonVersion = new JSONObject(res);
            String action = jsonVersion.getString("action");
            if (action != null && !action.isEmpty() && !action.equals(Main.getConfig().lastRemoteActionBiopod)) {
                new Thread(() -> {
                    String[] decoupe;
                    Utils.sleep(1000L);
                    for (String a : decoupe = action.split(":")) {
                        DebugView.sendCommande(a, null);
                    }
                    Main.getConfig().lastRemoteActionBiopod = action;
                    Main.getConfig().saveConfig();
                }).start();
            }
            Main.getConfig().setCurrentIndiceHtml(jsonVersion.getInt("indiceHtml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONObject checkLatestVersion() {
        try {
            boolean newVersion;
            String mail;
            Object type = Main.getConfig().option10() ? "1." : "2.";
            type = (String)type + Main.getConfig().nbVoiesPression();
            if (Main.getConfig().isActivated) {
                type = (String)type + "p";
            }
            if (Main.getConfig().optionBluetooth == 2) {
                type = (String)type + "bt";
            }
            if (Main.getConfig().optionBluetooth == 1) {
                type = (String)type + "B";
            }
            if (Main.getConfig().isVerrouilleTotal()) {
                type = (String)type + "V";
            }
            if (Main.getConfig().isVerrouillePartiel()) {
                type = (String)type + "v";
            }
            if (Version.isSAV()) {
                type = (String)type + "S";
            }
            int num_serie = Version.isSAV() && Main.getConfig().numero_serie >= 98000000 ? 0 : Main.getConfig().numero_serie;
            String string = mail = Security.verifCheckSum == 2 ? "force" : TransientConfig.password;
            String vbs = Main.getConfig().isExe ? (Computer.isMac() ? "app " : "exe ") : "";
            String url = String.format("https://www.mazetsante.fr/biostim/latest.php?num_serie=%d&type=%s&soft=%d&OS=%s / %s %s / %d proc %d Mo&java=%s%s %s bits&FW=%s&code=%d&mail=%s&lang=%s&compteur=%d", num_serie, type, Version.numVersionSoft, System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().maxMemory() / 1024L / 1024L, vbs, System.getProperty("java.version"), System.getProperty("sun.arch.data.model"), Main.getConfig().version_biostim, Main.getConfig().idBiostim, mail, TransientConfig.langueSuffixe.substring(1), Main.getConfig().dureeUtilisation).replaceAll(" ", "%20");
            String res = Utils.getHttp(url);
            JSONObject jsonVersion = new JSONObject(res);
            try {
                if (UsbBiostim.isConnexionBioStim()) {
                    Main.getConfig().recupCompte(jsonVersion);
                    String action = jsonVersion.getString("action");
                    if (action != null && !action.isEmpty() && !action.equals(Main.getConfig().lastRemoteAction)) {
                        String[] decoupe;
                        for (String a : decoupe = action.split(":")) {
                            DebugView.sendCommande(a, null);
                        }
                        Main.getConfig().lastRemoteAction = action;
                        Main.getConfig().saveConfig();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int compteur = jsonVersion.getInt("compteur");
            Main.getConfig().ajusteDureeUtilisation(compteur);
            int num = jsonVersion.getInt("num");
            boolean bl = newVersion = num > Version.numVersionSoft;
            if (newVersion) {
                Main.getConfig().setEtatCloud(1);
                Utils.debugInfo("Une version plus recente est disponible : " + num);
            } else {
                Main.getConfig().setEtatCloud(0);
                Utils.debugInfo("le logiciel est a jour : %d <= %d", num, Version.numVersionSoft);
            }
            Main.getConfig().setCurrentIndiceHtml(jsonVersion.getInt("indiceHtml"));
            return jsonVersion;
        }
        catch (Exception e) {
            Main.getConfig().setEtatCloud(2);
            Utils.debugInfo("pas de connexion cloud : " + String.valueOf(e));
            return null;
        }
    }

    public static void checkLatestVersionAndActivation() {
        CloudManager.checkLatestVersion();
        if (Version.isSAV()) {
            return;
        }
        if (Main.getConfig().compteOK()) {
            return;
        }
        if (Main.getConfig().nbAvantBlocage > 0) {
            --Main.getConfig().nbAvantBlocage;
            Main.getConfig().saveConfig();
        }
        if (Main.getConfig().nbAvantBlocage <= 0) {
            Utils.popupAlert(TransientConfig.translate("nonActiveBloque"));
            Platform.runLater(() -> Main.menu.goToConfig());
        } else {
            boolean ok = Utils.popupDialog(TransientConfig.translate("nbAvantBlocage", Main.getConfig().nbAvantBlocage - 1), false);
            if (ok) {
                Platform.runLater(() -> Main.menu.goToConfig());
            }
        }
    }

    public static boolean checkVerrouillage() {
        try {
            String url = String.format("https://www.mazetsante.fr/biostim/verrou.php?num_serie=%s", Main.getConfig().numero_serie);
            String res = Utils.getHttp(url);
            JSONObject jsonVersion = new JSONObject(res);
            return jsonVersion.getInt("verrou") != 0;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static void getPubHtml(TextFlow pub) {
        try {
            String url = String.format("https://www.mazetsante.fr/biostim/stat_htm.php?num_serie=%d&lang=%s&mail=%s&distrib=%s", Main.getConfig().numero_serie, TransientConfig.langueSuffixe.substring(1), Utils.urlEncode(TransientConfig.password), Main.getConfig().distributeur);
            String res = Utils.getHttp(url);
            Platform.runLater(() -> {
                HtmlToJavaFX.toTextFlow(res, pub);
                String version = res.substring(4, res.indexOf("-->"));
                Main.getConfig().setIndiceHtmlAffiche(Integer.parseInt(version));
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int nonNull(Integer i) {
        if (i == null) {
            return -1;
        }
        return i;
    }

    private static int nonNull(Double d) {
        if (d == null) {
            return -1;
        }
        return (int)d.doubleValue();
    }

    private static int nonNullDixieme(Double d) {
        if (d == null) {
            return -1;
        }
        return (int)(d * 10.0);
    }
}

