/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.utils.CloudManager;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Security;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.view.configuration.Upgrade;
import com.mazet.biostim.zdata.AnimationStyle;
import com.mazet.biostim.zdata.Programme;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.paint.ImagePattern;
import javafx.scene.text.Font;
import org.json.JSONObject;

public class Config {
    public static String configJson;
    private static final String progCustom = "progcustom.json";
    private static final String progFav = "progfav.json";
    private static final String kineJson = "kines.json";
    public boolean biopodDispo = false;
    public int nbVoiesStimDispo = 0;
    public int nbVoiesPressionDispo = 0;
    public static ArrayList<ImagePattern> listImagesCatch;
    private static final ArrayList<String> builtinListObjetsCatch;
    private static final int nbBuiltinObjets;
    public boolean isExe = false;
    public boolean biopodUsb = true;
    public int dureeTarage = 60;
    public int dureeReglageStim = 30;
    public boolean modeDemo = false;
    public int mouseMove = 1;
    public boolean verifLancementsMultiples = true;
    public int ignoreSecu = 500;
    public int timeOutBT = 3;
    public int nbConcatLines = 5;
    public int nbCombineLines = 2;
    public HashMap<String, String> traductions = new HashMap();
    public int maxDureeProgramme = 3600;
    public String distributeur = "";
    public String compteNom = "";
    public String comptePrenom = "";
    public String compteMail = "";
    public String compteAddresse = "";
    public boolean compteOptin = false;
    public int comptePass = 0;
    public int compteSerie = 0;
    public int nbAvantBlocage = 50;
    public int versionProtocole = 1;
    public boolean isActivated = false;
    public int optionBluetooth = 1;
    public int posCavaliers = 0;
    public String version_biostim = "";
    public int numero_serie = 777;
    public int idBiostim;
    public int mem_interne;
    public int num_version_soft = 0;
    public int dureeUtilisation = 0;
    public int numSerieBiopod = 0;
    public int modelBiopod;
    public int fwBiopod;
    public int hwBiopod;
    public int idBiopod = 0;
    public int style = 1;
    public HashMap<Integer, String> lastAddrBLE = new HashMap();
    public boolean inversionAxesBalance = false;
    public int coefBalanceGD = 300;
    public int coefBalanceAA = 300;
    public int typeBalance = 0;
    public int actionBalanceBFB = 1;
    private int animationParDefaut = 2;
    public boolean anorectalPression = true;
    public boolean baseZeroPatient = false;
    public static final int defaultProgBilan = 500;
    public int progBilan = 500;
    public int typeScore = 2;
    public boolean activSonFinProgramme = true;
    public String sonFinProgramme = "./appData/sounds/end.mp3";
    public boolean activSonPageBFB = false;
    public String sonPageBFB = "./appData/sounds/FR_BFB.mp3";
    public boolean activSonPageStim = false;
    public String sonPageStim = "./appData/sounds/FR_stimulation.mp3";
    public boolean activSonDebutBFB = false;
    public String sonDebutBfb = "./appData/sounds/start.mp3";
    public boolean activSonFinBFB = false;
    public String sonFinBfb = "./appData/sounds/stop.mp3";
    public boolean activSonDebutStim = false;
    public String sonDebutStim = "./appData/sounds/start.mp3";
    private int typeBfbSonore = 0;
    public boolean pauseEtapesBilan = true;
    public int typePageTarage = 2;
    public boolean autoStart = true;
    public boolean decomptePageBFB = false;
    public boolean decomptePageStim = false;
    public boolean autoTarage = false;
    public boolean reposAvantTravail = true;
    public int epaisseurProfil = 10;
    public boolean traitParSeconde = false;
    public boolean eventClicDroit = false;
    public String event1 = "event 1";
    public String event2 = "event 2";
    private int vitesseDefilement = 10;
    public boolean voiesSeparees = false;
    public int lissage = 10;
    public int tailleChar = 3;
    public String lang = null;
    public int unite = 0;
    public int triPatients = 0;
    public boolean triSeances = false;
    public boolean afficheHistorique = true;
    public boolean afficheTendance = false;
    public boolean afficheSidePanel = false;
    public boolean stimBFB = false;
    public String couleurVoie1 = "red";
    public String couleurVoie2 = "blue";
    public int epaisseurVoie = 8;
    public boolean toujoursCurseur = true;
    public boolean noParallax = false;
    public boolean modeConfidentiel = true;
    public boolean afficheGraphiquePagePatient = false;
    public boolean noPraticienInForm = false;
    public String logoPerso = "";
    public boolean multiKine = false;
    public int kine = -1;
    public int activationKey = 0;
    public int btKey = 0;
    public ArrayList<AnimationStyle> customAnimationList = new ArrayList();
    public ArrayList<Integer> selectedAnimationsNb = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21));
    public ArrayList<String> customPlancheList = new ArrayList();
    public ArrayList<String> customObjetsCatch = new ArrayList();
    public String repPatients = "./patients/";
    public boolean forcePatient = true;
    public String sauvegarde_auto = "./backup/";
    public int freqSauvegarde = 30;
    public long lastSauvegarde = 0L;
    public static ArrayList<Integer> freqsBackup;
    public long askAptitude = 0L;
    public String lastRemoteAction = "";
    public String lastRemoteActionBiopod = "";
    public int etatCloud = 0;
    public int currentIndiceHtml = 1;
    public int indiceHtmlAffiche = 0;

    public boolean nothingConnected() {
        return !this.biopodDispo && this.nbVoiesStimDispo == 0 && this.nbVoiesPressionDispo == 0;
    }

    public void clearDispo() {
        this.posCavaliers = -1;
        this.biopodDispo = false;
        this.nbVoiesStimDispo = 0;
        this.nbVoiesPressionDispo = 0;
        this.saveConfig();
        Main.menu.changeLogo();
    }

    public void setBiopodDispo(boolean biopodDispo) {
        if (this.biopodDispo != biopodDispo) {
            this.biopodDispo = biopodDispo;
            if (biopodDispo) {
                this.isActivated = true;
                this.setOptionBT(2);
            }
            this.saveConfig();
            Main.menu.changeLogo();
        }
    }

    public boolean optionPlanches() {
        return this.isActivated || !this.option10();
    }

    public boolean optionPatients() {
        return this.isActivated || !this.option10();
    }

    public boolean optionAnimationPerso() {
        return !this.option10();
    }

    public boolean optionBatir() {
        return this.isActivated || Main.getConfig().biopodDispo;
    }

    public boolean isTypeProgAutorise(int typeProg) {
        if (this.isActivated) {
            return true;
        }
        if (typeProg == 7) {
            return true;
        }
        if (typeProg == 11) {
            return true;
        }
        if (typeProg == 13) {
            return true;
        }
        return typeProg < 5;
    }

    public boolean optionStimMotrice() {
        return this.nbVoiesPression() > 0;
    }

    public boolean optionBFBAssiste() {
        return this.isActivated && this.nbVoiesStimDispo > 0;
    }

    public boolean option10() {
        return (this.posCavaliers & 4) == 4;
    }

    public int nbVoiesPression() {
        if (this.versionProtocole == 0) {
            return 1;
        }
        if ((this.posCavaliers & 3) == 1) {
            return 1;
        }
        if ((this.posCavaliers & 3) >= 2) {
            return 2;
        }
        return 0;
    }

    public int nbVoiesStim() {
        if (this.option10()) {
            return 1;
        }
        return 2;
    }

    public static int codePosObj(int i) {
        return i >= nbBuiltinObjets ? i - nbBuiltinObjets : -i - 1;
    }

    public static int decodePosObj(int i) {
        return Math.min(i >= 0 ? i + nbBuiltinObjets : -1 - i, listImagesCatch.size() - 1);
    }

    public void setDistributeur(String distributeur) {
        if (!this.distributeur.equals(distributeur)) {
            this.distributeur = distributeur;
            this.saveConfig();
            Main.setCSS();
            Main.menu.changeLogo();
            Main.menu.updateMenuWidth();
        }
        this.maxDureeProgramme = distributeur.equals("menfis") ? 2400 : 3600;
    }

    public int calcComptePass() {
        byte[] bytes;
        int res = this.compteSerie != 0 ? this.compteSerie : this.numero_serie;
        for (byte b : bytes = this.compteMail.getBytes()) {
            res = (res * 7 + b) % 997111;
        }
        return res;
    }

    public static int calcComptePass(int numSerie, String mail) {
        byte[] bytes;
        int res = numSerie;
        for (byte b : bytes = mail.getBytes()) {
            res = (res * 7 + b) % 997111;
        }
        return res;
    }

    public boolean compteOK() {
        return Main.getConfig().distributeur.equals("menfis") || !this.compteNom.isEmpty() && !this.comptePrenom.isEmpty() && !this.compteAddresse.isEmpty() && this.comptePass == this.calcComptePass();
    }

    public void recupCompte(JSONObject jsonVersion) {
        if (this.compteMail.isEmpty()) {
            this.compteSerie = jsonVersion.getInt("compteserie");
            if (this.compteSerie == this.numero_serie) {
                this.compteNom = jsonVersion.getString("nom");
                this.comptePrenom = jsonVersion.getString("prenom");
                this.compteMail = jsonVersion.getString("mail");
                this.compteAddresse = jsonVersion.getString("addr");
                this.compteOptin = jsonVersion.getInt("optin") == 1;
                this.comptePass = this.calcComptePass();
                this.nbAvantBlocage = 50;
                Platform.runLater(() -> Main.menu.changeAlertes());
            } else {
                this.compteSerie = 0;
            }
        }
    }

    public void incrDureeUtilisation(int duree) {
        if (duree > 0) {
            this.dureeUtilisation += duree;
            this.saveConfig();
        }
    }

    public void ajusteDureeUtilisation(int duree) {
        if (duree > this.dureeUtilisation) {
            this.dureeUtilisation = duree;
            this.saveConfig();
        }
    }

    public void setModelBiopod(int modelBiopod) {
        this.modelBiopod = modelBiopod;
        this.setBiopodDispo((modelBiopod & 2) != 0);
    }

    public static Config getConfigFromJson(String configFile) {
        if (configFile != null) {
            Utils.debugInfo("Lecture du config.json : %s", configFile);
            configJson = configFile;
        } else {
            configJson = System.getProperty("user.home") + File.separatorChar + "BiostimData" + File.separatorChar + "config.json";
        }
        if (!new File(configJson).exists()) {
            Upgrade.recupereVieuxJson();
        }
        Computer.absolutePath = System.getProperty("user.home") + File.separatorChar + "BiostimData" + File.separator;
        Config temps = Utils.fromJsonFile(configJson, Config.class);
        try {
            if (temps.repPatients == null || !Computer.newBiostimFile(temps.repPatients).exists()) {
                Utils.debugInfo("reinit repertoire patient");
                temps.repPatients = "./patients/";
                temps.saveConfig();
            }
            new File(temps.getRepPatients() + "/bilan").mkdirs();
            new File(temps.getRepPatients() + "/seances").mkdirs();
            new File(temps.getRepPatients() + "/db").mkdirs();
            new File(temps.getRepPatients() + "/trash").mkdirs();
            if (temps.sauvegarde_auto == null || !Computer.newBiostimFile(temps.sauvegarde_auto).exists()) {
                Utils.debugInfo("reinit repertoire backup");
                temps.sauvegarde_auto = "./backup/";
                Computer.newBiostimFile(temps.getSauvegarde_auto()).mkdirs();
            }
            for (AnimationStyle as : temps.customAnimationList) {
                as.type = 4;
                as.createPatterns();
            }
            for (String s : builtinListObjetsCatch) {
                Config.addImageCatch(s, true);
            }
            for (String s : temps.customObjetsCatch) {
                Config.addImageCatch(s, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return temps;
    }

    public static void addImageCatch(String s, boolean isBuiltin) {
        Image im = Computer.getImage(s, "croix.png", !isBuiltin);
        listImagesCatch.add(new ImagePattern(im));
    }

    public synchronized void saveConfig() {
        try {
            Utils.saveJson(this, configJson);
            new File(this.getRepPatients() + "/bilan").mkdirs();
            new File(this.getRepPatients() + "/seances").mkdirs();
            new File(this.getRepPatients() + "/db").mkdirs();
            new File(this.getRepPatients() + "/trash").mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean createBackup(String repSauvegarde, boolean auto) {
        try {
            String prefix;
            new File(repSauvegarde + "/bilan/").mkdirs();
            new File(repSauvegarde + "/seances/").mkdirs();
            String string = prefix = auto ? "sauvegarde_biostim" : "sauvegarde_manuelle_biostim";
            if (auto) {
                Utils.deleteOldFiles(repSauvegarde, prefix);
            }
            FileOutputStream fos = new FileOutputStream(repSauvegarde + "/" + prefix + "_" + Utils.fileDateFormat.format(new Date()) + ".mazet");
            ZipOutputStream zos = new ZipOutputStream(fos);
            Utils.addToZipFile(this.getKineJson(), zos);
            Utils.addToZipFile(this.getProgCustom(), zos);
            Utils.addToZipFile(this.getProgFav(), zos);
            File rep = new File(this.getRepPatients() + "/db/");
            for (String file : rep.list()) {
                if (!file.endsWith(".json")) continue;
                Utils.addToZipFile(this.getRepPatients() + "/db/" + file, zos);
            }
            zos.close();
            fos.close();
            this.copyDirContent(this.getRepPatients() + "/bilan/", repSauvegarde + "/bilan/");
            this.copyDirContent(this.getRepPatients() + "/seances/", repSauvegarde + "/seances/");
            return true;
        }
        catch (Exception e) {
            if (!auto) {
                Utils.popupAlert(TransientConfig.translate("sauvegarde_impossible"));
            }
            e.printStackTrace();
            return false;
        }
    }

    public boolean hasPatient() {
        File rep = new File(this.getRepPatients() + "/db/");
        for (String file : rep.list()) {
            if (!file.endsWith(".json")) continue;
            return true;
        }
        return false;
    }

    public void restoreBackup(String zipFile) {
        byte[] buffer = new byte[1024];
        try {
            String repSauvegarde = new File(zipFile).getParent();
            ZipInputStream zis = new ZipInputStream(Files.newInputStream(Paths.get(zipFile, new String[0]), new OpenOption[0]));
            for (String file : new File(this.getRepPatients() + "/db/").list()) {
                if (!file.endsWith(".json")) continue;
                new File(this.getRepPatients() + "/db/" + file).delete();
            }
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                Object outputFolder = this.getRepPatients() + "/db/";
                if (fileName.equalsIgnoreCase(progCustom) || fileName.equalsIgnoreCase(progFav) || fileName.equalsIgnoreCase(kineJson)) {
                    outputFolder = this.getRepPatients();
                }
                File newFile = new File((String)outputFolder + File.separator + fileName);
                System.out.println("file unzip : " + String.valueOf(newFile.getAbsoluteFile()));
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            this.copyDirContent(repSauvegarde + "/bilan/", this.getRepPatients() + "/bilan/");
            this.copyDirContent(repSauvegarde + "/seances/", this.getRepPatients() + "/seances/");
            Utils.popupAlert(TransientConfig.translate("contentAlertSauvOk"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyDirContent(String src, String dest) {
        try {
            File repertoireBilan_modele = new File(src);
            for (String fichier : repertoireBilan_modele.list()) {
                Path adresseSource = Paths.get(src + fichier, new String[0]);
                Path adresseDestination = Paths.get(dest + fichier, new String[0]);
                Files.copy(adresseSource, adresseDestination, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getLogo() {
        if (this.distributeur.equals("menfis")) {
            return "menfis/logo.png";
        }
        return "logo.png";
    }

    public String getProgFav() {
        return this.getRepPatients() + "/progfav.json";
    }

    public String getProgCustom() {
        return this.getRepPatients() + "/progcustom.json";
    }

    public String getKineJson() {
        return this.getRepPatients() + "/kines.json";
    }

    public String getSauvegarde_auto() {
        return Computer.makeAbsolute(this.sauvegarde_auto);
    }

    public void setSauvegarde_auto(String sauvegarde_auto) {
        this.sauvegarde_auto = Computer.tryRelative(sauvegarde_auto);
    }

    public int getAnimationParDefaut() {
        if (this.animationParDefaut >= this.selectedAnimationsNb.size() + this.customAnimationList.size()) {
            return 0;
        }
        return this.animationParDefaut;
    }

    public void setAnimationParDefaut(int animationParDefaut) {
        if (this.animationParDefaut != animationParDefaut) {
            this.animationParDefaut = animationParDefaut;
            this.saveConfig();
        }
    }

    public void setAJouteTailleChar(int deltaChar) {
        this.tailleChar += deltaChar;
        Main.mainLayout.setStyle(String.format("-fx-font-size: %d", (int)(Font.getDefault().getSize() * (0.55 + (double)this.tailleChar * 0.15))));
    }

    public void setLang(String lang) {
        this.lang = lang.contains(":") ? lang.substring(0, 2) : null;
        TransientConfig.choixLangue();
    }

    public void resetTraduction(String key) {
        this.traductions.remove(key);
        this.saveConfig();
    }

    public void addTraduction(String key, String value) {
        this.traductions.put(key, value);
        this.saveConfig();
    }

    public void setUnite(int unite) {
        this.unite = unite;
    }

    public String getPressureUnite() {
        switch (this.unite) {
            case 0: {
                return "mbar";
            }
            case 1: {
                return "cmH2O";
            }
        }
        return "mmHg";
    }

    public double getPressureFactor() {
        switch (this.unite) {
            case 0: 
            case 1: {
                return 1.0;
            }
        }
        return 1.36;
    }

    public void setTypePageTarage(int typePageTarage) {
        this.typePageTarage = typePageTarage;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setAutoTarage(boolean autoTarage) {
        this.autoTarage = autoTarage;
    }

    public void setVoiesSeparees(boolean voiesSep) {
        this.voiesSeparees = voiesSep;
    }

    public void setStimBFB(boolean stimBFB) {
        this.stimBFB = stimBFB;
    }

    public void setModeConfidentiel(boolean modeConfidentiel) {
        this.modeConfidentiel = modeConfidentiel;
        this.saveConfig();
    }

    public void setActivationKey(int activationKey) {
        if (this.activationKey != activationKey) {
            this.activationKey = activationKey;
            Security.checkKeyV0();
        }
    }

    public void setBtKey(int btKey) {
        if (this.btKey != btKey) {
            this.btKey = btKey;
            Security.checkKeyV0();
        }
    }

    public String getSonFinProgramme() {
        if (!this.activSonFinProgramme) {
            return null;
        }
        return Computer.makeAbsolute(this.sonFinProgramme);
    }

    public void setSonFinProgramme(String sonFinProgramme) {
        this.sonFinProgramme = Computer.tryRelative(sonFinProgramme);
    }

    public String getSonDebutBfb() {
        if (!this.activSonDebutBFB) {
            return null;
        }
        return Computer.makeAbsolute(this.sonDebutBfb);
    }

    public void setSonDebutBfb(String sonDebutBfb) {
        this.sonDebutBfb = Computer.tryRelative(sonDebutBfb);
    }

    public String getSonFinBfb() {
        if (!this.activSonFinBFB) {
            return null;
        }
        return Computer.makeAbsolute(this.sonFinBfb);
    }

    public void setSonFinBfb(String sonFinBfb) {
        this.sonFinBfb = Computer.tryRelative(sonFinBfb);
    }

    public String getSonPageBFB() {
        if (!this.activSonPageBFB) {
            return null;
        }
        return Computer.makeAbsolute(this.sonPageBFB);
    }

    public void setSonPageBFB(String sonPageBFB) {
        this.sonPageBFB = Computer.tryRelative(sonPageBFB);
    }

    public String getSonPageStim() {
        if (!this.activSonPageStim) {
            return null;
        }
        return Computer.makeAbsolute(this.sonPageStim);
    }

    public void setSonPageStim(String sonPageStim) {
        this.sonPageStim = Computer.tryRelative(sonPageStim);
    }

    public String getSonDebutStim() {
        if (!this.activSonDebutStim) {
            return null;
        }
        return Computer.makeAbsolute(this.sonDebutStim);
    }

    public void setSonDebutStim(String sonDebutStim) {
        this.sonDebutStim = Computer.tryRelative(sonDebutStim);
    }

    public void setVersionProtocole(int versionProtocole) {
        if (this.versionProtocole != versionProtocole) {
            this.versionProtocole = versionProtocole;
            Main.menu.changeLogo();
            this.saveConfig();
        }
    }

    public boolean isVerrouille() {
        if (this.isVerrouilleTotal()) {
            return true;
        }
        if (this.isVerrouillePartiel()) {
            return CloudManager.checkVerrouillage();
        }
        return false;
    }

    public boolean isVerrouilleTotal() {
        return (this.mem_interne & 4) != 0;
    }

    public boolean isVerrouillePartiel() {
        return (this.mem_interne & 8) != 0;
    }

    public void setActivated(boolean isActivated) {
        if (this.isActivated != isActivated) {
            this.isActivated = isActivated;
            if (!isActivated && !Version.isSAV()) {
                this.autoTarage = false;
                this.multiKine = false;
                this.kine = -1;
            }
            Main.menu.changeLogo();
            this.saveConfig();
        }
    }

    public void setOptionBT(int optionBluetooth) {
        boolean force;
        boolean bl = force = optionBluetooth == 2 && this.optionBluetooth != 2 || optionBluetooth == 0 && this.optionBluetooth != 0 || optionBluetooth == 1 && this.optionBluetooth == 0;
        if (force) {
            this.optionBluetooth = optionBluetooth;
            new Thread(() -> CloudManager.sendJdd("set option bluetooth = %d", this.optionBluetooth)).start();
            if (optionBluetooth == 0) {
                new Thread(SondeBT::stop).start();
            }
            Main.menu.changeBTStatus();
            this.saveConfig();
        }
    }

    public void setCavaliers(int cavaliers) {
        this.posCavaliers = cavaliers;
        this.nbVoiesStimDispo = this.nbVoiesStim();
        this.nbVoiesPressionDispo = this.nbVoiesPression();
        this.saveConfig();
        Main.menu.changeLogo();
    }

    public void setEtatCloud(int etatCloud) {
        if (etatCloud != this.etatCloud) {
            this.etatCloud = etatCloud;
            this.saveConfig();
            Main.menu.changeAlertes();
        }
    }

    public void setIndiceHtmlAffiche(int indiceHtmlAffiche) {
        if (indiceHtmlAffiche != this.indiceHtmlAffiche) {
            this.indiceHtmlAffiche = indiceHtmlAffiche;
            this.saveConfig();
            Main.menu.changeAlertes();
        }
    }

    public void setCurrentIndiceHtml(int currentIndiceHtml) {
        if (currentIndiceHtml != this.currentIndiceHtml) {
            this.currentIndiceHtml = currentIndiceHtml;
            this.saveConfig();
            Main.menu.changeAlertes();
        }
    }

    public void setVersion_biostim(String version_biostim) {
        if (!version_biostim.equals(this.version_biostim)) {
            this.version_biostim = version_biostim;
            this.saveConfig();
        }
    }

    public void setNumero_serie(int numero_serie) {
        if (numero_serie == 0) {
            numero_serie = 98000000 + this.idBiostim;
        }
        if (this.numero_serie != numero_serie) {
            this.numero_serie = numero_serie;
            this.dureeUtilisation = 0;
            this.saveConfig();
        }
    }

    public void setIdBiostim(int idBiostim) {
        if (this.idBiostim != idBiostim) {
            this.idBiostim = idBiostim;
            this.saveConfig();
        }
    }

    public void setMem_interne(int mem_interne) {
        if (this.mem_interne != mem_interne) {
            new Thread(() -> CloudManager.sendJdd("set mem interne = %d", mem_interne)).start();
        }
        this.mem_interne = mem_interne;
        this.setActivated((mem_interne & 1) != 0);
        this.setOptionBT(mem_interne & 2);
        Main.menu.changeHomeStatus();
        this.saveConfig();
    }

    public void setLastAddrBLE(int type, String addr) {
        if (!addr.equals(this.lastAddrBLE.get(type))) {
            this.lastAddrBLE.put(type, addr);
            this.saveConfig();
        }
    }

    public void setLastSauvegarde() {
        this.lastSauvegarde = System.currentTimeMillis() / 1000L;
        this.saveConfig();
    }

    public void setNextAptitude(int nbJour) {
        this.askAptitude = nbJour == -1 ? -1L : System.currentTimeMillis() / 1000L + (long)nbJour * 86400L;
        this.saveConfig();
    }

    public void setKine(int kine) {
        if (this.kine != kine) {
            this.kine = kine;
            this.saveConfig();
        }
    }

    public int getBfbSonore() {
        return this.typeBfbSonore;
    }

    public void setBfbSonore(int typeBfbSonore) {
        this.typeBfbSonore = typeBfbSonore;
    }

    public int getVitesseDefilement() {
        return this.vitesseDefilement;
    }

    public void setAjouteVitesseDefilement(int ajout) {
        this.vitesseDefilement += ajout;
    }

    public String getRepPatients() {
        return Computer.makeAbsolute(this.repPatients);
    }

    public void setRepPatients(String repPatients) {
        this.repPatients = Computer.tryRelative(repPatients);
    }

    public void setReposAvantTravail(boolean reposAvantTravail) {
        if (this.reposAvantTravail != reposAvantTravail) {
            this.reposAvantTravail = reposAvantTravail;
            Programme.resetPng();
        }
    }

    static {
        listImagesCatch = new ArrayList();
        builtinListObjetsCatch = new ArrayList<String>(Arrays.asList("catch/assis.png", "catch/debout.png", "catch/sauter.png", "catch/clochepied.png", "catch/courir.png", "catch/equilibre.png", "catch/penche.png", "div_anim/flecheplus.png", "div_anim/flechemoins.png", "etoile_bleu.png", "etoile_rouge.png", "pacman/objet0.png", "pacman/objet1.png", "pacman/objet2.png", "pacman/objet3.png"));
        nbBuiltinObjets = builtinListObjetsCatch.size();
        freqsBackup = new ArrayList<Integer>(Arrays.asList(0, 7, 14, 30));
    }
}

