/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.CloudManager;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import javafx.application.Platform;
import javax.swing.filechooser.FileSystemView;

public abstract class Security {
    public static int verifCheckSum = 1;

    public static void verifStart() {
        Security.verifCheckSum();
        if (Computer.isMac() && !TransientConfig.isDev()) {
            Security.verifInstallMac();
        }
        if (Computer.isWindows()) {
            Security.verifLnk();
        }
    }

    private static void verifCheckSum() {
        try {
            String f = Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (f.endsWith("/")) {
                Utils.debugInfo("!!! Pas de verif du checksum !!!");
                return;
            }
            if (f.charAt(0) == '/' && f.charAt(2) == ':') {
                f = f.substring(1);
            }
            String theorique = new String(Files.readAllBytes(Paths.get(Computer.absolutePath + Version.checkSumFile, new String[0])));
            long start = System.currentTimeMillis();
            String md5 = Security.getChecksum(f);
            Utils.debugInfo("md5 : %s (%d ms)", md5, System.currentTimeMillis() - start);
            if (theorique.equals(md5)) {
                verifCheckSum = 0;
            } else {
                verifCheckSum = 2;
                CloudManager.sendJdd("CheckSum Invalide", new Object[0]);
                Utils.popupAlert(TransientConfig.translate("checksum_invalide"));
                Platform.runLater(Main.menu::goToAutotest);
            }
        }
        catch (Exception e) {
            Utils.debugInfo("Impossible de v\u00e9rifier le checksum : %s", e);
        }
    }

    private static String getChecksum(String filename) throws Exception {
        int numRead;
        MessageDigest complete = MessageDigest.getInstance("MD5");
        InputStream fis = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        byte[] buffer = new byte[1024];
        do {
            if ((numRead = fis.read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        fis.close();
        byte[] b = complete.digest();
        StringBuilder result = new StringBuilder();
        for (byte value : b) {
            result.append(Integer.toString((value & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static String readRegString(String key, String value) {
        if (Computer.isMac()) {
            return null;
        }
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)value).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getHardKey() {
        if (Computer.isMac()) {
            return 0;
        }
        try {
            String key;
            int numPort = 0;
            while ((key = Security.readRegString("SYSTEM\\CurrentControlSet\\Services\\FTDIBUS\\Enum", String.valueOf(numPort))) != null) {
                ++numPort;
                if (!key.contains("PID_6001")) continue;
                int res = 0;
                for (int i = key.length() - 8; i < key.length(); ++i) {
                    res = (res * 11 + key.getBytes()[i]) % 999983;
                }
                return res;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String getBiostimPort() {
        if (Computer.isMac()) {
            return null;
        }
        try {
            String key;
            int numPort = 0;
            while ((key = Security.readRegString("SYSTEM\\CurrentControlSet\\Services\\FTDIBUS\\Enum", String.valueOf(numPort))) != null) {
                ++numPort;
                if (!key.contains("PID_6001")) continue;
                String portkey = "SYSTEM\\CurrentControlSet\\Enum\\FTDIBUS\\VID_0403+PID_6001+" + key.substring(22) + "A\\0000\\Device Parameters";
                return Security.readRegString(portkey, "PortName");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int oneWayFunction(int key) {
        return (int)(((long)key + 4423L) * 5483L % 900817L * 5501L % 999961L);
    }

    public static void checkKeyV0() {
        if (Computer.isWindows()) {
            Main.getConfig().setActivated(Security.oneWayFunction(Security.getHardKey()) == Main.getConfig().activationKey);
            Main.getConfig().setOptionBT(Security.oneWayFunction(Security.getHardKey() + 1357) == Main.getConfig().btKey ? 2 : 0);
        } else {
            Main.getConfig().setActivated(true);
            Main.getConfig().setOptionBT(0);
        }
    }

    private static void verifInstallMac() {
        try {
            String update;
            String jar = Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (!jar.startsWith(Computer.absolutePath)) {
                CloudManager.sendJdd("Mauvaise install Mac", new Object[0]);
                Utils.popupAlert(TransientConfig.translate("mauvaise_install_mac"));
            }
            Main.getConfig().isExe = jar.contains("Biostim.app");
            Main.getConfig().saveConfig();
            if (!Main.getConfig().isExe && new File(update = Computer.absolutePath + "update.sh").exists()) {
                if (Utils.popupDialog(TransientConfig.translate("finInstallMac"), false)) {
                    ProcessBuilder pb = new ProcessBuilder("/bin/bash", update);
                    pb.start();
                    System.exit(0);
                } else {
                    CloudManager.sendJdd("Refus fin d'install", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void verifLnk() {
        try {
            if (!Main.getConfig().isExe) {
                String desktop = Computer.readProcessOutput("powershell -NoLogo -NonInteractive \"Write-Host $([System.Environment]::GetFolderPath([System.Environment+SpecialFolder]::Desktop))\"");
                String desktop2 = FileSystemView.getFileSystemView().getHomeDirectory().toString();
                if (!desktop2.equals(desktop)) {
                    CloudManager.sendJdd("home dir : %s != %s", desktop, desktop2);
                }
                String lnk = desktop + "\\Biostim.exe.lnk";
                String target = Computer.readProcessOutput("powershell -NoProfile -Command \"(New-Object -ComObject WScript.Shell).CreateShortcut('" + lnk + "').TargetPath\"");
                Utils.debugInfo("init target lnk : %s", target);
                if (!target.endsWith(".exe")) {
                    String newTarget = target.replace(".jar", ".exe").replace(".vbs", ".exe");
                    Computer.readProcessOutput("powershell -NoProfile -Command \"$s = New-Object -ComObject WScript.Shell; $sc = $s.CreateShortcut('" + lnk + "'); $sc.TargetPath = '" + newTarget + "'; $sc.Save()\"");
                    target = Computer.readProcessOutput("powershell -NoProfile -Command \"(New-Object -ComObject WScript.Shell).CreateShortcut('" + lnk + "').TargetPath\"");
                    Utils.debugInfo("new target lnk : %s", target);
                    if (target.endsWith(".exe")) {
                        CloudManager.sendJdd("Modif raccourci en .exe", new Object[0]);
                    }
                }
                if (target.endsWith(".exe")) {
                    Main.getConfig().isExe = true;
                    Main.getConfig().saveConfig();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

