/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Utils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class TransientConfig {
    public static String patientBlueback;
    public static long dateTarageBlueback;
    public static final int validiteTarageBlueback = 3600;
    private static String patientCalibre;
    private static final ArrayList<Integer> tarageMin;
    private static final ArrayList<Integer> tarageMax;
    private static final ArrayList<Long> tarageDates;
    public static String password;
    public static final Locale defaultLocale;
    public static ResourceBundle langue;
    public static String langueSuffixe;

    public static boolean isDev() {
        return Main.debugFileName == null;
    }

    public static void setTarage(int voie) {
        if (Main.getCurrentPatient() == null) {
            return;
        }
        if (!Main.getCurrentPatient().id.equals(patientCalibre)) {
            patientCalibre = Main.getCurrentPatient().id;
            tarageMin.clear();
            tarageMax.clear();
            tarageDates.clear();
        }
        long tarageDate = System.currentTimeMillis() / 1000L;
        double limMin = Main.progEnCours.getBase(voie);
        double limMax = Main.progEnCours.getAffMax(voie);
        if (tarageMin.size() > voie) {
            tarageMin.set(voie, (int)limMin);
            tarageMax.set(voie, (int)limMax);
        } else {
            while (tarageMin.size() < voie) {
                tarageMin.add(null);
                tarageMax.add(null);
            }
            tarageMin.add((int)limMin);
            tarageMax.add((int)limMax);
        }
        if (tarageDates.size() > voie) {
            tarageDates.set(voie, tarageDate);
        } else {
            while (tarageDates.size() < voie) {
                tarageDates.add(null);
            }
            tarageDates.add(tarageDate);
        }
    }

    public static int getTarageMin(int voie) {
        try {
            if (Main.getCurrentPatient() == null || !Main.getCurrentPatient().id.equals(patientCalibre) || tarageDates.get(voie) < System.currentTimeMillis() / 1000L - 3600L) {
                return 9999;
            }
            return tarageMin.get(voie);
        }
        catch (Exception e) {
            return 9999;
        }
    }

    public static int getTarageMax(int voie) {
        try {
            if (Main.getCurrentPatient() == null || !Main.getCurrentPatient().id.equals(patientCalibre) || tarageDates.get(voie) < System.currentTimeMillis() / 1000L - 3600L) {
                return 0;
            }
            return tarageMax.get(voie);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String translate(String key) {
        String result;
        block2: {
            result = key;
            try {
                result = langue.getString(key);
            }
            catch (Exception e) {
                if (key.equals("SAV")) break block2;
                Utils.debugLine(1, "Traduction manquante pour ->%s<-", key);
            }
        }
        return result;
    }

    public static String persoTranslate(String key) {
        String res = Main.getConfig().traductions.get(key);
        if (res != null) {
            return res;
        }
        return TransientConfig.translate(key);
    }

    public static String translate(String key, Object ... args) {
        String result = key;
        try {
            result = langue.getString(key);
        }
        catch (Exception e) {
            Utils.debugLine(1, "Traduction manquante pour ->%s<-", key);
        }
        return String.format(result, args);
    }

    public static void choixLangue() {
        if (defaultLocale.toString().toLowerCase().contains("ko")) {
            Main.getConfig().setDistributeur("menfis");
        }
        try {
            Locale locale = defaultLocale;
            try {
                locale = new Locale(Main.getConfig().lang);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Locale.setDefault(locale);
            langue = ResourceBundle.getBundle("langue", locale);
            langueSuffixe = langue.getLocale().toString();
            if (langueSuffixe.isEmpty()) {
                langueSuffixe = "en";
            }
            if (langueSuffixe.equals("ko")) {
                Main.getConfig().setDistributeur("menfis");
            }
            langueSuffixe = "_" + langueSuffixe;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Utils.debugInfo("langue: %s (pc : %s)", langueSuffixe, defaultLocale.toString());
    }

    public static ArrayList<String> getListeLangue() {
        ArrayList<String> shorts = TransientConfig.getShortListeLangue();
        ArrayList<String> langues = new ArrayList<String>();
        for (String lang : shorts) {
            Locale locale = new Locale(lang);
            langues.add(lang + " : " + locale.getDisplayLanguage(locale));
        }
        return langues;
    }

    public static ArrayList<String> getShortListeLangue() {
        ArrayList<String> langues = new ArrayList<String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(Main.class.getResourceAsStream("/list_lang.txt")));){
            r.lines().forEach(langues::add);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        langues.sort(String::compareTo);
        return langues;
    }

    static {
        tarageMin = new ArrayList();
        tarageMax = new ArrayList();
        tarageDates = new ArrayList();
        password = "";
        defaultLocale = Locale.getDefault();
    }
}

