/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.configuration;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.CloudManager;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Security;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.utilsfx.HtmlToJavaFX;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.configuration.DebugView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;
import org.json.JSONArray;
import org.json.JSONObject;

public class Autotest
extends Controller {
    @FXML
    TextFlow resultat;
    @FXML
    private Button retry;
    @FXML
    private Button next;
    @FXML
    private TextFlow webDroite;
    @FXML
    private MediaView mediaDroite;
    @FXML
    private LineChart<Number, Number> graphique;
    @FXML
    private TextField commande;
    @FXML
    Region regionDroite;
    @FXML
    private VBox vboxInstall;
    @FXML
    private Label updateTitle;
    @FXML
    private Label features;
    @FXML
    private Hyperlink featuresUrl;
    @FXML
    private Button buttonDownload;
    @FXML
    private Circle statusDownload;
    @FXML
    private Label labelDownload;
    private static JSONObject jsonVersion;
    public static int telechargement;
    public static int lengthDownload;
    private static int telechargementEnCours;
    private int etape = 0;
    private boolean stimEnCours;
    private String valide = "";
    private String consigne = "";
    private int electrodeDecolleeA;
    private int electrodeDecolleeB = 0;
    private int stimMaxA;
    private int stimMaxB = 10;
    private int bfbCcRNA;
    private int bfbCcRNB = 0;
    private int bfbCcJNA;
    private int bfbCcJNB = 2000;
    private int testFini = 0;
    public boolean secuA = false;
    public boolean secuB = false;
    boolean firstRougeNoir = true;
    boolean firstJauneNoir = true;

    @Override
    public void setMain() {
        this.graphique.setAnimated(false);
        this.graphique.setCreateSymbols(false);
        this.graphique.setLegendVisible(false);
        ((NumberAxis)this.graphique.getXAxis()).setForceZeroInRange(false);
        this.graphique.getXAxis().setAutoRanging(false);
        this.next();
    }

    private void updateWebContent(boolean encours) {
        Platform.runLater(() -> {
            if (encours) {
                HtmlToJavaFX.toTextFlow("<pre>" + this.valide + "<br><br><i>" + this.consigne + "</i></pre>", this.resultat);
            } else {
                HtmlToJavaFX.toTextFlow("<pre>" + this.valide + "<br><br><b>" + this.consigne + "</b></pre>", this.resultat);
            }
        });
        if (this.consigne.isEmpty()) {
            Utils.sleep(300L);
        }
    }

    @FXML
    void next() {
        this.showNext(false);
        this.showRetry(false);
        this.consigne = "";
        this.stopFilm();
        new Thread(() -> {
            switch (this.etape) {
                case 0: {
                    this.testVersion();
                    break;
                }
                case 1: {
                    this.testConnexion();
                    break;
                }
                case 2: {
                    this.testElectrodeDecollee();
                    break;
                }
                case 3: {
                    this.testCourtCircuitRougeNoir(0);
                    break;
                }
                case 4: {
                    this.testCourtCircuitRougeNoir(1);
                    break;
                }
                case 5: {
                    this.testCourtCircuitJauneNoir(0);
                    break;
                }
                case 6: {
                    this.testCourtCircuitJauneNoir(1);
                    break;
                }
                case 7: {
                    this.afficheDiagFinal();
                }
            }
        }).start();
    }

    @FXML
    void retry() {
        this.etape -= Main.getConfig().nbVoiesStim() == 2 ? 1 : 2;
        this.next();
    }

    private void showNext(boolean state) {
        Platform.runLater(() -> FxUtils.setVisibility((Node)this.next, state));
    }

    private void showRetry(boolean state) {
        Platform.runLater(() -> FxUtils.setVisibility((Node)this.retry, state));
    }

    private void testVersion() {
        jsonVersion = CloudManager.checkLatestVersion();
        this.valide = String.format("<b>%20s : %s (%d)</b>", TransientConfig.translate("version"), Autotest.isOK(Main.getConfig().etatCloud == 0 || Main.getConfig().etatCloud == 2, Version.versionSoft), Version.numVersionSoft);
        if (Computer.isWindows()) {
            this.valide = Security.verifCheckSum == 1 ? this.valide + "<br>              !! CheckSum ??? !!" : this.valide + String.format("<br>%20s : %s", "CheckSum", Autotest.isOK(Security.verifCheckSum == 0));
        }
        if (Main.getConfig().modeDemo) {
            this.valide = this.valide + "<br>               !! Demo mode !!";
        }
        if (Main.getConfig().isVerrouilleTotal()) {
            this.valide = this.valide + "<br><br>          <b>" + TransientConfig.translate("verrouille") + "</b>";
            this.updateWebContent(false);
            return;
        }
        if (Main.getConfig().isVerrouillePartiel()) {
            this.valide = this.valide + "<br>        " + TransientConfig.translate("verrouille_partiel");
        }
        if (Main.getConfig().etatCloud == 2) {
            this.consigne = "<h1>" + TransientConfig.translate("requireInternet") + "</h1>";
        } else if (Main.getConfig().etatCloud == 1 || Security.verifCheckSum == 2) {
            Platform.runLater(() -> {
                FxUtils.setVisibility((Node)this.vboxInstall, true);
                this.updateTitle.setText(String.format(TransientConfig.translate("updateVersion"), jsonVersion.getString("versionName")));
                try {
                    Object nouveautes = TransientConfig.translate("nouveautes");
                    JSONArray array = jsonVersion.getJSONArray("features");
                    for (int i = 0; i < array.length(); ++i) {
                        nouveautes = (String)nouveautes + "\n- " + array.getString(i);
                    }
                    this.features.setText((String)nouveautes);
                }
                catch (Exception nouveautes) {
                    // empty catch block
                }
                try {
                    String urlF = jsonVersion.getString("featuresUrl");
                    this.featuresUrl.setOnAction(actionEvent -> Main.main.getHostServices().showDocument(urlF));
                    this.featuresUrl.setText(TransientConfig.translate("enSavoirPlus"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        } else {
            this.consigne = Autotest.clicNext("branchement_biostim", new Object[0]);
            this.showNext(true);
            ++this.etape;
        }
        this.updateWebContent(false);
    }

    @FXML
    private void download() {
        boolean newStart;
        boolean bl = newStart = telechargementEnCours != 1;
        if (newStart) {
            telechargement = 0;
            telechargementEnCours = 1;
            this.buttonDownload.setDisable(true);
            this.buttonDownload.setMinWidth(this.buttonDownload.getWidth());
            new Thread(() -> {
                try {
                    String url = jsonVersion.getString("url");
                    String filename = url.substring(url.lastIndexOf(47) + 1);
                    Utils.debugInfo("telechargement de " + filename);
                    Autotest.saveHttp(url, filename);
                    Utils.debugInfo("fin de telechargement");
                    telechargementEnCours = 2;
                }
                catch (Exception e) {
                    telechargementEnCours = 0;
                    Utils.debugLine("telechargement ko : %s", e);
                }
            }).start();
        }
        new Thread(() -> {
            while (telechargementEnCours == 1 && Main.currentController == this) {
                this.statusDownload.setFill((Paint)Color.ORANGE);
                Utils.sleep(500L);
                String total = lengthDownload > 0 ? String.format(" / %,d ko", lengthDownload / 1024) : "";
                Platform.runLater(() -> this.labelDownload.setText(String.format("%,d ko%s", telechargement / 1024, total)));
            }
            if (telechargementEnCours == 2) {
                this.statusDownload.setFill((Paint)Color.GREEN);
                this.install();
            } else {
                this.statusDownload.setFill((Paint)Color.RED);
            }
        }).start();
    }

    public static void saveHttp(String url, String file) throws Exception {
        try (HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            Path outputPath = Computer.newBiostimFile(file).toPath();
            try (InputStream is = response.body();
                 OutputStream os = Files.newOutputStream(outputPath, new OpenOption[0]);){
                int amt;
                byte[] buf = new byte[16384];
                while ((amt = is.read(buf)) > 0) {
                    os.write(buf, 0, amt);
                    telechargement += amt;
                }
            }
        }
    }

    private void install() {
        Platform.runLater(() -> this.labelDownload.setText("Install starting"));
        new Thread(() -> {
            try {
                String url = jsonVersion.getString("url");
                String filename = url.substring(url.lastIndexOf(47) + 1);
                Utils.debugInfo("installation de " + filename);
                ZipInputStream zis = new ZipInputStream(Files.newInputStream(Computer.newBiostimFile(filename).toPath(), new OpenOption[0]), Charset.forName("CP850"));
                while (zis.getNextEntry() != null) {
                }
                zis.closeEntry();
                zis.close();
                Utils.debugInfo("Fichier zip conforme");
                this.unzip(filename);
                if (Computer.isMac()) {
                    ProcessBuilder pb = new ProcessBuilder("/bin/bash", Computer.absolutePath + "update.sh");
                    pb.start();
                } else {
                    Utils.debugInfo("decompression OK, lancement de l'installation");
                    String rep = Computer.absolutePath + filename.substring(0, filename.lastIndexOf(".")) + "/";
                    new ProcessBuilder("cmd", "/c", "start", "\"Biostim Install\" cmd /c \"timeout /t 2 /nobreak >nul && installation.cmd\"").directory(new File(rep)).start();
                    System.exit(0);
                }
                Utils.debugInfo("decompression OK");
                System.exit(0);
            }
            catch (Exception e) {
                Platform.runLater(() -> {
                    this.statusDownload.setFill((Paint)Color.RED);
                    this.labelDownload.setText(TransientConfig.translate("Erreur"));
                });
                e.printStackTrace();
            }
        }).start();
    }

    private void unzip(String zipFile) throws Exception {
        byte[] buffer = new byte[16384];
        ZipInputStream zis = new ZipInputStream(Files.newInputStream(Computer.newBiostimFile(zipFile).toPath(), new OpenOption[0]), Charset.forName("CP850"));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int pos = ze.getName().indexOf("BiostimData");
            if (!(ze.isDirectory() || Computer.isMac() && pos == -1)) {
                int len;
                String dest = Computer.isMac() ? ze.getName().substring(pos + 12) : ze.getName();
                File newFile = Computer.newBiostimFile(dest);
                newFile.getParentFile().mkdirs();
                System.out.println("file unzip : " + String.valueOf(newFile.getAbsoluteFile()));
                Platform.runLater(() -> this.labelDownload.setText("unzip : " + String.valueOf(newFile.getAbsoluteFile())));
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private void testConnexion() {
        this.valide = this.valide + "<br><br>";
        int hardkey = Security.getHardKey();
        if (Computer.isWindows()) {
            boolean detection = hardkey != 0;
            this.valide = this.valide + String.format("%20s : %s %s<br>", TransientConfig.translate("Biostim_detecte"), Autotest.isOK(detection), detection ? " (" + Security.getBiostimPort() + " / " + Main.getConfig().version_biostim + ")" : "");
            this.updateWebContent(false);
        }
        this.valide = this.valide + String.format("%20s : %s<br>", TransientConfig.translate("Connexion"), Autotest.isOK(UsbBiostim.isConnexionBioStim()));
        this.updateWebContent(false);
        if (Main.getConfig().versionProtocole > 0) {
            this.valide = this.valide + String.format("%20s : ", TransientConfig.translate("Poire"));
            if (UsbBiostim.isConnexionBioStim()) {
                switch (UsbBiostim.getEtatPoire()) {
                    case 0: {
                        this.valide = this.valide + "<font color=\"green\">OK</font><br>";
                        break;
                    }
                    case 1: {
                        this.valide = this.valide + "<font color=\"red\">*** " + TransientConfig.translate("poire_debranchee") + " ***</font><br>";
                        break;
                    }
                    default: {
                        this.valide = this.valide + "<font color=\"red\">*** " + TransientConfig.translate("arret_urgence") + " ***</font><br>";
                        break;
                    }
                }
            } else {
                this.valide = this.valide + "---<br>";
            }
            this.updateWebContent(false);
        }
        this.valide = this.valide + String.format("%20s : %s<br>", TransientConfig.translate("Biostim_active"), Autotest.isOK2(Main.getConfig().isActivated));
        this.valide = this.valide + String.format("%20s : %s (os %s)<br>", TransientConfig.translate("BT_active"), Autotest.isOK2(Main.getConfig().optionBluetooth), SondeBT.isOsCompatible() ? "OK" : "KO : " + System.getProperty("os.name"));
        this.updateWebContent(false);
        if (Main.getConfig().versionProtocole != 0) {
            if (UsbBiostim.isConnexionBioStim()) {
                this.valide = this.valide + String.format("<br>%20s : %06d", TransientConfig.translate("serial"), Main.getConfig().numero_serie);
                this.valide = this.valide + String.format("<br>%20s : %06d", TransientConfig.translate("codeBiostim"), Main.getConfig().idBiostim);
            }
        } else {
            this.valide = this.valide + String.format("<br>%20s : %06d", TransientConfig.translate("codeBiostim"), hardkey);
            this.valide = this.valide + String.format("<br>%20s : %06d", "activation", Main.getConfig().activationKey);
            this.valide = this.valide + String.format("<br>%20s : %06d", "BT", Main.getConfig().btKey);
        }
        String port = UsbBiostim.serialPort != null && UsbBiostim.serialPort.isOpen() ? UsbBiostim.serialPort.getSystemPortName() : "---";
        this.valide = this.valide + String.format("<br>%20s : %s<br>", "port", port);
        if (!port.equals("---")) {
            this.valide = this.valide + String.format("%20s : %s<br>", TransientConfig.translate("connecte_depuis"), Utils.stringOfTime((int)((System.currentTimeMillis() - UsbBiostim.openDate) / 1000L)));
        }
        String diagString = Autotest.getDiagString();
        Platform.runLater(() -> {
            if (UsbBiostim.isConnexionBioStim()) {
                this.updateWebContent(false);
            }
            if (diagString != null) {
                FxUtils.setVisibility((Node)this.webDroite, true);
                HtmlToJavaFX.toTextFlow("<h1>" + TransientConfig.translate("help") + "</h1><font color=\"red\"><b>" + diagString + "</b></font>", this.webDroite);
            }
        });
    }

    public static String getState() {
        Object stateString = String.format("%20s : %s (%s)<br>", TransientConfig.translate("version"), Version.versionSoft, Version.numVersionSoft);
        int hardkey = Security.getHardKey();
        if (Computer.isWindows()) {
            boolean detection = hardkey != 0;
            stateString = (String)stateString + String.format("%20s : %s %s<br>", TransientConfig.translate("Biostim_detecte"), Autotest.isOK(detection), detection ? " (" + Security.getBiostimPort() + " / " + Main.getConfig().version_biostim + ")" : "");
        }
        stateString = (String)stateString + String.format("%20s : %s<br>", TransientConfig.translate("Connexion"), Autotest.isOK(UsbBiostim.isConnexionBioStim()));
        if (Main.getConfig().versionProtocole > 0) {
            stateString = (String)stateString + String.format("%20s : ", TransientConfig.translate("Poire"));
            if (UsbBiostim.isConnexionBioStim()) {
                switch (UsbBiostim.getEtatPoire()) {
                    case 0: {
                        stateString = (String)stateString + "<font color=\"green\">OK</font><br>";
                        break;
                    }
                    case 1: {
                        stateString = (String)stateString + "<font color=\"red\">*** " + TransientConfig.translate("poire_debranchee") + " ***</font><br>";
                        break;
                    }
                    default: {
                        stateString = (String)stateString + "<font color=\"red\">*** " + TransientConfig.translate("arret_urgence") + " ***</font><br>";
                        break;
                    }
                }
            } else {
                stateString = (String)stateString + "---<br>";
            }
        }
        stateString = (String)stateString + String.format("%20s : %s<br>", TransientConfig.translate("Biostim_active"), Autotest.isOK2(Main.getConfig().isActivated));
        stateString = (String)stateString + String.format("%20s : %s (os %s)<br>", TransientConfig.translate("BT_active"), Autotest.isOK2(Main.getConfig().optionBluetooth), SondeBT.isOsCompatible() ? "OK" : "KO : " + System.getProperty("os.name"));
        if (Main.getConfig().versionProtocole != 0) {
            if (UsbBiostim.isConnexionBioStim()) {
                stateString = (String)stateString + String.format("<br>%20s : %06d", TransientConfig.translate("serial"), Main.getConfig().numero_serie);
                stateString = (String)stateString + String.format("<br>%20s : %06d", TransientConfig.translate("codeBiostim"), Main.getConfig().idBiostim);
            }
        } else {
            stateString = (String)stateString + String.format("<br>%20s : %06d", TransientConfig.translate("codeBiostim"), hardkey);
            stateString = (String)stateString + String.format("<br>%20s : %06d", "activation", Main.getConfig().activationKey);
            stateString = (String)stateString + String.format("<br>%20s : %06d", "BT", Main.getConfig().btKey);
        }
        String port = UsbBiostim.serialPort != null && UsbBiostim.serialPort.isOpen() ? UsbBiostim.serialPort.getSystemPortName() : "---";
        stateString = (String)stateString + String.format("<br>%20s : %s<br>", "port", port);
        if (!port.equals("---")) {
            stateString = (String)stateString + String.format("%20s : %s<br>", TransientConfig.translate("connecte_depuis"), Utils.stringOfTime((int)((System.currentTimeMillis() - UsbBiostim.openDate) / 1000L)));
        }
        if (Main.getConfig().modeDemo) {
            stateString = (String)stateString + "<br>            !! Demo mode !!";
        }
        if (Main.getConfig().isVerrouilleTotal()) {
            stateString = (String)stateString + "<br>          " + TransientConfig.translate("verrouille");
        } else if (Main.getConfig().isVerrouillePartiel()) {
            stateString = (String)stateString + "<br>        " + TransientConfig.translate("verrouille_partiel");
        }
        if (Security.verifCheckSum == 1) {
            stateString = (String)stateString + "<br>           !! CheckSum ??? !!";
        } else if (Security.verifCheckSum == 2) {
            stateString = (String)stateString + "<br>           !! <font color=\"red\">CheckSum KO</font> !!";
        }
        stateString = "<h1>" + TransientConfig.translate("informations") + "</h1><pre>" + (String)stateString + "<br></pre>";
        String diagString = Autotest.getDiagString();
        if (diagString != null) {
            stateString = "<h1>" + TransientConfig.translate("help") + "</h1><font color=\"red\"><b>" + diagString + "</b></font>" + (String)stateString;
        }
        return stateString;
    }

    public static String getDiagString() {
        String diagString = null;
        if (Computer.isWindows() && Security.getHardKey() == 0) {
            diagString = TransientConfig.translate("brancher_biostim");
        } else if (!UsbBiostim.isConnexionBioStim()) {
            diagString = UsbBiostim.serialPort != null && UsbBiostim.serialPort.isOpen() && System.currentTimeMillis() - UsbBiostim.openDate > 10000L ? TransientConfig.translate("connexion_bloque") : TransientConfig.translate("allumer_biostim");
        } else if (UsbBiostim.getEtatPoire() != 0) {
            diagString = TransientConfig.translate("probleme_poire");
        }
        return diagString;
    }

    private void testElectrodeDecollee() {
        this.valide = this.valide + "<p/><b>" + TransientConfig.translate("test_circuit_ouvert") + "</b><br>";
        this.consigne = TransientConfig.translate("test_en_cours", "A");
        this.updateWebContent(true);
        try {
            this.electrodeDecolleeA = this.testStim(0);
            this.valide = this.valide + String.format("<br>%20s : %s", "A", Autotest.isOK(this.electrodeDecolleeA < 8, String.format("%d mA", this.electrodeDecolleeA)));
            if (Main.getConfig().nbVoiesStim() == 2) {
                this.consigne = TransientConfig.translate("test_en_cours", "B");
                this.updateWebContent(true);
                this.electrodeDecolleeB = this.testStim(1);
                this.valide = this.valide + String.format("<br>%20s : %s", "B", Autotest.isOK(this.electrodeDecolleeB < 8, String.format("%d mA", this.electrodeDecolleeB)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.stopStim();
        ++this.etape;
        this.consigne = Autotest.clicNext("connecter_rouge_noir", "A");
        this.startFilm("https://mazetsante.fr/biostim/videos/rougenoir.mp4");
        this.updateWebContent(false);
        this.showNext(true);
    }

    private void testCourtCircuitRougeNoir(int voie) {
        this.consigne = TransientConfig.translate("test_en_cours", voie == 0 ? "A" : "B");
        if (this.firstRougeNoir) {
            this.firstRougeNoir = false;
            this.valide = this.valide + "<p/><b>" + TransientConfig.translate("test_rouge_noir") + "</b><br>";
        }
        this.updateWebContent(true);
        Platform.runLater(() -> FxUtils.setVisibility(this.graphique, false));
        int niv = this.testStim(voie);
        if (voie == 0) {
            this.stimMaxA = niv;
        } else {
            this.stimMaxB = niv;
        }
        this.valide = this.valide + String.format("<br>%20s : %s", voie == 0 ? "A" : "B", Autotest.isOK(niv == 10, String.format("%d mA", niv)));
        int val = this.getValStab(voie);
        if (voie == 0) {
            this.bfbCcRNA = val;
        } else {
            this.bfbCcRNB = val;
        }
        if (niv != 10) {
            this.consigne = Autotest.clicRetry("err_cordon", new Object[0]);
            this.showRetry(true);
        } else {
            this.consigne = "";
        }
        if (voie == 0 && Main.getConfig().nbVoiesStim() == 2) {
            this.consigne = this.consigne + Autotest.clicNext("connecter_rouge_noir", "B");
            this.startFilm("https://mazetsante.fr/biostim/videos/aversb.mp4");
        } else {
            this.consigne = this.consigne + Autotest.clicNext("connecter_jaune_noir", "A");
            this.startFilm("https://mazetsante.fr/biostim/videos/jaunenoir.mp4");
        }
        this.showNext(true);
        this.updateWebContent(false);
        this.etape += Main.getConfig().nbVoiesStim() == 2 ? 1 : 2;
    }

    private void testCourtCircuitJauneNoir(int voie) {
        this.consigne = TransientConfig.translate("test_en_cours", voie == 0 ? "A" : "B");
        if (this.firstJauneNoir) {
            this.firstJauneNoir = false;
            this.valide = this.valide + "<p><b>" + TransientConfig.translate("test_jaune_noir") + "</b><br>";
        }
        this.updateWebContent(true);
        Platform.runLater(() -> FxUtils.setVisibility(this.graphique, false));
        int niv = this.testStim(voie);
        this.afficheBFB(voie);
        int val = this.getValStab(voie);
        if (voie == 0) {
            this.bfbCcJNA = val;
        } else {
            this.bfbCcJNB = val;
        }
        val = Math.abs(val);
        this.valide = this.valide + String.format("<br>%20s : %s", voie == 0 ? "A" : "B", Autotest.isOK(val > 1000, String.format("%d \u00b5V", val)));
        if (niv > 8) {
            this.consigne = Autotest.clicRetry("err_rouge_noir", new Object[0]);
            this.showRetry(true);
        } else if (val < 1000) {
            this.consigne = Autotest.clicRetry("err_cordon", new Object[0]);
            this.showRetry(true);
        } else {
            Platform.runLater(() -> FxUtils.setVisibility(this.graphique, false));
            this.consigne = "";
        }
        if (voie == 0 && Main.getConfig().nbVoiesStim() == 2) {
            this.consigne = this.consigne + Autotest.clicNext("connecter_jaune_noir", "B");
            this.startFilm("https://mazetsante.fr/biostim/videos/aversb.mp4");
            this.showNext(true);
        } else {
            this.testFini = 1;
            if (this.consigne.isEmpty()) {
                this.sendCloud();
                this.afficheDiagFinal();
            } else {
                this.showNext(true);
                this.consigne = this.consigne + Autotest.clicNext("fin_diag", new Object[0]);
            }
        }
        this.updateWebContent(false);
        this.etape += Main.getConfig().nbVoiesStim() == 2 ? 1 : 2;
    }

    private void afficheDiagFinal() {
        Platform.runLater(() -> {
            this.consigne = "";
            this.updateWebContent(true);
            FxUtils.setVisibility(this.graphique, false);
            FxUtils.setVisibility((Node)this.webDroite, true);
            Object diagString = null;
            if (this.electrodeDecolleeA > 8 || this.electrodeDecolleeB > 8) {
                diagString = TransientConfig.translate("prevoir_maintenance");
            } else if (this.stimMaxA < 10 || this.stimMaxB < 10 || this.bfbCcJNA < 1000 || this.bfbCcJNB < 1000) {
                diagString = TransientConfig.translate("pb_cordon");
            }
            diagString = diagString == null ? "<h1><font color=\"green\">" + TransientConfig.translate("tout_ok") + "</font></h1>" : "<h1>" + TransientConfig.translate("help") + "</h1><font color=\"red\"><b>" + (String)diagString + "</b></font>";
            HtmlToJavaFX.toTextFlow((String)diagString, this.webDroite);
        });
    }

    private void sendCloud() {
        if (this.testFini == 1) {
            new Thread(() -> {
                Date now = new Date();
                String url = String.format("https://www.mazetsante.fr/biostim/send_autotest.php?date=%s&heure=%s&num_serie=%d&soft=%d&secua=%d&secub=%d&stima=%d&bfbrna=%d&stimb=%d&bfbrnb=%d&bfbjna=%d&bfbjnb=%d", Utils.cloudDateFormat.format(now), Utils.cloudTimeFormat.format(now), Main.getConfig().numero_serie, Version.numVersionSoft, this.electrodeDecolleeA, this.electrodeDecolleeB, this.stimMaxA, this.bfbCcRNA, this.stimMaxB, this.bfbCcRNB, this.bfbCcJNA, this.bfbCcJNB);
                try {
                    String res = Utils.getHttp(url);
                    System.out.format("autotest sent to cloud : %s\n%s\n", url, res);
                }
                catch (Exception e) {
                    Utils.debugInfo("Erreur cloud save : %s", e.toString());
                }
            }).start();
        }
        this.testFini = 2;
    }

    private int testStim(int voie) {
        int niv = 0;
        try {
            this.startStim();
            while (niv < 20 && !this.secuA && !this.secuB) {
                UsbBiostim.amplitudeVoie(voie, (double)(++niv) / 2.0);
                Utils.sleep(100L);
            }
            UsbBiostim.amplitudeVoie(voie, 0.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopStim();
        return niv / 2;
    }

    private void startStim() {
        this.stimEnCours = true;
        UsbBiostim.initStimInnervee(2, 50L, 0L, 0L, 0L, 50L, 0L, 0L, 0L, 0, 50, 350, 50, 350, 0, 0, 0, 0, 0, 0, 0, 0, 0, false, false);
        Utils.sleep(1000L);
        this.secuA = false;
        this.secuB = false;
    }

    private void stopStim() {
        if (this.stimEnCours) {
            UsbBiostim.activateGenerateur(2, false);
        }
        this.stimEnCours = false;
    }

    private void afficheBFB(int voie) {
        XYChart.Series series = new XYChart.Series();
        Platform.runLater(() -> {
            this.graphique.getData().clear();
            this.graphique.getData().add((Object)series);
            FxUtils.setVisibility(this.graphique, true);
            new Thread(() -> {
                double start = (double)System.currentTimeMillis() / 1000.0;
                while (this.graphique.isVisible() && this.etape != -1) {
                    Platform.runLater(() -> {
                        double now = (double)System.currentTimeMillis() / 1000.0;
                        series.getData().add((Object)new XYChart.Data((Object)(now - start), (Object)this.getVal(voie)));
                        if (series.getData().size() > 200) {
                            series.getData().removeFirst();
                        }
                        double debutAff = Math.max(0.0, now - start - 20.0);
                        ((NumberAxis)this.graphique.getXAxis()).setLowerBound(debutAff);
                        ((NumberAxis)this.graphique.getXAxis()).setUpperBound(debutAff + 20.0);
                    });
                    Utils.sleep(100L);
                }
            }).start();
        });
    }

    private int getValStab(int voie) {
        int i;
        Utils.sleep(2000L);
        double val = 0.0;
        int good = 0;
        for (i = 0; i < 100 && good < 20; ++i) {
            double newVal = this.getVal(voie);
            double diff = Math.abs(val - newVal);
            if (diff < 10.0 || diff < 0.1 * val) {
                ++good;
            } else {
                val = newVal;
            }
            Utils.sleep(100L);
        }
        return (int)(i >= 100 ? -val : val);
    }

    private double getVal(int voie) {
        return Biostim.getVoie(voie == 0 ? 0 : 1);
    }

    private static String clicNext(String key, Object ... args) {
        return TransientConfig.translate(key, args) + ",\n" + TransientConfig.translate("clic_next");
    }

    private static String clicRetry(String key, Object ... args) {
        return TransientConfig.translate(key, args) + ",\n" + TransientConfig.translate("clic_retry") + "\n\n" + TransientConfig.translate("else") + ", ";
    }

    private static String isOK(boolean b) {
        if (b) {
            return "<font color=\"green\">OK</font>";
        }
        return "<font color=\"red\">*** KO ***</font>";
    }

    private static String isOK(boolean b, String s) {
        if (b) {
            return "<font color=\"green\">" + s + "</font>";
        }
        return "<font color=\"red\">*** " + s + " ***</font>";
    }

    private static String isOK2(boolean b) {
        if (b) {
            return "<font color=\"green\">OK</font>";
        }
        return TransientConfig.translate("non");
    }

    private static String isOK2(int option) {
        if (option == 2) {
            return "<font color=\"green\">OK</font>";
        }
        if (option == 1) {
            return "Demo";
        }
        return TransientConfig.translate("non");
    }

    private void startFilm(String film) {
        this.mediaDroite.setVisible(true);
        Platform.runLater(() -> {
            this.mediaDroite.setFitWidth(this.regionDroite.getWidth() - 10.0);
            Media media = new Media(film);
            MediaPlayer mediaPlayer = new MediaPlayer(media);
            mediaPlayer.setOnError(() -> Utils.debugInfo("Erreur MediaPlayer : " + String.valueOf(mediaPlayer.getError())));
            mediaPlayer.setCycleCount(-1);
            PauseTransition delay = new PauseTransition(Duration.millis((double)200.0));
            delay.setOnFinished(actionEvent -> {
                this.mediaDroite.setMediaPlayer(mediaPlayer);
                mediaPlayer.play();
            });
            delay.play();
        });
    }

    private void stopFilm() {
        try {
            if (this.mediaDroite.isVisible()) {
                this.mediaDroite.setVisible(false);
                MediaPlayer mp = this.mediaDroite.getMediaPlayer();
                if (mp != null) {
                    mp.stop();
                    mp.dispose();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void sendCommande() {
        String msg = this.commande.getText();
        if (msg.equals("next")) {
            ++this.etape;
            this.consigne = Autotest.clicNext("debrancher_cables", new Object[0]);
            FxUtils.setVisibility((Node)this.next, true);
            this.updateWebContent(false);
        } else {
            DebugView.sendCommande(msg, this);
        }
    }

    @Override
    public void exitAction() {
        this.stopStim();
        this.stopFilm();
        this.etape = -1;
        this.sendCloud();
    }

    static {
        telechargement = -1;
        telechargementEnCours = 0;
    }
}

