/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.patient;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.patient.PatientFile;
import com.mazet.biostim.zdata.Kines;
import com.mazet.biostim.zdata.Patient;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Optional;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class PatientListViewCtrl
extends Controller {
    @FXML
    private Region scrollKines;
    @FXML
    private VBox kineList;
    @FXML
    private VBox patientList;
    @FXML
    private TextField searchField;
    @FXML
    private CheckBox checkConfidentiel;
    @FXML
    private CheckBox checkArchive;
    private boolean cacheNom;
    private Kines kines;
    private ToggleButton boutonKineSelect;
    static final PatientFile tempPatient = new PatientFile("000", "Patient");
    private double tailleMax;

    @Override
    public void setMain() {
        this.checkConfidentiel.setSelected(Main.getConfig().modeConfidentiel);
        Text text = new Text("M... M...");
        this.tailleMax = text.getLayoutBounds().getWidth();
        for (PatientFile p : PatientFile.getPatientFiles(true)) {
            text = new Text(p.getNomCache(false));
            this.tailleMax = Math.max(this.tailleMax, text.getLayoutBounds().getWidth());
        }
        this.tailleMax *= 2.5;
        this.searchField.setMaxWidth(this.tailleMax * 1.5);
        this.refreshPatients();
        if (Main.getConfig().multiKine) {
            this.kines = Utils.fromJsonFile(Main.getConfig().getKineJson(), Kines.class);
            this.refreshKines();
        } else {
            FxUtils.setVisibility((Node)this.scrollKines, false);
        }
    }

    @FXML
    private void refreshPatients() {
        try {
            this.patientList.getChildren().clear();
            ArrayList<PatientFile> listPatient = PatientFile.getPatientFiles(this.checkArchive.isSelected());
            String search = this.searchField.getText().toLowerCase();
            ArrayList<PatientFile> selection = new ArrayList<PatientFile>();
            for (PatientFile p : listPatient) {
                if (p.kine != Main.getConfig().kine && Main.getConfig().kine != -1 || !p.getFirstName().toLowerCase().contains(search) && !p.getLastName().toLowerCase().contains(search)) continue;
                selection.add(p);
            }
            boolean bl = this.cacheNom = this.checkConfidentiel.isSelected() && selection.size() > 1;
            if (Main.tempPatient != null) {
                this.createItemList(tempPatient);
            }
            for (PatientFile patientFile : selection) {
                this.createItemList(patientFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createItemList(PatientFile patient) {
        Pane pane1 = new Pane();
        Label name = new Label(patient.getNomCache(this.cacheNom));
        Pane pane2 = new Pane();
        Button supprIcon = new Button();
        ToggleButton archIcon = new ToggleButton();
        HBox hbox = new HBox(20.0, new Node[]{pane1, name, pane2});
        if (patient != tempPatient) {
            hbox.getChildren().addAll((Object[])new Node[]{supprIcon, archIcon});
        }
        hbox.setMaxWidth(this.tailleMax + 300.0);
        supprIcon.getStyleClass().add((Object)"iconPatientSuppr");
        supprIcon.setOnMouseClicked(e -> this.cliqueDelete(patient));
        archIcon.setSelected(patient.isArchive());
        archIcon.getStyleClass().add((Object)"iconPatientArch");
        archIcon.setOnMouseClicked(e -> this.clicArchive(patient));
        hbox.getStyleClass().add((Object)"itemListPatient");
        HBox.setHgrow((Node)pane1, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)pane2, (Priority)Priority.ALWAYS);
        hbox.setUserData((Object)patient);
        hbox.setOnMouseClicked(e -> this.cliquePatient(patient));
        hbox.setOnMouseEntered(e -> this.mouseEntered(patient, name));
        hbox.setOnMouseExited(e -> this.mouseExited(patient, name));
        this.patientList.getChildren().add((Object)hbox);
    }

    private void refreshKines() {
        this.kineList.getChildren().clear();
        for (int i = 0; i < this.kines.nums.size(); ++i) {
            int num = this.kines.nums.get(i);
            ToggleButton boutonKine = new ToggleButton(this.kines.noms.get(i));
            boutonKine.getStyleClass().add((Object)"itemListKine");
            boutonKine.setOnMouseClicked(this::selectKine);
            boutonKine.setUserData((Object)num);
            if (Main.getConfig().kine == num) {
                this.boutonKineSelect = boutonKine;
                boutonKine.setSelected(true);
            }
            this.kineList.getChildren().add((Object)boutonKine);
        }
    }

    private String cacheNomToujours(String nom) {
        if (nom.isEmpty()) {
            return nom;
        }
        return nom.charAt(0) + "...";
    }

    @FXML
    private void changeConfidentiel() {
        Main.getConfig().setModeConfidentiel(this.checkConfidentiel.isSelected());
        this.refreshPatients();
    }

    @FXML
    private void redirectToNewPatient() {
        try {
            new Thread(() -> {
                boolean res = Utils.popupAlertAndWaitAvecTitre(TransientConfig.translate("consentement"), TransientConfig.translate("detailConsentement"), TransientConfig.translate("accepter"));
                if (!res) {
                    return;
                }
                Main.setCurrentPatient(new Patient());
                Utils.debugInfo("creation d'un nouveau patient");
                Platform.runLater(() -> Main.changeCenterView("patient", "bilan", Main.menu.patientButton));
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void mouseEntered(PatientFile patientFile, Label name) {
        if (this.cacheNom) {
            name.setText(patientFile.getFirstName() + " " + patientFile.getLastName());
        }
    }

    private void mouseExited(PatientFile patientFile, Label name) {
        if (this.cacheNom) {
            name.setText(patientFile.getNomCache(true));
        }
    }

    private void cliquePatient(PatientFile patientFile) {
        if (patientFile == tempPatient) {
            Main.changeCenterView("patient", "bilan", Main.menu.patientButton);
        } else {
            Patient patient = Patient.patientFromJson(patientFile.getFileName());
            if (patient != null) {
                Utils.debugInfo("s\u00e9lection patient : " + this.cacheNomToujours(patient.getFirstName()) + " " + this.cacheNomToujours(patient.getLastName()));
                Main.setCurrentPatient(patient);
                Main.changeCenterView("patient", "bilan", Main.menu.patientButton);
            }
        }
    }

    private void cliqueDelete(PatientFile patient) {
        File file = new File(Main.getConfig().getRepPatients() + "/db/" + patient.getFileName());
        new Thread(() -> {
            try {
                if (Utils.popupDialog(TransientConfig.translate("confirmer_suppression"))) {
                    new File(Main.getConfig().getRepPatients() + "/trash").mkdirs();
                    Files.copy(Paths.get(Main.getConfig().getRepPatients() + "/db/" + patient.getFileName(), new String[0]), Paths.get(Main.getConfig().getRepPatients() + "/trash/" + patient.getFileName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    file.delete();
                    Utils.debugInfo("%s supprim\u00e9", patient.getFileName());
                    Platform.runLater(this::refreshPatients);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    private void clicArchive(PatientFile patient) {
        File file = new File(Main.getConfig().getRepPatients() + "/db/" + patient.getFileName());
        Object newFile = patient.isArchive() ? patient.getFileName().substring(1) : "@" + patient.getFileName();
        file.renameTo(new File(Main.getConfig().getRepPatients() + "/db/" + (String)newFile));
        this.refreshPatients();
    }

    @FXML
    private void addKine() {
        Optional<String> result = Utils.popupReadVal("name", "");
        if (result.isPresent() && !result.get().isEmpty()) {
            this.kines.add(result.get());
            this.refreshKines();
        }
    }

    private void selectKine(MouseEvent event) {
        ToggleButton target = (ToggleButton)event.getSource();
        int num = (Integer)target.getUserData();
        if (event.getButton() == MouseButton.SECONDARY) {
            this.initContextMenu(event, num);
        } else {
            if (target == this.boutonKineSelect) {
                Main.getConfig().setKine(-1);
                this.boutonKineSelect.setSelected(false);
                this.boutonKineSelect = null;
            } else {
                if (this.boutonKineSelect != null) {
                    this.boutonKineSelect.setSelected(false);
                }
                this.boutonKineSelect = target;
                this.boutonKineSelect.setSelected(true);
                Main.getConfig().setKine(num);
            }
            this.refreshPatients();
        }
    }

    private void initContextMenu(MouseEvent event, int num) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem item = new MenuItem(TransientConfig.translate("delete"));
        item.setOnAction(e -> {
            if (this.boutonKineSelect == event.getSource()) {
                Main.getConfig().setKine(-1);
                this.refreshPatients();
            }
            this.kines.delete(num);
            this.refreshKines();
        });
        contextMenu.getItems().add((Object)item);
        contextMenu.show((Node)event.getSource(), event.getScreenX(), event.getScreenY());
    }
}

