/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.patient;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.utilsfx.Pdf;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.main.MenuController;
import com.mazet.biostim.view.patient.PatientbilanViewCtrl;
import com.mazet.biostim.view.patient.RevoirController;
import com.mazet.biostim.zdata.Bilan;
import com.mazet.biostim.zdata.Patient;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.json.JSONArray;
import org.json.JSONObject;

public class RevoirBilan
extends Controller {
    static boolean isAnorectal;
    static ArrayList<Bilan> listBilans;
    @FXML
    private VBox gauche;
    @FXML
    private GridPane gridBilan;
    @FXML
    private GridPane gridBilan2;
    @FXML
    private AnchorPane droite;
    @FXML
    LineChart<Number, Number> graph1;
    @FXML
    LineChart<Number, Number> graph2;
    @FXML
    LineChart<Number, Number> graph3;
    @FXML
    LineChart<Number, Number> graph4;
    @FXML
    Label titre1;
    @FXML
    Label titre2;
    @FXML
    Label titre3;
    @FXML
    Label titre4;
    @FXML
    private Label logoMenuBasBiostim;
    private final ArrayList<LineChart<Number, Number>> graphs = new ArrayList();

    @Override
    public void setMain() {
        try {
            Main.mainLayout.setLeft(null);
            FxUtils.setBackGroundInJar((Region)this.logoMenuBasBiostim, MenuController.logoName, 150.0, false);
            if (isAnorectal) {
                PatientbilanViewCtrl.afficheTableauBilanAnorectal(null, this.gridBilan, listBilans);
                this.titre1.setText(TransientConfig.translate("mesure_pression_anale"));
                this.titre2.setText(TransientConfig.translate("Fibres_rapides"));
                this.titre3.setText(TransientConfig.translate("Fibres_lentes"));
                this.titre4.setText(TransientConfig.translate("reflexe_anal"));
            } else {
                this.gridBilan.getColumnConstraints().remove(7, 10);
                PatientbilanViewCtrl.afficheTableauBilanVaginal(null, this.gridBilan, listBilans);
                this.titre1.setText(TransientConfig.translate("Fibres_rapides"));
                this.titre2.setText(TransientConfig.translate("Fibres_lentes"));
                this.titre3.setText(TransientConfig.translate("reflexe_toux"));
                this.titre4.setText(TransientConfig.translate("verrouillage_effort"));
            }
            this.remplirGridStats();
            boolean legende = listBilans.size() == 1 && RevoirBilan.listBilans.get((int)0).prog.getVoieBFB2() != -1;
            this.graphs.add(this.graph1);
            this.graph1.setLegendVisible(legende);
            this.graphs.add(this.graph2);
            this.graph2.setLegendVisible(legende);
            this.graphs.add(this.graph3);
            this.graph3.setLegendVisible(legende);
            this.graphs.add(this.graph4);
            this.graph4.setLegendVisible(legende);
            for (Bilan bilan : listBilans) {
                this.afficheCourbe(bilan);
            }
            Platform.runLater(() -> {
                for (LineChart<Number, Number> graph : this.graphs) {
                    for (Node n : graph.lookupAll(".default-color0")) {
                        n.setStyle(this.getCouleurStyle(0));
                    }
                    for (Node n : graph.lookupAll(".default-color1")) {
                        n.setStyle(this.getCouleurStyle(1));
                    }
                    for (Node n : graph.lookupAll(".default-color2")) {
                        n.setStyle(this.getCouleurStyle(2));
                    }
                    for (Node n : graph.lookupAll(".default-color3")) {
                        n.setStyle(this.getCouleurStyle(3));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getCouleurStyle(int i) {
        String color = RevoirController.couleurs.get(i);
        if (listBilans.size() == 1) {
            if (i == 0) {
                color = Main.getConfig().couleurVoie1;
            } else if (i == 1) {
                color = Main.getConfig().couleurVoie2;
            }
        }
        return String.format("-fx-stroke: %s; -fx-background-color: %s;", color, color);
    }

    private void remplirGridStats() {
        Region regionRow0 = new Region();
        regionRow0.getStyleClass().add((Object)"row0GridConfig");
        this.gridBilan2.add((Node)regionRow0, 0, 0, 3, 1);
        this.addTitleTableau(this.gridBilan2, "date", 0);
        this.addTitleTableau(this.gridBilan2, "vitesseContraction", 1);
        this.addTitleTableau(this.gridBilan2, "vitesseRelachement", 2);
        for (int i = 0; i < listBilans.size(); ++i) {
            Region regionRow = new Region();
            regionRow.setMinHeight(45.0);
            regionRow.getStyleClass().add((Object)(i % 2 == 0 ? "grisclair" : "blanc"));
            this.gridBilan2.add((Node)regionRow, 0, i + 1, 3, 1);
            Bilan bilan = listBilans.get(i);
            Label date = new Label(bilan.getDate());
            date.getStyleClass().add((Object)"nomSeanceTableau");
            if (listBilans.size() > 1) {
                date.setStyle("-fx-text-fill : " + RevoirController.couleurs.get(i));
            }
            this.gridBilan2.add((Node)date, 0, i + 1);
            if (bilan.vitesseContraction != null) {
                this.gridBilan2.add((Node)new Label(String.format("%.1fs", bilan.vitesseContraction)), 1, i + 1);
            }
            if (bilan.vitesseRelachement == null) continue;
            this.gridBilan2.add((Node)new Label(String.format("%.1fs", bilan.vitesseRelachement)), 2, i + 1);
        }
    }

    void addTitleTableau(GridPane tableau, String name, int col) {
        Label label = new Label(TransientConfig.translate(name));
        label.setPadding(new Insets(3.0, 20.0, 3.0, 20.0));
        label.getStyleClass().add((Object)"timetableau");
        tableau.add((Node)label, col, 0);
    }

    public void afficheCourbe(Bilan bilan) {
        try {
            File file = Utils.findFileWhateverEncoded(Main.getConfig().getRepPatients() + "/seances/", bilan.getCourbeSauvee());
            String contents = new String(Files.readAllBytes(file.toPath()));
            JSONObject obj = new JSONObject(contents);
            JSONArray tempsJSON = (JSONArray)obj.get("temps");
            JSONArray tempsEvt = (JSONArray)obj.get("tempsEvt");
            JSONArray voie1JSON = (JSONArray)obj.get("niveauVoie1");
            JSONArray voie2JSON = (JSONArray)obj.get("niveauVoie2");
            ArrayList<XYChart.Series> series1 = new ArrayList<XYChart.Series>();
            ArrayList<XYChart.Series> series2 = new ArrayList<XYChart.Series>();
            boolean voie2 = !voie2JSON.isEmpty() && listBilans.size() == 1;
            for (int i = 0; i < 4; ++i) {
                XYChart.Series serie = new XYChart.Series();
                series1.add(serie);
                this.graphs.get(i).getData().add((Object)serie);
                if (voie2) {
                    serie.setName(Biostim.nomOfVoie(bilan.prog.getVoieBFB1()));
                    XYChart.Series serie2 = new XYChart.Series();
                    series2.add(serie2);
                    this.graphs.get(i).getData().add((Object)serie2);
                    serie2.setName(Biostim.nomOfVoie(bilan.prog.getVoieBFB2()));
                    continue;
                }
                serie.setName(bilan.getDate());
            }
            int pos = 0;
            int t0 = 0;
            int nbTotal = tempsJSON.length();
            double correctionVoie2 = 1.0;
            if (voie2 && bilan.levelMax2 > bilan.levelMax) {
                correctionVoie2 = bilan.levelMax / bilan.levelMax2;
            }
            for (int i = 0; i < nbTotal; ++i) {
                int t = tempsJSON.getInt(i);
                if (pos < 3 && t > tempsEvt.getInt(pos + 1)) {
                    t0 = tempsEvt.getInt(++pos);
                }
                ((XYChart.Series)series1.get(pos)).getData().add((Object)new XYChart.Data((Object)((double)(t - t0) / 100.0), (Object)((double)voie1JSON.getInt(i) / 10.0)));
                if (!voie2) continue;
                ((XYChart.Series)series2.get(pos)).getData().add((Object)new XYChart.Data((Object)((double)(t - t0) / 100.0), (Object)((double)voie2JSON.getInt(i) / 10.0 * correctionVoie2)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void printHistory() {
        Patient patient = Main.getCurrentPatient();
        Pdf.createBilanPDF((Node)this.gauche, (Node)this.droite, patient.getName(), patient.getNameAndId(), isAnorectal, false);
    }

    @FXML
    private void clicStop() {
        Main.changeCenterView("patient", "bilan", Main.menu.patientButton);
    }

    @FXML
    private void setFullScreen() {
        MenuController.setFullScreen();
    }
}

