/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.planche;

import com.mazet.biostim.utils.TransientConfig;
import java.util.ArrayList;
import java.util.Arrays;

public class Planche {
    public static final ArrayList<String> familles = new ArrayList<String>(Arrays.asList("planchesAnatomiques", "branchement", "Anorectal"));
    private static final ArrayList<PlancheStd> listPlanches = new ArrayList();
    private static final ArrayList<PlancheStd> listeAnorectal = new ArrayList();
    private static final ArrayList<PlancheStd> listBranchement = new ArrayList();
    public static final ArrayList<ArrayList<PlancheStd>> toutesLesPlanches = new ArrayList<ArrayList>(Arrays.asList(listPlanches, listBranchement, listeAnorectal));
    String name;

    public static void initPlanches() {
        listPlanches.add(new PlancheStd("Plancher_Pelvien", "Plancher_pelvien_url"));
        listPlanches.add(new PlancheStd("Plancher_Pelvien_2", "Plancher_pelvien_2_url"));
        listPlanches.add(new PlancheStd("Anatomie3D", "Anatomie3D_url"));
        listPlanches.add(new PlancheStd("Transverse", "Transverse_url"));
        listPlanches.add(new PlancheStd("prolapsus", "Prolapsus_url"));
        listPlanches.add(new PlancheStd("Appareil_Genital_de_la_Femme", "genital_femme.jpg"));
        listPlanches.add(new PlancheStd("Appareil_Genital_de_lHomme", "genital_homme.jpg"));
        listBranchement.add(new PlancheStd("biomoovGonio", "biomoov.png"));
        listBranchement.add(new PlancheStd("electrodesAnorectal", "electrodes_anorectal.png"));
        listBranchement.add(new PlancheStd("doubleBallonnet", "double_ballonnet.png"));
        listeAnorectal.add(new PlancheStd("bristol", "bristol_url"));
        listeAnorectal.add(new PlancheStd("posture", "posture.png"));
        listeAnorectal.add(new PlancheStd("transit", "transit_url"));
    }

    public Planche() {
    }

    public Planche(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name.isEmpty()) {
            return this.name;
        }
        return TransientConfig.translate(this.name);
    }

    public String getUrlImg() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static class PlancheStd
    extends Planche {
        private final String urlImg;

        public PlancheStd(String name, String urlImg) {
            super(name);
            this.urlImg = urlImg;
        }

        @Override
        public String getUrlImg() {
            String res = this.urlImg;
            if (res.endsWith("_url")) {
                res = TransientConfig.translate(res);
            }
            if (res.startsWith("http")) {
                return res;
            }
            return "/images/" + res;
        }
    }

    public static class PlancheUser
    extends Planche {
        public final String initString;
        private final String urlImg;

        public PlancheUser(String s) {
            this.initString = s;
            int pos = s.indexOf(62);
            this.name = s.substring(0, pos);
            this.urlImg = s.substring(pos + 1);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getUrlImg() {
            return this.urlImg;
        }
    }
}

