/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.utilsfx.LineChartWithMarkers;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.programme.MenuBasController;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javafx.animation.AnimationTimer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class TarageController
extends Controller {
    private static final double dureeVisu = 20.0;
    private int voie;
    @FXML
    private HBox tarageClassique;
    @FXML
    private LineChartWithMarkers<Number, Number> sc;
    @FXML
    private NumberAxis xAxis;
    @FXML
    private NumberAxis yAxis;
    @FXML
    private Label title;
    @FXML
    private Label currentValue;
    @FXML
    private HBox hboxLimMax;
    @FXML
    private Button plusLimMax;
    @FXML
    private Label valLimMax;
    @FXML
    private Button moinLimMax;
    @FXML
    private HBox hboxLimMin;
    @FXML
    private Button plusLimMin;
    @FXML
    private Label valLimMin;
    @FXML
    private Button moinLimMin;
    @FXML
    private Button reinit;
    @FXML
    private GridPane tarageBlueback;
    @FXML
    private Label imageBlueback;
    @FXML
    private Label textBlueback;
    @FXML
    private Button restart;
    @FXML
    private MenuBasController menuBasController;
    private double dureeMilli = 0.0;
    private long startTime;
    private long debutPause = 0L;
    private boolean active = true;
    private boolean pageQuittee = false;
    private boolean firstStart = true;
    private AnimationTimer animationTimer;
    private XYChart.Series<Number, Number> series;
    private double finAffichage;
    private XYChart.Data<Number, Number> horizontalRangeMarker;
    private String targetID;
    private int compteurTemp;
    private Timeline holdBouton;
    private boolean initGonio = false;
    private double dateInitRef;
    private static final Color orangeClair = new Color(1.0, 0.5, 0.0, 0.5);
    private static final Color vertClair = new Color(0.0, 0.8, 0.0, 0.5);
    private int placementSondeAnorectale = 0;
    private Double initGood = null;
    private int stateBlueback = 0;
    private double lastCurrentValue = 0.0;

    @Override
    public void setMain() {
        boolean positionneSonde;
        this.voie = Main.progEnCours.currentPageProgram.getNbVoie();
        boolean bl = positionneSonde = this.voie == 2 && Main.progEnCours.currentProgram.aidePlacementSondePression;
        if (positionneSonde || this.voie == 8) {
            Main.progEnCours.setPageDureeRestante(null);
        }
        this.title.setText(TransientConfig.translate("tarageVoie", Biostim.nomOfVoie(this.voie)));
        this.menuBasController.getLabelSuivant().setOnMouseClicked(event -> this.suivantAction());
        this.menuBasController.getLabelPrecedent().setOnMouseClicked(event -> this.precedentAction());
        this.menuBasController.getLabelStop().setOnMouseClicked(event -> this.stopAction());
        this.menuBasController.getLabelPause().setOnMouseClicked(event -> this.pauseAction());
        this.menuBasController.initLogo();
        this.menuBasController.afficheDureeRestante();
        FxUtils.adjustHboxReglageStyle(this.hboxLimMax, (Region)this.reinit);
        FxUtils.adjustHboxReglageStyle(this.hboxLimMin);
        if (this.voie == 8) {
            this.initTarageBlueback();
        } else {
            if (this.voie == 14) {
                this.initGonio = true;
                this.sc.setHorizontalRangeColor((Paint)orangeClair);
                this.active = false;
                new Thread(() -> {
                    Utils.popupAlertAndWait(TransientConfig.translate("placement_repos_ref"), TransientConfig.translate("start"));
                    this.startTime = System.currentTimeMillis();
                    this.active = true;
                    Platform.runLater(this::reinitArea);
                }).start();
            } else if (positionneSonde) {
                this.placementSondeAnorectale = 3;
                this.title.getStyleClass().setAll((Object[])new String[]{"titleConfiguration"});
                this.title.setText(TransientConfig.translate("inserer_sonde"));
                this.sc.setHorizontalRangeColor((Paint)orangeClair);
                Platform.runLater(this::reinitArea);
            }
            UsbBiostim.selectCalibre(this.voie, Main.progEnCours.getAffMax(this.voie));
            this.initTarageClassique();
        }
        Platform.runLater(this::compteurPageProgrammeThread);
    }

    void initTarageClassique() {
        try {
            FxUtils.setVisibility((Node)this.tarageClassique, true);
            this.plusLimMax.setOnMousePressed(this::mousePressed);
            this.plusLimMax.setOnMouseReleased(e -> this.mouseReleased());
            this.moinLimMax.setOnMousePressed(this::mousePressed);
            this.moinLimMax.setOnMouseReleased(e -> this.mouseReleased());
            this.plusLimMin.setOnMousePressed(this::mousePressed);
            this.plusLimMin.setOnMouseReleased(e -> this.mouseReleased());
            this.moinLimMin.setOnMousePressed(this::mousePressed);
            this.moinLimMin.setOnMouseReleased(e -> this.mouseReleased());
            this.initGraph();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    void initTarageBlueback() {
        FxUtils.setVisibility((Node)this.tarageBlueback, true);
        this.menuBasController.getLabelPause().setVisible(false);
        this.menuBasController.getLabelSuivant().setVisible(false);
        SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.debutCalibration);
    }

    private void initGraph() {
        this.xAxis.setForceZeroInRange(false);
        this.xAxis.setAutoRanging(false);
        this.xAxis.setTickLabelsVisible(false);
        this.xAxis.setTickUnit(1.0);
        this.yAxis.setAutoRanging(false);
        this.yAxis.setUpperBound(100.0);
        this.yAxis.setLowerBound(0.0);
        this.yAxis.setTickUnit(25.0);
        this.yAxis.setTickLabelsVisible(false);
        this.updateMinMax();
        this.series = new XYChart.Series();
        this.sc.setId("historique");
        this.sc.setAnimated(false);
        this.sc.setCreateSymbols(false);
        this.sc.getData().add(this.series);
    }

    @FXML
    private void reinitArea() {
        double min;
        if (this.horizontalRangeMarker != null) {
            this.sc.removeHorizontalRangeMarker(this.horizontalRangeMarker);
        }
        this.horizontalRangeMarker = null;
        UsbBiostim.selectCalibre(this.voie, Biostim.getVoie(this.voie));
        Main.progEnCours.forceAffMax(this.voie, 0.0);
        double d = min = this.voie == 14 ? 0.0 : 9999.0;
        if (this.placementSondeAnorectale != 1) {
            Main.progEnCours.setAffMin(this.voie, min);
        }
        if (this.placementSondeAnorectale == 0) {
            Main.progEnCours.setBase(this.voie, min);
        }
        if (this.voie == 14) {
            SondeBT.setRefGonio();
            if (this.initGonio || !this.series.getData().isEmpty()) {
                this.initGonio = true;
                this.sc.setHorizontalRangeColor((Paint)orangeClair);
                this.dateInitRef = this.dureeMilli;
            }
        }
    }

    private double tickUnit(double max) {
        if (max < 10.0) {
            return 1.0;
        }
        if (max < 25.0) {
            return 2.0;
        }
        if (max < 50.0) {
            return 5.0;
        }
        if (max < 100.0) {
            return 10.0;
        }
        if (max < 250.0) {
            return 20.0;
        }
        if (max < 500.0) {
            return 50.0;
        }
        if (max < 1000.0) {
            return 100.0;
        }
        return 200.0;
    }

    private void updateMinMax() {
        double delta = 0.2 * (Main.progEnCours.getAffMax(this.voie) - Main.progEnCours.getAffMin(this.voie));
        this.yAxis.setUpperBound(Main.progEnCours.getAffMax(this.voie) + delta);
        this.yAxis.setLowerBound(Math.max(0.0, Main.progEnCours.getAffMin(this.voie) - delta));
        this.yAxis.setTickUnit(this.tickUnit(this.yAxis.getUpperBound()));
        this.valLimMin.setText(String.format("%.1f", Main.progEnCours.getAffMin(this.voie)));
        this.valLimMax.setText(Main.progEnCours.relativeValue(this.voie, Main.progEnCours.getAffMax(this.voie)));
        if (this.horizontalRangeMarker != null) {
            this.sc.removeHorizontalRangeMarker(this.horizontalRangeMarker);
        }
        this.horizontalRangeMarker = new XYChart.Data((Object)Main.progEnCours.getAffMin(this.voie), (Object)Main.progEnCours.getAffMax(this.voie));
        this.sc.addHorizontalRangeMarker(this.horizontalRangeMarker);
    }

    private void timerDraw() {
        try {
            double niveau = Biostim.getVoie(this.voie);
            if (this.lastCurrentValue + 0.2 < this.dureeMilli) {
                this.currentValue.setText(Main.progEnCours.relativeValue(this.voie, niveau));
                this.lastCurrentValue = this.dureeMilli;
            }
            this.addDataToGraphique(niveau);
            if (this.placementSondeAnorectale == 2) {
                double base = Main.progEnCours.getBase(this.voie);
                if (base * 0.9 < niveau && niveau < base * 1.1) {
                    if (this.initGood == null) {
                        this.initGood = this.dureeMilli;
                    } else if (this.dureeMilli > this.initGood + 3.0) {
                        this.placementSondeAnorectale = 1;
                        this.sc.setHorizontalRangeColor(null);
                        this.series.getData().clear();
                        this.reinitArea();
                        this.title.setText(TransientConfig.translate("tarageVoie", Biostim.nomOfVoie(this.voie)));
                        this.title.getStyleClass().setAll((Object[])new String[]{"title"});
                        Main.progEnCours.setPageDureeRestante(Main.getConfig().dureeTarage);
                    }
                } else {
                    this.initGood = null;
                }
            } else {
                double max;
                boolean modifyArea = false;
                if (niveau < Main.progEnCours.getAffMin(this.voie) && this.placementSondeAnorectale != 1 && this.placementSondeAnorectale != 2) {
                    Main.progEnCours.setAffMin(this.voie, niveau);
                    Main.progEnCours.setBase(this.voie, niveau);
                    modifyArea = true;
                }
                if (niveau > Main.progEnCours.getAffMax(this.voie)) {
                    Main.progEnCours.forceAffMax(this.voie, Math.max(niveau, Main.progEnCours.getAffMin(this.voie) + TarageController.minDelta(this.voie)));
                    modifyArea = true;
                }
                if (modifyArea) {
                    this.updateMinMax();
                }
                if (this.initGonio) {
                    if (niveau > 2.0) {
                        this.reinitArea();
                    } else if (this.dureeMilli - this.dateInitRef > 2.0) {
                        this.series.getData().clear();
                        this.initGonio = false;
                        this.sc.setHorizontalRangeColor(null);
                        this.reinitArea();
                        Utils.makeToast(TransientConfig.translate("ref_validee"), new Object[0]);
                    }
                } else if (this.placementSondeAnorectale == 3 && (max = Main.progEnCours.getAffMax(this.voie)) > 30.0 && niveau < max * 0.5) {
                    Main.progEnCours.setBase(this.voie, max);
                    Main.progEnCours.setAffMin(this.voie, max);
                    this.placementSondeAnorectale = 2;
                    this.sc.setHorizontalRangeColor((Paint)vertClair);
                    this.yAxis.setUpperBound(max * 1.3);
                    if (this.horizontalRangeMarker != null) {
                        this.sc.removeHorizontalRangeMarker(this.horizontalRangeMarker);
                    }
                    this.horizontalRangeMarker = new XYChart.Data((Object)(max * 0.9), (Object)(max * 1.1));
                    this.sc.addHorizontalRangeMarker(this.horizontalRangeMarker);
                    this.title.setText(TransientConfig.translate("placer_sonde"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double minDelta(int voie) {
        switch (voie) {
            case 0: 
            case 1: 
            case 15: 
            case 16: {
                return 5.0;
            }
            case 2: 
            case 3: 
            case 14: {
                return 10.0;
            }
        }
        return 0.0;
    }

    private void addDataToGraphique(Double data) {
        if (this.series.getData().isEmpty()) {
            this.finAffichage = this.dureeMilli + 20.0;
        }
        this.finAffichage = Math.max(this.dureeMilli, this.finAffichage);
        double debutAffichage = this.finAffichage - 20.0;
        this.xAxis.setLowerBound(debutAffichage);
        this.xAxis.setUpperBound(this.finAffichage);
        this.series.getData().add((Object)new XYChart.Data((Object)this.dureeMilli, (Object)data));
        while (((Number)((XYChart.Data)this.series.getData().get(0)).getXValue()).doubleValue() < debutAffichage - 0.01) {
            this.series.getData().remove(0);
        }
    }

    private void compteurPageProgrammeThread() {
        this.startTime = System.currentTimeMillis();
        this.animationTimer = new AnimationTimer(this){
            private double lastSeconde;
            final /* synthetic */ TarageController this$0;
            {
                TarageController tarageController = this$0;
                Objects.requireNonNull(tarageController);
                this.this$0 = tarageController;
                this.lastSeconde = 0.0;
            }

            public void handle(long now) {
                try {
                    this.this$0.dureeMilli = (double)(System.currentTimeMillis() - this.this$0.startTime) / 1000.0;
                    if (this.this$0.voie == 8) {
                        if (this.this$0.stateBlueback == 0 && this.this$0.dureeMilli > 0.0) {
                            this.this$0.stateBlueback = 1;
                            this.this$0.textBlueback.setText(TransientConfig.translate("repos"));
                        } else if (this.this$0.stateBlueback == 1 && this.this$0.dureeMilli > 5.0) {
                            this.this$0.stateBlueback = 2;
                            Image image = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/img/tousser.png"));
                            BackgroundSize bgSize = new BackgroundSize(-1.0, 1.0, false, true, false, false);
                            BackgroundImage bg = new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, bgSize);
                            this.this$0.imageBlueback.setMinSize(this.this$0.tarageBlueback.getWidth() * 0.5, this.this$0.tarageBlueback.getHeight() * 0.5);
                            this.this$0.imageBlueback.setMaxSize(this.this$0.tarageBlueback.getWidth() * 0.5, this.this$0.tarageBlueback.getHeight() * 0.5);
                            this.this$0.imageBlueback.setBackground(new Background(new BackgroundImage[]{bg}));
                            this.this$0.textBlueback.setText(TransientConfig.translate("tousser"));
                        } else if (this.this$0.stateBlueback == 2 && this.this$0.dureeMilli > 10.0) {
                            FxUtils.setVisibility((Node)this.this$0.imageBlueback, false);
                            this.this$0.stateBlueback = 3;
                            this.this$0.textBlueback.setText(TransientConfig.translate("repos"));
                        }
                    } else if (this.this$0.active) {
                        if (this.this$0.firstStart) {
                            this.this$0.firstStart = false;
                            String color = this.this$0.voie == Main.progEnCours.currentProgram.getVoieBFB1() ? Main.getConfig().couleurVoie1 : Main.getConfig().couleurVoie2;
                            String style = String.format("-fx-stroke: %s;  -fx-background-color: %s; -fx-stroke-width: %d;", color, color, Main.getConfig().epaisseurVoie);
                            for (Node n : this.this$0.sc.lookupAll(".default-color0")) {
                                n.setStyle(style);
                            }
                        }
                        if (this.this$0.dureeMilli - this.lastSeconde >= 1.0) {
                            this.lastSeconde += 1.0;
                            if (Main.progEnCours.getPageDureeRestante() != null) {
                                Main.progEnCours.decrPageDureeRestante();
                                if (Main.progEnCours.getPageDureeRestante() <= 0) {
                                    this.this$0.suivantAction();
                                } else {
                                    this.this$0.menuBasController.afficheDureeRestante();
                                }
                            }
                        }
                        this.this$0.timerDraw();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.animationTimer.start();
    }

    public void retourCalibBlueback(int erreur) {
        if (!this.pageQuittee && this.voie == 8 && this.stateBlueback < 4 && this.dureeMilli > 1.0) {
            Platform.runLater(() -> {
                SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.finCalibration);
                FxUtils.setVisibility((Node)this.imageBlueback, false);
                boolean bl = SondeBT.bluebackCalibre = erreur == 0;
                if (SondeBT.bluebackCalibre) {
                    if (Main.getCurrentPatient() != null) {
                        TransientConfig.patientBlueback = Main.getCurrentPatient().id;
                        TransientConfig.dateTarageBlueback = System.currentTimeMillis() / 1000L;
                    } else {
                        TransientConfig.dateTarageBlueback = 0L;
                    }
                    this.stateBlueback = 4;
                    this.textBlueback.setText(TransientConfig.translate("succes"));
                    new Timer().schedule(new TimerTask(this){
                        final /* synthetic */ TarageController this$0;
                        {
                            TarageController tarageController = this$0;
                            Objects.requireNonNull(tarageController);
                            this.this$0 = tarageController;
                        }

                        @Override
                        public void run() {
                            Platform.runLater(this.this$0::suivantAction);
                        }
                    }, 2000L);
                } else {
                    TransientConfig.dateTarageBlueback = 0L;
                    String msg = "echec_calibration";
                    if (erreur == 2 || erreur == 6) {
                        msg = "echec_repos";
                    }
                    if (erreur == 8 || erreur == 10 || erreur == 12) {
                        msg = "echec_contact_electrodes";
                    }
                    this.textBlueback.setText(TransientConfig.translate(msg));
                    FxUtils.setVisibility((Node)this.restart, true);
                    this.stateBlueback = 5;
                }
                Main.getConfig().saveConfig();
            });
        }
    }

    private void mousePressed(MouseEvent event) {
        Button targetObject = (Button)event.getSource();
        this.targetID = targetObject.getId();
        this.compteurTemp = 0;
        if (this.holdBouton != null) {
            this.holdBouton.stop();
        }
        this.holdBouton = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)20.0), ae -> {
            if (this.pageQuittee) {
                this.holdBouton.stop();
            }
            if (this.compteurTemp > 10) {
                this.methodeHoldMouse();
            }
            ++this.compteurTemp;
        }, new KeyValue[0])});
        this.holdBouton.setCycleCount(-1);
        this.holdBouton.playFromStart();
    }

    private void mouseReleased() {
        if (this.holdBouton != null) {
            this.holdBouton.stop();
            this.holdBouton = null;
            this.methodeHoldMouse();
        }
    }

    private void methodeHoldMouse() {
        try {
            if (this.targetID != null) {
                switch (this.targetID) {
                    case "plusLimMax": {
                        Main.progEnCours.incrAffMax(this.voie, 1);
                        break;
                    }
                    case "moinLimMax": {
                        Main.progEnCours.incrAffMax(this.voie, -1);
                        break;
                    }
                    case "plusLimMin": {
                        Main.progEnCours.incrAffMin(this.voie, 1);
                        break;
                    }
                    case "moinLimMin": {
                        Main.progEnCours.incrAffMin(this.voie, -1);
                    }
                }
                this.updateMinMax();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopTarrage() {
        try {
            this.pageQuittee = true;
            this.active = false;
            if (this.animationTimer != null) {
                this.animationTimer.stop();
            }
            if (this.voie == 8) {
                Main.progEnCours.setAffMax(this.voie, 100.0);
                Main.progEnCours.setBase(this.voie, 0.0);
                Main.progEnCours.setAffMin(this.voie, 0.0);
                SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.finCalibration);
            } else {
                if (this.placementSondeAnorectale != 0) {
                    Main.progEnCours.setAffMin(this.voie, Main.progEnCours.getBase(this.voie) * 0.7);
                }
                Utils.debugInfo("fin de tarage voie %s. min : %.1f, max : %.1f", Biostim.nomOfVoie(this.voie), Main.progEnCours.getAffMin(this.voie), Main.progEnCours.getAffMax(this.voie));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void restartPage() {
        this.stopTarrage();
        Main.progEnCours.gotoSamePage();
    }

    private void suivantAction() {
        this.stopTarrage();
        Main.progEnCours.gotoNextPage();
    }

    @Override
    public void stopAction() {
        this.stopTarrage();
        Main.progEnCours.finProgramme();
    }

    @Override
    public void pauseAction() {
        if (this.active) {
            this.active = false;
            this.menuBasController.getLabelPause().getStyleClass().setAll((Object[])new String[]{"buttonNav", "restartButton"});
            this.debutPause = System.currentTimeMillis();
        } else {
            this.active = true;
            this.menuBasController.getLabelPause().getStyleClass().setAll((Object[])new String[]{"buttonNav", "pauseButton"});
            this.startTime += System.currentTimeMillis() - this.debutPause;
        }
    }

    private void precedentAction() {
        this.stopTarrage();
        Main.progEnCours.gotoLastPage();
    }
}

