/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.utils.Maths;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimationSpecif;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class AnimationTachymetre
extends BiofeedbackAnimationSpecif {
    private static final double voie1RelativePosX = 0.5;
    private static final double voie1RelativePosY = 0.45;
    private static final double angleMin = -118.0;
    private static final double angleMax = 157.0;
    private Rectangle compteur;
    private Rectangle aiguille;
    private Image imageAiguille;

    @Override
    public void initGame() {
        try {
            this.compteur = new Rectangle();
            this.compteur.setFill((Paint)new ImagePattern(new Image(this.getClass().getResourceAsStream("/img/div_anim/tachymetre.png"))));
            this.imageAiguille = new Image(this.getClass().getResourceAsStream("/img/div_anim/aiguille.png"));
            this.aiguille = new Rectangle();
            this.aiguille.setFill((Paint)new ImagePattern(this.imageAiguille));
            this.aiguille.setRotate(45.0);
            this.controller.gameAnchor.getChildren().addAll((Object[])new Node[]{this.compteur, this.aiguille});
            super.initGame();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void updateSizeGame() {
        super.updateSizeGame();
        double hauteur = this.anchorHeight * 0.8;
        this.compteur.setX(this.widthGame * 0.5 - hauteur / 2.0);
        this.compteur.setY(this.anchorHeight * 0.45 - hauteur / 2.0);
        this.compteur.setHeight(hauteur);
        this.compteur.setWidth(hauteur);
        hauteur = this.anchorHeight * 0.6;
        double largeur = hauteur * this.imageAiguille.getWidth() / this.imageAiguille.getHeight();
        this.aiguille.setX(this.widthGame * 0.5 - largeur / 2.0);
        this.aiguille.setY(this.anchorHeight * 0.45 - hauteur / 2.0);
        this.aiguille.setWidth(largeur);
        this.aiguille.setHeight(hauteur);
    }

    @Override
    public void updateSpecifique() {
        super.updateSpecifique();
        this.aiguille.setRotate(Maths.interpolation(0.0, 100.0, -118.0, 157.0, this.controller.niveauVoie1Aff));
    }
}

