/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.view.programme.bfb.AnimationAPA;
import com.mazet.biostim.view.programme.bfb.AnimationBalance;
import com.mazet.biostim.view.programme.bfb.BalanceDesign;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Rectangle;

public class BalanceCible
extends BalanceDesign {
    boolean balanceExercice;
    static final double tailleCible = 0.1;
    private static final int nbNiveaux = 4;
    Rectangle position;
    double rayonMax;
    Circle cible;
    Circle cibleVerte;
    double ciblex;
    double cibley;
    Double inStart;
    private double dureeValidation = 2.0;
    Rectangle masquage1;
    Rectangle masquage2;
    Polyline cible1D;

    BalanceCible(BiofeedbackAnimation animation) {
        this.controller = animation.controller;
        this.balanceExercice = animation instanceof AnimationAPA || animation instanceof AnimationBalance || Main.getConfig().actionBalanceBFB == 2;
    }

    @Override
    void init() {
        try {
            for (int i = 4; i > 0; --i) {
                Circle c = new Circle();
                c.getStyleClass().add((Object)"cibleBalance");
                this.controller.balanceAnchor.getChildren().add((Object)c);
            }
            if (Main.getConfig().typeBalance != 0) {
                this.masquage1 = new Rectangle();
                this.masquage1.getStyleClass().add((Object)"masquageBalance");
                this.masquage2 = new Rectangle();
                this.masquage2.getStyleClass().add((Object)"masquageBalance");
                this.cible1D = new Polyline();
                this.cible1D.getStyleClass().add((Object)"cibleBalance");
                this.controller.balanceAnchor.getChildren().addAll((Object[])new Node[]{this.masquage1, this.masquage2, this.cible1D});
            }
            if (this.balanceExercice) {
                this.cible = new Circle();
                this.cible.setFill((Paint)Color.RED);
                this.cibleVerte = new Circle();
                this.cibleVerte.setFill((Paint)Color.GREEN);
                FxUtils.setVisibility((Node)this.cibleVerte, false);
                this.controller.balanceAnchor.getChildren().addAll((Object[])new Node[]{this.cible, this.cibleVerte});
                this.bougeCible();
            }
            ImagePattern ip = new ImagePattern(Computer.getImage("balance/curseur.png", "no-image.png", false));
            this.position = FxUtils.creationObjet((Pane)this.controller.balanceAnchor, ip, 0.1 * this.rayonMax * 2.0);
            this.updateSizeBalance();
            this.updateBalance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    void fin() {
        for (int i = 0; i < 4; ++i) {
            Circle c = (Circle)this.controller.balanceAnchor.getChildren().get(i);
            c.getStyleClass().add((Object)"cibleBalanceFin");
        }
    }

    @Override
    void updateSizeBalance() {
        super.updateSizeBalance();
        this.rayonMax = Math.min(this.width, this.height) / 2.0 * 0.85;
        for (int i = 4; i > 0; --i) {
            Circle c = (Circle)this.controller.balanceAnchor.getChildren().get(4 - i);
            c.setCenterX(this.width / 2.0);
            c.setCenterY(this.height / 2.0);
            c.setRadius(this.rayonMax * (double)i / 4.0);
        }
        if (this.cible != null) {
            this.cible.setRadius(0.1 * this.rayonMax);
            this.cible.setCenterX(this.width / 2.0 + this.ciblex * this.rayonMax);
            this.cible.setCenterY(this.height / 2.0 - this.cibley * this.rayonMax);
            this.cibleVerte.setCenterX(this.width / 2.0 + this.ciblex * this.rayonMax);
            this.cibleVerte.setCenterY(this.height / 2.0 - this.cibley * this.rayonMax);
        }
        this.position.setWidth(0.1 * this.rayonMax * 2.0);
        this.position.setHeight(0.1 * this.rayonMax * 2.0);
        if (Main.getConfig().typeBalance != 0) {
            if (Main.getConfig().typeBalance == 1) {
                this.masquage1.setX(this.width / 2.0 - this.rayonMax - 0.1 * this.rayonMax * 1.1);
                this.masquage1.setY(this.height / 2.0 - this.rayonMax - 0.1 * this.rayonMax * 1.1);
                this.masquage1.setWidth(this.rayonMax * 2.2);
                this.masquage1.setHeight(this.rayonMax);
                this.masquage2.setX(this.width / 2.0 - this.rayonMax - 0.1 * this.rayonMax * 1.1);
                this.masquage2.setY(this.height / 2.0 + 0.1 * this.rayonMax * 1.1);
                this.masquage2.setWidth(this.rayonMax * 2.2);
                this.masquage2.setHeight(this.rayonMax);
                this.cible1D.getPoints().setAll((Object[])new Double[]{this.width / 2.0 - this.rayonMax, this.height / 2.0, this.width / 2.0 + this.rayonMax, this.height / 2.0});
            } else {
                this.masquage1.setX(this.width / 2.0 - this.rayonMax - 0.1 * this.rayonMax * 1.1);
                this.masquage1.setY(this.height / 2.0 - this.rayonMax - 0.1 * this.rayonMax * 1.1);
                this.masquage1.setWidth(this.rayonMax);
                this.masquage1.setHeight(this.rayonMax * 2.2);
                this.masquage2.setX(this.width / 2.0 + 0.1 * this.rayonMax * 1.1);
                this.masquage2.setY(this.height / 2.0 - this.rayonMax - 0.1 * this.rayonMax * 1.1);
                this.masquage2.setWidth(this.rayonMax);
                this.masquage2.setHeight(this.rayonMax * 2.2);
                this.cible1D.getPoints().setAll((Object[])new Double[]{this.width / 2.0, this.height / 2.0 - this.rayonMax, this.width / 2.0, this.height / 2.0 + this.rayonMax});
            }
        }
    }

    @Override
    public void updateBalance() {
        double posx = (Biostim.getVoie(9) - 50.0) / 50.0;
        double posy = (Biostim.getVoie(10) - 50.0) / 50.0;
        this.position.setX(this.width / 2.0 + (posx - 0.1) * this.rayonMax);
        this.position.setY(this.height / 2.0 - (posy + 0.1) * this.rayonMax);
        if (this.balanceExercice) {
            if ((this.ciblex - posx) * (this.ciblex - posx) + (this.cibley - posy) * (this.cibley - posy) < 0.04000000000000001) {
                if (this.inStart == null) {
                    this.inStart = this.controller.dureeMilli;
                    FxUtils.setVisibility((Node)this.cibleVerte, true);
                }
                if (this.controller.dureeMilli - this.inStart > this.dureeValidation) {
                    this.updateScore(1);
                    this.bougeCible();
                } else {
                    double progress = 0.2 + 0.8 * (this.controller.dureeMilli - this.inStart) / this.dureeValidation;
                    this.cibleVerte.setRadius(0.1 * this.rayonMax * progress);
                }
            } else if (this.inStart != null) {
                this.inStart = null;
                FxUtils.setVisibility((Node)this.cibleVerte, false);
            }
        }
    }

    public void bougeCible() {
        this.inStart = null;
        FxUtils.setVisibility((Node)this.cibleVerte, false);
        int vitesse = Main.progEnCours.currentPageProgram.vitesse;
        this.dureeValidation = vitesse != 0 ? (double)vitesse : 0.5 + 4.0 * Math.random();
        this.ciblex = (this.ciblex + 1.1 + 1.8 * Math.random()) % 2.0 - 1.0;
        this.cibley = (this.cibley + 1.1 + 1.8 * Math.random()) % 2.0 - 1.0;
        switch (Main.getConfig().typeBalance) {
            case 1: {
                this.cibley = 0.0;
                break;
            }
            case 2: {
                this.ciblex = 0.0;
                break;
            }
            default: {
                double r = Math.sqrt(this.ciblex * this.ciblex + this.cibley * this.cibley);
                if (!(r > 1.0)) break;
                this.ciblex *= 1.0 / r;
                this.cibley *= 1.0 / r;
            }
        }
        this.cible.setCenterX(this.width / 2.0 + this.ciblex * this.rayonMax);
        this.cible.setCenterY(this.height / 2.0 - this.cibley * this.rayonMax);
        this.cibleVerte.setCenterX(this.width / 2.0 + this.ciblex * this.rayonMax);
        this.cibleVerte.setCenterY(this.height / 2.0 - this.cibley * this.rayonMax);
    }
}

